/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.ReferenceData;
import com.intellij.codeInsight.editorActions.ReferenceTransferableData;
import com.intellij.codeInsight.editorActions.RestoreReferencesDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CopyPasteReferenceProcessor<TRef extends PsiElement>
extends CopyPastePostProcessor<ReferenceTransferableData> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.CopyPasteReferenceProcessor");

    @NotNull
    public List<ReferenceTransferableData> collectTransferableData(PsiFile file, Editor editor, int[] startOffsets, int[] endOffsets) {
        if (CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE == 2) {
            List<ReferenceTransferableData> list = Collections.emptyList();
            if (list == null) {
                CopyPasteReferenceProcessor.$$$reportNull$$$0(0);
            }
            return list;
        }
        if (!(file instanceof PsiClassOwner)) {
            List<ReferenceTransferableData> list = Collections.emptyList();
            if (list == null) {
                CopyPasteReferenceProcessor.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<ReferenceData> array = new ArrayList<ReferenceData>();
        int refOffset = 0;
        for (int j = 0; j < startOffsets.length; ++j) {
            refOffset += startOffsets[j];
            for (PsiElement element : CollectHighlightsUtil.getElementsInRange((PsiElement)file, (int)startOffsets[j], (int)endOffsets[j])) {
                this.addReferenceData(file, refOffset, element, array);
            }
            refOffset -= endOffsets[j] + 1;
        }
        if (array.isEmpty()) {
            List<ReferenceTransferableData> list = Collections.emptyList();
            if (list == null) {
                CopyPasteReferenceProcessor.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<ReferenceTransferableData> list = Collections.singletonList(new ReferenceTransferableData(array.toArray(new ReferenceData[0])));
        if (list == null) {
            CopyPasteReferenceProcessor.$$$reportNull$$$0(3);
        }
        return list;
    }

    protected abstract void addReferenceData(PsiFile var1, int var2, PsiElement var3, ArrayList<ReferenceData> var4);

    @NotNull
    public List<ReferenceTransferableData> extractTransferableData(Transferable content) {
        ReferenceTransferableData referenceData = null;
        if (CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE != 2) {
            try {
                DataFlavor flavor = ReferenceData.getDataFlavor();
                if (flavor != null) {
                    referenceData = (ReferenceTransferableData)content.getTransferData(flavor);
                }
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
        }
        if (referenceData != null) {
            List<ReferenceTransferableData> list = Collections.singletonList(referenceData.clone());
            if (list == null) {
                CopyPasteReferenceProcessor.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<ReferenceTransferableData> list = Collections.emptyList();
        if (list == null) {
            CopyPasteReferenceProcessor.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void processTransferableData(Project project, Editor editor, RangeMarker bounds, int caretOffset, Ref<Boolean> indented, List<ReferenceTransferableData> values) {
        if (DumbService.getInstance((Project)project).isDumb()) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (!(file instanceof PsiClassOwner)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        assert (values.size() == 1);
        ReferenceData[] referenceData = values.get(0).getData();
        PsiElement[] refs = this.findReferencesToRestore(file, bounds, referenceData);
        if (CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE == 3) {
            CopyPasteReferenceProcessor.askReferencesToRestore(project, refs, referenceData);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ApplicationManager.getApplication().runWriteAction(() -> this.restoreReferences(referenceData, refs));
    }

    protected static void addReferenceData(PsiElement element, ArrayList<ReferenceData> array, int startOffset, String qClassName, @Nullable String staticMemberName) {
        TextRange range = element.getTextRange();
        array.add(new ReferenceData(range.getStartOffset() - startOffset, range.getEndOffset() - startOffset, qClassName, staticMemberName));
    }

    @NotNull
    protected abstract TRef[] findReferencesToRestore(PsiFile var1, RangeMarker var2, ReferenceData[] var3);

    protected PsiElement resolveReferenceIgnoreOverriding(PsiPolyVariantReference reference) {
        ResolveResult[] results;
        PsiElement referent = reference.resolve();
        if (referent == null && (results = reference.multiResolve(true)).length > 0) {
            referent = results[0].getElement();
        }
        return referent;
    }

    protected abstract void restoreReferences(ReferenceData[] var1, TRef[] var2);

    private static void askReferencesToRestore(Project project, @NotNull PsiElement[] refs, ReferenceData[] referenceData) {
        Object refObject;
        if (refs == null) {
            CopyPasteReferenceProcessor.$$$reportNull$$$0(6);
        }
        PsiManager manager = PsiManager.getInstance((Project)project);
        ArrayList<PsiClass> array = new ArrayList<PsiClass>();
        Object[] refObjects = new Object[refs.length];
        for (int i = 0; i < referenceData.length; ++i) {
            PsiElement ref = refs[i];
            if (ref == null) continue;
            LOG.assertTrue(ref.isValid());
            ReferenceData data = referenceData[i];
            PsiClass refClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(data.qClassName, ref.getResolveScope());
            if (refClass == null) continue;
            refObject = refClass;
            if (data.staticMemberName != null) {
                refObject = refClass.getQualifiedName() + "." + data.staticMemberName;
            }
            refObjects[i] = refObject;
            if (array.contains(refObject)) continue;
            array.add((PsiClass)refObject);
        }
        if (array.isEmpty()) {
            return;
        }
        Object[] selectedObjects = ArrayUtil.toObjectArray(array);
        Arrays.sort(selectedObjects, (o1, o2) -> CopyPasteReferenceProcessor.getFQName(o1).compareToIgnoreCase(CopyPasteReferenceProcessor.getFQName(o2)));
        RestoreReferencesDialog dialog = new RestoreReferencesDialog(project, selectedObjects);
        dialog.show();
        selectedObjects = dialog.getSelectedElements();
        for (int i = 0; i < referenceData.length; ++i) {
            PsiElement ref = refs[i];
            if (ref == null) continue;
            PsiUtilCore.ensureValid((PsiElement)ref);
            refObject = refObjects[i];
            boolean found = false;
            for (Object selected : selectedObjects) {
                if (!Comparing.equal((Object)refObject, (Object)selected)) continue;
                found = true;
                break;
            }
            if (found) continue;
            refs[i] = null;
        }
    }

    private static String getFQName(Object element) {
        return element instanceof PsiClass ? ((PsiClass)element).getQualifiedName() : (String)element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/CopyPasteReferenceProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTransferableData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTransferableData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/CopyPasteReferenceProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "askReferencesToRestore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

