/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.quickfix.ModifierFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.JavaElementRenderer;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.java.actions.CreateConstructorAction;
import com.intellij.lang.java.actions.CreateEnumConstantAction;
import com.intellij.lang.java.actions.CreateEnumConstantActionKt;
import com.intellij.lang.java.actions.CreateFieldAction;
import com.intellij.lang.java.actions.CreateFieldActionBase;
import com.intellij.lang.java.actions.CreateFieldActionKt;
import com.intellij.lang.java.actions.CreateMethodAction;
import com.intellij.lang.java.actions.JvmPsiUtilKt;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.CreateConstructorRequest;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.lang.jvm.actions.CreateMethodRequest;
import com.intellij.lang.jvm.actions.JvmElementActionsFactory;
import com.intellij.lang.jvm.actions.MemberRequest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JvmPsiConversionHelper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.CreateJavaBeanPropertyFix;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/codeInsight/intention/impl/JavaElementActionsFactory;", "Lcom/intellij/lang/jvm/actions/JvmElementActionsFactory;", "renderer", "Lcom/intellij/codeInsight/intention/impl/JavaElementRenderer;", "(Lcom/intellij/codeInsight/intention/impl/JavaElementRenderer;)V", "createAddConstructorActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "targetClass", "Lcom/intellij/lang/jvm/JvmClass;", "request", "Lcom/intellij/lang/jvm/actions/CreateConstructorRequest;", "createAddFieldActions", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "createAddMethodActions", "Lcom/intellij/lang/jvm/actions/CreateMethodRequest;", "createAddPropertyActions", "Lcom/intellij/lang/jvm/actions/MemberRequest$Property;", "createChangeModifierActions", "target", "Lcom/intellij/lang/jvm/JvmModifiersOwner;", "Lcom/intellij/lang/jvm/actions/MemberRequest$Modifier;", "intellij.java.impl"})
public final class JavaElementActionsFactory
extends JvmElementActionsFactory {
    private final JavaElementRenderer renderer;

    @NotNull
    public List<IntentionAction> createChangeModifierActions(@NotNull JvmModifiersOwner target, @NotNull MemberRequest.Modifier request) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        MemberRequest.Modifier $receiver = request;
        PsiModifierListOwner declaration2 = (PsiModifierListOwner)target;
        return Intrinsics.areEqual((Object)declaration2.getLanguage(), (Object)JavaLanguage.INSTANCE) ^ true ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)((Object)new ModifierFix(declaration2.getModifierList(), this.renderer.render($receiver.getModifier()), $receiver.getShouldPresent(), false)));
    }

    @NotNull
    public List<IntentionAction> createAddPropertyActions(@NotNull JvmClass targetClass, @NotNull MemberRequest.Property request) {
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        MemberRequest.Property $receiver = request;
        PsiClass psiClass = JvmPsiUtilKt.toJavaClassOrNull(targetClass);
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass psiClass2 = psiClass;
        JvmPsiConversionHelper helper = JvmPsiConversionHelper.getInstance((Project)psiClass2.getProject());
        PsiType propertyType = helper.convertType($receiver.getPropertyType());
        if ($receiver.getGetterRequired() && $receiver.getSetterRequired()) {
            return CollectionsKt.listOf((Object[])new IntentionAction[]{new CreateJavaBeanPropertyFix(psiClass2, $receiver.getPropertyName(), propertyType, $receiver.getGetterRequired(), $receiver.getSetterRequired(), true), new CreateJavaBeanPropertyFix(psiClass2, $receiver.getPropertyName(), propertyType, $receiver.getGetterRequired(), $receiver.getSetterRequired(), false)});
        }
        if ($receiver.getGetterRequired() || $receiver.getSetterRequired()) {
            return CollectionsKt.listOf((Object[])new IntentionAction[]{new CreateJavaBeanPropertyFix(psiClass2, $receiver.getPropertyName(), propertyType, $receiver.getGetterRequired(), $receiver.getSetterRequired(), true), new CreateJavaBeanPropertyFix(psiClass2, $receiver.getPropertyName(), propertyType, $receiver.getGetterRequired(), $receiver.getSetterRequired(), false), new CreateJavaBeanPropertyFix(psiClass2, $receiver.getPropertyName(), propertyType, true, true, true)});
        }
        return CollectionsKt.listOf((Object)new CreateJavaBeanPropertyFix(psiClass2, $receiver.getPropertyName(), propertyType, $receiver.getGetterRequired(), $receiver.getSetterRequired(), true));
    }

    @NotNull
    public List<IntentionAction> createAddFieldActions(@NotNull JvmClass targetClass, @NotNull CreateFieldRequest request) {
        CreateFieldActionBase createFieldActionBase;
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        PsiClass psiClass = JvmPsiUtilKt.toJavaClassOrNull(targetClass);
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass javaClass = psiClass;
        boolean constantRequested = request.getConstant() || javaClass.isInterface() || request.getModifiers().containsAll((Collection)CreateFieldActionKt.getConstantModifiers());
        ArrayList result = new ArrayList();
        if (constantRequested || StringUtil.isCapitalized((String)request.getFieldName())) {
            collection = result;
            createFieldActionBase = new CreateFieldAction(javaClass, request, true);
            collection.add(createFieldActionBase);
        }
        if (!constantRequested) {
            collection = result;
            createFieldActionBase = new CreateFieldAction(javaClass, request, false);
            collection.add(createFieldActionBase);
        }
        if (CreateEnumConstantActionKt.canCreateEnumConstant(javaClass, request)) {
            collection = result;
            createFieldActionBase = new CreateEnumConstantAction(javaClass, request);
            collection.add(createFieldActionBase);
        }
        return result;
    }

    @NotNull
    public List<IntentionAction> createAddMethodActions(@NotNull JvmClass targetClass, @NotNull CreateMethodRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        PsiClass psiClass = JvmPsiUtilKt.toJavaClassOrNull(targetClass);
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass javaClass = psiClass;
        Collection requestedModifiers = request.getModifiers();
        boolean staticMethodRequested = requestedModifiers.contains(JvmModifier.STATIC);
        if (staticMethodRequested) {
            if (javaClass.isInterface() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)((PsiElement)javaClass))) {
                return CollectionsKt.emptyList();
            }
            if (javaClass.getContainingClass() != null && !javaClass.hasModifierProperty("static")) {
                return CollectionsKt.emptyList();
            }
        }
        ArrayList result = new ArrayList();
        Collection collection = result;
        CreateMethodAction createMethodAction = new CreateMethodAction(javaClass, request, false);
        collection.add(createMethodAction);
        if (!staticMethodRequested && javaClass.hasModifierProperty("abstract") && !javaClass.isInterface()) {
            collection = result;
            createMethodAction = new CreateMethodAction(javaClass, request, true);
            collection.add(createMethodAction);
        }
        return result;
    }

    @NotNull
    public List<IntentionAction> createAddConstructorActions(@NotNull JvmClass targetClass, @NotNull CreateConstructorRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        PsiClass psiClass = JvmPsiUtilKt.toJavaClassOrNull(targetClass);
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass javaClass = psiClass;
        return CollectionsKt.listOf((Object)new CreateConstructorAction(javaClass, request));
    }

    public JavaElementActionsFactory(@NotNull JavaElementRenderer renderer) {
        Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
        this.renderer = renderer;
    }
}

