/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NonFinalGuardInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CONCURRENCY_ANNOTATION_ISSUES;
        if (string == null) {
            NonFinalGuardInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Non-final @GuardedBy field" == null) {
            NonFinalGuardInspection.$$$reportNull$$$0(1);
        }
        return "Non-final @GuardedBy field";
    }

    @NotNull
    public String getShortName() {
        if ("NonFinalGuard" == null) {
            NonFinalGuardInspection.$$$reportNull$$$0(2);
        }
        return "NonFinalGuard";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            NonFinalGuardInspection.$$$reportNull$$$0(3);
        }
        Visitor visitor = new Visitor(holder);
        if (visitor == null) {
            NonFinalGuardInspection.$$$reportNull$$$0(4);
        }
        return visitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/concurrencyAnnotations/NonFinalGuardInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/concurrencyAnnotations/NonFinalGuardInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        public Visitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            if (!JCiPUtil.isGuardedByAnnotation(annotation)) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(annotation);
            if (guardValue == null || "this".equals(guardValue)) {
                return;
            }
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiClass.class);
            if (containingClass == null) {
                return;
            }
            PsiField guardField = containingClass.findFieldByName(guardValue, true);
            if (guardField == null) {
                return;
            }
            if (guardField.hasModifierProperty("final")) {
                return;
            }
            PsiAnnotationMemberValue member = annotation.findAttributeValue("value");
            if (member == null) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)member, "Non-final @GuardedBy field #ref #loc", new LocalQuickFix[0]);
        }

        public void visitDocTag(PsiDocTag psiDocTag) {
            super.visitDocTag(psiDocTag);
            if (!JCiPUtil.isGuardedByTag(psiDocTag)) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(psiDocTag);
            if ("this".equals(guardValue)) {
                return;
            }
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiDocTag, PsiClass.class);
            if (containingClass == null) {
                return;
            }
            PsiField guardField = containingClass.findFieldByName(guardValue, true);
            if (guardField == null) {
                return;
            }
            if (guardField.hasModifierProperty("final")) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)psiDocTag, "Non-final @GuardedBy field \"" + guardValue + "\" #loc", new LocalQuickFix[0]);
        }
    }
}

