/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.Java8MigrationUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java8MapApiInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(Java8MapApiInspection.class);
    public static final String SHORT_NAME = "Java8MapApi";
    public boolean mySuggestMapGetOrDefault = true;
    public boolean mySuggestMapComputeIfAbsent = true;
    public boolean mySuggestMapPutIfAbsent = true;
    public boolean mySuggestMapMerge = true;
    public boolean myTreatGetNullAsContainsKey = false;
    public boolean mySideEffects = false;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox("Suggest conversion to Map.computeIfAbsent", "mySuggestMapComputeIfAbsent");
        panel.addCheckbox("Suggest conversion to Map.getOrDefault", "mySuggestMapGetOrDefault");
        panel.addCheckbox("Suggest conversion to Map.putIfAbsent", "mySuggestMapPutIfAbsent");
        panel.addCheckbox("Suggest conversion to Map.merge", "mySuggestMapMerge");
        panel.addCheckbox("Treat 'get(k) != null' the same as 'containsKey(k)' (may change semantics)", "myTreatGetNullAsContainsKey");
        panel.addCheckbox("Suggest replacement even if lambda may have side effects", "mySideEffects");
        return panel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            Java8MapApiInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                Java8MapApiInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitConditionalExpression(PsiConditionalExpression expression2) {
                Java8MigrationUtils.MapCheckCondition condition2 = Java8MigrationUtils.MapCheckCondition.fromConditional((PsiElement)expression2, Java8MapApiInspection.this.myTreatGetNullAsContainsKey);
                if (condition2 == null || condition2.hasVariable()) {
                    return;
                }
                PsiExpression existsBranch = condition2.getExistsBranch(expression2.getThenExpression(), expression2.getElseExpression());
                PsiExpression noneBranch = condition2.getNoneBranch(expression2.getThenExpression(), expression2.getElseExpression());
                this.processGetPut(condition2, (PsiElement)existsBranch, (PsiElement)existsBranch, (PsiElement)noneBranch);
            }

            public void visitIfStatement(PsiIfStatement statement) {
                Java8MigrationUtils.MapCheckCondition condition2 = Java8MigrationUtils.MapCheckCondition.fromConditional((PsiElement)statement, Java8MapApiInspection.this.myTreatGetNullAsContainsKey);
                if (condition2 == null) {
                    return;
                }
                PsiStatement existsBranch = ControlFlowUtils.stripBraces(condition2.getExistsBranch(statement.getThenBranch(), statement.getElseBranch()));
                PsiStatement noneBranch = ControlFlowUtils.stripBraces(condition2.getNoneBranch(statement.getThenBranch(), statement.getElseBranch()));
                if (existsBranch == null) {
                    this.processSingleBranch(condition2, noneBranch);
                } else {
                    if (Java8MapApiInspection.this.mySuggestMapMerge && condition2.isGetNull()) {
                        this.processMerge(condition2, existsBranch, noneBranch);
                    }
                    if (condition2.hasVariable()) {
                        return;
                    }
                    EquivalenceChecker.Match match = EquivalenceChecker.getCanonicalPsiEquivalence().statementsMatch(noneBranch, existsBranch);
                    this.processGetPut(condition2, (PsiElement)existsBranch, match.getRightDiff(), match.getLeftDiff());
                }
            }

            private void processMerge(Java8MigrationUtils.MapCheckCondition condition2, PsiStatement existsBranch, PsiStatement noneBranch) {
                if (noneBranch instanceof PsiExpressionStatement && existsBranch instanceof PsiExpressionStatement) {
                    PsiElement[] mapRefs;
                    PsiExpression absentValue = Java8MigrationUtils.extractPutValue(condition2, noneBranch);
                    if (absentValue == null) {
                        return;
                    }
                    PsiExpression presentValue = Java8MigrationUtils.extractPutValue(condition2, existsBranch);
                    if (presentValue == null || !LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)presentValue)) {
                        return;
                    }
                    if (!PsiTreeUtil.processElements((PsiElement)absentValue, e -> !condition2.isMap(e))) {
                        return;
                    }
                    boolean hasVariable = condition2.hasVariable();
                    if (hasVariable) {
                        if (PsiTreeUtil.collectElements((PsiElement)presentValue, condition2::isValueReference).length == 0) {
                            return;
                        }
                    }
                    if (hasVariable ^ (mapRefs = PsiTreeUtil.collectElements((PsiElement)presentValue, condition2::isMap)).length == 0) {
                        return;
                    }
                    for (PsiElement mapRef : mapRefs) {
                        PsiElement parent = mapRef.getParent();
                        if (parent instanceof PsiReferenceExpression && condition2.extractGetCall(parent.getParent()) != null) continue;
                        return;
                    }
                    if (PsiTreeUtil.collectElements((PsiElement)presentValue, e -> PsiEquivalenceUtil.areElementsEquivalent((PsiElement)e, (PsiElement)absentValue)).length == 0) {
                        return;
                    }
                    boolean informationLevel = !Java8MapApiInspection.this.mySideEffects && SideEffectChecker.mayHaveSideEffects((PsiElement)presentValue, ex -> condition2.extractGetCall((PsiElement)ex) != null);
                    Java8MapApiInspection.register(condition2, holder, informationLevel, new ReplaceWithSingleMapOperation("merge", (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)absentValue, PsiMethodCallExpression.class), presentValue, (PsiElement)noneBranch));
                }
            }

            private void processGetPut(Java8MigrationUtils.MapCheckCondition condition2, PsiElement result, PsiElement exists, PsiElement none) {
                PsiMethodCallExpression getCall = condition2.extractGetCall(exists);
                if (getCall == null) {
                    return;
                }
                if (!(none instanceof PsiExpression)) {
                    return;
                }
                PsiExpression noneExpression = (PsiExpression)none;
                PsiMethodCallExpression putCall = Java8MigrationUtils.extractMapMethodCall(noneExpression, "put");
                if (Java8MapApiInspection.this.mySuggestMapPutIfAbsent && putCall != null && condition2.isGetNull() && condition2.isMap((PsiElement)putCall.getMethodExpression().getQualifierExpression())) {
                    PsiExpression[] putArgs = putCall.getArgumentList().getExpressions();
                    if (putArgs.length != 2 || !condition2.isKey((PsiElement)putArgs[0]) || !ExpressionUtils.isSimpleExpression(putArgs[1])) {
                        return;
                    }
                    Java8MapApiInspection.register(condition2, holder, false, new ReplaceWithSingleMapOperation("putIfAbsent", getCall, putArgs[1], result));
                }
                if (Java8MapApiInspection.this.mySuggestMapGetOrDefault && condition2.isContainsKey() && ExpressionUtils.isSimpleExpression(noneExpression) && condition2.isMapValueType(noneExpression.getType())) {
                    Java8MapApiInspection.register(condition2, holder, false, new ReplaceWithSingleMapOperation("getOrDefault", getCall, noneExpression, result));
                }
            }

            private void processSingleBranch(Java8MigrationUtils.MapCheckCondition condition2, PsiStatement noneBranch) {
                PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)noneBranch);
                if (assignment != null && Java8MapApiInspection.this.mySuggestMapGetOrDefault && condition2.isContainsKey()) {
                    PsiExpression rValue = assignment.getRExpression();
                    if (ExpressionUtils.isSimpleExpression(rValue) && condition2.isValueReference((PsiElement)assignment.getLExpression()) && !condition2.isValueReference((PsiElement)rValue) && condition2.isMapValueType(rValue.getType())) {
                        Java8MapApiInspection.register(condition2, holder, false, ReplaceWithSingleMapOperation.fromIf("getOrDefault", condition2, rValue));
                    }
                } else if (condition2.isGetNull()) {
                    PsiExpression expression2;
                    PsiExpression lambdaCandidate = Java8MigrationUtils.extractLambdaCandidate(condition2, noneBranch);
                    if (lambdaCandidate != null && Java8MapApiInspection.this.mySuggestMapComputeIfAbsent) {
                        boolean informationLevel = !Java8MapApiInspection.this.mySideEffects && SideEffectChecker.mayHaveSideEffects(lambdaCandidate);
                        Java8MapApiInspection.register(condition2, holder, informationLevel, ReplaceWithSingleMapOperation.fromIf("computeIfAbsent", condition2, lambdaCandidate));
                    }
                    if (lambdaCandidate == null && (expression2 = Java8MigrationUtils.extractPutValue(condition2, noneBranch)) != null) {
                        String replacement = null;
                        boolean informationLevel = false;
                        if (Java8MapApiInspection.this.mySuggestMapPutIfAbsent && ExpressionUtils.isSimpleExpression(expression2) && !condition2.isValueReference((PsiElement)expression2)) {
                            replacement = "putIfAbsent";
                        } else if (Java8MapApiInspection.this.mySuggestMapComputeIfAbsent && !condition2.hasVariable()) {
                            informationLevel = !Java8MapApiInspection.this.mySideEffects && SideEffectChecker.mayHaveSideEffects(expression2);
                            replacement = "computeIfAbsent";
                        }
                        if (replacement != null) {
                            if (condition2.hasVariable()) {
                                Java8MapApiInspection.register(condition2, holder, informationLevel, ReplaceWithSingleMapOperation.fromIf(replacement, condition2, expression2));
                            } else {
                                PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethodCallExpression.class);
                                LOG.assertTrue(call != null);
                                Java8MapApiInspection.register(condition2, holder, informationLevel, new ReplaceWithSingleMapOperation(replacement, call, expression2, (PsiElement)noneBranch));
                            }
                        }
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            Java8MapApiInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    @NotNull
    public static String getNameCandidate(String name) {
        if ((name = name.replaceFirst("^[_\\d]+", "")).isEmpty()) {
            if ("k" == null) {
                Java8MapApiInspection.$$$reportNull$$$0(3);
            }
            return "k";
        }
        String nameCandidate = name.substring(0, 1);
        for (int pos = name.length() - 1; pos > 0; --pos) {
            if (!Character.isUpperCase(name.charAt(pos))) continue;
            if (pos == name.length() - 1) break;
            nameCandidate = name.substring(pos, pos + 1);
            break;
        }
        String string = nameCandidate.toLowerCase(Locale.ENGLISH);
        if (string == null) {
            Java8MapApiInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static void register(Java8MigrationUtils.MapCheckCondition condition2, ProblemsHolder holder, boolean informationLevel, ReplaceWithSingleMapOperation fix) {
        if (informationLevel && !holder.isOnTheFly()) {
            return;
        }
        holder.registerProblem((PsiElement)condition2.getFullCondition(), QuickFixBundle.message("java.8.map.api.inspection.description", fix.myMethodName), informationLevel ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java18api/Java8MapApiInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java18api/Java8MapApiInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameCandidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceWithSingleMapOperation
    implements LocalQuickFix {
        private final String myMethodName;
        private final SmartPsiElementPointer<PsiMethodCallExpression> myCallPointer;
        private final SmartPsiElementPointer<PsiExpression> myValuePointer;
        private final SmartPsiElementPointer<PsiElement> myResultPointer;

        ReplaceWithSingleMapOperation(String methodName, PsiMethodCallExpression call, PsiExpression value2, PsiElement result) {
            this.myMethodName = methodName;
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)value2.getProject());
            this.myCallPointer = manager.createSmartPsiElementPointer((PsiElement)call);
            this.myValuePointer = manager.createSmartPsiElementPointer((PsiElement)value2);
            this.myResultPointer = manager.createSmartPsiElementPointer(result);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpression replacement;
            PsiElement conditional;
            if (project == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(1);
            }
            if ((conditional = PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), (Class[])new Class[]{PsiIfStatement.class, PsiConditionalExpression.class})) == null) {
                return;
            }
            Java8MigrationUtils.MapCheckCondition condition2 = Java8MigrationUtils.MapCheckCondition.fromConditional(conditional, true);
            if (condition2 == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)this.myCallPointer.getElement();
            if (call == null) {
                return;
            }
            PsiExpressionList argsList = call.getArgumentList();
            PsiExpression[] args = argsList.getExpressions();
            if (args.length == 0) {
                return;
            }
            if (this.myMethodName.equals("merge") && args.length != 2) {
                return;
            }
            PsiExpression value2 = (PsiExpression)this.myValuePointer.getElement();
            if (value2 == null) {
                return;
            }
            PsiElement result = this.myResultPointer.getElement();
            if (result == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            CommentTracker ct = new CommentTracker();
            ExpressionUtils.bindCallTo(call, this.myMethodName);
            if (this.myMethodName.equals("computeIfAbsent")) {
                PsiMethod method;
                PsiExpression key2 = args[0];
                List refs = Collections.emptyList();
                String nameCandidate = "k";
                if (key2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)key2).getQualifier() == null && (method = call.resolveMethod()) != null) {
                    PsiType argType = method.getParameterList().getParameters()[0].getType();
                    PsiType mapKeyType = call.resolveMethodGenerics().getSubstitutor().substitute(argType);
                    PsiType keyType = key2.getType();
                    if (mapKeyType != null && keyType != null && keyType.isAssignableFrom(mapKeyType)) {
                        PsiElement target = ((PsiReferenceExpression)key2).resolve();
                        refs = ((StreamEx)StreamEx.of((Collection)PsiTreeUtil.collectElementsOfType((PsiElement)value2, (Class[])new Class[]{PsiReferenceExpression.class})).filter(ref -> ref.getQualifierExpression() == null && ref.isReferenceTo(target))).toList();
                        if (!refs.isEmpty()) {
                            nameCandidate = Java8MapApiInspection.getNameCandidate(((PsiReferenceExpression)key2).getReferenceName());
                        }
                    }
                }
                String varName = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName(nameCandidate, (PsiElement)value2, true);
                for (PsiReferenceExpression ref2 : refs) {
                    ExpressionUtils.bindReferenceTo(ref2, varName);
                }
                replacement = factory.createExpressionFromText(varName + " -> " + ct.text((PsiElement)value2), (PsiElement)value2);
            } else if (this.myMethodName.equals("merge")) {
                PsiExpression absentValue = args[1];
                String aVar = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName("a", (PsiElement)value2, true);
                String bVar = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName("b", (PsiElement)value2, true);
                for (PsiElement e2 : PsiTreeUtil.collectElements((PsiElement)value2, e -> PsiEquivalenceUtil.areElementsEquivalent((PsiElement)e, (PsiElement)absentValue))) {
                    ct.replace(e2, (PsiElement)factory.createIdentifier(bVar));
                }
                for (PsiElement e2 : PsiTreeUtil.collectElements((PsiElement)value2, e -> condition2.extractGetCall(e) != null || condition2.isValueReference(e))) {
                    ct.replace(e2, (PsiElement)factory.createIdentifier(aVar));
                }
                replacement = factory.createExpressionFromText("(" + aVar + "," + bVar + ") -> " + ct.text((PsiElement)value2), (PsiElement)value2);
            } else {
                replacement = ct.markUnchanged(value2);
            }
            PsiElement newArg = args.length == 2 && !this.myMethodName.equals("merge") ? ct.replace((PsiElement)args[1], (PsiElement)replacement) : argsList.add((PsiElement)replacement);
            if (newArg instanceof PsiLambdaExpression) {
                LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference((PsiLambdaExpression)newArg);
            }
            if (PsiTreeUtil.isAncestor((PsiElement)conditional, (PsiElement)result, (boolean)true)) {
                result = ct.replaceAndRestoreComments(conditional, ct.markUnchanged(result));
            } else {
                ct.deleteAndRestoreComments(conditional);
            }
            PsiVariable variable = condition2.extractDeclaration();
            if (variable != null && !PsiTreeUtil.isAncestor((PsiElement)result, (PsiElement)variable, (boolean)true) && ReferencesSearch.search((PsiElement)variable).findFirst() == null) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)variable);
            }
            CodeStyleManager.getInstance((Project)project).reformat(result);
        }

        @Nls
        @NotNull
        public String getName() {
            String string = QuickFixBundle.message("java.8.map.api.inspection.fix.text", this.myMethodName);
            if (string == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("java.8.map.api.inspection.fix.family.name", new Object[0]);
            if (string == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        static ReplaceWithSingleMapOperation fromIf(String methodName, Java8MigrationUtils.MapCheckCondition condition2, PsiExpression value2) {
            PsiMethodCallExpression call = condition2.getCheckCall();
            PsiStatement result = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)call, PsiStatement.class);
            LOG.assertTrue(result != null);
            ReplaceWithSingleMapOperation replaceWithSingleMapOperation = new ReplaceWithSingleMapOperation(methodName, call, value2, (PsiElement)result);
            if (replaceWithSingleMapOperation == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(4);
            }
            return replaceWithSingleMapOperation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java18api/Java8MapApiInspection$ReplaceWithSingleMapOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java18api/Java8MapApiInspection$ReplaceWithSingleMapOperation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromIf";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

