/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesDialog;
import com.intellij.find.findUsages.JavaPackageFindUsagesOptions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class FindPackageUsagesDialog
extends JavaFindUsagesDialog<JavaPackageFindUsagesOptions> {
    private StateRestoringCheckBox myCbUsages;
    private StateRestoringCheckBox myCbClassesUsages;

    public FindPackageUsagesDialog(PsiElement element, Project project, FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler) {
        super(element, project, findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler);
    }

    public JComponent getPreferredFocusedControl() {
        return this.myCbUsages;
    }

    @Override
    public void calcFindUsagesOptions(JavaPackageFindUsagesOptions options) {
        super.calcFindUsagesOptions(options);
        options.isUsages = FindPackageUsagesDialog.isSelected((JCheckBox)this.myCbUsages);
        if (FindPackageUsagesDialog.isToChange((JCheckBox)this.myCbClassesUsages)) {
            options.isClassesUsages = FindPackageUsagesDialog.isSelected((JCheckBox)this.myCbClassesUsages);
        }
        options.isSkipPackageStatements = false;
        options.isSkipImportStatements = false;
    }

    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = new JPanel();
        findWhatPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message((String)"find.what.group", (Object[])new Object[0]), (boolean)true));
        findWhatPanel.setLayout(new BoxLayout(findWhatPanel, 1));
        this.myCbUsages = this.addCheckboxToPanel(FindBundle.message((String)"find.what.usages.checkbox", (Object[])new Object[0]), ((JavaPackageFindUsagesOptions)((Object)this.getFindUsagesOptions())).isUsages, findWhatPanel, true);
        this.myCbClassesUsages = this.addCheckboxToPanel(FindBundle.message((String)"find.what.usages.of.classes.and.interfaces", (Object[])new Object[0]), ((JavaPackageFindUsagesOptions)((Object)this.getFindUsagesOptions())).isClassesUsages, findWhatPanel, true);
        return findWhatPanel;
    }

    protected void update() {
        if (this.myCbToSearchForTextOccurrences != null) {
            if (FindPackageUsagesDialog.isSelected((JCheckBox)this.myCbUsages)) {
                this.myCbToSearchForTextOccurrences.makeSelectable();
            } else {
                this.myCbToSearchForTextOccurrences.makeUnselectable(false);
            }
        }
        boolean hasSelected = FindPackageUsagesDialog.isSelected((JCheckBox)this.myCbUsages) || FindPackageUsagesDialog.isSelected((JCheckBox)this.myCbClassesUsages);
        this.setOKActionEnabled(hasSelected);
    }
}

