/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.services;

import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.services.MavenRepositoryService;
import com.intellij.jarRepository.services.artifactory.ArtifactoryRepositoryService;
import com.intellij.jarRepository.services.nexus.NexusRepositoryService;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="MavenServices", storages={@Storage(value="mavenServices.xml")})
public class MavenRepositoryServicesManager
implements PersistentStateComponent<MavenRepositoryServicesManager> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.repository.services.MavenRepositoryServicesManager");
    private final List<String> myUrls = new ArrayList<String>();
    public static final List<String> DEFAULT_SERVICES = Collections.unmodifiableList(Arrays.asList("https://oss.sonatype.org/service/local/", "http://repo.jfrog.org/artifactory/api/", "https://repository.jboss.org/nexus/service/local/"));

    public MavenRepositoryServicesManager() {
        this.myUrls.addAll(DEFAULT_SERVICES);
    }

    @NotNull
    public static MavenRepositoryServicesManager getInstance(Project project) {
        MavenRepositoryServicesManager mavenRepositoryServicesManager = (MavenRepositoryServicesManager)ServiceManager.getService((Project)project, MavenRepositoryServicesManager.class);
        if (mavenRepositoryServicesManager == null) {
            MavenRepositoryServicesManager.$$$reportNull$$$0(0);
        }
        return mavenRepositoryServicesManager;
    }

    @NotNull
    public static MavenRepositoryService[] getServices() {
        MavenRepositoryService[] mavenRepositoryServiceArray = new MavenRepositoryService[]{new NexusRepositoryService(), new ArtifactoryRepositoryService()};
        if (mavenRepositoryServiceArray == null) {
            MavenRepositoryServicesManager.$$$reportNull$$$0(1);
        }
        return mavenRepositoryServiceArray;
    }

    public static String[] getServiceUrls(Project project) {
        return ArrayUtil.toStringArray(MavenRepositoryServicesManager.getInstance(project).getUrls());
    }

    @Property(surroundWithTag=false)
    @XCollection(elementName="service-url", valueAttributeName="")
    @NotNull
    public List<String> getUrls() {
        List<String> list = this.myUrls;
        if (list == null) {
            MavenRepositoryServicesManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void setUrls(@NotNull List<String> urls) {
        if (urls == null) {
            MavenRepositoryServicesManager.$$$reportNull$$$0(3);
        }
        if (this.myUrls != urls) {
            this.myUrls.clear();
            this.myUrls.addAll(urls);
        }
    }

    public MavenRepositoryServicesManager getState() {
        return this;
    }

    public void loadState(@NotNull MavenRepositoryServicesManager state) {
        if (state == null) {
            MavenRepositoryServicesManager.$$$reportNull$$$0(4);
        }
        this.myUrls.clear();
        this.myUrls.addAll(state.getUrls());
    }

    @NotNull
    public static List<RemoteRepositoryDescription> getRepositories(String url) {
        SmartList result = new SmartList();
        for (MavenRepositoryService service : MavenRepositoryServicesManager.getServices()) {
            try {
                result.addAll(service.getRepositories(url));
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            MavenRepositoryServicesManager.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    @NotNull
    public static List<RepositoryArtifactDescription> findArtifacts(@NotNull RepositoryArtifactDescription template, @NotNull String url) {
        if (template == null) {
            MavenRepositoryServicesManager.$$$reportNull$$$0(6);
        }
        if (url == null) {
            MavenRepositoryServicesManager.$$$reportNull$$$0(7);
        }
        SmartList result = new SmartList();
        for (MavenRepositoryService service : MavenRepositoryServicesManager.getServices()) {
            try {
                result.addAll(service.findArtifacts(url, template));
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            MavenRepositoryServicesManager.$$$reportNull$$$0(8);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/services/MavenRepositoryServicesManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getServices";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/services/MavenRepositoryServicesManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setUrls";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findArtifacts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

