/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java.wrap.impl;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.java.JavaFormatterUtil;
import com.intellij.psi.formatter.java.wrap.ReservedWrapsProvider;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;

public class JavaChildBlockWrapFactory {
    @Nullable
    public Wrap create(ASTBlock block, CommonCodeStyleSettings settings, ReservedWrapsProvider reservedWrapsProvider) {
        ASTNode node = block.getNode();
        Wrap wrap = block.getWrap();
        IElementType nodeType = node.getElementType();
        if (nodeType == JavaElementType.EXTENDS_LIST || nodeType == JavaElementType.IMPLEMENTS_LIST) {
            return Wrap.createWrap((int)settings.EXTENDS_LIST_WRAP, (boolean)false);
        }
        if (node instanceof PsiPolyadicExpression) {
            Wrap actualWrap;
            Wrap wrap2 = actualWrap = wrap != null ? wrap : reservedWrapsProvider.getReservedWrap(JavaElementType.BINARY_EXPRESSION);
            if (actualWrap == null) {
                return Wrap.createWrap((int)settings.BINARY_OPERATION_WRAP, (boolean)false);
            }
            if (JavaFormatterUtil.areSamePriorityBinaryExpressions(node, node.getTreeParent())) {
                return actualWrap;
            }
            return Wrap.createChildWrap((Wrap)actualWrap, (WrapType)WrapType.byLegacyRepresentation((int)settings.BINARY_OPERATION_WRAP), (boolean)false);
        }
        if (nodeType == JavaElementType.CONDITIONAL_EXPRESSION) {
            return Wrap.createWrap((int)settings.TERNARY_OPERATION_WRAP, (boolean)false);
        }
        if (nodeType == JavaElementType.ASSERT_STATEMENT) {
            return Wrap.createWrap((int)settings.ASSERT_STATEMENT_WRAP, (boolean)false);
        }
        if (nodeType == JavaElementType.FOR_STATEMENT) {
            return Wrap.createWrap((int)settings.FOR_STATEMENT_WRAP, (boolean)false);
        }
        if (nodeType == JavaElementType.THROWS_LIST) {
            return Wrap.createWrap((int)settings.THROWS_LIST_WRAP, (boolean)true);
        }
        if (nodeType == JavaElementType.CODE_BLOCK) {
            if (settings.KEEP_SIMPLE_METHODS_IN_ONE_LINE && node.getPsi().getParent() instanceof PsiMethod && !node.textContains('\n')) {
                return null;
            }
            return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)false);
        }
        if (JavaFormatterUtil.isAssignment(node)) {
            return Wrap.createWrap((int)settings.ASSIGNMENT_WRAP, (boolean)true);
        }
        return null;
    }
}

