/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.beanProperties;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateJavaBeanPropertyFix
implements LocalQuickFix,
IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.beanProperties.CreateJavaBeanPropertyFix");
    protected final String myPropertyName;
    @NotNull
    protected final SmartPsiElementPointer<PsiClass> myPsiClass;
    @NotNull
    protected final PsiType myType;
    private final boolean myGetter;
    private final boolean mySetter;
    private final boolean myField;

    public CreateJavaBeanPropertyFix(@NotNull PsiClass psiClass, @NotNull String propertyName, @NotNull PsiType propertyType, boolean getterRequired, boolean setterRequired, boolean fieldRequired) {
        if (psiClass == null) {
            CreateJavaBeanPropertyFix.$$$reportNull$$$0(0);
        }
        if (propertyName == null) {
            CreateJavaBeanPropertyFix.$$$reportNull$$$0(1);
        }
        if (propertyType == null) {
            CreateJavaBeanPropertyFix.$$$reportNull$$$0(2);
        }
        this.myPropertyName = propertyName;
        this.myPsiClass = SmartPointerManager.getInstance((Project)psiClass.getProject()).createSmartPsiElementPointer((PsiElement)psiClass);
        this.myType = propertyType;
        this.myGetter = getterRequired;
        this.mySetter = setterRequired;
        this.myField = fieldRequired;
    }

    @NotNull
    public String getName() {
        if (this.myGetter && this.mySetter && this.myField) {
            String string = QuickFixBundle.message("create.readable.writable.property.with.field", this.myPropertyName);
            if (string == null) {
                CreateJavaBeanPropertyFix.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (this.myField && this.myGetter) {
            String string = QuickFixBundle.message("create.readable.property.with.field", this.myPropertyName);
            if (string == null) {
                CreateJavaBeanPropertyFix.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (this.myField && this.mySetter) {
            String string = QuickFixBundle.message("create.writable.property.with.field", this.myPropertyName);
            if (string == null) {
                CreateJavaBeanPropertyFix.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (!this.myField && this.myGetter) {
            String string = QuickFixBundle.message("create.readable.property", this.myPropertyName);
            if (string == null) {
                CreateJavaBeanPropertyFix.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (!this.myField && this.mySetter) {
            String string = QuickFixBundle.message("create.writable.property", this.myPropertyName);
            if (string == null) {
                CreateJavaBeanPropertyFix.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = QuickFixBundle.message("create.readable.writable.property.with.field", this.myPropertyName);
        if (string == null) {
            CreateJavaBeanPropertyFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    protected void doFix() throws IncorrectOperationException {
        if (this.myField) {
            this.createField();
        }
        if (this.mySetter) {
            this.createSetter(this.myField);
        }
        if (this.myGetter) {
            this.createGetter(this.myField);
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            CreateJavaBeanPropertyFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            CreateJavaBeanPropertyFix.$$$reportNull$$$0(10);
        }
        if (descriptor == null) {
            CreateJavaBeanPropertyFix.$$$reportNull$$$0(11);
        }
        this.applyFix(project);
    }

    private void applyFix(Project project) {
        new WriteCommandAction.Simple(project, this.getName(), new PsiFile[]{this.myPsiClass.getContainingFile()}){

            protected void run() throws Throwable {
                try {
                    CreateJavaBeanPropertyFix.this.doFix();
                }
                catch (IncorrectOperationException e) {
                    LOG.error("Cannot create property", (Throwable)e);
                }
            }
        }.execute();
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            CreateJavaBeanPropertyFix.$$$reportNull$$$0(12);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CreateJavaBeanPropertyFix.$$$reportNull$$$0(13);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            CreateJavaBeanPropertyFix.$$$reportNull$$$0(14);
        }
        this.applyFix(project);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private String getFieldName() {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.myPsiClass.getProject());
        return styleManager.suggestVariableName((VariableKind)VariableKind.FIELD, (String)this.myPropertyName, null, (PsiType)this.myType).names[0];
    }

    private void createSetter(boolean createField) throws IncorrectOperationException {
        String text2;
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myPsiClass.getProject()).getElementFactory();
        String methodName = PropertyUtilBase.suggestSetterName((String)this.myPropertyName);
        String typeName = this.myType.getCanonicalText();
        PsiClass psiClass = (PsiClass)this.myPsiClass.getElement();
        if (psiClass == null) {
            return;
        }
        boolean isInterface = psiClass.isInterface();
        if (isInterface) {
            text2 = "public void " + methodName + "(" + typeName + " " + this.myPropertyName + ");";
        } else if (createField) {
            String fieldName = this.getFieldName();
            if (fieldName.equals(this.myPropertyName)) {
                fieldName = "this." + fieldName;
            }
            text2 = "public void " + methodName + "(" + typeName + " " + this.myPropertyName + ") {" + fieldName + "=" + this.myPropertyName + ";}";
        } else {
            text2 = "public void " + methodName + "(" + typeName + " " + this.myPropertyName + ") {}";
        }
        PsiMethod method = elementFactory.createMethodFromText(text2, null);
        PsiMethod psiElement = (PsiMethod)psiClass.add((PsiElement)method);
        if (!isInterface && !createField) {
            CreateFromUsageUtils.setupMethodBody(psiElement, psiClass);
        }
    }

    private void createGetter(boolean createField) throws IncorrectOperationException {
        String text2;
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myPsiClass.getProject()).getElementFactory();
        String methodName = PropertyUtilBase.suggestGetterName((String)this.myPropertyName, (PsiType)this.myType);
        String typeName = this.myType.getCanonicalText();
        PsiClass psiClass = (PsiClass)this.myPsiClass.getElement();
        if (psiClass == null) {
            return;
        }
        boolean isInterface = psiClass.isInterface();
        if (createField) {
            String fieldName = this.getFieldName();
            text2 = "public " + typeName + " " + methodName + "() { return " + fieldName + "; }";
        } else {
            text2 = isInterface ? typeName + " " + methodName + "();" : "public " + typeName + " " + methodName + "() { return null; }";
        }
        PsiMethod method = elementFactory.createMethodFromText(text2, null);
        PsiMethod psiElement = (PsiMethod)psiClass.add((PsiElement)method);
        if (!createField && !isInterface) {
            CreateFromUsageUtils.setupMethodBody(psiElement);
        }
    }

    private void createField() throws IncorrectOperationException {
        String fieldName = this.getFieldName();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myPsiClass.getProject()).getElementFactory();
        PsiField psiField = elementFactory.createField(fieldName, this.myType);
        PsiClass psiClass = (PsiClass)this.myPsiClass.getElement();
        if (psiClass == null) {
            return;
        }
        psiClass.add((PsiElement)psiField);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/beanProperties/CreateJavaBeanPropertyFix";
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/beanProperties/CreateJavaBeanPropertyFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

