/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.ReferenceAdjuster;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.search.MethodDeepestSuperSearcher;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatement;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCodeStyleManagerImpl
extends JavaCodeStyleManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.JavaCodeStyleManagerImpl");
    @NonNls
    private static final String IMPL_SUFFIX = "Impl";
    @NonNls
    private static final String GET_PREFIX = "get";
    @NonNls
    private static final String IS_PREFIX = "is";
    @NonNls
    private static final String FIND_PREFIX = "find";
    @NonNls
    private static final String CREATE_PREFIX = "create";
    @NonNls
    private static final String SET_PREFIX = "set";
    @NonNls
    private static final String[] ourPrepositions = new String[]{"as", "at", "by", "down", "for", "from", "in", "into", "of", "on", "onto", "out", "over", "per", "to", "up", "upon", "via", "with"};
    private final Project myProject;

    public JavaCodeStyleManagerImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public PsiElement shortenClassReferences(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = this.shortenClassReferences(element, 0);
        if (psiElement == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement shortenClassReferences(@NotNull PsiElement element, int flags) throws IncorrectOperationException {
        if (element == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(2);
        }
        CheckUtil.checkWritable((PsiElement)element);
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)element)) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        boolean addImports = !BitUtil.isSet((int)flags, (int)4096);
        boolean incompleteCode = BitUtil.isSet((int)flags, (int)8192);
        ReferenceAdjuster adjuster = ReferenceAdjuster.Extension.getReferenceAdjuster((Language)element.getLanguage());
        if (adjuster != null) {
            ASTNode reference = adjuster.process(element.getNode(), addImports, incompleteCode, this.myProject);
            PsiElement psiElement = SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)reference);
            if (psiElement == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    public void shortenClassReferences(@NotNull PsiElement element, int startOffset, int endOffset) throws IncorrectOperationException {
        ReferenceAdjuster adjuster;
        if (element == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(6);
        }
        CheckUtil.checkWritable((PsiElement)element);
        if (SourceTreeToPsiMap.hasTreeElement((PsiElement)element) && (adjuster = ReferenceAdjuster.Extension.getReferenceAdjuster((Language)element.getLanguage())) != null) {
            adjuster.processRange(element.getNode(), startOffset, endOffset, this.myProject);
        }
    }

    @NotNull
    public PsiElement qualifyClassReferences(@NotNull PsiElement element) {
        ReferenceAdjuster adjuster;
        if (element == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(7);
        }
        if ((adjuster = ReferenceAdjuster.Extension.getReferenceAdjuster((Language)element.getLanguage())) != null) {
            ASTNode reference = adjuster.process(element.getNode(), false, false, true, true);
            PsiElement psiElement = SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)reference);
            if (psiElement == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(8);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(9);
        }
        return psiElement;
    }

    public void optimizeImports(@NotNull PsiFile file) throws IncorrectOperationException {
        PsiImportList importList;
        PsiImportList newList;
        if (file == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(10);
        }
        CheckUtil.checkWritable((PsiElement)file);
        if (file instanceof PsiJavaFile && (newList = this.prepareOptimizeImportsResult((PsiJavaFile)file)) != null && (importList = ((PsiJavaFile)file).getImportList()) != null) {
            importList.replace((PsiElement)newList);
        }
    }

    public PsiImportList prepareOptimizeImportsResult(@NotNull PsiJavaFile file) {
        if (file == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(11);
        }
        return new ImportHelper(CodeStyle.getSettings((PsiFile)file)).prepareOptimizeImportsResult(file);
    }

    public boolean hasConflictingOnDemandImport(@NotNull PsiJavaFile file, @NotNull PsiClass psiClass, @NotNull String referenceName) {
        if (file == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(12);
        }
        if (psiClass == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(13);
        }
        if (referenceName == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(14);
        }
        return ImportHelper.hasConflictingOnDemandImport(file, psiClass, referenceName);
    }

    public boolean addImport(@NotNull PsiJavaFile file, @NotNull PsiClass refClass) {
        if (file == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(15);
        }
        if (refClass == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(16);
        }
        return new ImportHelper(CodeStyle.getSettings((PsiFile)file)).addImport(file, refClass);
    }

    public void removeRedundantImports(@NotNull PsiJavaFile file) throws IncorrectOperationException {
        Collection<PsiImportStatementBase> redundant;
        if (file == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(17);
        }
        if ((redundant = this.findRedundantImports(file)) == null) {
            return;
        }
        for (PsiImportStatementBase importStatement : redundant) {
            PsiJavaCodeReferenceElement ref = importStatement.getImportReference();
            if (ref == null || ref.resolve() == null) continue;
            importStatement.delete();
        }
    }

    @Nullable
    public Collection<PsiImportStatementBase> findRedundantImports(final @NotNull PsiJavaFile file) {
        THashSet redundant;
        PsiImportList importList;
        if (file == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(18);
        }
        if ((importList = file.getImportList()) == null) {
            return null;
        }
        Object[] imports2 = importList.getAllImportStatements();
        if (imports2.length == 0) {
            return null;
        }
        THashSet allImports = new THashSet(Arrays.asList(imports2));
        if (FileTypeUtils.isInServerPageFile((PsiElement)file)) {
            redundant = ContainerUtil.newIdentityTroveSet();
            ContainerUtil.addAll((Collection)redundant, (Object[])imports2);
            redundant.removeAll((Collection<?>)allImports);
            for (Object importStatement : imports2) {
                if (!(importStatement instanceof JspxImportStatement) || !importStatement.isForeignFileImport()) continue;
                redundant.remove(importStatement);
            }
        } else {
            redundant = allImports;
            List roots = file.getViewProvider().getAllFiles();
            for (PsiElement root : roots) {
                root.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Collection)redundant){
                    final /* synthetic */ Collection val$redundant;
                    {
                        this.val$redundant = collection;
                    }

                    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                        PsiElement resolveScope;
                        JavaResolveResult resolveResult;
                        if (!reference.isQualified() && !this.inTheSamePackage(file, (resolveResult = reference.advancedResolve(false)).getElement()) && (resolveScope = resolveResult.getCurrentFileResolveScope()) instanceof PsiImportStatementBase) {
                            PsiImportStatementBase importStatementBase = (PsiImportStatementBase)resolveScope;
                            this.val$redundant.remove(importStatementBase);
                        }
                        super.visitReferenceElement(reference);
                    }

                    private boolean inTheSamePackage(PsiJavaFile file2, PsiElement element) {
                        PsiFile containingFile;
                        if (element instanceof PsiClass && ((PsiClass)element).getContainingClass() == null && (containingFile = element.getContainingFile()) instanceof PsiJavaFile) {
                            return Comparing.strEqual((String)file2.getPackageName(), (String)((PsiJavaFile)containingFile).getPackageName());
                        }
                        return false;
                    }
                });
            }
        }
        return redundant;
    }

    public int findEntryIndex(@NotNull PsiImportStatementBase statement) {
        if (statement == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(19);
        }
        return new ImportHelper(CodeStyle.getSettings((PsiFile)statement.getContainingFile())).findEntryIndex(statement);
    }

    @NotNull
    public SuggestedNameInfo suggestCompiledParameterName(@NotNull PsiType type2) {
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(20);
        }
        SuggestedNameInfo suggestedNameInfo = new SuggestedNameInfo(this.suggestVariableNameByType(type2, VariableKind.PARAMETER, true, true)){};
        if (suggestedNameInfo == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(21);
        }
        return suggestedNameInfo;
    }

    @NotNull
    public SuggestedNameInfo suggestVariableName(final @NotNull VariableKind kind2, @Nullable String propertyName, @Nullable PsiExpression expr, @Nullable PsiType type2, boolean correctKeywords) {
        NamesByExprInfo namesByExpr;
        if (kind2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(22);
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (expr != null && type2 == null) {
            type2 = expr.getType();
        }
        if (propertyName != null) {
            Object[] namesByName = this.getSuggestionsByName(propertyName, kind2, false, correctKeywords);
            JavaCodeStyleManagerImpl.sortVariableNameSuggestions((String[])namesByName, kind2, propertyName, null);
            ContainerUtil.addAll(names, (Object[])namesByName);
        }
        if (expr != null) {
            namesByExpr = this.suggestVariableNameByExpression(expr, kind2, correctKeywords);
            if (namesByExpr.propertyName != null) {
                JavaCodeStyleManagerImpl.sortVariableNameSuggestions(namesByExpr.names, kind2, namesByExpr.propertyName, null);
            }
            ContainerUtil.addAll(names, (Object[])namesByExpr.names);
        } else {
            namesByExpr = null;
        }
        if (type2 != null) {
            Object[] namesByType = this.suggestVariableNameByType(type2, kind2, correctKeywords);
            JavaCodeStyleManagerImpl.sortVariableNameSuggestions((String[])namesByType, kind2, null, type2);
            ContainerUtil.addAll(names, (Object[])namesByType);
        }
        final String _propertyName = propertyName != null ? propertyName : (namesByExpr != null ? namesByExpr.propertyName : null);
        JavaCodeStyleManagerImpl.addNamesFromStatistics(names, kind2, _propertyName, type2);
        String[] namesArray = ArrayUtil.toStringArray(names);
        JavaCodeStyleManagerImpl.sortVariableNameSuggestions(namesArray, kind2, _propertyName, type2);
        final PsiType _type = type2;
        SuggestedNameInfo suggestedNameInfo = new SuggestedNameInfo(namesArray){

            public void nameChosen(String name) {
                if (_propertyName != null || _type != null && _type.isValid()) {
                    JavaStatisticsManager.incVariableNameUseCount((String)name, (VariableKind)kind2, (String)_propertyName, (PsiType)_type);
                }
            }
        };
        if (suggestedNameInfo == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(23);
        }
        return suggestedNameInfo;
    }

    private static void addNamesFromStatistics(@NotNull Set<String> names, @NotNull VariableKind variableKind, @Nullable String propertyName, @Nullable PsiType type2) {
        if (names == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(24);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(25);
        }
        String[] allNames = JavaStatisticsManager.getAllVariableNamesUsed((VariableKind)variableKind, (String)propertyName, (PsiType)type2);
        int maxFrequency = 0;
        for (String name : allNames) {
            int count = JavaStatisticsManager.getVariableNameUseCount((String)name, (VariableKind)variableKind, (String)propertyName, (PsiType)type2);
            maxFrequency = Math.max(maxFrequency, count);
        }
        int frequencyLimit = Math.max(5, maxFrequency / 2);
        for (String name : allNames) {
            if (names.contains(name)) continue;
            int count = JavaStatisticsManager.getVariableNameUseCount((String)name, (VariableKind)variableKind, (String)propertyName, (PsiType)type2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("new name:" + name + " count:" + count);
                LOG.debug("frequencyLimit:" + frequencyLimit);
            }
            if (count < frequencyLimit) continue;
            names.add(name);
        }
        if (propertyName != null && type2 != null) {
            JavaCodeStyleManagerImpl.addNamesFromStatistics(names, variableKind, propertyName, null);
            JavaCodeStyleManagerImpl.addNamesFromStatistics(names, variableKind, null, type2);
        }
    }

    @NotNull
    private String[] suggestVariableNameByType(@NotNull PsiType type2, @NotNull VariableKind variableKind, boolean correctKeywords) {
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(26);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(27);
        }
        String[] stringArray = this.suggestVariableNameByType(type2, variableKind, correctKeywords, false);
        if (stringArray == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(28);
        }
        return stringArray;
    }

    @NotNull
    private String[] suggestVariableNameByType(@NotNull PsiType type2, @NotNull VariableKind variableKind, boolean correctKeywords, boolean skipIndices) {
        String typeName;
        PsiClass psiClass;
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(29);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(30);
        }
        String longTypeName = skipIndices ? type2.getCanonicalText() : JavaCodeStyleManagerImpl.getLongTypeName(type2);
        CodeStyleSettings.TypeToNameMap map = this.getMapByVariableKind(variableKind);
        if (map != null && longTypeName != null) {
            String name;
            if (type2.equals(PsiType.NULL)) {
                longTypeName = "java.lang.Object";
            }
            if ((name = map.nameByType(longTypeName)) != null && this.isIdentifier(name)) {
                String[] stringArray = this.getSuggestionsByName(name, variableKind, type2 instanceof PsiArrayType, correctKeywords);
                if (stringArray == null) {
                    JavaCodeStyleManagerImpl.$$$reportNull$$$0(31);
                }
                return stringArray;
            }
        }
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
        PsiClass psiClass2 = psiClass = !skipIndices && type2 instanceof PsiClassType ? ((PsiClassType)type2).resolve() : null;
        if (!skipIndices) {
            this.suggestNamesForCollectionInheritors(type2, variableKind, suggestions, correctKeywords);
            if (psiClass != null && "java.util.Optional".equals(psiClass.getQualifiedName()) && ((PsiClassType)type2).getParameterCount() == 1) {
                PsiType optionalContent = ((PsiClassType)type2).getParameters()[0];
                String[] contentSuggestions = this.suggestVariableNameByType(optionalContent, variableKind, correctKeywords, false);
                Collections.addAll(suggestions, contentSuggestions);
                for (String s : contentSuggestions) {
                    Collections.addAll(suggestions, this.getSuggestionsByName("optional" + StringUtil.capitalize((String)s), variableKind, false, correctKeywords));
                }
            }
            this.suggestNamesFromGenericParameters(type2, variableKind, suggestions, correctKeywords);
        }
        if ((typeName = JavaCodeStyleManagerImpl.getTypeName(type2, !skipIndices)) != null) {
            typeName = JavaCodeStyleManagerImpl.normalizeTypeName(typeName);
            ContainerUtil.addAll(suggestions, (Object[])this.getSuggestionsByName(typeName, variableKind, type2 instanceof PsiArrayType, correctKeywords));
        }
        if (psiClass != null && psiClass.getContainingClass() != null) {
            InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)false, superClass -> {
                if (variableKind == null) {
                    JavaCodeStyleManagerImpl.$$$reportNull$$$0(114);
                }
                if (PsiTreeUtil.isAncestor((PsiElement)superClass, (PsiElement)psiClass, (boolean)true)) {
                    ContainerUtil.addAll((Collection)suggestions, (Object[])this.getSuggestionsByName(superClass.getName(), variableKind, false, correctKeywords));
                }
                return false;
            });
        }
        String[] stringArray = ArrayUtil.toStringArray(suggestions);
        if (stringArray == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(32);
        }
        return stringArray;
    }

    private void suggestNamesFromGenericParameters(@NotNull PsiType type2, @NotNull VariableKind variableKind, @NotNull Collection<String> suggestions, boolean correctKeywords) {
        PsiType[] parameters2;
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(33);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(34);
        }
        if (suggestions == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(35);
        }
        if (!(type2 instanceof PsiClassType)) {
            return;
        }
        StringBuilder fullNameBuilder = new StringBuilder();
        for (PsiType parameter2 : parameters2 = ((PsiClassType)type2).getParameters()) {
            String typeName;
            if (!(parameter2 instanceof PsiClassType) || (typeName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName(parameter2))) == null) continue;
            fullNameBuilder.append(typeName);
        }
        String baseName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName(type2));
        if (baseName != null) {
            fullNameBuilder.append(baseName);
            ContainerUtil.addAll(suggestions, (Object[])this.getSuggestionsByName(fullNameBuilder.toString(), variableKind, false, correctKeywords));
        }
    }

    private void suggestNamesForCollectionInheritors(@NotNull PsiType type2, @NotNull VariableKind variableKind, @NotNull Collection<String> suggestions, boolean correctKeywords) {
        PsiType componentType;
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(36);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(37);
        }
        if (suggestions == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(38);
        }
        if ((componentType = PsiUtil.extractIterableTypeParameter((PsiType)type2, (boolean)false)) == null || componentType.equals(type2)) {
            return;
        }
        String typeName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName(componentType));
        if (typeName != null) {
            ContainerUtil.addAll(suggestions, (Object[])this.getSuggestionsByName(typeName, variableKind, true, correctKeywords));
        }
    }

    private static String normalizeTypeName(@Nullable String typeName) {
        if (typeName == null) {
            return null;
        }
        if (typeName.endsWith(IMPL_SUFFIX) && typeName.length() > IMPL_SUFFIX.length()) {
            return typeName.substring(0, typeName.length() - IMPL_SUFFIX.length());
        }
        return typeName;
    }

    @Nullable
    public static String getTypeName(@NotNull PsiType type2) {
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(39);
        }
        return JavaCodeStyleManagerImpl.getTypeName(type2, true);
    }

    @Nullable
    private static String getTypeName(@NotNull PsiType type2, boolean withIndices) {
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(40);
        }
        if ((type2 = type2.getDeepComponentType()) instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type2;
            String className = classType.getClassName();
            if (className != null || !withIndices) {
                return className;
            }
            PsiClass aClass = classType.resolve();
            return aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getClassName() : null;
        }
        if (type2 instanceof PsiPrimitiveType) {
            return type2.getPresentableText();
        }
        if (type2 instanceof PsiWildcardType) {
            return JavaCodeStyleManagerImpl.getTypeName(((PsiWildcardType)type2).getExtendsBound(), withIndices);
        }
        if (type2 instanceof PsiIntersectionType) {
            return JavaCodeStyleManagerImpl.getTypeName(((PsiIntersectionType)type2).getRepresentative(), withIndices);
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            return JavaCodeStyleManagerImpl.getTypeName((PsiType)((PsiCapturedWildcardType)type2).getWildcard(), withIndices);
        }
        if (type2 instanceof PsiDisjunctionType) {
            return JavaCodeStyleManagerImpl.getTypeName(((PsiDisjunctionType)type2).getLeastUpperBound(), withIndices);
        }
        return null;
    }

    @Nullable
    private static String getLongTypeName(@NotNull PsiType type2) {
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(41);
        }
        if (type2 instanceof PsiClassType) {
            PsiClass aClass = ((PsiClassType)type2).resolve();
            if (aClass == null) {
                return null;
            }
            if (aClass instanceof PsiAnonymousClass) {
                PsiClass baseClass = ((PsiAnonymousClass)aClass).getBaseClassType().resolve();
                return baseClass != null ? baseClass.getQualifiedName() : null;
            }
            return aClass.getQualifiedName();
        }
        if (type2 instanceof PsiArrayType) {
            return JavaCodeStyleManagerImpl.getLongTypeName(((PsiArrayType)type2).getComponentType()) + "[]";
        }
        if (type2 instanceof PsiPrimitiveType) {
            return type2.getPresentableText();
        }
        if (type2 instanceof PsiWildcardType) {
            PsiType bound = ((PsiWildcardType)type2).getBound();
            return bound != null ? JavaCodeStyleManagerImpl.getLongTypeName(bound) : "java.lang.Object";
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            PsiType bound = ((PsiCapturedWildcardType)type2).getWildcard().getBound();
            return bound != null ? JavaCodeStyleManagerImpl.getLongTypeName(bound) : "java.lang.Object";
        }
        if (type2 instanceof PsiIntersectionType) {
            return JavaCodeStyleManagerImpl.getLongTypeName(((PsiIntersectionType)type2).getRepresentative());
        }
        if (type2 instanceof PsiDisjunctionType) {
            return JavaCodeStyleManagerImpl.getLongTypeName(((PsiDisjunctionType)type2).getLeastUpperBound());
        }
        return null;
    }

    @NotNull
    private NamesByExprInfo suggestVariableNameByExpression(@NotNull PsiExpression expr, @NotNull VariableKind variableKind, boolean correctKeywords) {
        if (expr == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(42);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(43);
        }
        LinkedHashSet names = new LinkedHashSet();
        Object[] fromLiterals = this.suggestVariableNameFromLiterals(expr, variableKind, correctKeywords);
        if (fromLiterals != null) {
            ContainerUtil.addAll(names, (Object[])fromLiterals);
        }
        ContainerUtil.addAll(names, (Object[])this.suggestVariableNameByExpressionOnly(expr, variableKind, correctKeywords, false).names);
        ContainerUtil.addAll(names, (Object[])this.suggestVariableNameByExpressionPlace(expr, variableKind, correctKeywords).names);
        PsiType type2 = expr.getType();
        if (type2 != null) {
            ContainerUtil.addAll(names, (Object[])this.suggestVariableNameByType(type2, variableKind, correctKeywords));
        }
        ContainerUtil.addAll(names, (Object[])this.suggestVariableNameByExpressionOnly(expr, variableKind, correctKeywords, true).names);
        String[] namesArray = ArrayUtil.toStringArray(names);
        String propertyName = this.suggestVariableNameByExpressionOnly(expr, variableKind, correctKeywords, false).propertyName != null ? this.suggestVariableNameByExpressionOnly(expr, variableKind, correctKeywords, false).propertyName : this.suggestVariableNameByExpressionPlace(expr, variableKind, correctKeywords).propertyName;
        NamesByExprInfo namesByExprInfo = new NamesByExprInfo(propertyName, namesArray);
        if (namesByExprInfo == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(44);
        }
        return namesByExprInfo;
    }

    @Nullable
    private String[] suggestVariableNameFromLiterals(@NotNull PsiExpression expr, @NotNull VariableKind variableKind, boolean correctKeywords) {
        PsiElement[] literals;
        if (expr == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(45);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(46);
        }
        if ((literals = PsiTreeUtil.collectElements((PsiElement)expr, (PsiElementFilter)new PsiElementFilter(){

            public boolean isAccepted(PsiElement element) {
                PsiElement exprList;
                if (JavaCodeStyleManagerImpl.isStringPsiLiteral(element) && this.isNameSupplier(element) && (exprList = element.getParent()) instanceof PsiExpressionList) {
                    PsiElement call = exprList.getParent();
                    if (call instanceof PsiNewExpression) {
                        return true;
                    }
                    if (call instanceof PsiMethodCallExpression) {
                        return true;
                    }
                }
                return false;
            }

            private boolean isNameSupplier(PsiElement element) {
                String stringPresentation = StringUtil.unquoteString((String)element.getText());
                String[] words = stringPresentation.split(" ");
                if (words.length > 5) {
                    return false;
                }
                return Arrays.stream(words).allMatch(StringUtil::isJavaIdentifier);
            }
        })).length == 1) {
            String text2 = StringUtil.unquoteString((String)literals[0].getText());
            return this.getSuggestionsByName(text2.replaceAll(" ", "_"), variableKind, expr.getType() instanceof PsiArrayType, correctKeywords);
        }
        return null;
    }

    @NotNull
    private NamesByExprInfo suggestVariableNameByExpressionOnly(@NotNull PsiExpression expr, @NotNull VariableKind variableKind, boolean correctKeywords, boolean useAllMethodNames) {
        PsiType functionalInterfaceType;
        if (expr == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(47);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(48);
        }
        if (expr instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpr = ((PsiMethodCallExpression)expr).getMethodExpression();
            String methodName = methodExpr.getReferenceName();
            if (methodName != null) {
                PsiExpression[] expressions2;
                if (("of".equals(methodName) || "ofNullable".equals(methodName)) && JavaCodeStyleManagerImpl.isJavaUtilMethodCall((PsiMethodCallExpression)expr) && (expressions2 = ((PsiMethodCallExpression)expr).getArgumentList().getExpressions()).length > 0) {
                    NamesByExprInfo namesByExprInfo = this.suggestVariableNameByExpressionOnly(expressions2[0], variableKind, correctKeywords, useAllMethodNames);
                    if (namesByExprInfo == null) {
                        JavaCodeStyleManagerImpl.$$$reportNull$$$0(49);
                    }
                    return namesByExprInfo;
                }
                if (("map".equals(methodName) || "flatMap".equals(methodName) || "filter".equals(methodName)) && JavaCodeStyleManagerImpl.isJavaUtilMethodCall((PsiMethodCallExpression)expr)) {
                    NamesByExprInfo namesByExprInfo = new NamesByExprInfo(null, new String[0]);
                    if (namesByExprInfo == null) {
                        JavaCodeStyleManagerImpl.$$$reportNull$$$0(50);
                    }
                    return namesByExprInfo;
                }
                String[] words = NameUtil.nameToWords((String)methodName);
                if (words.length > 0) {
                    String firstWord = words[0];
                    if (GET_PREFIX.equals(firstWord) || IS_PREFIX.equals(firstWord) || FIND_PREFIX.equals(firstWord) || CREATE_PREFIX.equals(firstWord)) {
                        if (words.length > 1) {
                            String propertyName = methodName.substring(firstWord.length());
                            Object[] names = this.getSuggestionsByName(propertyName, variableKind, false, correctKeywords);
                            PsiExpression qualifierExpression2 = methodExpr.getQualifierExpression();
                            if (qualifierExpression2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression2).resolve() instanceof PsiVariable) {
                                String name = qualifierExpression2.getText() + StringUtil.capitalize((String)propertyName);
                                Object[] propertySuggestions = this.getSuggestionsByName(name, variableKind, false, correctKeywords);
                                names = (String[])((StreamEx)StreamEx.of((Object[])names).append(propertySuggestions).distinct()).toArray(String[]::new);
                            }
                            NamesByExprInfo namesByExprInfo = new NamesByExprInfo(propertyName, (String[])names);
                            if (namesByExprInfo == null) {
                                JavaCodeStyleManagerImpl.$$$reportNull$$$0(51);
                            }
                            return namesByExprInfo;
                        }
                    } else if (words.length == 1 || useAllMethodNames) {
                        NamesByExprInfo namesByExprInfo = new NamesByExprInfo(methodName, this.getSuggestionsByName(methodName, variableKind, false, correctKeywords));
                        if (namesByExprInfo == null) {
                            JavaCodeStyleManagerImpl.$$$reportNull$$$0(52);
                        }
                        return namesByExprInfo;
                    }
                }
            }
        } else if (expr instanceof PsiReferenceExpression) {
            String propertyName = ((PsiReferenceExpression)expr).getReferenceName();
            PsiElement refElement = ((PsiReferenceExpression)expr).resolve();
            if (refElement instanceof PsiVariable) {
                VariableKind refVariableKind = this.getVariableKind((PsiVariable)refElement);
                propertyName = this.variableNameToPropertyName(propertyName, refVariableKind);
            }
            if (refElement != null && propertyName != null) {
                String[] names = this.getSuggestionsByName(propertyName, variableKind, false, correctKeywords);
                NamesByExprInfo namesByExprInfo = new NamesByExprInfo(propertyName, names);
                if (namesByExprInfo == null) {
                    JavaCodeStyleManagerImpl.$$$reportNull$$$0(53);
                }
                return namesByExprInfo;
            }
        } else if (expr instanceof PsiArrayAccessExpression) {
            PsiExpression arrayExpr = ((PsiArrayAccessExpression)expr).getArrayExpression();
            if (arrayExpr instanceof PsiReferenceExpression) {
                String name;
                String arrayName = ((PsiReferenceExpression)arrayExpr).getReferenceName();
                PsiElement refElement = ((PsiReferenceExpression)arrayExpr).resolve();
                if (refElement instanceof PsiVariable) {
                    VariableKind refVariableKind = this.getVariableKind((PsiVariable)refElement);
                    arrayName = this.variableNameToPropertyName(arrayName, refVariableKind);
                }
                if (arrayName != null && (name = StringUtil.unpluralize((String)arrayName)) != null) {
                    String[] names = this.getSuggestionsByName(name, variableKind, false, correctKeywords);
                    NamesByExprInfo namesByExprInfo = new NamesByExprInfo(name, names);
                    if (namesByExprInfo == null) {
                        JavaCodeStyleManagerImpl.$$$reportNull$$$0(54);
                    }
                    return namesByExprInfo;
                }
            }
        } else if (expr instanceof PsiLiteralExpression && variableKind == VariableKind.STATIC_FINAL_FIELD) {
            String stringValue;
            String[] names;
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expr;
            Object value2 = literalExpression.getValue();
            if (value2 instanceof String && (names = JavaCodeStyleManagerImpl.getSuggestionsByValue(stringValue = (String)value2)).length > 0) {
                NamesByExprInfo namesByExprInfo = new NamesByExprInfo(null, new String[]{JavaCodeStyleManagerImpl.constantValueToConstantName(names)});
                if (namesByExprInfo == null) {
                    JavaCodeStyleManagerImpl.$$$reportNull$$$0(55);
                }
                return namesByExprInfo;
            }
        } else if (expr instanceof PsiParenthesizedExpression) {
            PsiExpression expression2 = ((PsiParenthesizedExpression)expr).getExpression();
            if (expression2 != null) {
                NamesByExprInfo namesByExprInfo = this.suggestVariableNameByExpressionOnly(expression2, variableKind, correctKeywords, useAllMethodNames);
                if (namesByExprInfo == null) {
                    JavaCodeStyleManagerImpl.$$$reportNull$$$0(56);
                }
                return namesByExprInfo;
            }
        } else if (expr instanceof PsiTypeCastExpression) {
            PsiExpression operand2 = ((PsiTypeCastExpression)expr).getOperand();
            if (operand2 != null) {
                NamesByExprInfo namesByExprInfo = this.suggestVariableNameByExpressionOnly(operand2, variableKind, correctKeywords, useAllMethodNames);
                if (namesByExprInfo == null) {
                    JavaCodeStyleManagerImpl.$$$reportNull$$$0(57);
                }
                return namesByExprInfo;
            }
        } else if (expr instanceof PsiLiteralExpression) {
            String text2 = StringUtil.unquoteString((String)expr.getText());
            if (this.isIdentifier(text2)) {
                NamesByExprInfo namesByExprInfo = new NamesByExprInfo(text2, this.getSuggestionsByName(text2, variableKind, false, correctKeywords));
                if (namesByExprInfo == null) {
                    JavaCodeStyleManagerImpl.$$$reportNull$$$0(58);
                }
                return namesByExprInfo;
            }
        } else if (expr instanceof PsiFunctionalExpression && (functionalInterfaceType = ((PsiFunctionalExpression)expr).getFunctionalInterfaceType()) != null) {
            String[] namesByType = this.suggestVariableNameByType(functionalInterfaceType, variableKind, correctKeywords);
            NamesByExprInfo namesByExprInfo = new NamesByExprInfo(null, namesByType);
            if (namesByExprInfo == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(59);
            }
            return namesByExprInfo;
        }
        NamesByExprInfo namesByExprInfo = new NamesByExprInfo(null, ArrayUtil.EMPTY_STRING_ARRAY);
        if (namesByExprInfo == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(60);
        }
        return namesByExprInfo;
    }

    private static boolean isJavaUtilMethodCall(@NotNull PsiMethodCallExpression expr) {
        PsiMethod method;
        if (expr == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(61);
        }
        if ((method = expr.resolveMethod()) == null) {
            return false;
        }
        return JavaCodeStyleManagerImpl.isJavaUtilMethod(method) || !MethodDeepestSuperSearcher.processDeepestSuperMethods(method, (Processor<PsiMethod>)((Processor)method1 -> !JavaCodeStyleManagerImpl.isJavaUtilMethod(method1)));
    }

    private static boolean isJavaUtilMethod(@NotNull PsiMethod method) {
        String name;
        if (method == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(62);
        }
        return (name = PsiUtil.getMemberQualifiedName((PsiMember)method)) != null && name.startsWith("java.util.");
    }

    @NotNull
    private static String constantValueToConstantName(@NotNull String[] names) {
        if (names == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(63);
        }
        String string = String.join((CharSequence)"_", names);
        if (string == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(64);
        }
        return string;
    }

    @NotNull
    private static String[] getSuggestionsByValue(@NotNull String stringValue) {
        if (stringValue == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(65);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer currentWord = new StringBuffer();
        boolean prevIsUpperCase = false;
        for (int i = 0; i < stringValue.length(); ++i) {
            char c = stringValue.charAt(i);
            if (Character.isUpperCase(c)) {
                if (currentWord.length() > 0 && !prevIsUpperCase) {
                    result.add(currentWord.toString());
                    currentWord = new StringBuffer();
                }
                currentWord.append(c);
            } else if (Character.isLowerCase(c)) {
                currentWord.append(Character.toUpperCase(c));
            } else if (Character.isJavaIdentifierPart(c) && c != '_') {
                if (Character.isJavaIdentifierStart(c) || currentWord.length() > 0 || !result.isEmpty()) {
                    currentWord.append(c);
                }
            } else if (currentWord.length() > 0) {
                result.add(currentWord.toString());
                currentWord = new StringBuffer();
            }
            prevIsUpperCase = Character.isUpperCase(c);
        }
        if (currentWord.length() > 0) {
            result.add(currentWord.toString());
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(66);
        }
        return stringArray;
    }

    @NotNull
    private NamesByExprInfo suggestVariableNameByExpressionPlace(@NotNull PsiExpression expr, @NotNull VariableKind variableKind, boolean correctKeywords) {
        PsiVariable variable;
        String variableName;
        if (expr == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(67);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(68);
        }
        if (expr.getParent() instanceof PsiExpressionList) {
            PsiExpressionList list = (PsiExpressionList)expr.getParent();
            PsiElement listParent = list.getParent();
            PsiSubstitutor subst = PsiSubstitutor.EMPTY;
            PsiMethod method = null;
            if (listParent instanceof PsiMethodCallExpression) {
                JavaResolveResult resolveResult = ((PsiMethodCallExpression)listParent).getMethodExpression().advancedResolve(false);
                method = (PsiMethod)resolveResult.getElement();
                subst = resolveResult.getSubstitutor();
            } else {
                if (listParent instanceof PsiAnonymousClass) {
                    listParent = listParent.getParent();
                }
                if (listParent instanceof PsiNewExpression) {
                    method = ((PsiNewExpression)listParent).resolveConstructor();
                }
            }
            if (method != null) {
                String name;
                PsiParameter[] parameters2;
                Object[] expressions2;
                int index;
                PsiElement navElement = method.getNavigationElement();
                if (navElement instanceof PsiMethod) {
                    method = (PsiMethod)navElement;
                }
                if ((index = ArrayUtil.indexOf((Object[])(expressions2 = list.getExpressions()), (Object)expr)) < (parameters2 = method.getParameterList().getParameters()).length && (name = parameters2[index].getName()) != null && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)subst.substitute(parameters2[index].getType()), (PsiExpression)expr)) {
                    String firstWord;
                    String methodName;
                    String[] words;
                    name = this.variableNameToPropertyName(name, VariableKind.PARAMETER);
                    String[] names = this.getSuggestionsByName(name, variableKind, false, correctKeywords);
                    if (expressions2.length == 1 && (words = NameUtil.nameToWords((String)(methodName = method.getName()))).length > 0 && SET_PREFIX.equals(firstWord = words[0])) {
                        String propertyName = methodName.substring(firstWord.length());
                        String[] setterNames = this.getSuggestionsByName(propertyName, variableKind, false, correctKeywords);
                        names = ArrayUtil.mergeArrays((String[])names, (String[])setterNames);
                    }
                    NamesByExprInfo namesByExprInfo = new NamesByExprInfo(name, names);
                    if (namesByExprInfo == null) {
                        JavaCodeStyleManagerImpl.$$$reportNull$$$0(69);
                    }
                    return namesByExprInfo;
                }
            }
        } else if (expr.getParent() instanceof PsiAssignmentExpression) {
            String name;
            PsiExpression leftExpression;
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expr.getParent();
            if (expr == assignmentExpression.getRExpression() && (leftExpression = assignmentExpression.getLExpression()) instanceof PsiReferenceExpression && (name = ((PsiReferenceExpression)leftExpression).getReferenceName()) != null) {
                PsiElement resolve = ((PsiReferenceExpression)leftExpression).resolve();
                if (resolve instanceof PsiVariable) {
                    name = this.variableNameToPropertyName(name, this.getVariableKind((PsiVariable)resolve));
                }
                String[] names = this.getSuggestionsByName(name, variableKind, false, correctKeywords);
                NamesByExprInfo namesByExprInfo = new NamesByExprInfo(name, names);
                if (namesByExprInfo == null) {
                    JavaCodeStyleManagerImpl.$$$reportNull$$$0(70);
                }
                return namesByExprInfo;
            }
        } else if (expr.getParent() instanceof PsiLocalVariable && variableKind != VariableKind.LOCAL_VARIABLE && (variableName = (variable = (PsiVariable)expr.getParent()).getName()) != null) {
            String propertyName = this.variableNameToPropertyName(variableName, this.getVariableKind(variable));
            NamesByExprInfo namesByExprInfo = new NamesByExprInfo(propertyName, this.getSuggestionsByName(propertyName, variableKind, false, correctKeywords));
            if (namesByExprInfo == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(71);
            }
            return namesByExprInfo;
        }
        NamesByExprInfo namesByExprInfo = new NamesByExprInfo(null, ArrayUtil.EMPTY_STRING_ARRAY);
        if (namesByExprInfo == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(72);
        }
        return namesByExprInfo;
    }

    @NotNull
    public String variableNameToPropertyName(@NotNull String name, @NotNull VariableKind variableKind) {
        if (name == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(73);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(74);
        }
        if (variableKind == VariableKind.STATIC_FINAL_FIELD || variableKind == VariableKind.STATIC_FIELD && name.contains("_")) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c != '_') {
                    if (Character.isLowerCase(c)) {
                        String string = this.variableNameToPropertyNameInner(name, variableKind);
                        if (string == null) {
                            JavaCodeStyleManagerImpl.$$$reportNull$$$0(75);
                        }
                        return string;
                    }
                    buffer.append(Character.toLowerCase(c));
                    continue;
                }
                if (++i >= name.length()) continue;
                c = name.charAt(i);
                buffer.append(c);
            }
            String string = buffer.toString();
            if (string == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(76);
            }
            return string;
        }
        String string = this.variableNameToPropertyNameInner(name, variableKind);
        if (string == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(77);
        }
        return string;
    }

    @NotNull
    private String variableNameToPropertyNameInner(@NotNull String name, @NotNull VariableKind variableKind) {
        if (name == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(78);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(79);
        }
        String prefix = this.getPrefixByVariableKind(variableKind);
        String suffix = this.getSuffixByVariableKind(variableKind);
        boolean doDecapitalize = false;
        int pLength = prefix.length();
        if (pLength > 0 && name.startsWith(prefix) && name.length() > pLength && (!Character.isLetter(prefix.charAt(pLength - 1)) || Character.isUpperCase(name.charAt(pLength)))) {
            name = name.substring(pLength);
            doDecapitalize = true;
        }
        if (name.endsWith(suffix) && name.length() > suffix.length()) {
            name = name.substring(0, name.length() - suffix.length());
            doDecapitalize = true;
        }
        if (doDecapitalize) {
            name = Introspector.decapitalize(name);
        }
        String string = name;
        if (string == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(80);
        }
        return string;
    }

    @NotNull
    public String propertyNameToVariableName(@NotNull String propertyName, @NotNull VariableKind variableKind) {
        if (propertyName == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(81);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(82);
        }
        if (variableKind == VariableKind.STATIC_FINAL_FIELD) {
            Object[] words = NameUtil.nameToWords((String)propertyName);
            String string = StringUtil.join((Object[])words, StringUtil::toUpperCase, (String)"_");
            if (string == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(83);
            }
            return string;
        }
        String prefix = this.getPrefixByVariableKind(variableKind);
        String name = propertyName;
        if (!(name.isEmpty() || prefix.isEmpty() || StringUtil.endsWithChar((CharSequence)prefix, (char)'_'))) {
            name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        name = prefix + name + this.getSuffixByVariableKind(variableKind);
        String string = name = this.changeIfNotIdentifier(name);
        if (string == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(84);
        }
        return string;
    }

    @NotNull
    private String[] getSuggestionsByName(@NotNull String name, @NotNull VariableKind variableKind, boolean isArray, boolean correctKeywords) {
        if (name == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(85);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(86);
        }
        boolean upperCaseStyle = variableKind == VariableKind.STATIC_FINAL_FIELD;
        boolean preferLongerNames = this.getJavaSettings().PREFER_LONGER_NAMES;
        String prefix = this.getPrefixByVariableKind(variableKind);
        String suffix = this.getSuffixByVariableKind(variableKind);
        ArrayList<String> answer = new ArrayList<String>();
        for (String suggestion : NameUtil.getSuggestionsByName((String)name, (String)prefix, (String)suffix, (boolean)upperCaseStyle, (boolean)preferLongerNames, (boolean)isArray)) {
            answer.add(correctKeywords ? this.changeIfNotIdentifier(suggestion) : suggestion);
        }
        ContainerUtil.addIfNotNull(answer, (Object)JavaCodeStyleManagerImpl.getWordByPreposition(name, prefix, suffix, upperCaseStyle, isArray));
        String[] stringArray = ArrayUtil.toStringArray(answer);
        if (stringArray == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(87);
        }
        return stringArray;
    }

    private static String getWordByPreposition(@NotNull String name, String prefix, String suffix, boolean upperCaseStyle, boolean isArray) {
        if (name == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(88);
        }
        String[] words = NameUtil.splitNameIntoWords((String)name);
        for (int i = 1; i < words.length; ++i) {
            for (String preposition : ourPrepositions) {
                if (!preposition.equalsIgnoreCase(words[i])) continue;
                String mainWord = words[i - 1];
                mainWord = upperCaseStyle ? StringUtil.toUpperCase((String)mainWord) : (prefix.isEmpty() || StringUtil.endsWithChar((CharSequence)prefix, (char)'_') ? StringUtil.toLowerCase((String)mainWord) : StringUtil.capitalize((String)mainWord));
                String result = prefix + mainWord + suffix;
                return isArray ? StringUtil.pluralize((String)result) : result;
            }
        }
        return null;
    }

    @NotNull
    public String suggestUniqueVariableName(@NotNull String baseName, PsiElement place, boolean lookForward) {
        if (baseName == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(89);
        }
        String string = JavaCodeStyleManagerImpl.suggestUniqueVariableName(baseName, place, lookForward, false, v -> false);
        if (string == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(90);
        }
        return string;
    }

    @NotNull
    public String suggestUniqueVariableName(@NotNull String baseName, PsiElement place, Predicate<PsiVariable> canBeReused) {
        if (baseName == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(91);
        }
        String string = JavaCodeStyleManagerImpl.suggestUniqueVariableName(baseName, place, true, false, canBeReused);
        if (string == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(92);
        }
        return string;
    }

    @NotNull
    public SuggestedNameInfo suggestUniqueVariableName(final @NotNull SuggestedNameInfo baseNameInfo, PsiElement place, boolean ignorePlaceName, boolean lookForward) {
        if (baseNameInfo == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(93);
        }
        String[] names = baseNameInfo.names;
        LinkedHashSet<String> uniqueNames = new LinkedHashSet<String>(names.length);
        for (String name : names) {
            String withShadowing;
            String placeName;
            if (ignorePlaceName && place instanceof PsiNamedElement && Comparing.strEqual((String)(placeName = ((PsiNamedElement)place).getName()), (String)name)) {
                uniqueNames.add(name);
                continue;
            }
            String unique = this.suggestUniqueVariableName(name, place, lookForward);
            if (!unique.equals(name) && (withShadowing = JavaCodeStyleManagerImpl.suggestUniqueVariableName(name, place, lookForward, true, v -> false)).equals(name)) {
                uniqueNames.add(name);
            }
            uniqueNames.add(unique);
        }
        SuggestedNameInfo suggestedNameInfo = new SuggestedNameInfo(ArrayUtil.toStringArray(uniqueNames)){

            public void nameChosen(String name) {
                baseNameInfo.nameChosen(name);
            }
        };
        if (suggestedNameInfo == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(94);
        }
        return suggestedNameInfo;
    }

    @NotNull
    private static String suggestUniqueVariableName(@NotNull String baseName, PsiElement place, boolean lookForward, boolean allowShadowing, Predicate<PsiVariable> canBeReused) {
        if (baseName == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(95);
        }
        PsiElement scope = PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{PsiStatement.class, PsiCodeBlock.class, PsiMethod.class});
        int index = 0;
        while (true) {
            String name;
            String string = name = index > 0 ? baseName + index : baseName;
            if (!(JavaCodeStyleManagerImpl.hasConflictingVariable(place, name, allowShadowing) || lookForward && JavaCodeStyleManagerImpl.hasConflictingVariableAfterwards(scope, name, canBeReused))) {
                String string2 = name;
                if (string2 == null) {
                    JavaCodeStyleManagerImpl.$$$reportNull$$$0(96);
                }
                return string2;
            }
            ++index;
        }
    }

    private static boolean hasConflictingVariable(@Nullable PsiElement place, @NotNull String name, boolean allowShadowing) {
        if (name == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(97);
        }
        if (place == null) {
            return false;
        }
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)place.getProject()).getResolveHelper();
        PsiVariable existingVariable = helper.resolveAccessibleReferencedVariable(name, place);
        if (existingVariable == null) {
            return false;
        }
        return !allowShadowing || !(existingVariable instanceof PsiField) || PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{PsiMethod.class}) == null;
    }

    public static boolean hasConflictingVariableAfterwards(@Nullable PsiElement scope, final @NotNull String name, final @NotNull Predicate<PsiVariable> canBeReused) {
        if (name == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(98);
        }
        if (canBeReused == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(99);
        }
        for (PsiElement run = scope; run != null; run = run.getNextSibling()) {
            class CancelException
            extends RuntimeException {
                CancelException() {
                }
            }
            try {
                run.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitClass(PsiClass aClass) {
                    }

                    public void visitVariable(PsiVariable variable) {
                        if (name.equals(variable.getName()) && !canBeReused.test(variable)) {
                            throw new CancelException();
                        }
                    }
                });
                continue;
            }
            catch (CancelException e) {
                return true;
            }
        }
        return false;
    }

    private static void sortVariableNameSuggestions(@NotNull String[] names, @NotNull VariableKind variableKind, @Nullable String propertyName, @Nullable PsiType type2) {
        if (names == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(100);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(101);
        }
        if (names.length <= 1) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("sorting names:" + variableKind);
            if (propertyName != null) {
                LOG.debug("propertyName:" + propertyName);
            }
            if (type2 != null) {
                LOG.debug("type:" + type2);
            }
            for (String name : names) {
                int count = JavaStatisticsManager.getVariableNameUseCount((String)name, (VariableKind)variableKind, (String)propertyName, (PsiType)type2);
                LOG.debug(name + " : " + count);
            }
        }
        Comparator comparator = (s1, s2) -> {
            if (variableKind == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(113);
            }
            int count1 = JavaStatisticsManager.getVariableNameUseCount((String)s1, (VariableKind)variableKind, (String)propertyName, (PsiType)type2);
            int count2 = JavaStatisticsManager.getVariableNameUseCount((String)s2, (VariableKind)variableKind, (String)propertyName, (PsiType)type2);
            return count2 - count1;
        };
        Arrays.sort(names, comparator);
    }

    @NotNull
    public String getPrefixByVariableKind(@NotNull VariableKind variableKind) {
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(102);
        }
        String prefix = "";
        switch (variableKind) {
            case FIELD: {
                prefix = this.getJavaSettings().FIELD_NAME_PREFIX;
                break;
            }
            case STATIC_FIELD: {
                prefix = this.getJavaSettings().STATIC_FIELD_NAME_PREFIX;
                break;
            }
            case PARAMETER: {
                prefix = this.getJavaSettings().PARAMETER_NAME_PREFIX;
                break;
            }
            case LOCAL_VARIABLE: {
                prefix = this.getJavaSettings().LOCAL_VARIABLE_NAME_PREFIX;
                break;
            }
            case STATIC_FINAL_FIELD: {
                prefix = "";
                break;
            }
            default: {
                LOG.assertTrue(false);
            }
        }
        if (prefix == null) {
            prefix = "";
        }
        String string = prefix;
        if (string == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(103);
        }
        return string;
    }

    @NotNull
    public String getSuffixByVariableKind(@NotNull VariableKind variableKind) {
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(104);
        }
        String suffix = "";
        switch (variableKind) {
            case FIELD: {
                suffix = this.getJavaSettings().FIELD_NAME_SUFFIX;
                break;
            }
            case STATIC_FIELD: {
                suffix = this.getJavaSettings().STATIC_FIELD_NAME_SUFFIX;
                break;
            }
            case PARAMETER: {
                suffix = this.getJavaSettings().PARAMETER_NAME_SUFFIX;
                break;
            }
            case LOCAL_VARIABLE: {
                suffix = this.getJavaSettings().LOCAL_VARIABLE_NAME_SUFFIX;
                break;
            }
            case STATIC_FINAL_FIELD: {
                suffix = "";
                break;
            }
            default: {
                LOG.assertTrue(false);
            }
        }
        if (suffix == null) {
            suffix = "";
        }
        String string = suffix;
        if (string == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(105);
        }
        return string;
    }

    @Nullable
    private CodeStyleSettings.TypeToNameMap getMapByVariableKind(@NotNull VariableKind variableKind) {
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(106);
        }
        if (variableKind == VariableKind.FIELD) {
            return this.getJavaSettings().FIELD_TYPE_TO_NAME;
        }
        if (variableKind == VariableKind.STATIC_FIELD) {
            return this.getJavaSettings().STATIC_FIELD_TYPE_TO_NAME;
        }
        if (variableKind == VariableKind.PARAMETER) {
            return this.getJavaSettings().PARAMETER_TYPE_TO_NAME;
        }
        if (variableKind == VariableKind.LOCAL_VARIABLE) {
            return this.getJavaSettings().LOCAL_VARIABLE_TYPE_TO_NAME;
        }
        return null;
    }

    @NonNls
    @NotNull
    private String changeIfNotIdentifier(@NotNull String name) {
        if (name == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(107);
        }
        if (!this.isIdentifier(name)) {
            String string = StringUtil.fixVariableNameDerivedFromPropertyName((String)name);
            if (string == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(108);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(109);
        }
        return string;
    }

    private boolean isIdentifier(@NotNull String name) {
        if (name == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(110);
        }
        return PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(name, LanguageLevel.HIGHEST);
    }

    @NotNull
    private JavaCodeStyleSettings getJavaSettings() {
        JavaCodeStyleSettings javaCodeStyleSettings = (JavaCodeStyleSettings)CodeStyle.getSettings((Project)this.myProject).getCustomSettings(JavaCodeStyleSettings.class);
        if (javaCodeStyleSettings == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(111);
        }
        return javaCodeStyleSettings;
    }

    private static boolean isStringPsiLiteral(@NotNull PsiElement element) {
        if (element == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(112);
        }
        if (element instanceof PsiLiteralExpression) {
            String text2 = element.getText();
            return StringUtil.isQuotedString((String)text2);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 21: 
            case 23: 
            case 28: 
            case 31: 
            case 32: 
            case 44: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 76: 
            case 77: 
            case 80: 
            case 83: 
            case 84: 
            case 87: 
            case 90: 
            case 92: 
            case 94: 
            case 96: 
            case 103: 
            case 105: 
            case 108: 
            case 109: 
            case 111: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 21: 
            case 23: 
            case 28: 
            case 31: 
            case 32: 
            case 44: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 76: 
            case 77: 
            case 80: 
            case 83: 
            case 84: 
            case 87: 
            case 90: 
            case 92: 
            case 94: 
            case 96: 
            case 103: 
            case 105: 
            case 108: 
            case 109: 
            case 111: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 21: 
            case 23: 
            case 28: 
            case 31: 
            case 32: 
            case 44: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 76: 
            case 77: 
            case 80: 
            case 83: 
            case 84: 
            case 87: 
            case 90: 
            case 92: 
            case 94: 
            case 96: 
            case 103: 
            case 105: 
            case 108: 
            case 109: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 20: 
            case 26: 
            case 29: 
            case 33: 
            case 36: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 24: 
            case 63: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 25: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 43: 
            case 46: 
            case 48: 
            case 68: 
            case 74: 
            case 79: 
            case 82: 
            case 86: 
            case 101: 
            case 102: 
            case 104: 
            case 106: 
            case 113: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableKind";
                break;
            }
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestions";
                break;
            }
            case 42: 
            case 45: 
            case 47: 
            case 61: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringValue";
                break;
            }
            case 73: 
            case 78: 
            case 85: 
            case 88: 
            case 97: 
            case 98: 
            case 107: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 89: 
            case 91: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseNameInfo";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canBeReused";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenClassReferences";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifyClassReferences";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestCompiledParameterName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestVariableName";
                break;
            }
            case 28: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestVariableNameByType";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestVariableNameByExpression";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestVariableNameByExpressionOnly";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "constantValueToConstantName";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestionsByValue";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestVariableNameByExpressionPlace";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "variableNameToPropertyName";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "variableNameToPropertyNameInner";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "propertyNameToVariableName";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestionsByName";
                break;
            }
            case 90: 
            case 92: 
            case 94: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestUniqueVariableName";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixByVariableKind";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuffixByVariableKind";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "changeIfNotIdentifier";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shortenClassReferences";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 21: 
            case 23: 
            case 28: 
            case 31: 
            case 32: 
            case 44: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 76: 
            case 77: 
            case 80: 
            case 83: 
            case 84: 
            case 87: 
            case 90: 
            case 92: 
            case 94: 
            case 96: 
            case 103: 
            case 105: 
            case 108: 
            case 109: 
            case 111: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "qualifyClassReferences";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "optimizeImports";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prepareOptimizeImportsResult";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasConflictingOnDemandImport";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeRedundantImports";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findRedundantImports";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findEntryIndex";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "suggestCompiledParameterName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "suggestVariableName";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addNamesFromStatistics";
                break;
            }
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "suggestVariableNameByType";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "suggestNamesFromGenericParameters";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "suggestNamesForCollectionInheritors";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getLongTypeName";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "suggestVariableNameByExpression";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "suggestVariableNameFromLiterals";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "suggestVariableNameByExpressionOnly";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isJavaUtilMethodCall";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isJavaUtilMethod";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "constantValueToConstantName";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestionsByValue";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "suggestVariableNameByExpressionPlace";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "variableNameToPropertyName";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "variableNameToPropertyNameInner";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "propertyNameToVariableName";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestionsByName";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getWordByPreposition";
                break;
            }
            case 89: 
            case 91: 
            case 93: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "suggestUniqueVariableName";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "hasConflictingVariable";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "hasConflictingVariableAfterwards";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "sortVariableNameSuggestions";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixByVariableKind";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getSuffixByVariableKind";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getMapByVariableKind";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "changeIfNotIdentifier";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifier";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "isStringPsiLiteral";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sortVariableNameSuggestions$5";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "lambda$suggestVariableNameByType$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 21: 
            case 23: 
            case 28: 
            case 31: 
            case 32: 
            case 44: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 76: 
            case 77: 
            case 80: 
            case 83: 
            case 84: 
            case 87: 
            case 90: 
            case 92: 
            case 94: 
            case 96: 
            case 103: 
            case 105: 
            case 108: 
            case 109: 
            case 111: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NamesByExprInfo {
        private final String[] names;
        private final String propertyName;

        private NamesByExprInfo(String propertyName, String ... names) {
            if (names == null) {
                NamesByExprInfo.$$$reportNull$$$0(0);
            }
            this.names = names;
            this.propertyName = propertyName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl$NamesByExprInfo", "<init>"));
        }
    }
}

