/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.extractMethod.JavaDuplicatesExtractMethodProcessor;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.ExtractedParameter;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.VariableReturnValue;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParametrizedDuplicates {
    private static final Logger LOG = Logger.getInstance(ParametrizedDuplicates.class);
    private final PsiElement[] myElements;
    private List<Match> myMatches;
    private List<ClusterOfUsages> myUsagesList;
    private PsiMethod myParametrizedMethod;
    private PsiMethodCallExpression myParametrizedCall;
    private VariableData[] myVariableDatum;

    private ParametrizedDuplicates(@NotNull PsiElement[] pattern, @NotNull ExtractMethodProcessor originalProcessor) {
        if (pattern == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(0);
        }
        if (originalProcessor == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(1);
        }
        pattern = ParametrizedDuplicates.getFilteredElements(pattern);
        LOG.assertTrue(pattern.length != 0, (Object)"pattern length");
        if (pattern[0] instanceof PsiStatement) {
            PsiElement[] copy = ParametrizedDuplicates.copyElements(pattern);
            this.myElements = ParametrizedDuplicates.wrapWithCodeBlock(copy);
        } else if (pattern[0] instanceof PsiExpression) {
            PsiElement[] psiElementArray;
            PsiElement[] copy = ParametrizedDuplicates.copyElements(pattern);
            PsiExpression wrapped = ParametrizedDuplicates.wrapExpressionWithCodeBlock(copy, originalProcessor);
            if (wrapped != null) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = wrapped;
            } else {
                psiElementArray = PsiElement.EMPTY_ARRAY;
            }
            this.myElements = psiElementArray;
        } else {
            this.myElements = PsiElement.EMPTY_ARRAY;
        }
    }

    private static PsiElement[] copyElements(@NotNull PsiElement[] pattern) {
        if (pattern == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(2);
        }
        Project project = pattern[0].getProject();
        return IntroduceParameterHandler.getElementsInCopy(project, pattern[0].getContainingFile(), pattern);
    }

    @Nullable
    public static ParametrizedDuplicates findDuplicates(@NotNull ExtractMethodProcessor originalProcessor) {
        PsiElement[] pattern;
        if (originalProcessor == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(3);
        }
        if ((pattern = originalProcessor.myElements).length == 0) {
            return null;
        }
        List<Match> matches = ParametrizedDuplicates.findOriginalDuplicates(originalProcessor);
        if (matches.isEmpty()) {
            return null;
        }
        ParametrizedDuplicates duplicates = new ParametrizedDuplicates(pattern, originalProcessor);
        if (!duplicates.initMatches(matches)) {
            return null;
        }
        if (!duplicates.extract(originalProcessor)) {
            return null;
        }
        return duplicates;
    }

    @NotNull
    private static List<Match> findOriginalDuplicates(@NotNull ExtractMethodProcessor processor) {
        if (processor == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(4);
        }
        final PsiElement[] elements = ParametrizedDuplicates.getFilteredElements(processor.myElements);
        Set<PsiVariable> effectivelyLocal = processor.getEffectivelyLocalVariables();
        List variables = ContainerUtil.map(processor.myInputVariables.getInputVariables(), iv -> iv.variable);
        InputVariables inputVariables = new InputVariables(variables, processor.myProject, new LocalSearchScope(processor.myElements), false);
        DuplicatesFinder finder = new DuplicatesFinder(elements, inputVariables, processor.myOutputVariable != null ? new VariableReturnValue(processor.myOutputVariable) : null, Collections.emptyList(), true, effectivelyLocal){

            @Override
            protected boolean isSelf(@NotNull PsiElement candidate) {
                if (candidate == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (PsiElement element : elements) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)candidate, (boolean)false)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/refactoring/extractMethod/ParametrizedDuplicates$1", "isSelf"));
            }
        };
        List<Match> list = finder.findDuplicates((PsiElement)processor.myTargetClass);
        if (list == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public PsiMethod replaceMethod(@NotNull PsiMethod originalMethod) {
        if (originalMethod == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(6);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)originalMethod.getProject());
        String text2 = this.myParametrizedMethod.getText();
        PsiMethod method = factory.createMethodFromText(text2, originalMethod.getParent());
        PsiMethod psiMethod = (PsiMethod)originalMethod.replace((PsiElement)method);
        if (psiMethod == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(7);
        }
        return psiMethod;
    }

    @NotNull
    public PsiMethodCallExpression replaceCall(@NotNull PsiMethodCallExpression originalCall) {
        if (originalCall == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(8);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)originalCall.getProject());
        String text2 = this.myParametrizedCall.getText();
        PsiMethodCallExpression call = (PsiMethodCallExpression)factory.createExpressionFromText(text2, originalCall.getParent());
        PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)originalCall.replace((PsiElement)call);
        if (psiMethodCallExpression == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(9);
        }
        return psiMethodCallExpression;
    }

    private boolean initMatches(@NotNull List<Match> matches) {
        if (matches == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(10);
        }
        if (this.myElements.length == 0) {
            return false;
        }
        matches = ParametrizedDuplicates.filterNestedSubexpressions(matches);
        this.myUsagesList = new ArrayList<ClusterOfUsages>();
        THashMap usagesMap = new THashMap();
        THashSet badMatches = new THashSet();
        for (Match match : matches) {
            List<ClusterOfUsages> usagesInMatch = ParametrizedDuplicates.getUsagesInMatch((Map<PsiExpression, ClusterOfUsages>)usagesMap, match);
            if (usagesInMatch == null) {
                badMatches.add(match);
                continue;
            }
            for (ClusterOfUsages usages2 : usagesInMatch) {
                this.myUsagesList.add(usages2);
                for (PsiExpression expression2 : usages2.myPatterns) {
                    usagesMap.put(expression2, usages2);
                }
            }
        }
        if (!badMatches.isEmpty()) {
            matches = new ArrayList<Match>(matches);
            matches.removeAll((Collection<?>)badMatches);
        }
        this.myMatches = matches;
        if (this.myMatches.isEmpty()) {
            return false;
        }
        for (ClusterOfUsages usages3 : this.myUsagesList) {
            for (Match match : this.myMatches) {
                ExtractedParameter parameter2 = (ExtractedParameter)usages3.myParameters.get(match);
                if (parameter2 != null) continue;
                parameter2 = usages3.myParameter.mapPatternToItself(match);
                usages3.putParameter(match, parameter2);
            }
        }
        this.myUsagesList.sort(Comparator.comparing(usages -> ((ClusterOfUsages)usages).myFirstOffset));
        return true;
    }

    private static List<Match> filterNestedSubexpressions(List<Match> matches) {
        THashMap patternUsages = new THashMap();
        for (Match match : matches) {
            for (ExtractedParameter parameter2 : match.getExtractedParameters()) {
                for (PsiExpression patternUsage : parameter2.myPatternUsages) {
                    patternUsages.computeIfAbsent(patternUsage, k -> new THashSet()).add(match);
                }
            }
        }
        THashSet badMatches = new THashSet();
        block3: for (Map.Entry entry : patternUsages.entrySet()) {
            PsiExpression patternUsage = (PsiExpression)entry.getKey();
            Set patternMatches = (Set)entry.getValue();
            for (PsiExpression maybeNestedUsage : patternUsages.keySet()) {
                if (patternUsage == maybeNestedUsage || !PsiTreeUtil.isAncestor((PsiElement)patternUsage, (PsiElement)maybeNestedUsage, (boolean)true)) continue;
                badMatches.addAll(patternMatches);
                continue block3;
            }
        }
        if (!badMatches.isEmpty()) {
            matches = new ArrayList<Match>(matches);
            matches.removeAll((Collection<?>)badMatches);
        }
        return matches;
    }

    @Nullable
    private static List<ClusterOfUsages> getUsagesInMatch(@NotNull Map<PsiExpression, ClusterOfUsages> usagesMap, @NotNull Match match) {
        if (usagesMap == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(11);
        }
        if (match == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(12);
        }
        ArrayList<ClusterOfUsages> result = new ArrayList<ClusterOfUsages>();
        List<ExtractedParameter> parameters2 = match.getExtractedParameters();
        for (ExtractedParameter parameter2 : parameters2) {
            ClusterOfUsages usages = usagesMap.get(parameter2.myPattern.getUsage());
            if (usages != null && !usages.isEquivalent(parameter2) || usages == null && ClusterOfUsages.isPresent(usagesMap, parameter2)) {
                return null;
            }
            if (usages == null) {
                usages = new ClusterOfUsages(parameter2);
                result.add(usages);
            }
            usages.putParameter(match, parameter2);
        }
        return result;
    }

    private boolean extract(@NotNull ExtractMethodProcessor originalProcessor) {
        if (originalProcessor == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(13);
        }
        THashMap expressionsMapping = new THashMap();
        THashMap variablesMapping = new THashMap();
        ParametrizedDuplicates.collectCopyMapping(originalProcessor.myElements, this.myElements, this.myUsagesList, (Map<PsiExpression, PsiExpression>)expressionsMapping, (Map<PsiVariable, PsiVariable>)variablesMapping);
        Map<PsiLocalVariable, ClusterOfUsages> parameterDeclarations = this.createParameterDeclarations(originalProcessor, (Map<PsiExpression, PsiExpression>)expressionsMapping);
        this.putMatchParameters(parameterDeclarations);
        JavaDuplicatesExtractMethodProcessor parametrizedProcessor = new JavaDuplicatesExtractMethodProcessor(this.myElements, ExtractMethodHandler.REFACTORING_NAME);
        if (!parametrizedProcessor.prepare(false)) {
            return false;
        }
        parametrizedProcessor.applyFrom(originalProcessor, (Map<PsiVariable, PsiVariable>)variablesMapping);
        parametrizedProcessor.doExtract();
        this.myParametrizedMethod = parametrizedProcessor.getExtractedMethod();
        this.myParametrizedCall = parametrizedProcessor.getMethodCall();
        this.myVariableDatum = ParametrizedDuplicates.unmapVariableData(parametrizedProcessor.myVariableDatum, (Map<PsiVariable, PsiVariable>)variablesMapping);
        ParametrizedDuplicates.replaceArguments(parameterDeclarations, this.myParametrizedCall);
        return true;
    }

    @NotNull
    private static VariableData[] unmapVariableData(@NotNull VariableData[] variableDatum, @NotNull Map<PsiVariable, PsiVariable> variablesMapping) {
        if (variableDatum == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(14);
        }
        if (variablesMapping == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(15);
        }
        Map reverseMapping = ContainerUtil.reverseMap(variablesMapping);
        VariableData[] variableDataArray = (VariableData[])StreamEx.of((Object[])variableDatum).map(data -> data.substitute((PsiVariable)reverseMapping.get(data.variable))).toArray(VariableData[]::new);
        if (variableDataArray == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(16);
        }
        return variableDataArray;
    }

    private static void replaceArguments(@NotNull Map<PsiLocalVariable, ClusterOfUsages> parameterDeclarations, @NotNull PsiMethodCallExpression parametrizedCall) {
        PsiExpression[] arguments;
        if (parameterDeclarations == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(17);
        }
        if (parametrizedCall == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(18);
        }
        for (PsiExpression argument : arguments = parametrizedCall.getArgumentList().getExpressions()) {
            PsiExpression initializer;
            PsiElement resolved;
            if (!(argument instanceof PsiReferenceExpression) || !((resolved = ((PsiReferenceExpression)argument).resolve()) instanceof PsiLocalVariable) || !parameterDeclarations.containsKey(resolved) || (initializer = ((PsiLocalVariable)resolved).getInitializer()) == null) continue;
            argument.replace((PsiElement)initializer);
        }
    }

    private void putMatchParameters(@NotNull Map<PsiLocalVariable, ClusterOfUsages> parameterDeclarations) {
        if (parameterDeclarations == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(19);
        }
        THashMap patternUsageToParameter = new THashMap();
        for (Map.Entry<PsiLocalVariable, ClusterOfUsages> entry : parameterDeclarations.entrySet()) {
            PsiExpression usage = ((ClusterOfUsages)entry.getValue()).myParameter.myPattern.getUsage();
            patternUsageToParameter.put(usage, entry.getKey());
        }
        for (Match match : this.myMatches) {
            List<ExtractedParameter> matchedParameters = match.getExtractedParameters();
            for (ExtractedParameter matchedParameter : matchedParameters) {
                PsiLocalVariable localVariable = (PsiLocalVariable)patternUsageToParameter.get(matchedParameter.myPattern.getUsage());
                LOG.assertTrue(localVariable != null, (Object)"match local variable");
                boolean ok = match.putParameter((Pair<PsiVariable, PsiType>)Pair.createNonNull((Object)localVariable, (Object)matchedParameter.myType), (PsiElement)matchedParameter.myCandidate.getUsage());
                LOG.assertTrue(ok, (Object)"put match parameter");
            }
        }
    }

    public PsiMethod getParametrizedMethod() {
        return this.myParametrizedMethod;
    }

    public PsiMethodCallExpression getParametrizedCall() {
        return this.myParametrizedCall;
    }

    public VariableData[] getVariableDatum() {
        return this.myVariableDatum;
    }

    public int getSize() {
        return this.myMatches != null ? this.myMatches.size() : 0;
    }

    public List<Match> getDuplicates() {
        return this.myMatches;
    }

    @NotNull
    private static PsiElement[] wrapWithCodeBlock(@NotNull PsiElement[] elements) {
        if (elements == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(20);
        }
        PsiElement parent = elements[0].getParent();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)elements[0].getProject());
        PsiBlockStatement statement = (PsiBlockStatement)factory.createStatementFromText("{}", parent);
        statement.getCodeBlock().addRange(elements[0], elements[elements.length - 1]);
        statement = (PsiBlockStatement)parent.addBefore((PsiElement)statement, elements[0]);
        parent.deleteChildRange(elements[0], elements[elements.length - 1]);
        PsiCodeBlock codeBlock = statement.getCodeBlock();
        PsiElement[] elementsInCopy = codeBlock.getChildren();
        LOG.assertTrue(elementsInCopy.length >= elements.length + 2, (Object)"wrapper block length is too small");
        PsiElement[] psiElementArray = Arrays.copyOfRange(elementsInCopy, 1, elementsInCopy.length - 1);
        if (psiElementArray == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(21);
        }
        return psiElementArray;
    }

    @Nullable
    private static PsiExpression wrapExpressionWithCodeBlock(@NotNull PsiElement[] copy, @NotNull ExtractMethodProcessor originalProcessor) {
        if (copy == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(22);
        }
        if (originalProcessor == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(23);
        }
        if (copy.length != 1 || !(copy[0] instanceof PsiExpression)) {
            return null;
        }
        PsiExpression expression2 = (PsiExpression)copy[0];
        PsiType type2 = expression2.getType();
        if (type2 == null || PsiType.NULL.equals((Object)type2)) {
            return null;
        }
        PsiElement parent = expression2.getParent();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class);
        if (parentClass == null) {
            return null;
        }
        PsiElement parentClassStart = parentClass.getLBrace();
        if (parentClassStart == null) {
            return null;
        }
        String wrapperBodyText = (PsiType.VOID.equals((Object)type2) ? "" : "return ") + expression2.getText() + ";";
        String wrapperClassImmediateCallText = "new java.lang.Object() { " + type2.getCanonicalText() + " wrapperMethod() {" + wrapperBodyText + "} }.wrapperMethod()";
        PsiExpression wrapperClassImmediateCall = factory.createExpressionFromText(wrapperClassImmediateCallText, parent);
        wrapperClassImmediateCall = (PsiExpression)expression2.replace((PsiElement)wrapperClassImmediateCall);
        PsiMethod method = (PsiMethod)PsiTreeUtil.findChildOfType((PsiElement)wrapperClassImmediateCall, PsiMethod.class);
        LOG.assertTrue(method != null, (Object)"wrapper class method is null");
        PsiCodeBlock body2 = method.getBody();
        LOG.assertTrue(body2 != null, (Object)"wrapper class method's body is null");
        PsiStatement[] statements = body2.getStatements();
        LOG.assertTrue(statements.length == 1, (Object)"wrapper class method's body statement count");
        PsiStatement bodyStatement = statements[0];
        Set<PsiVariable> effectivelyLocal = originalProcessor.getEffectivelyLocalVariables();
        for (PsiVariable variable : effectivelyLocal) {
            String name = variable.getName();
            LOG.assertTrue(name != null, (Object)"effectively local variable's name is null");
            PsiDeclarationStatement declaration2 = factory.createVariableDeclarationStatement(name, variable.getType(), null);
            body2.addBefore((PsiElement)declaration2, (PsiElement)bodyStatement);
        }
        PsiExpression wrapped = null;
        if (PsiType.VOID.equals((Object)type2) && bodyStatement instanceof PsiExpressionStatement) {
            wrapped = ((PsiExpressionStatement)bodyStatement).getExpression();
        } else if (bodyStatement instanceof PsiReturnStatement) {
            wrapped = ((PsiReturnStatement)bodyStatement).getReturnValue();
        } else {
            LOG.error("Unexpected statement in expression code block " + bodyStatement);
        }
        if (wrapped != null) {
            wrapped.putUserData(ElementToWorkOn.REPLACE_NON_PHYSICAL, expression2.getUserData(ElementToWorkOn.REPLACE_NON_PHYSICAL));
        }
        return wrapped;
    }

    @NotNull
    private Map<PsiLocalVariable, ClusterOfUsages> createParameterDeclarations(@NotNull ExtractMethodProcessor originalProcessor, @NotNull Map<PsiExpression, PsiExpression> expressionsMapping) {
        if (originalProcessor == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(24);
        }
        if (expressionsMapping == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(25);
        }
        Project project = this.myElements[0].getProject();
        THashMap parameterDeclarations = new THashMap();
        UniqueNameGenerator generator = originalProcessor.getParameterNameGenerator(this.myElements[0]);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiStatement statement = this.myElements[0] instanceof PsiStatement ? (PsiStatement)this.myElements[0] : (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myElements[0], PsiStatement.class);
        LOG.assertTrue(statement != null, (Object)"first statement is null");
        PsiElement parent = statement.getParent();
        LOG.assertTrue(parent instanceof PsiCodeBlock, (Object)"first statement's parent isn't a code block");
        for (ClusterOfUsages usages : this.myUsagesList) {
            ExtractedParameter parameter2 = usages.myParameter;
            PsiExpression patternUsage = parameter2.myPattern.getUsage();
            String initializerText = patternUsage.getText();
            PsiExpression initializer = factory.createExpressionFromText(initializerText, parent);
            SuggestedNameInfo info = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName(VariableKind.PARAMETER, null, initializer, null);
            String parameterName = generator.generateUniqueName(info.names.length > 0 ? info.names[0] : "p");
            String declarationText = parameter2.myType.getCanonicalText() + " " + parameterName + " = " + initializerText + ";";
            PsiDeclarationStatement paramDeclaration = (PsiDeclarationStatement)factory.createStatementFromText(declarationText, parent);
            paramDeclaration = (PsiDeclarationStatement)parent.addBefore((PsiElement)paramDeclaration, (PsiElement)statement);
            PsiLocalVariable localVariable = (PsiLocalVariable)paramDeclaration.getDeclaredElements()[0];
            parameterDeclarations.put(localVariable, usages);
            for (PsiExpression expression2 : parameter2.myPatternUsages) {
                PsiExpression mapped = expressionsMapping.get(expression2);
                if (mapped == null) continue;
                PsiExpression replacement = factory.createExpressionFromText(parameterName, (PsiElement)expression2);
                mapped.replace((PsiElement)replacement);
            }
        }
        THashMap tHashMap = parameterDeclarations;
        if (tHashMap == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(26);
        }
        return tHashMap;
    }

    private static void collectCopyMapping(@NotNull PsiElement[] pattern, @NotNull PsiElement[] copy, @NotNull List<ClusterOfUsages> patternUsages, @NotNull Map<PsiExpression, PsiExpression> expressions2, @NotNull Map<PsiVariable, PsiVariable> variables) {
        if (pattern == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(27);
        }
        if (copy == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(28);
        }
        if (patternUsages == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(29);
        }
        if (expressions2 == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(30);
        }
        if (variables == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(31);
        }
        THashSet patternExpressions = new THashSet();
        for (ClusterOfUsages usages : patternUsages) {
            patternExpressions.addAll(usages.myPatterns);
        }
        ParametrizedDuplicates.collectCopyMapping(pattern, copy, (Set<PsiExpression>)patternExpressions, expressions2, variables);
    }

    private static void collectCopyMapping(@NotNull PsiElement[] pattern, @NotNull PsiElement[] copy, @NotNull Set<PsiExpression> replaceablePatterns, @NotNull Map<PsiExpression, PsiExpression> expressions2, @NotNull Map<PsiVariable, PsiVariable> variables) {
        if (pattern == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(32);
        }
        if (copy == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(33);
        }
        if (replaceablePatterns == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(34);
        }
        if (expressions2 == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(35);
        }
        if (variables == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(36);
        }
        pattern = ParametrizedDuplicates.getFilteredElements(pattern);
        LOG.assertTrue((copy = ParametrizedDuplicates.getFilteredElements(copy)).length == pattern.length, (Object)"copy length");
        for (int i = 0; i < pattern.length; ++i) {
            ParametrizedDuplicates.collectCopyMapping(pattern[i], copy[i], replaceablePatterns, expressions2, variables);
        }
    }

    private static void collectCopyMapping(PsiElement pattern, PsiElement copy, Set<PsiExpression> replaceablePatterns, Map<PsiExpression, PsiExpression> expressions2, Map<PsiVariable, PsiVariable> variables) {
        if (pattern == copy) {
            return;
        }
        LOG.assertTrue(pattern != null && copy != null, (Object)"null in collectVariablesMapping");
        if (pattern instanceof PsiExpression && copy instanceof PsiExpression && replaceablePatterns.contains(pattern)) {
            expressions2.put((PsiExpression)pattern, (PsiExpression)copy);
        }
        if (pattern instanceof PsiReferenceExpression && copy instanceof PsiReferenceExpression) {
            PsiElement resolvedCopy;
            PsiElement resolvedPattern = ((PsiReferenceExpression)pattern).resolve();
            if (resolvedPattern != (resolvedCopy = ((PsiReferenceExpression)copy).resolve()) && resolvedPattern instanceof PsiVariable && resolvedCopy instanceof PsiVariable) {
                variables.put((PsiVariable)resolvedPattern, (PsiVariable)resolvedCopy);
            }
        } else if (pattern instanceof PsiVariable && copy instanceof PsiVariable) {
            variables.put((PsiVariable)pattern, (PsiVariable)copy);
        }
        ParametrizedDuplicates.collectCopyMapping(pattern.getChildren(), copy.getChildren(), replaceablePatterns, expressions2, variables);
    }

    @NotNull
    private static PsiElement[] getFilteredElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(37);
        }
        if (elements.length == 0) {
            if (elements == null) {
                ParametrizedDuplicates.$$$reportNull$$$0(38);
            }
            return elements;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>(elements.length);
        for (PsiElement e : elements) {
            if (e == null || e instanceof PsiWhiteSpace || e instanceof PsiComment || e instanceof PsiEmptyStatement) continue;
            if (e instanceof PsiParenthesizedExpression) {
                e = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiParenthesizedExpression)e));
            }
            result.add(e);
        }
        PsiElement[] psiElementArray = result.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(39);
        }
        return psiElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 21: 
            case 26: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 21: 
            case 26: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 3: 
            case 13: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 21: 
            case 26: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/ParametrizedDuplicates";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalMethod";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalCall";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matches";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagesMap";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDatum";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variablesMapping";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterDeclarations";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametrizedCall";
                break;
            }
            case 20: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 22: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionsMapping";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternUsages";
                break;
            }
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceablePatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/ParametrizedDuplicates";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findOriginalDuplicates";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceMethod";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceCall";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "unmapVariableData";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithCodeBlock";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterDeclarations";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyElements";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findDuplicates";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findOriginalDuplicates";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 21: 
            case 26: 
            case 38: 
            case 39: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replaceMethod";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceCall";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "initMatches";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUsagesInMatch";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "unmapVariableData";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replaceArguments";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "putMatchParameters";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithCodeBlock";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "wrapExpressionWithCodeBlock";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createParameterDeclarations";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "collectCopyMapping";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 21: 
            case 26: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ClusterOfUsages {
        @NotNull
        private final Set<PsiExpression> myPatterns;
        @NotNull
        private final Map<Match, ExtractedParameter> myParameters;
        @NotNull
        private final ExtractedParameter myParameter;
        private final int myFirstOffset;

        public ClusterOfUsages(@NotNull ExtractedParameter parameter2) {
            if (parameter2 == null) {
                ClusterOfUsages.$$$reportNull$$$0(0);
            }
            this.myPatterns = parameter2.myPatternUsages;
            this.myParameters = new THashMap();
            this.myParameter = parameter2;
            this.myFirstOffset = this.myPatterns.stream().mapToInt(PsiElement::getTextOffset).min().orElse(0);
        }

        public void putParameter(Match match, ExtractedParameter parameter2) {
            this.myParameters.put(match, parameter2);
        }

        public boolean isEquivalent(ExtractedParameter parameter2) {
            return this.myPatterns.equals(parameter2.myPatternUsages);
        }

        public static boolean isPresent(Map<PsiExpression, ClusterOfUsages> usagesMap, @NotNull ExtractedParameter parameter2) {
            if (parameter2 == null) {
                ClusterOfUsages.$$$reportNull$$$0(1);
            }
            return parameter2.myPatternUsages.stream().anyMatch(usagesMap::containsKey);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "parameter";
            objectArray2[1] = "com/intellij/refactoring/extractMethod/ParametrizedDuplicates$ClusterOfUsages";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPresent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

