/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass.usageInfo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class ReplaceConstructorUsageInfo
extends FixableUsageInfo {
    private final PsiType myNewType;
    private String myConflict;
    private static final String CONSTRUCTOR_MATCHING_SUPER_NOT_FOUND = "Constructor matching super not found";

    public ReplaceConstructorUsageInfo(PsiNewExpression element, PsiType newType, PsiClass[] targetClasses) {
        super((PsiElement)element);
        PsiType type2;
        this.myNewType = newType;
        PsiMethod[] constructors = targetClasses[0].getConstructors();
        PsiMethod constructor = element.resolveConstructor();
        if (constructor == null) {
            if (element.getArgumentList() != null && (constructors.length == 1 && !constructors[0].getParameterList().isEmpty() || constructors.length > 1)) {
                this.myConflict = CONSTRUCTOR_MATCHING_SUPER_NOT_FOUND;
            }
        } else {
            PsiParameter[] superParameters = constructor.getParameterList().getParameters();
            boolean foundMatchingConstructor = constructors.length == 0 && superParameters.length == 0;
            block0: for (PsiMethod method : constructors) {
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                if (superParameters.length != parameters2.length) continue;
                for (int i = 0; i < parameters2.length; ++i) {
                    PsiParameter parameter2 = parameters2[i];
                    if (!TypeConversionUtil.isAssignable((PsiType)TypeConversionUtil.erasure((PsiType)parameter2.getType()), (PsiType)TypeConversionUtil.erasure((PsiType)superParameters[i].getType()))) continue block0;
                }
                foundMatchingConstructor = true;
            }
            if (!foundMatchingConstructor) {
                this.myConflict = CONSTRUCTOR_MATCHING_SUPER_NOT_FOUND;
            }
        }
        if ((type2 = element.getType()) == null) {
            this.appendConflict("Type is unknown");
            return;
        }
        if (!TypeConversionUtil.isAssignable((PsiType)(type2 = type2.getDeepComponentType()), (PsiType)newType)) {
            String conflict = "Type parameters do not agree in " + element.getText() + ". Expected " + newType.getPresentableText() + " but found " + type2.getPresentableText();
            this.appendConflict(conflict);
        }
        if (targetClasses.length > 1) {
            String conflict = "Constructor " + element.getText() + " can be replaced with any of " + StringUtil.join((Object[])targetClasses, psiClass -> psiClass.getQualifiedName(), (String)", ");
            this.appendConflict(conflict);
        }
    }

    private void appendConflict(String conflict) {
        this.myConflict = this.myConflict == null ? conflict : this.myConflict + "\n" + conflict;
    }

    public void fixUsage() throws IncorrectOperationException {
        PsiNewExpression newExpression = (PsiNewExpression)this.getElement();
        if (newExpression != null) {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)newExpression.getProject()).getElementFactory();
            StringBuffer buf = new StringBuffer();
            buf.append("new ").append(this.myNewType.getCanonicalText());
            PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
            PsiType newExpressionType = newExpression.getType();
            assert (newExpressionType != null);
            if (arrayInitializer != null) {
                for (int i = 0; i < newExpressionType.getArrayDimensions(); ++i) {
                    buf.append("[]");
                }
                buf.append(arrayInitializer.getText());
            } else {
                Object[] arrayDimensions = newExpression.getArrayDimensions();
                if (arrayDimensions.length > 0) {
                    buf.append("[");
                    buf.append(StringUtil.join((Object[])arrayDimensions, psiExpression -> psiExpression.getText(), (String)"]["));
                    buf.append("]");
                    for (int i = 0; i < newExpressionType.getArrayDimensions() - arrayDimensions.length; ++i) {
                        buf.append("[]");
                    }
                } else {
                    PsiExpressionList list = newExpression.getArgumentList();
                    if (list != null) {
                        buf.append(list.getText());
                    }
                }
            }
            newExpression.replace((PsiElement)elementFactory.createExpressionFromText(buf.toString(), (PsiElement)newExpression));
        }
    }

    public String getConflictMessage() {
        return this.myConflict;
    }
}

