/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceField.InplaceIntroduceConstantPopup;
import com.intellij.refactoring.introduceField.IntroduceConstantDialog;
import com.intellij.refactoring.introduceField.LocalToFieldHandler;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.ClassMemberReferencesVisitor;
import com.intellij.refactoring.util.occurrences.ExpressionOccurrenceManager;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroduceConstantHandler
extends BaseExpressionToFieldHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"introduce.constant.title");
    protected InplaceIntroduceConstantPopup myInplaceIntroduceConstantPopup;

    public IntroduceConstantHandler() {
        super(true);
    }

    @Override
    protected String getHelpID() {
        return "refactoring.introduceConstant";
    }

    public void invoke(Project project, PsiExpression[] expressions2) {
        for (PsiExpression expression2 : expressions2) {
            PsiFile file = expression2.getContainingFile();
            if (CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) continue;
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        super.invoke(project, (PsiElement[])expressions2, null);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            IntroduceConstantHandler.$$$reportNull$$$0(0);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ElementToWorkOn.processElementToWorkOn(editor, file, REFACTORING_NAME, this.getHelpID(), project, this.getElementProcessor(project, editor));
    }

    @Override
    protected boolean invokeImpl(final Project project, PsiLocalVariable localVariable, final Editor editor) {
        PsiElement parent = localVariable.getParent();
        if (!(parent instanceof PsiDeclarationStatement)) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.local.or.expression.name"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)this.getHelpID());
            return false;
        }
        LocalToFieldHandler localToFieldHandler = new LocalToFieldHandler(project, true){

            @Override
            protected BaseExpressionToFieldHandler.Settings showRefactoringDialog(PsiClass aClass, PsiLocalVariable local, PsiExpression[] occurences, boolean isStatic) {
                return IntroduceConstantHandler.this.showRefactoringDialog(project, editor, aClass, local.getInitializer(), local.getType(), occurences, (PsiElement)local, null);
            }
        };
        return localToFieldHandler.convertLocalToField(localVariable, editor);
    }

    @Override
    protected BaseExpressionToFieldHandler.Settings showRefactoringDialog(Project project, Editor editor, PsiClass parentClass, PsiExpression expr, PsiType type2, PsiExpression[] occurrences, PsiElement anchorElement, PsiElement anchorElementIfAll) {
        PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)(expr != null ? expr : anchorElement), PsiMethod.class);
        PsiLocalVariable localVariable = null;
        if (expr instanceof PsiReferenceExpression) {
            PsiElement ref = ((PsiReferenceExpression)expr).resolve();
            if (ref instanceof PsiLocalVariable) {
                localVariable = (PsiLocalVariable)ref;
            }
        } else if (anchorElement instanceof PsiLocalVariable) {
            localVariable = (PsiLocalVariable)anchorElement;
        }
        String enteredName = null;
        boolean replaceAllOccurrences = true;
        AbstractInplaceIntroducer activeIntroducer = AbstractInplaceIntroducer.getActiveIntroducer((Editor)editor);
        if (activeIntroducer != null) {
            activeIntroducer.stopIntroduce(editor);
            expr = (PsiExpression)activeIntroducer.getExpr();
            localVariable = (PsiLocalVariable)activeIntroducer.getLocalVariable();
            occurrences = (PsiExpression[])activeIntroducer.getOccurrences();
            enteredName = activeIntroducer.getInputName();
            replaceAllOccurrences = activeIntroducer.isReplaceAllOccurrences();
            type2 = ((InplaceIntroduceConstantPopup)activeIntroducer).getType();
        }
        for (PsiExpression occurrence : occurrences) {
            if (!RefactoringUtil.isAssignmentLHS((PsiElement)occurrence)) continue;
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)"Selected expression is used for write");
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)this.getHelpID());
            IntroduceConstantHandler.highlightError(project, editor, (PsiElement)occurrence);
            return null;
        }
        if (localVariable == null) {
            PsiElement errorElement = this.isStaticFinalInitializer(expr);
            if (errorElement != null) {
                String message3 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.expression.cannot.be.a.constant.initializer"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message3, (String)REFACTORING_NAME, (String)this.getHelpID());
                IntroduceConstantHandler.highlightError(project, editor, errorElement);
                return null;
            }
        } else {
            PsiExpression initializer = localVariable.getInitializer();
            if (initializer == null) {
                String message4 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.does.not.have.an.initializer", (Object[])new Object[]{localVariable.getName()}));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message4, (String)REFACTORING_NAME, (String)this.getHelpID());
                return null;
            }
            PsiElement errorElement = this.isStaticFinalInitializer(initializer);
            if (errorElement != null) {
                String message5 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"initializer.for.variable.cannot.be.a.constant.initializer", (Object[])new Object[]{localVariable.getName()}));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message5, (String)REFACTORING_NAME, (String)this.getHelpID());
                IntroduceConstantHandler.highlightError(project, editor, errorElement);
                return null;
            }
        }
        TypeSelectorManagerImpl typeSelectorManager = new TypeSelectorManagerImpl(project, type2, containingMethod, expr, occurrences);
        if (editor != null && editor.getSettings().isVariableInplaceRenameEnabled() && (expr == null || expr.isPhysical()) && activeIntroducer == null) {
            this.myInplaceIntroduceConstantPopup = new InplaceIntroduceConstantPopup(project, editor, parentClass, expr, localVariable, occurrences, typeSelectorManager, anchorElement, anchorElementIfAll, expr != null ? this.createOccurrenceManager(expr, parentClass) : null);
            if (this.myInplaceIntroduceConstantPopup.startInplaceIntroduceTemplate()) {
                return null;
            }
        }
        IntroduceConstantDialog dialog = new IntroduceConstantDialog(project, parentClass, expr, localVariable, localVariable != null, occurrences, this.getParentClass(), typeSelectorManager, enteredName);
        dialog.setReplaceAllOccurrences(replaceAllOccurrences);
        if (!dialog.showAndGet()) {
            if (occurrences.length > 1) {
                WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            }
            return null;
        }
        return new BaseExpressionToFieldHandler.Settings(dialog.getEnteredName(), expr, occurrences, dialog.isReplaceAllOccurrences(), true, true, BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION, dialog.getFieldVisibility(), localVariable, dialog.getSelectedType(), dialog.isDeleteVariable(), dialog.getDestinationClass(), dialog.isAnnotateAsNonNls(), dialog.introduceEnumConstant());
    }

    private static void highlightError(Project project, Editor editor, PsiElement errorElement) {
        if (editor != null) {
            TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            TextRange textRange = errorElement.getTextRange();
            HighlightManager.getInstance((Project)project).addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributes, true, new ArrayList());
        }
    }

    @Override
    protected String getRefactoringName() {
        return REFACTORING_NAME;
    }

    @Override
    public AbstractInplaceIntroducer getInplaceIntroducer() {
        return this.myInplaceIntroduceConstantPopup;
    }

    @Nullable
    private PsiElement isStaticFinalInitializer(PsiExpression expr) {
        PsiClass parentClass;
        PsiClass psiClass = parentClass = expr != null ? this.getParentClass(expr) : null;
        if (parentClass == null) {
            return null;
        }
        IsStaticFinalInitializerExpression visitor = new IsStaticFinalInitializerExpression(parentClass, expr);
        expr.accept((PsiElementVisitor)visitor);
        return visitor.getElementReference();
    }

    @Override
    protected OccurrenceManager createOccurrenceManager(PsiExpression selectedExpr, PsiClass parentClass) {
        return new ExpressionOccurrenceManager(selectedExpr, (PsiElement)parentClass, null);
    }

    @Override
    public PsiClass getParentClass(@NotNull PsiExpression initializerExpression) {
        PsiType type2;
        if (initializerExpression == null) {
            IntroduceConstantHandler.$$$reportNull$$$0(1);
        }
        if ((type2 = initializerExpression.getType()) != null && PsiUtil.isConstantExpression((PsiExpression)initializerExpression) && (type2 instanceof PsiPrimitiveType || PsiType.getJavaLangString((PsiManager)initializerExpression.getManager(), (GlobalSearchScope)initializerExpression.getResolveScope()).equals((Object)type2))) {
            return super.getParentClass(initializerExpression);
        }
        PsiElement parent = (PsiElement)initializerExpression.getUserData(ElementToWorkOn.PARENT);
        if (parent == null) {
            parent = initializerExpression;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class);
        while (aClass != null) {
            if (aClass.hasModifierProperty("static")) {
                return aClass;
            }
            if (aClass.getParent() instanceof PsiJavaFile) {
                return aClass;
            }
            aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
        }
        return null;
    }

    @Override
    protected boolean accept(ElementToWorkOn elementToWorkOn) {
        PsiExpression expr = elementToWorkOn.getExpression();
        if (expr != null) {
            return this.isStaticFinalInitializer(expr) == null;
        }
        PsiLocalVariable localVariable = elementToWorkOn.getLocalVariable();
        PsiExpression initializer = localVariable.getInitializer();
        return initializer != null && this.isStaticFinalInitializer(initializer) == null;
    }

    @Override
    protected boolean validClass(PsiClass parentClass, Editor editor) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializerExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/introduceField/IntroduceConstantHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class IsStaticFinalInitializerExpression
    extends ClassMemberReferencesVisitor {
        private PsiElement myElementReference;
        private final PsiExpression myInitializer;
        private boolean myCheckThrowables = true;

        public IsStaticFinalInitializerExpression(PsiClass aClass, PsiExpression initializer) {
            super(aClass);
            this.myInitializer = initializer;
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            PsiElement psiElement = expression2.resolve();
            if ((psiElement instanceof PsiLocalVariable || psiElement instanceof PsiParameter) && !PsiTreeUtil.isAncestor((PsiElement)this.myInitializer, (PsiElement)psiElement, (boolean)false)) {
                this.myElementReference = expression2;
            } else {
                super.visitReferenceExpression(expression2);
            }
        }

        public void visitCallExpression(PsiCallExpression callExpression) {
            super.visitCallExpression(callExpression);
            if (!this.myCheckThrowables) {
                return;
            }
            List<PsiClassType> checkedExceptions = ExceptionUtil.getThrownCheckedExceptions(new PsiElement[]{callExpression});
            if (!checkedExceptions.isEmpty()) {
                this.myElementReference = callExpression;
            }
        }

        public void visitClass(PsiClass aClass) {
            this.myCheckThrowables = false;
            super.visitClass(aClass);
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
            this.myCheckThrowables = false;
            super.visitLambdaExpression(expression2);
        }

        @Override
        protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
            if (!classMember.hasModifierProperty("static")) {
                this.myElementReference = classMemberReference;
            }
        }

        public void visitElement(PsiElement element) {
            if (this.myElementReference != null) {
                return;
            }
            super.visitElement(element);
        }

        @Nullable
        public PsiElement getElementReference() {
            return this.myElementReference;
        }
    }
}

