/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncrementDecrementUsedAsExpressionInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ValueOfIncrementOrDecrementUsed" == null) {
            IncrementDecrementUsedAsExpressionInspection.$$$reportNull$$$0(0);
        }
        return "ValueOfIncrementOrDecrementUsed";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("increment.decrement.display.name", new Object[0]);
        if (string == null) {
            IncrementDecrementUsedAsExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Object info = infos[0];
        if (info instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)info;
            IElementType tokenType = postfixExpression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.PLUSPLUS)) {
                String string = InspectionGadgetsBundle.message("value.of.post.increment.problem.descriptor", new Object[0]);
                if (string == null) {
                    IncrementDecrementUsedAsExpressionInspection.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("value.of.post.decrement.problem.descriptor", new Object[0]);
            if (string == null) {
                IncrementDecrementUsedAsExpressionInspection.$$$reportNull$$$0(3);
            }
            return string;
        }
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)info;
        IElementType tokenType = prefixExpression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.PLUSPLUS)) {
            String string = InspectionGadgetsBundle.message("value.of.pre.increment.problem.descriptor", new Object[0]);
            if (string == null) {
                IncrementDecrementUsedAsExpressionInspection.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("value.of.pre.decrement.problem.descriptor", new Object[0]);
        if (string == null) {
            IncrementDecrementUsedAsExpressionInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression expression2 = (PsiExpression)infos[0];
        if (PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiMember.class}) == null) {
            return null;
        }
        return new IncrementDecrementUsedAsExpressionFix(expression2.getText());
    }

    public static void extractPrefixPostfixExpressionToSeparateStatement(PsiElement element) {
        SearchScope useScope;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        if (!(element instanceof PsiUnaryExpression)) {
            assert (false);
            return;
        }
        PsiUnaryExpression unaryExpression = (PsiUnaryExpression)element;
        PsiExpression operand2 = unaryExpression.getOperand();
        if (operand2 == null) {
            return;
        }
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        if (statement == null) {
            return;
        }
        PsiElement parent = statement.getParent();
        if (parent == null) {
            return;
        }
        Project project = element.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        String newStatementText = element.getText() + ';';
        String operandText = operand2.getText();
        if (parent instanceof PsiIfStatement || parent instanceof PsiLoopStatement) {
            StringBuilder text2 = new StringBuilder();
            text2.append('{');
            String elementText = PsiReplacementUtil.getElementText((PsiElement)statement, element, operandText);
            if (element instanceof PsiPostfixExpression) {
                text2.append(elementText);
                text2.append(newStatementText);
            } else {
                text2.append(newStatementText);
                text2.append(elementText);
            }
            text2.append('}');
            PsiCodeBlock codeBlock = factory.createCodeBlockFromText(text2.toString(), parent);
            statement.replace((PsiElement)codeBlock);
            return;
        }
        PsiStatement newStatement = factory.createStatementFromText(newStatementText, element);
        if (statement instanceof PsiReturnStatement) {
            if (element instanceof PsiPostfixExpression) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
                PsiExpression returnValue = returnStatement.getReturnValue();
                if (returnValue == null) {
                    return;
                }
                JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                String variableName = javaCodeStyleManager.suggestUniqueVariableName("result", (PsiElement)returnValue, true);
                PsiType type2 = returnValue.getType();
                if (type2 == null) {
                    return;
                }
                String newReturnValueText = PsiReplacementUtil.getElementText((PsiElement)returnValue, element, operandText);
                String declarationStatementText = type2.getCanonicalText() + ' ' + variableName + '=' + newReturnValueText + ';';
                PsiStatement declarationStatement = factory.createStatementFromText(declarationStatementText, (PsiElement)returnStatement);
                parent.addBefore((PsiElement)declarationStatement, (PsiElement)statement);
                parent.addBefore((PsiElement)newStatement, (PsiElement)statement);
                PsiStatement newReturnStatement = factory.createStatementFromText("return " + variableName + ';', (PsiElement)returnStatement);
                returnStatement.replace((PsiElement)newReturnStatement);
                return;
            }
            parent.addBefore((PsiElement)newStatement, (PsiElement)statement);
        } else if (statement instanceof PsiThrowStatement) {
            if (element instanceof PsiPostfixExpression) {
                PsiThrowStatement returnStatement = (PsiThrowStatement)statement;
                PsiExpression exception = returnStatement.getException();
                if (exception == null) {
                    return;
                }
                JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                String variableName = javaCodeStyleManager.suggestUniqueVariableName("e", (PsiElement)exception, true);
                PsiType type3 = exception.getType();
                if (type3 == null) {
                    return;
                }
                String newReturnValueText = PsiReplacementUtil.getElementText((PsiElement)exception, element, operandText);
                String declarationStatementText = type3.getCanonicalText() + ' ' + variableName + '=' + newReturnValueText + ';';
                PsiStatement declarationStatement = factory.createStatementFromText(declarationStatementText, (PsiElement)returnStatement);
                parent.addBefore((PsiElement)declarationStatement, (PsiElement)statement);
                parent.addBefore((PsiElement)newStatement, (PsiElement)statement);
                PsiStatement newReturnStatement = factory.createStatementFromText("throw " + variableName + ';', (PsiElement)returnStatement);
                returnStatement.replace((PsiElement)newReturnStatement);
                return;
            }
            parent.addBefore((PsiElement)newStatement, (PsiElement)statement);
        } else if (!(statement instanceof PsiForStatement)) {
            if (element instanceof PsiPostfixExpression) {
                parent.addAfter((PsiElement)newStatement, (PsiElement)statement);
            } else {
                parent.addBefore((PsiElement)newStatement, (PsiElement)statement);
            }
        } else if (operand2 instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)operand2).resolve()) != null && !new LocalSearchScope((PsiElement)statement).equals((Object)(useScope = target.getUseScope()))) {
            if (element instanceof PsiPostfixExpression) {
                parent.addAfter((PsiElement)newStatement, (PsiElement)statement);
            } else {
                parent.addBefore((PsiElement)newStatement, (PsiElement)statement);
            }
        }
        if (statement instanceof PsiLoopStatement) {
            PsiLoopStatement loopStatement = (PsiLoopStatement)statement;
            PsiStatement body2 = loopStatement.getBody();
            if (body2 instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body2;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                if (element instanceof PsiPostfixExpression) {
                    PsiElement firstElement = codeBlock.getFirstBodyElement();
                    codeBlock.addBefore((PsiElement)newStatement, firstElement);
                } else {
                    codeBlock.add((PsiElement)newStatement);
                }
            } else {
                StringBuilder blockText = new StringBuilder();
                blockText.append('{');
                if (element instanceof PsiPostfixExpression) {
                    blockText.append(newStatementText);
                    if (body2 != null) {
                        blockText.append(body2.getText());
                    }
                } else {
                    if (body2 != null) {
                        blockText.append(body2.getText());
                    }
                    blockText.append(newStatementText);
                }
                blockText.append('}');
                PsiStatement blockStatement = factory.createStatementFromText(blockText.toString(), (PsiElement)statement);
                if (body2 == null) {
                    loopStatement.add((PsiElement)blockStatement);
                } else {
                    body2.replace((PsiElement)blockStatement);
                }
            }
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)element, operandText);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IncrementDecrementUsedAsExpressionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/assignment/IncrementDecrementUsedAsExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class IncrementDecrementUsedAsExpressionVisitor
    extends BaseInspectionVisitor {
        private IncrementDecrementUsedAsExpressionVisitor() {
        }

        public void visitUnaryExpression(@NotNull PsiUnaryExpression expression2) {
            if (expression2 == null) {
                IncrementDecrementUsedAsExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitUnaryExpression(expression2);
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiExpressionStatement || parent instanceof PsiExpressionList && parent.getParent() instanceof PsiExpressionListStatement) {
                return;
            }
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/assignment/IncrementDecrementUsedAsExpressionInspection$IncrementDecrementUsedAsExpressionVisitor", "visitUnaryExpression"));
        }
    }

    private static class IncrementDecrementUsedAsExpressionFix
    extends InspectionGadgetsFix {
        private final String elementText;

        IncrementDecrementUsedAsExpressionFix(String elementText) {
            this.elementText = elementText;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("increment.decrement.used.as.expression.quickfix", this.elementText);
            if (string == null) {
                IncrementDecrementUsedAsExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Extract to separate statement" == null) {
                IncrementDecrementUsedAsExpressionFix.$$$reportNull$$$0(1);
            }
            return "Extract to separate statement";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            IncrementDecrementUsedAsExpressionInspection.extractPrefixPostfixExpressionToSeparateStatement(descriptor.getPsiElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/assignment/IncrementDecrementUsedAsExpressionInspection$IncrementDecrementUsedAsExpressionFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

