/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.naming.AbstractNamingConventionInspection;
import com.intellij.codeInspection.naming.NamingConvention;
import com.intellij.codeInspection.naming.NamingConventionBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.siyeh.ig.fixes.RenameFix;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldNamingConventionInspection
extends AbstractNamingConventionInspection<PsiField> {
    public static final ExtensionPointName<NamingConvention<PsiField>> EP_NAME = ExtensionPointName.create((String)"com.intellij.naming.convention.field");

    public FieldNamingConventionInspection() {
        super(Arrays.asList(EP_NAME.getExtensions()), null);
    }

    @Nullable
    protected LocalQuickFix createRenameFix() {
        return new RenameFix();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FieldNamingConventionInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitField(PsiField field) {
                String name = field.getName();
                if (name != null) {
                    FieldNamingConventionInspection.this.checkName((PsiNameIdentifierOwner)field, name, holder);
                }
            }
        };
        if (javaElementVisitor == null) {
            FieldNamingConventionInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/naming/FieldNamingConventionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/naming/FieldNamingConventionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class FieldNamingConventionBean
    extends NamingConventionBean {
        public FieldNamingConventionBean(String regex, int minLength, int maxLength) {
            super(regex, minLength, maxLength, new String[]{"serialVersionUID"});
        }
    }
}

