/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassUtils {
    private static final Set<String> immutableTypes = new HashSet<String>(19);
    private static final Set<PsiType> primitiveNumericTypes = new HashSet<PsiType>(7);
    private static final Set<PsiType> integralTypes = new HashSet<PsiType>(5);

    private ClassUtils() {
    }

    @Nullable
    public static PsiClass findClass(@NonNls String fqClassName, PsiElement context) {
        return JavaPsiFacade.getInstance((Project)context.getProject()).findClass(fqClassName, context.getResolveScope());
    }

    @Nullable
    public static PsiClass findObjectClass(PsiElement context) {
        return ClassUtils.findClass("java.lang.Object", context);
    }

    public static boolean isPrimitive(PsiType type2) {
        return TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type2);
    }

    public static boolean isIntegral(PsiType type2) {
        return integralTypes.contains(type2);
    }

    public static boolean isImmutable(PsiType type2) {
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type2)) {
            return true;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        if (aClass == null) {
            return false;
        }
        if (immutableTypes.contains(aClass.getQualifiedName())) {
            return true;
        }
        return JCiPUtil.isImmutable(aClass);
    }

    public static boolean inSamePackage(@Nullable PsiElement element1, @Nullable PsiElement element2) {
        if (element1 == null || element2 == null) {
            return false;
        }
        PsiFile containingFile1 = element1.getContainingFile();
        if (!(containingFile1 instanceof PsiClassOwner)) {
            return false;
        }
        PsiClassOwner containingJavaFile1 = (PsiClassOwner)containingFile1;
        String packageName1 = containingJavaFile1.getPackageName();
        PsiFile containingFile2 = element2.getContainingFile();
        if (!(containingFile2 instanceof PsiClassOwner)) {
            return false;
        }
        PsiClassOwner containingJavaFile2 = (PsiClassOwner)containingFile2;
        String packageName2 = containingJavaFile2.getPackageName();
        return packageName1.equals(packageName2);
    }

    public static boolean isFieldVisible(@NotNull PsiField field, PsiClass fromClass) {
        PsiClass fieldClass;
        if (field == null) {
            ClassUtils.$$$reportNull$$$0(0);
        }
        if ((fieldClass = field.getContainingClass()) == null) {
            return false;
        }
        if (fieldClass.equals(fromClass)) {
            return true;
        }
        if (field.hasModifierProperty("private")) {
            return false;
        }
        if (field.hasModifierProperty("public") || field.hasModifierProperty("protected")) {
            return true;
        }
        return ClassUtils.inSamePackage((PsiElement)fieldClass, (PsiElement)fromClass);
    }

    @Contract(value="null -> false")
    public static boolean isPrimitiveNumericType(@Nullable PsiType type2) {
        return primitiveNumericTypes.contains(type2);
    }

    public static boolean isInnerClass(PsiClass aClass) {
        PsiClass parentClass = ClassUtils.getContainingClass((PsiElement)aClass);
        return parentClass != null;
    }

    @Nullable
    public static PsiClass getContainingClass(PsiElement element) {
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
    }

    public static PsiClass getOutermostContainingClass(PsiClass aClass) {
        PsiClass containingClass;
        PsiClass outerClass = aClass;
        while ((containingClass = ClassUtils.getContainingClass((PsiElement)outerClass)) != null) {
            outerClass = containingClass;
        }
        return outerClass;
    }

    @Nullable
    public static PsiClass getContainingStaticClass(PsiElement element) {
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false, (Class[])new Class[]{PsiFile.class});
        while (ClassUtils.isNonStaticClass(aClass)) {
            aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true, (Class[])new Class[]{PsiFile.class});
        }
        return aClass;
    }

    public static boolean isNonStaticClass(@Nullable PsiClass aClass) {
        if (aClass == null) {
            return false;
        }
        if (aClass.hasModifierProperty("static") || aClass.isInterface() || aClass.isEnum()) {
            return false;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return true;
        }
        PsiElement parent = aClass.getParent();
        if (parent == null || parent instanceof PsiFile) {
            return false;
        }
        if (!(parent instanceof PsiClass)) {
            return true;
        }
        PsiClass parentClass = (PsiClass)parent;
        return !parentClass.isInterface();
    }

    @Nullable
    public static PsiClassInitializer getDoubleBraceInitializer(PsiAnonymousClass aClass) {
        PsiClassInitializer[] initializers = aClass.getInitializers();
        if (initializers.length != 1) {
            return null;
        }
        PsiClassInitializer initializer = initializers[0];
        if (initializer.hasModifierProperty("static")) {
            return null;
        }
        if (aClass.getFields().length != 0 || aClass.getMethods().length != 0 || aClass.getInnerClasses().length != 0) {
            return null;
        }
        if (aClass.getBaseClassReference().resolve() == null) {
            return null;
        }
        return initializer;
    }

    public static boolean isFinalClassWithDefaultEquals(@Nullable PsiClass aClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            return false;
        }
        if (!aClass.hasModifierProperty("final") && !ClassUtils.hasOnlyPrivateConstructors(aClass)) {
            return false;
        }
        for (PsiMethod method : methods = aClass.findMethodsByName("equals", true)) {
            PsiClass containingClass;
            if (!MethodUtils.isEquals(method) || (containingClass = method.getContainingClass()) != null && "java.lang.Object".equals(containingClass.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    public static boolean hasOnlyPrivateConstructors(PsiClass aClass) {
        if (aClass == null) {
            return false;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        for (PsiMethod constructor : constructors) {
            if (constructor.hasModifierProperty("private")) continue;
            return false;
        }
        return true;
    }

    public static boolean isSingleton(@Nullable PsiClass aClass) {
        if (aClass == null || aClass.isInterface() || aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
            return false;
        }
        if (aClass.isEnum()) {
            if (!ControlFlowUtils.hasChildrenOfTypeCount((PsiElement)aClass, 1, PsiEnumConstant.class)) {
                return false;
            }
            return Arrays.stream(aClass.getMethods()).anyMatch(m -> !m.isConstructor() && !m.hasModifierProperty("private") && !m.hasModifierProperty("static"));
        }
        if (ClassUtils.getIfOnlyInvisibleConstructors(aClass).length == 0) {
            return false;
        }
        PsiField selfInstance = ClassUtils.getIfOneStaticSelfInstance(aClass);
        return selfInstance != null && ClassUtils.newOnlyAssignsToStaticSelfInstance(ClassUtils.getIfOnlyInvisibleConstructors(aClass)[0], selfInstance);
    }

    private static PsiField getIfOneStaticSelfInstance(PsiClass aClass) {
        Stream<PsiField> fieldStream = Stream.concat(Arrays.stream(aClass.getFields()), Arrays.stream(aClass.getInnerClasses()).filter(innerClass -> innerClass.hasModifierProperty("static")).flatMap(innerClass -> Arrays.stream(innerClass.getFields())));
        List fields = fieldStream.filter(field -> ClassUtils.resolveToSingletonField(aClass, field)).limit(2L).collect(Collectors.toList());
        return fields.size() == 1 ? (PsiField)fields.get(0) : null;
    }

    private static boolean resolveToSingletonField(PsiClass aClass, PsiField field) {
        if (!field.hasModifierProperty("static")) {
            return false;
        }
        PsiClass targetClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)field.getType());
        return aClass.equals(targetClass);
    }

    @NotNull
    private static PsiMethod[] getIfOnlyInvisibleConstructors(PsiClass aClass) {
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                ClassUtils.$$$reportNull$$$0(1);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        for (PsiMethod constructor : constructors) {
            if (constructor.hasModifierProperty("public")) {
                if (PsiMethod.EMPTY_ARRAY == null) {
                    ClassUtils.$$$reportNull$$$0(2);
                }
                return PsiMethod.EMPTY_ARRAY;
            }
            if (constructor.hasModifierProperty("private") || constructor.hasModifierProperty("protected")) continue;
            if (PsiMethod.EMPTY_ARRAY == null) {
                ClassUtils.$$$reportNull$$$0(3);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        if (constructors == null) {
            ClassUtils.$$$reportNull$$$0(4);
        }
        return constructors;
    }

    private static boolean newOnlyAssignsToStaticSelfInstance(PsiMethod method, PsiField field) {
        Query search = MethodReferencesSearch.search((PsiMethod)method, (SearchScope)field.getUseScope(), (boolean)false);
        NewOnlyAssignedToFieldProcessor processor = new NewOnlyAssignedToFieldProcessor(field);
        search.forEach((Processor)processor);
        return processor.isNewOnlyAssignedToField();
    }

    static {
        integralTypes.add((PsiType)PsiType.LONG);
        integralTypes.add((PsiType)PsiType.INT);
        integralTypes.add((PsiType)PsiType.SHORT);
        integralTypes.add((PsiType)PsiType.CHAR);
        integralTypes.add((PsiType)PsiType.BYTE);
        primitiveNumericTypes.add((PsiType)PsiType.BYTE);
        primitiveNumericTypes.add((PsiType)PsiType.CHAR);
        primitiveNumericTypes.add((PsiType)PsiType.SHORT);
        primitiveNumericTypes.add((PsiType)PsiType.INT);
        primitiveNumericTypes.add((PsiType)PsiType.LONG);
        primitiveNumericTypes.add((PsiType)PsiType.FLOAT);
        primitiveNumericTypes.add((PsiType)PsiType.DOUBLE);
        immutableTypes.add("java.lang.Boolean");
        immutableTypes.add("java.lang.Character");
        immutableTypes.add("java.lang.Short");
        immutableTypes.add("java.lang.Integer");
        immutableTypes.add("java.lang.Long");
        immutableTypes.add("java.lang.Float");
        immutableTypes.add("java.lang.Double");
        immutableTypes.add("java.lang.Byte");
        immutableTypes.add("java.lang.String");
        immutableTypes.add("java.awt.Font");
        immutableTypes.add("java.awt.BasicStroke");
        immutableTypes.add("java.awt.Color");
        immutableTypes.add("java.awt.Cursor");
        immutableTypes.add("java.math.BigDecimal");
        immutableTypes.add("java.math.BigInteger");
        immutableTypes.add("java.math.MathContext");
        immutableTypes.add("java.nio.channels.FileLock");
        immutableTypes.add("java.nio.charset.Charset");
        immutableTypes.add("java.io.File");
        immutableTypes.add("java.net.Inet4Address");
        immutableTypes.add("java.net.Inet6Address");
        immutableTypes.add("java.net.InetSocketAddress");
        immutableTypes.add("java.net.URI");
        immutableTypes.add("java.net.URL");
        immutableTypes.add("java.util.Locale");
        immutableTypes.add("java.util.UUID");
        immutableTypes.add("java.util.regex.Pattern");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/ClassUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/ClassUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIfOnlyInvisibleConstructors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFieldVisible";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NewOnlyAssignedToFieldProcessor
    implements Processor<PsiReference> {
        private boolean newOnlyAssignedToField = true;
        private final PsiField field;

        public NewOnlyAssignedToFieldProcessor(PsiField field) {
            this.field = field;
        }

        public boolean process(PsiReference reference) {
            PsiElement element = reference.getElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiNewExpression)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (this.field.equals(grandParent)) {
                return true;
            }
            if (!(grandParent instanceof PsiAssignmentExpression)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)grandParent;
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (!this.field.equals(target)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            return true;
        }

        public boolean isNewOnlyAssignedToField() {
            return this.newOnlyAssignedToField;
        }
    }
}

