/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.redundancy;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class RedundantStringOperationInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    private static final CallMatcher STRING_TO_STRING = CallMatcher.instanceCall("java.lang.String", "toString").parameterCount(0);
    private static final CallMatcher STRING_INTERN = CallMatcher.instanceCall("java.lang.String", "intern").parameterCount(0);
    private static final CallMatcher STRING_LENGTH = CallMatcher.instanceCall("java.lang.String", "length").parameterCount(0);
    private static final CallMatcher STRING_SUBSTRING = CallMatcher.anyOf(CallMatcher.instanceCall("java.lang.String", "substring").parameterTypes("int"), CallMatcher.instanceCall("java.lang.String", "substring").parameterTypes("int", "int"));
    private static final CallMatcher STRING_BUILDER_APPEND = CallMatcher.instanceCall("java.lang.AbstractStringBuilder", "append").parameterTypes("java.lang.String");
    private static final CallMatcher PRINTSTREAM_PRINTLN = CallMatcher.instanceCall("java.io.PrintStream", "println").parameterTypes("java.lang.String");

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantStringOperationInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                if (qualifier != null) {
                    if (STRING_TO_STRING.test(call)) {
                        this.registerProblem(call, "inspection.redundant.string.call.message");
                    } else if (STRING_SUBSTRING.test(call)) {
                        this.processSubstring(call);
                    } else if (STRING_BUILDER_APPEND.test(call)) {
                        if (this.getSingleEmptyStringArgument((PsiCall)call) != null) {
                            this.registerProblem(call, "inspection.redundant.string.call.message");
                        }
                    } else if (STRING_INTERN.test(call) && PsiUtil.isConstantExpression((PsiExpression)qualifier)) {
                        this.registerProblem(call, "inspection.redundant.string.intern.on.constant.message");
                    } else if (PRINTSTREAM_PRINTLN.test(call)) {
                        this.checkUnnecessaryEmptyStringArgument((PsiCall)call);
                    }
                }
            }

            public void visitNewExpression(PsiNewExpression expression2) {
                PsiJavaCodeReferenceElement classRef = expression2.getClassReference();
                if (ConstructionUtils.isReferenceTo(classRef, "java.lang.StringBuilder", "java.lang.StringBuffer")) {
                    this.checkUnnecessaryEmptyStringArgument((PsiCall)expression2);
                }
            }

            private void checkUnnecessaryEmptyStringArgument(PsiCall call) {
                PsiExpression argument = this.getSingleEmptyStringArgument(call);
                if (argument != null) {
                    DeleteElementFix fix = new DeleteElementFix((PsiElement)argument, InspectionGadgetsBundle.message("inspection.redundant.string.remove.argument.fix.name", new Object[0]));
                    holder.registerProblem((PsiElement)argument, InspectionGadgetsBundle.message("inspection.redundant.string.argument.message", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{fix});
                }
            }

            private PsiExpression getSingleEmptyStringArgument(PsiCall call) {
                PsiExpressionList argList = call.getArgumentList();
                if (argList == null) {
                    return null;
                }
                PsiExpression[] args = argList.getExpressions();
                if (args.length != 1) {
                    return null;
                }
                return ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]), "") ? args[0] : null;
            }

            private void processSubstring(PsiMethodCallExpression call) {
                PsiElement parent;
                PsiExpression[] args = call.getArgumentList().getExpressions();
                if (this.isRedundantSubstring(call, args)) {
                    this.registerProblem(call, "inspection.redundant.string.call.message");
                } else if (args.length == 2 && (parent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent())) instanceof PsiExpressionList && ((PsiExpressionList)parent).getExpressionCount() == 1) {
                    PsiMethodCallExpression parentCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class);
                    if (STRING_BUILDER_APPEND.test(parentCall)) {
                        PsiElement nameElement = Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement());
                        holder.registerProblem(nameElement, InspectionGadgetsBundle.message("inspection.redundant.string.call.message", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveRedundantStringCallFix(nameElement.getText(), FixType.REPLACE_WITH_ARGUMENTS)});
                    }
                }
            }

            private boolean isRedundantSubstring(PsiMethodCallExpression call, PsiExpression[] args) {
                if (!ExpressionUtils.isZero(args[0])) {
                    return false;
                }
                if (args.length == 2) {
                    PsiMethodCallExpression argCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)args[1]), PsiMethodCallExpression.class);
                    if (!STRING_LENGTH.test(argCall) || !EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(call.getMethodExpression().getQualifierExpression(), argCall.getMethodExpression().getQualifierExpression())) {
                        return false;
                    }
                }
                return true;
            }

            private void registerProblem(PsiMethodCallExpression call, @NotNull @PropertyKey(resourceBundle="com.siyeh.InspectionGadgetsBundle") String key2) {
                if (key2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                String name = call.getMethodExpression().getReferenceName();
                holder.registerProblem((PsiElement)call, InspectionGadgetsBundle.message(key2, new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, RedundantStringOperationInspection.getRange(call), new LocalQuickFix[]{new RemoveRedundantStringCallFix(name, FixType.REPLACE_WITH_QUALIFIER)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/siyeh/ig/redundancy/RedundantStringOperationInspection$1", "registerProblem"));
            }
        };
        if (javaElementVisitor == null) {
            RedundantStringOperationInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    @NotNull
    private static TextRange getRange(PsiMethodCallExpression call) {
        PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
        if (nameElement != null) {
            TextRange callRange = call.getTextRange();
            TextRange textRange = new TextRange(nameElement.getTextRange().getStartOffset(), callRange.getEndOffset()).shiftLeft(callRange.getStartOffset());
            if (textRange == null) {
                RedundantStringOperationInspection.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        TextRange textRange = call.getTextRange();
        if (textRange == null) {
            RedundantStringOperationInspection.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/redundancy/RedundantStringOperationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/redundancy/RedundantStringOperationInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveRedundantStringCallFix
    implements LocalQuickFix {
        private final FixType myFixType;
        private final String myToRemove;

        public RemoveRedundantStringCallFix(String toRemove, FixType fixType) {
            this.myToRemove = toRemove;
            this.myFixType = fixType;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("inspection.redundant.string.remove.fix.name", this.myToRemove);
            if (string == null) {
                RemoveRedundantStringCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inspection.redundant.string.fix.family.name", new Object[0]);
            if (string == null) {
                RemoveRedundantStringCallFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression call;
            if (project == null) {
                RemoveRedundantStringCallFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RemoveRedundantStringCallFix.$$$reportNull$$$0(3);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)descriptor.getStartElement(), (Class[])new Class[]{PsiMethodCallExpression.class})) == null) {
                return;
            }
            PsiExpression qualifier = ExpressionUtils.getQualifierOrThis(call.getMethodExpression());
            CommentTracker ct = new CommentTracker();
            switch (this.myFixType) {
                case REPLACE_WITH_QUALIFIER: {
                    PsiExpression result = (PsiExpression)ct.replaceAndRestoreComments((PsiElement)call, (PsiElement)ct.markUnchanged(qualifier));
                    if (!(result.getParent() instanceof PsiExpressionStatement)) break;
                    RemoveRedundantStringCallFix.extractSideEffects(result, (PsiStatement)((PsiExpressionStatement)result.getParent()));
                    break;
                }
                case REPLACE_WITH_ARGUMENTS: {
                    PsiExpressionList list = (PsiExpressionList)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiExpressionList.class);
                    if (list == null) {
                        return;
                    }
                    for (PsiExpression arg : call.getArgumentList().getExpressions()) {
                        list.add((PsiElement)ct.markUnchanged(arg));
                    }
                    ct.replaceAndRestoreComments((PsiElement)call, (PsiElement)ct.markUnchanged(qualifier));
                }
            }
        }

        private static void extractSideEffects(PsiExpression result, PsiStatement statement) {
            List<PsiExpression> sideEffects = SideEffectChecker.extractSideEffectExpressions(result);
            if (Collections.singletonList(result).equals(sideEffects)) {
                return;
            }
            PsiStatement[] statements = StatementExtractor.generateStatements(sideEffects, result);
            if (statements.length > 0) {
                PsiStatement lastAdded = BlockUtils.addBefore(statement, statements);
                statement = (PsiStatement)Objects.requireNonNull(PsiTreeUtil.getNextSiblingOfType((PsiElement)lastAdded, PsiStatement.class));
            }
            statement.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/redundancy/RedundantStringOperationInspection$RemoveRedundantStringCallFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/redundancy/RedundantStringOperationInspection$RemoveRedundantStringCallFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static enum FixType {
        REPLACE_WITH_QUALIFIER,
        REPLACE_WITH_ARGUMENTS;

    }
}

