/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.serialization.SerializableInspectionBase;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NonSerializableFieldInSerializableClassInspectionBase
extends SerializableInspectionBase {
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet(new String[0]);

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.serializable.field.in.serializable.class.display.name", new Object[0]);
        if (string == null) {
            NonSerializableFieldInSerializableClassInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.serializable.field.in.serializable.class.problem.descriptor", new Object[0]);
        if (string == null) {
            NonSerializableFieldInSerializableClassInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        InspectionGadgetsFix[] inspectionGadgetsFixArray = AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)field, (List<String>)((Object)this.ignorableAnnotations));
        if (inspectionGadgetsFixArray == null) {
            NonSerializableFieldInSerializableClassInspectionBase.$$$reportNull$$$0(2);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonSerializableFieldInSerializableClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/serialization/NonSerializableFieldInSerializableClassInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NonSerializableFieldInSerializableClassVisitor
    extends BaseInspectionVisitor {
        private NonSerializableFieldInSerializableClassVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                NonSerializableFieldInSerializableClassVisitor.$$$reportNull$$$0(0);
            }
            if (field.hasModifierProperty("transient") || field.hasModifierProperty("static")) {
                return;
            }
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (NonSerializableFieldInSerializableClassInspectionBase.this.ignoreAnonymousInnerClasses && aClass instanceof PsiAnonymousClass) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            if (SerializationUtils.isProbablySerializable(field.getType())) {
                return;
            }
            boolean hasWriteObject = SerializationUtils.hasWriteObject(aClass);
            if (hasWriteObject) {
                return;
            }
            if (NonSerializableFieldInSerializableClassInspectionBase.this.isIgnoredSubclass(aClass)) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)field, (Collection)((Object)NonSerializableFieldInSerializableClassInspectionBase.this.ignorableAnnotations), (int)0)) {
                return;
            }
            this.registerFieldError(field, field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/serialization/NonSerializableFieldInSerializableClassInspectionBase$NonSerializableFieldInSerializableClassVisitor", "visitField"));
        }
    }
}

