/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.asserttoif;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ObjectsRequireNonNullIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        NullCheckedAssignmentPredicate nullCheckedAssignmentPredicate = new NullCheckedAssignmentPredicate();
        if (nullCheckedAssignmentPredicate == null) {
            ObjectsRequireNonNullIntention.$$$reportNull$$$0(0);
        }
        return nullCheckedAssignmentPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            ObjectsRequireNonNullIntention.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiVariable)) {
            return;
        }
        PsiVariable variable = (PsiVariable)target;
        List notNulls = NullableNotNullManager.getInstance((Project)element.getProject()).getNotNulls();
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)variable, (Collection)notNulls);
        CommentTracker commentTracker = new CommentTracker();
        if (annotation == null) {
            PsiStatement referenceStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiStatement.class);
            if (referenceStatement == null) {
                return;
            }
            PsiElement parent = referenceStatement.getParent();
            if (!(parent instanceof PsiCodeBlock)) {
                return;
            }
            PsiCodeBlock codeBlock = (PsiCodeBlock)parent;
            PsiStatement[] statements = codeBlock.getStatements();
            PsiStatement statementToDelete = null;
            for (PsiStatement statement : statements) {
                if (statement == referenceStatement) break;
                if (!NullCheckedAssignmentPredicate.isNotNullAssertion(statement, variable) && !NullCheckedAssignmentPredicate.isIfStatementNullCheck(statement, variable)) continue;
                statementToDelete = statement;
                break;
            }
            if (statementToDelete == null) {
                return;
            }
            commentTracker.delete((PsiElement)statementToDelete);
        }
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)referenceExpression, "java.util.Objects.requireNonNull(" + commentTracker.text((PsiElement)referenceExpression) + ")", commentTracker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/asserttoif/ObjectsRequireNonNullIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/asserttoif/ObjectsRequireNonNullIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NullCheckedAssignmentPredicate
    implements PsiElementPredicate {
        private NullCheckedAssignmentPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            PsiStatement[] statements;
            PsiElement parent;
            if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)element)) {
                return false;
            }
            if (!(element instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            if (PsiUtil.isAccessedForWriting((PsiExpression)referenceExpression)) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)target;
            if (ClassUtils.findClass("java.util.Objects", element) == null) {
                return false;
            }
            PsiAnnotation annotation = NullableNotNullManager.getInstance((Project)variable.getProject()).getNotNullAnnotation((PsiModifierListOwner)variable, true);
            if (annotation != null && !AnnotationUtil.isExternalAnnotation((PsiAnnotation)annotation) && !AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation)) {
                return true;
            }
            PsiStatement referenceStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiStatement.class);
            PsiElement psiElement = parent = referenceStatement != null ? referenceStatement.getParent() : null;
            if (!(parent instanceof PsiCodeBlock)) {
                return false;
            }
            PsiCodeBlock codeBlock = (PsiCodeBlock)parent;
            for (PsiStatement statement : statements = codeBlock.getStatements()) {
                if (statement == referenceStatement) {
                    return false;
                }
                if (!NullCheckedAssignmentPredicate.isNotNullAssertion(statement, variable) && !NullCheckedAssignmentPredicate.isIfStatementNullCheck(statement, variable)) continue;
                return true;
            }
            return false;
        }

        static boolean isIfStatementNullCheck(PsiStatement statement, @NotNull PsiVariable variable) {
            if (variable == null) {
                NullCheckedAssignmentPredicate.$$$reportNull$$$0(0);
            }
            if (!(statement instanceof PsiIfStatement)) {
                return false;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch != null) {
                return false;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (!NullCheckedAssignmentPredicate.isSimpleThrowStatement(thenBranch)) {
                return false;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            return ComparisonUtils.isNullComparison(condition2, variable, true);
        }

        static boolean isNotNullAssertion(PsiStatement statement, @NotNull PsiVariable variable) {
            if (variable == null) {
                NullCheckedAssignmentPredicate.$$$reportNull$$$0(1);
            }
            if (!(statement instanceof PsiAssertStatement)) {
                return false;
            }
            PsiAssertStatement assertStatement = (PsiAssertStatement)statement;
            PsiExpression condition2 = assertStatement.getAssertCondition();
            return ComparisonUtils.isNullComparison(condition2, variable, false);
        }

        public static boolean isSimpleThrowStatement(PsiStatement element) {
            if (element instanceof PsiThrowStatement) {
                return true;
            }
            if (element instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)element;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length != 1) {
                    return false;
                }
                PsiStatement statement = statements[0];
                return NullCheckedAssignmentPredicate.isSimpleThrowStatement(statement);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "variable";
            objectArray2[1] = "com/siyeh/ipp/asserttoif/ObjectsRequireNonNullIntention$NullCheckedAssignmentPredicate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isIfStatementNullCheck";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isNotNullAssertion";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

