/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.BuildConsoleView;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.ExecutionNode;
import com.intellij.build.ExecutionNodeProgressAnimator;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.FileMessageEvent;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.FinishEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.ProgressBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.StartEvent;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildTreeConsoleView
implements ConsoleView,
DataProvider,
BuildConsoleView {
    private static final Logger n = Logger.getInstance(BuildTreeConsoleView.class);
    @NonNls
    private static final String e = "tree";
    private final JPanel l = new JPanel();
    private final SimpleTreeBuilder i;
    private final Map<Object, ExecutionNode> m = ContainerUtil.newConcurrentMap();
    private final ExecutionNodeProgressAnimator a;
    private final Project k;
    private final SimpleTreeStructure g;
    private final DetailsHandler d;
    private final TableColumn j;
    private final String c;
    private volatile int b;
    private final AtomicBoolean h = new AtomicBoolean();
    private final TransferToEDTQueue<Runnable> f = TransferToEDTQueue.createRunnableMerger((String)"BuildTreeConsoleView later invocator");

    public BuildTreeConsoleView(Project project2, BuildDescriptor buildDescriptor) {
        this.k = project2;
        this.c = FileUtil.toSystemIndependentName((String)buildDescriptor.getWorkingDir());
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new TreeColumnInfo("name"), new ColumnInfo("time elapsed"){

            @Nullable
            public Object valueOf(Object object) {
                Object object2;
                if (object instanceof DefaultMutableTreeNode && (object2 = ((DefaultMutableTreeNode)object).getUserObject()) instanceof ExecutionNode) {
                    String string = ((ExecutionNode)((Object)object2)).getDuration();
                    BuildTreeConsoleView.this.a("___" + string, false);
                    return string;
                }
                return null;
            }
        }};
        ExecutionNode executionNode = new ExecutionNode(this.k, null);
        executionNode.setAutoExpandNode(true);
        ListTreeTableModelOnColumns listTreeTableModelOnColumns = new ListTreeTableModelOnColumns((TreeNode)new DefaultMutableTreeNode((Object)executionNode), columnInfoArray);
        final DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
                this.setHorizontalAlignment(4);
                Color color = bl2 ? UIUtil.getTreeSelectionForeground() : SimpleTextAttributes.GRAY_ATTRIBUTES.getFgColor();
                this.setForeground(color);
                return this;
            }
        };
        final TreeTable treeTable = new TreeTable((TreeTableModel)listTreeTableModelOnColumns){

            public TableCellRenderer getCellRenderer(int n2, int n3) {
                if (n3 == 1) {
                    return defaultTableCellRenderer;
                }
                return super.getCellRenderer(n2, n3);
            }
        };
        EditSourceOnDoubleClickHandler.install((TreeTable)treeTable);
        EditSourceOnEnterKeyHandler.install((JComponent)treeTable, null);
        TreeTableTree treeTableTree = treeTable.getTree();
        final TreeCellRenderer treeCellRenderer = treeTableTree.getCellRenderer();
        treeTableTree.setCellRenderer(new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
                Component component = treeCellRenderer.getTreeCellRendererComponent(jTree, object, bl2, bl3, bl4, n2, bl5);
                if (component instanceof SimpleColoredComponent) {
                    Color color;
                    Color color2 = bl2 ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
                    Color color3 = color = bl2 ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeForeground();
                    if (bl2) {
                        SimpleColoredComponent.ColoredIterator coloredIterator = ((SimpleColoredComponent)component).iterator();
                        while (coloredIterator.hasNext()) {
                            coloredIterator.next();
                            int n3 = coloredIterator.getOffset();
                            int n4 = coloredIterator.getEndOffset();
                            SimpleTextAttributes simpleTextAttributes = coloredIterator.getTextAttributes();
                            SimpleTextAttributes simpleTextAttributes2 = new SimpleTextAttributes(color2, color, simpleTextAttributes.getWaveColor(), simpleTextAttributes.getStyle());
                            coloredIterator.split(n4 - n3, simpleTextAttributes2);
                        }
                    }
                    SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)treeTable, (SimpleColoredComponent)((SimpleColoredComponent)component), (boolean)true, (boolean)bl2);
                }
                return component;
            }
        });
        new TreeTableSpeedSearch(treeTable).setComparator(new SpeedSearchComparator(false));
        treeTable.setTableHeader(null);
        this.j = treeTable.getColumnModel().getColumn(1);
        this.j.setResizable(false);
        this.a("Running for " + StringUtil.formatDuration((long)11111L), true);
        TreeUtil.installActions((JTree)treeTableTree);
        this.g = new SimpleTreeStructure.Impl((SimpleNode)executionNode);
        this.i = new SimpleTreeBuilder((JTree)treeTableTree, (DefaultTreeModel)listTreeTableModelOnColumns, (AbstractTreeStructure)this.g, null);
        Disposer.register((Disposable)this, (Disposable)this.i);
        this.i.initRootNode();
        this.i.updateFromRoot();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new CardLayout());
        jPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)treeTable, (int)1), e);
        this.l.setLayout(new BorderLayout());
        ThreeComponentsSplitter threeComponentsSplitter = new ThreeComponentsSplitter(){

            public void doLayout() {
                super.doLayout();
                JComponent jComponent = BuildTreeConsoleView.this.d.getComponent();
                if (jComponent != null && jComponent.isVisible()) {
                    int n2 = this.getFirstSize();
                    int n3 = this.getLastSize();
                    if (n2 == 0 && n3 == 0) {
                        int n4 = Math.round((float)this.getWidth() / 2.0f);
                        this.setFirstSize(n4);
                    }
                }
            }
        };
        Disposer.register((Disposable)this, (Disposable)threeComponentsSplitter);
        threeComponentsSplitter.setFirstComponent((JComponent)jPanel);
        this.d = new DetailsHandler(this.k, treeTableTree, threeComponentsSplitter);
        threeComponentsSplitter.setLastComponent(this.d.getComponent());
        this.l.add((Component)threeComponentsSplitter, "Center");
        this.a = new ExecutionNodeProgressAnimator(this);
    }

    private ExecutionNode b() {
        return (ExecutionNode)((Object)this.g.getRootElement());
    }

    public void print(@NotNull String string, @NotNull ConsoleViewContentType consoleViewContentType) {
        if (string == null) {
            BuildTreeConsoleView.c(0);
        }
        if (consoleViewContentType == null) {
            BuildTreeConsoleView.c(1);
        }
    }

    public void clear() {
        this.b().removeChildren();
        this.m.clear();
        this.d.clear();
        this.i.queueUpdate();
    }

    public void scrollTo(int n2) {
    }

    public void attachToProcess(ProcessHandler processHandler) {
    }

    public void setOutputPaused(boolean bl2) {
    }

    public boolean isOutputPaused() {
        return false;
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable) {
        if (runnable == null) {
            BuildTreeConsoleView.c(2);
        }
    }

    public void setHelpId(@NotNull String string) {
        if (string == null) {
            BuildTreeConsoleView.c(3);
        }
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            BuildTreeConsoleView.c(4);
        }
    }

    public void printHyperlink(@NotNull String string, @Nullable HyperlinkInfo hyperlinkInfo) {
        if (string == null) {
            BuildTreeConsoleView.c(5);
        }
    }

    public int getContentSize() {
        return 0;
    }

    public boolean canPause() {
        return false;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            BuildTreeConsoleView.c(6);
        }
        return AnAction.EMPTY_ARRAY;
    }

    public void allowHeavyFilters() {
    }

    public JComponent getComponent() {
        return this.l;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.i.getTree();
    }

    public void dispose() {
        this.h.set(true);
    }

    public boolean isDisposed() {
        return this.h.get();
    }

    @Override
    public void onEvent(BuildEvent buildEvent) {
        Object object;
        Object object2;
        ExecutionNode executionNode = buildEvent.getParentId() == null ? null : this.m.get(buildEvent.getParentId());
        ExecutionNode executionNode2 = this.m.get(buildEvent.getId());
        if (buildEvent instanceof StartEvent || buildEvent instanceof MessageEvent) {
            ExecutionNode executionNode3 = this.b();
            if (executionNode2 == null) {
                if (buildEvent instanceof StartBuildEvent) {
                    executionNode2 = executionNode3;
                } else {
                    if (buildEvent instanceof MessageEvent) {
                        object2 = (MessageEvent)buildEvent;
                        executionNode = this.a((MessageEvent)object2, executionNode);
                    }
                    executionNode2 = new ExecutionNode(this.k, executionNode);
                }
            } else {
                n.warn("start event id collision found");
                return;
            }
            executionNode2.setAutoExpandNode(executionNode2 == executionNode3 || executionNode == executionNode3);
            this.m.put(buildEvent.getId(), executionNode2);
            if (executionNode != null) {
                executionNode.add(executionNode2);
            }
            if (buildEvent instanceof StartBuildEvent) {
                object2 = ((StartBuildEvent)buildEvent).getBuildTitle();
                executionNode2.setTitle((String)object2);
                executionNode2.setAutoExpandNode(true);
                this.a.startMovie();
            } else if (buildEvent instanceof MessageEvent) {
                object2 = (MessageEvent)buildEvent;
                executionNode2.setStartTime(object2.getEventTime());
                executionNode2.setEndTime(object2.getEventTime());
                executionNode2.setNavigatable(object2.getNavigatable(this.k));
                object = object2.getResult();
                executionNode2.setResult((EventResult)object);
            }
        } else {
            executionNode2 = this.m.get(buildEvent.getId());
            if (executionNode2 == null && buildEvent instanceof ProgressBuildEvent) {
                executionNode2 = new ExecutionNode(this.k, executionNode);
                this.m.put(buildEvent.getId(), executionNode2);
                if (executionNode != null) {
                    executionNode.add(executionNode2);
                }
            }
        }
        if (executionNode2 == null) {
            return;
        }
        executionNode2.setName(buildEvent.getMessage());
        executionNode2.setHint(buildEvent.getHint());
        if (executionNode2.getStartTime() == 0L) {
            executionNode2.setStartTime(buildEvent.getEventTime());
        }
        if (buildEvent instanceof FinishEvent) {
            executionNode2.setEndTime(buildEvent.getEventTime());
            executionNode2.setResult(((FinishEvent)buildEvent).getResult());
            int n2 = new JLabel((String)new StringBuilder().append((String)"__").append((String)executionNode2.getDuration()).toString(), (int)4).getPreferredSize().width;
            if (this.b < n2) {
                this.b = n2;
            }
        } else {
            this.scheduleUpdate(executionNode2);
            if (buildEvent instanceof StartEvent) {
                this.a.addNode(executionNode2);
            }
        }
        if (buildEvent instanceof FinishBuildEvent) {
            String string = buildEvent.getHint();
            object2 = DateFormatUtil.formatDateTime((long)buildEvent.getEventTime());
            string = string == null ? "  at " + (String)object2 : string + "  at " + (String)object2;
            executionNode2.setHint(string);
            this.b(this.b);
            if (this.d.a == null) {
                this.d.setNode(this.b());
            }
            if (((FinishBuildEvent)buildEvent).getResult() instanceof FailureResult && (object = this.i.getTree()) != null && !((JTree)object).isRootVisible()) {
                ExecutionNode executionNode4 = this.b();
                ExecutionNode executionNode5 = new ExecutionNode(this.k, executionNode4);
                executionNode5.setName(StringUtil.toTitleCase((String)executionNode4.getName()));
                executionNode5.setHint(executionNode4.getHint());
                executionNode5.setEndTime(executionNode4.getEndTime());
                executionNode5.setStartTime(executionNode4.getStartTime());
                executionNode5.setResult(executionNode4.getResult());
                executionNode5.setTooltip(executionNode4.getTooltip());
                executionNode4.add(executionNode5);
                this.scheduleUpdate(executionNode5);
            }
            this.a.stopMovie();
            this.i.updateFromRoot();
        }
    }

    void scheduleUpdate(ExecutionNode executionNode) {
        ExecutionNode executionNode2 = executionNode.getParent() == null ? executionNode : executionNode.getParent();
        Update update = new Update((Object)executionNode2, (SimpleNode)executionNode2){
            final /* synthetic */ SimpleNode val$node;
            {
                this.val$node = simpleNode;
                super(object);
            }

            public void run() {
                BuildTreeConsoleView.this.i.queueUpdateFrom((Object)this.val$node, false, true);
            }
        };
        this.f.offerIfAbsent((Object)update);
    }

    private ExecutionNode a(MessageEvent messageEvent, ExecutionNode executionNode) {
        ExecutionNode executionNode2;
        Object object = messageEvent.getParentId();
        if (object == null) {
            return null;
        }
        String string = messageEvent.getGroup();
        String string2 = string.hashCode() + object.toString();
        ExecutionNode executionNode3 = BuildTreeConsoleView.a(messageEvent, string2, executionNode, null, string, true, null, null, this.m, this.k);
        EventResult eventResult = executionNode3.getResult();
        final MessageEvent.Kind kind = messageEvent.getKind();
        if (!(eventResult instanceof MessageEventResult) || ((MessageEventResult)eventResult).getKind().compareTo(kind) > 0) {
            executionNode3.setResult(new MessageEventResult(){

                @Override
                public MessageEvent.Kind getKind() {
                    return kind;
                }
            });
        }
        if (messageEvent instanceof FileMessageEvent) {
            String string3;
            Object object2;
            String string4;
            executionNode2 = executionNode3;
            FilePosition filePosition = ((FileMessageEvent)messageEvent).getFilePosition();
            String string5 = FileUtil.toSystemIndependentName((String)filePosition.getFile().getPath());
            String string6 = "";
            String string7 = FileUtil.getRelativePath((String)this.c, (String)string5, (char)'/');
            if (string7 != null) {
                string4 = string.hashCode() + this.c;
                object2 = BuildTreeConsoleView.a(messageEvent, string4, executionNode3, this.c, null, false, () -> AllIcons.Nodes.Module, null, this.m, this.k);
                string6 = this.c;
                executionNode2 = object2;
            }
            if ((object2 = VfsUtil.findFileByIoFile((File)new File(string5), (boolean)false)) != null && (string4 = ProjectFileIndex.SERVICE.getInstance((Project)this.k).getSourceRootForFile(object2)) != null && (string7 = FileUtil.getRelativePath((String)string6, (String)string4.getPath(), (char)'/')) != null) {
                string6 = string6 + "/" + string7;
                string3 = string.hashCode() + string4.getPath();
                executionNode2 = BuildTreeConsoleView.a(messageEvent, string3, executionNode2, string7, null, false, () -> this.a((VirtualFile)object2), null, this.m, this.k);
            }
            string3 = string.hashCode() + string5;
            string7 = StringUtil.isEmpty((String)string6) ? string5 : FileUtil.getRelativePath((String)string6, (String)string5, (char)'/');
            executionNode = BuildTreeConsoleView.a(messageEvent, string3, executionNode2, string7, null, false, () -> {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)filePosition.getFile(), (boolean)false);
                if (virtualFile != null) {
                    return virtualFile.getFileType().getIcon();
                }
                return null;
            }, messageEvent.getNavigatable(this.k), this.m, this.k);
        } else {
            executionNode = executionNode3;
        }
        if (kind == MessageEvent.Kind.ERROR || kind == MessageEvent.Kind.WARNING) {
            executionNode2 = executionNode;
            do {
                executionNode2.reportChildMessageKind(kind);
            } while ((executionNode2 = executionNode2.getParent()) instanceof ExecutionNode);
        }
        return executionNode;
    }

    @NotNull
    private static ExecutionNode a(MessageEvent messageEvent, String string, ExecutionNode executionNode, String string2, String string3, boolean bl2, @Nullable Supplier<Icon> supplier, @Nullable Navigatable navigatable, Map<Object, ExecutionNode> map, Project project2) {
        ExecutionNode executionNode2 = map.get(string);
        if (executionNode2 == null) {
            executionNode2 = new ExecutionNode(project2, executionNode);
            executionNode2.setName(string2);
            executionNode2.setTitle(string3);
            if (bl2) {
                executionNode2.setAutoExpandNode(true);
            }
            executionNode2.setStartTime(messageEvent.getEventTime());
            executionNode2.setEndTime(messageEvent.getEventTime());
            if (supplier != null) {
                executionNode2.setIconProvider(supplier);
            }
            if (navigatable != null) {
                executionNode2.setNavigatable(navigatable);
            }
            executionNode.add(executionNode2);
            map.put(string, executionNode2);
        }
        ExecutionNode executionNode3 = executionNode2;
        if (executionNode3 == null) {
            BuildTreeConsoleView.c(7);
        }
        return executionNode3;
    }

    public void hideRootNode() {
        UIUtil.invokeLaterIfNeeded(() -> {
            JTree jTree = this.i.getTree();
            if (jTree != null) {
                jTree.setRootVisible(false);
                jTree.setShowsRootHandles(true);
            }
        });
    }

    private void a(String string, boolean bl2) {
        int n2 = new JLabel((String)string, (int)4).getPreferredSize().width;
        if (this.b > n2) {
            n2 = this.b;
        }
        if (bl2 || this.j.getMaxWidth() < n2 || this.j.getWidth() < n2) {
            this.b(n2);
        }
    }

    private void b(int n2) {
        this.j.setPreferredWidth(n2);
        this.j.setMinWidth(n2);
        this.j.setMaxWidth(n2);
    }

    @Nullable
    public Object getData(String string) {
        if (PlatformDataKeys.HELP_ID.is(string)) {
            return "reference.build.tool.window";
        }
        if (CommonDataKeys.PROJECT.is(string)) {
            return this.k;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(string)) {
            return this.c();
        }
        return null;
    }

    private Object c() {
        ArrayList<Navigatable> arrayList = new ArrayList<Navigatable>();
        for (ExecutionNode executionNode : this.a()) {
            List<Navigatable> list2 = executionNode.getNavigatables();
            arrayList.addAll(list2);
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new Navigatable[0]);
    }

    private ExecutionNode[] a() {
        JTree jTree = this.i.getTree();
        if (jTree instanceof Tree) {
            DefaultMutableTreeNode[] defaultMutableTreeNodeArray = (DefaultMutableTreeNode[])((Tree)jTree).getSelectedNodes(DefaultMutableTreeNode.class, null);
            return (ExecutionNode[])Arrays.stream(defaultMutableTreeNodeArray).map(DefaultMutableTreeNode::getUserObject).filter(object -> object instanceof ExecutionNode).map(ExecutionNode.class::cast).distinct().toArray(ExecutionNode[]::new);
        }
        return new ExecutionNode[0];
    }

    private /* synthetic */ Icon a(VirtualFile virtualFile) {
        return ProjectFileIndex.SERVICE.getInstance((Project)this.k).isInTestSourceContent(virtualFile) ? AllIcons.Modules.TestRoot : AllIcons.Modules.SourceRoot;
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/BuildTreeConsoleView";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/BuildTreeConsoleView";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateMessagesNode";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DetailsHandler {
        private final ThreeComponentsSplitter d;
        @Nullable
        private ExecutionNode a;
        private final ConsoleView c;
        private final JPanel b;

        public DetailsHandler(Project project2, TreeTableTree treeTableTree, ThreeComponentsSplitter threeComponentsSplitter) {
            this.c = TextConsoleBuilderFactory.getInstance().createBuilder(project2).getConsole();
            this.d = threeComponentsSplitter;
            this.b = new JPanel(new BorderLayout());
            JComponent jComponent = this.c.getComponent();
            AnAction[] anActionArray = this.c.createConsoleActions();
            jComponent.setFocusable(true);
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
            jComponent.setBorder(new CompoundBorder(IdeBorderFactory.createBorder((int)4), (Border)new SideBorder(color, 1)));
            this.b.add((Component)jComponent, "Center");
            ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("BuildResults", (ActionGroup)new DefaultActionGroup(anActionArray), false);
            this.b.add((Component)actionToolbar.getComponent(), "East");
            this.b.setVisible(false);
            treeTableTree.addTreeSelectionListener(treeSelectionEvent -> {
                TreePath treePath = treeSelectionEvent.getPath();
                if (treePath == null || !treeSelectionEvent.isAddedPath()) {
                    return;
                }
                TreePath treePath2 = treeTableTree.getSelectionPath();
                this.setNode(treePath2 != null ? (DefaultMutableTreeNode)treePath2.getLastPathComponent() : null);
            });
            Disposer.register((Disposable)threeComponentsSplitter, (Disposable)this.c);
        }

        public boolean setNode(@NotNull ExecutionNode executionNode) {
            Object object;
            if (executionNode == null) {
                DetailsHandler.a(0);
            }
            EventResult eventResult = executionNode.getResult();
            boolean bl2 = false;
            if (eventResult instanceof FailureResult) {
                this.c.clear();
                object = ((FailureResult)eventResult).getFailures();
                if (object.isEmpty()) {
                    return false;
                }
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Failure failure = (Failure)iterator.next();
                    String string = (String)ObjectUtils.chooseNotNull((Object)failure.getDescription(), (Object)failure.getMessage());
                    if (string == null && failure.getError() != null) {
                        string = failure.getError().getMessage();
                    }
                    if (string == null) continue;
                    this.a(failure, string);
                    bl2 = true;
                    if (!iterator.hasNext()) continue;
                    this.c.print("\n\n", ConsoleViewContentType.NORMAL_OUTPUT);
                }
            } else if (eventResult instanceof MessageEventResult) {
                object = ((MessageEventResult)eventResult).getDetails();
                if (object == null) {
                    return false;
                }
                if (((String)object).isEmpty()) {
                    return false;
                }
                this.c.clear();
                this.a(null, (String)object);
                bl2 = true;
            }
            if (!bl2) {
                return false;
            }
            this.c.scrollTo(0);
            int n2 = this.d.getFirstSize();
            int n3 = this.d.getLastSize();
            if (n2 == 0 && n3 == 0) {
                int n4 = Math.round((float)this.d.getWidth() / 2.0f);
                this.d.setFirstSize(n4);
            }
            this.b.setVisible(true);
            return true;
        }

        private boolean a(Failure failure, @Nullable String string) {
            return BuildConsoleUtils.printDetails(this.c, failure, string);
        }

        public void setNode(@Nullable DefaultMutableTreeNode defaultMutableTreeNode) {
            if (defaultMutableTreeNode == null || defaultMutableTreeNode.getUserObject() == this.a) {
                return;
            }
            if (defaultMutableTreeNode.getUserObject() instanceof ExecutionNode) {
                this.a = (ExecutionNode)((Object)defaultMutableTreeNode.getUserObject());
                if (this.setNode((ExecutionNode)((Object)defaultMutableTreeNode.getUserObject()))) {
                    return;
                }
            }
            this.a = null;
            this.b.setVisible(false);
        }

        public JComponent getComponent() {
            return this.b;
        }

        public void clear() {
            this.b.setVisible(false);
            this.c.clear();
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/build/BuildTreeConsoleView$DetailsHandler", "setNode"));
        }
    }
}

