/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class CompositeView<T extends ComponentContainer>
extends JPanel
implements ComponentContainer,
DataProvider {
    private final Map<String, T> b = ContainerUtil.newConcurrentMap();
    private final String a;
    private final AtomicReference<String> c = new AtomicReference();
    @NotNull
    private final SwitchViewAction d;

    public CompositeView(String string) {
        super(new CardLayout());
        this.a = string;
        this.d = new SwitchViewAction();
    }

    public void addView(T t2, String string, boolean bl2) {
        T t3 = this.getView(string);
        if (t3 != null) {
            this.remove(t3.getComponent());
            Disposer.dispose(t3);
        }
        this.b.put(string, t2);
        this.add((Component)t2.getComponent(), string);
        String string2 = this.a();
        if (string2 != null && string2.equals(string) || string2 == null && bl2) {
            this.enableView(string);
            this.a(string);
        }
        Disposer.register((Disposable)this, t2);
    }

    public void enableView(@NotNull String string) {
        if (string == null) {
            CompositeView.a(0);
        }
        if (!StringUtil.equals((CharSequence)string, (CharSequence)this.c.get())) {
            this.c.set(string);
            CardLayout cardLayout = (CardLayout)this.getLayout();
            cardLayout.show(this, string);
        }
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
            T t2;
            if (string == null) {
                CompositeView.a(6);
            }
            if ((t2 = this.getView(string)) != null) {
                IdeFocusManager.getGlobalInstance().requestFocus((Component)t2.getPreferredFocusableComponent(), true);
            }
        });
    }

    public boolean isViewEnabled(String string) {
        return StringUtil.equals((CharSequence)this.c.get(), (CharSequence)string);
    }

    public T getView(@NotNull String string) {
        if (string == null) {
            CompositeView.a(1);
        }
        return (T)((ComponentContainer)this.b.get(string));
    }

    @Nullable
    public <U> U getView(@NotNull String string, @NotNull Class<U> clazz) {
        T t2;
        if (string == null) {
            CompositeView.a(2);
        }
        if (clazz == null) {
            CompositeView.a(3);
        }
        return clazz.isInstance(t2 = this.getView(string)) ? (U)clazz.cast(t2) : null;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            CompositeView.a(4);
        }
        return AnAction.EMPTY_ARRAY;
    }

    @NotNull
    public AnAction[] getSwitchActions() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.addSeparator();
        defaultActionGroup.add((AnAction)this.d);
        AnAction[] anActionArray = new AnAction[]{defaultActionGroup};
        if (anActionArray == null) {
            CompositeView.a(5);
        }
        return anActionArray;
    }

    public JComponent getComponent() {
        return this;
    }

    public JComponent getPreferredFocusableComponent() {
        return this;
    }

    public void dispose() {
    }

    @Nullable
    public Object getData(@NonNls String string) {
        Object object;
        T t2;
        String string2 = this.c.get();
        if (string2 != null && (t2 = this.getView(string2)) instanceof DataProvider && (object = ((DataProvider)t2).getData(string)) != null) {
            return object;
        }
        return null;
    }

    private void a(String string) {
        if (this.a != null) {
            PropertiesComponent.getInstance().setValue(this.a, string);
        }
    }

    @Nullable
    private String a() {
        return this.a == null ? null : PropertiesComponent.getInstance().getValue(this.a);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/CompositeView";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/CompositeView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwitchActions";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "enableView";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getView";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$enableView$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SwitchViewAction
    extends ToggleAction
    implements DumbAware {
        public SwitchViewAction() {
            super("Toggle view", null, AllIcons.Actions.ChangeView);
        }

        public void update(@NotNull AnActionEvent anActionEvent) {
            if (anActionEvent == null) {
                SwitchViewAction.a(0);
            }
            Presentation presentation = anActionEvent.getPresentation();
            if (CompositeView.this.b.size() <= 1) {
                presentation.setEnabled(false);
            } else {
                presentation.setEnabled(true);
                presentation.putClientProperty("selected", (Object)this.isSelected(anActionEvent));
            }
        }

        public boolean isSelected(AnActionEvent anActionEvent) {
            String string = (String)CompositeView.this.c.get();
            if (string == null) {
                return true;
            }
            Set set = CompositeView.this.b.keySet();
            return set.isEmpty() || string.equals(set.iterator().next());
        }

        public void setSelected(AnActionEvent anActionEvent, boolean bl2) {
            if (CompositeView.this.b.size() > 1) {
                ArrayList arrayList = new ArrayList(CompositeView.this.b.keySet());
                String string = bl2 ? (String)arrayList.get(0) : (String)arrayList.get(1);
                CompositeView.this.enableView(string);
                CompositeView.this.a(string);
                ApplicationManager.getApplication().invokeLater(() -> this.update(anActionEvent));
            }
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/build/CompositeView$SwitchViewAction", "update"));
        }
    }
}

