/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.ExecutionNode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class ExecutionNodeProgressAnimator
implements Runnable,
Disposable {
    private static final int b = 8;
    private static final int c = 1200;
    private static final int a = 150;
    public static final Icon[] FRAMES = new Icon[8];
    private long f = -1L;
    private Alarm g;
    private List<ExecutionNode> d = new SmartList();
    private BuildTreeConsoleView e;

    public ExecutionNodeProgressAnimator(BuildTreeConsoleView buildTreeConsoleView) {
        Disposer.register((Disposable)buildTreeConsoleView, (Disposable)this);
        this.g = new Alarm();
        this.e = buildTreeConsoleView;
    }

    public static int getCurrentFrameIndex() {
        return (int)(System.currentTimeMillis() % 1200L / 150L);
    }

    public static Icon getCurrentFrame() {
        return FRAMES[ExecutionNodeProgressAnimator.getCurrentFrameIndex()];
    }

    @Override
    public void run() {
        long l2;
        if (!this.d.isEmpty() && (l2 = System.currentTimeMillis()) - this.f >= 150L) {
            this.c();
            this.f = l2;
        }
        this.b();
    }

    public void addNode(@Nullable ExecutionNode executionNode) {
        this.d.add(executionNode);
    }

    public void startMovie() {
        this.b();
    }

    public void stopMovie() {
        this.c();
        for (ExecutionNode executionNode : this.d) {
            executionNode.setIconProvider(() -> AllIcons.Process.State.YellowStr);
            executionNode.setEndTime(System.currentTimeMillis());
        }
        this.d.clear();
        this.a();
    }

    public void dispose() {
        this.e = null;
        this.d.clear();
        this.a();
    }

    private void a() {
        if (this.g != null) {
            this.g.cancelAllRequests();
            this.g = null;
        }
    }

    private void c() {
        if (this.e == null || this.e.isDisposed()) {
            return;
        }
        Iterator<ExecutionNode> iterator = this.d.iterator();
        while (iterator.hasNext()) {
            ExecutionNode executionNode = iterator.next();
            this.e.scheduleUpdate(executionNode);
            if (executionNode.isRunning()) continue;
            iterator.remove();
        }
    }

    private void b() {
        if (this.g == null) {
            return;
        }
        this.g.cancelAllRequests();
        this.g.addRequest((Runnable)this, 150);
    }

    static {
        ExecutionNodeProgressAnimator.FRAMES[0] = AllIcons.Process.State.GreyProgr_1;
        ExecutionNodeProgressAnimator.FRAMES[1] = AllIcons.Process.State.GreyProgr_2;
        ExecutionNodeProgressAnimator.FRAMES[2] = AllIcons.Process.State.GreyProgr_3;
        ExecutionNodeProgressAnimator.FRAMES[3] = AllIcons.Process.State.GreyProgr_4;
        ExecutionNodeProgressAnimator.FRAMES[4] = AllIcons.Process.State.GreyProgr_5;
        ExecutionNodeProgressAnimator.FRAMES[5] = AllIcons.Process.State.GreyProgr_6;
        ExecutionNodeProgressAnimator.FRAMES[6] = AllIcons.Process.State.GreyProgr_7;
        ExecutionNodeProgressAnimator.FRAMES[7] = AllIcons.Process.State.GreyProgr_8;
    }
}

