/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.AbstractViewManager;
import com.intellij.build.BuildContentDescriptor;
import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildContentManagerImpl;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.BuildView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class MultipleBuildsView
implements BuildProgressListener,
Disposable {
    protected final Project myProject;
    protected final BuildContentManager myBuildContentManager;
    private final AtomicBoolean c;
    private final List<Runnable> e;
    private final ProgressWatcher j;
    private final ThreeComponentsSplitter b;
    private final JBList<AbstractViewManager.BuildInfo> g;
    private final Map<Object, AbstractViewManager.BuildInfo> l;
    private final Map<AbstractViewManager.BuildInfo, BuildView> h;
    private final AbstractViewManager i;
    private volatile Content k;
    private volatile DefaultActionGroup f;
    private volatile boolean d;
    private final TransferToEDTQueue<Runnable> a;

    public MultipleBuildsView(Project project2, BuildContentManager buildContentManager, AbstractViewManager abstractViewManager) {
        this.myProject = project2;
        this.myBuildContentManager = buildContentManager;
        this.i = abstractViewManager;
        this.c = new AtomicBoolean();
        this.e = ContainerUtil.createConcurrentList();
        this.b = new ThreeComponentsSplitter();
        Disposer.register((Disposable)this, (Disposable)this.b);
        this.g = new JBList();
        this.g.setModel(new DefaultListModel());
        this.g.setFixedCellHeight(40);
        this.g.installCellRenderer(object -> {
            AbstractViewManager.BuildInfo buildInfo = (AbstractViewManager.BuildInfo)object;
            JPanel jPanel = new JPanel(new BorderLayout());
            SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
            simpleColoredComponent.setIcon(buildInfo.getIcon());
            simpleColoredComponent.append(buildInfo.getTitle() + ": ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            simpleColoredComponent.append(buildInfo.message, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            jPanel.add((Component)simpleColoredComponent, "North");
            if (buildInfo.statusMessage != null) {
                SimpleColoredComponent simpleColoredComponent2 = new SimpleColoredComponent();
                simpleColoredComponent2.setIcon(EmptyIcon.ICON_16);
                simpleColoredComponent2.append(buildInfo.statusMessage, SimpleTextAttributes.GRAY_ATTRIBUTES);
                jPanel.add((Component)simpleColoredComponent2, "South");
            }
            return jPanel;
        });
        this.h = ContainerUtil.newConcurrentMap();
        this.l = ContainerUtil.newConcurrentMap();
        this.j = new ProgressWatcher();
        this.a = new TransferToEDTQueue("Multiple builds view queue", runnable -> {
            runnable.run();
            return true;
        }, object -> this.d);
    }

    public void dispose() {
        this.d = true;
    }

    public Content getContent() {
        return this.k;
    }

    public Map<AbstractViewManager.BuildInfo, BuildView> getBuildsMap() {
        return Collections.unmodifiableMap(this.h);
    }

    public boolean shouldConsume(BuildEvent buildEvent) {
        return buildEvent.getParentId() != null && this.l.containsKey(buildEvent.getParentId()) || this.l.containsKey(buildEvent.getId());
    }

    @Override
    public void onEvent(BuildEvent buildEvent) {
        SmartList smartList = new SmartList();
        if (buildEvent instanceof StartBuildEvent) {
            if (this.c.get()) {
                long l2 = System.currentTimeMillis();
                DefaultListModel defaultListModel = (DefaultListModel)this.g.getModel();
                boolean bl2 = !defaultListModel.isEmpty();
                for (int i2 = 0; i2 < defaultListModel.getSize(); ++i2) {
                    AbstractViewManager.BuildInfo buildInfo = (AbstractViewManager.BuildInfo)defaultListModel.getElementAt(i2);
                    if (buildInfo.endTime != -1L && l2 - buildInfo.endTime >= TimeUnit.SECONDS.toMillis(1L)) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    this.l.clear();
                    SmartList smartList2 = new SmartList(this.h.values());
                    smartList.add(() -> smartList2.forEach(Disposer::dispose));
                    this.h.clear();
                    defaultListModel.clear();
                    this.g.setVisible(false);
                    smartList.add(() -> {
                        this.b.setFirstComponent(null);
                        this.b.setLastComponent(null);
                    });
                    this.f.removeAll();
                }
            }
            StartBuildEvent startBuildEvent = (StartBuildEvent)buildEvent;
            AbstractViewManager.BuildInfo buildInfo = new AbstractViewManager.BuildInfo(buildEvent.getId(), startBuildEvent.getBuildTitle(), startBuildEvent.getWorkingDir(), buildEvent.getEventTime());
            this.l.put(buildEvent.getId(), buildInfo);
        } else if (buildEvent.getParentId() != null) {
            AbstractViewManager.BuildInfo buildInfo = this.l.get(buildEvent.getParentId());
            assert (buildInfo != null);
            this.l.put(buildEvent.getId(), buildInfo);
        }
        smartList.add(() -> {
            AbstractViewManager.BuildInfo buildInfo2 = this.l.get(buildEvent.getId());
            assert (buildInfo2 != null);
            if (buildEvent instanceof StartBuildEvent) {
                RunContentDescriptor runContentDescriptor;
                StartBuildEvent startBuildEvent = (StartBuildEvent)buildEvent;
                buildInfo2.message = startBuildEvent.getMessage();
                DefaultListModel defaultListModel = (DefaultListModel)this.g.getModel();
                defaultListModel.addElement(buildInfo2);
                BuildView buildView = this.h.computeIfAbsent(buildInfo2, buildInfo -> {
                    DefaultBuildDescriptor defaultBuildDescriptor = new DefaultBuildDescriptor(startBuildEvent.getId(), startBuildEvent.getBuildTitle(), startBuildEvent.getWorkingDir(), startBuildEvent.getEventTime());
                    String string = "build.toolwindow." + this.i.getViewName() + ".selection.state";
                    BuildView buildView = new BuildView(this.myProject, defaultBuildDescriptor, string, this.i);
                    Disposer.register((Disposable)this.b, (Disposable)buildView);
                    return buildView;
                });
                buildView.onEvent(startBuildEvent);
                this.k.setPreferredFocusedComponent(buildView::getPreferredFocusableComponent);
                Supplier<RunContentDescriptor> supplier = startBuildEvent.getContentDescriptorSupplier();
                RunContentDescriptor runContentDescriptor2 = runContentDescriptor = supplier != null ? supplier.get() : null;
                if (runContentDescriptor != null) {
                    boolean bl2;
                    buildInfo2.activateToolWindowWhenAdded = bl2 = runContentDescriptor.isActivateToolWindowWhenAdded();
                    if (runContentDescriptor instanceof BuildContentDescriptor) {
                        buildInfo2.activateToolWindowWhenFailed = ((BuildContentDescriptor)runContentDescriptor).isActivateToolWindowWhenFailed();
                    }
                    boolean bl3 = runContentDescriptor.isAutoFocusContent();
                    this.myBuildContentManager.setSelectedContent(this.k, bl3, bl3, bl2, runContentDescriptor.getActivationCallback());
                    Disposer.register((Disposable)buildView, (Disposable)runContentDescriptor);
                } else {
                    this.myBuildContentManager.setSelectedContent(this.k, true, true, false, null);
                }
                buildInfo2.content = this.k;
                if (this.b.getLastComponent() == null) {
                    this.b.setLastComponent((JComponent)buildView);
                    this.i.configureToolbar(this.f, this, buildView);
                }
                if (this.g.getModel().getSize() > 1) {
                    JBScrollPane jBScrollPane = new JBScrollPane();
                    jBScrollPane.setBorder((Border)JBUI.Borders.empty());
                    jBScrollPane.setViewportView(this.g);
                    this.b.setFirstComponent((JComponent)jBScrollPane);
                    this.g.setVisible(true);
                    this.g.setSelectedIndex(0);
                    this.b.repaint();
                    for (BuildView buildView2 : this.h.values()) {
                        BuildTreeConsoleView buildTreeConsoleView = buildView2.getView(BuildTreeConsoleView.class.getName(), BuildTreeConsoleView.class);
                        if (buildTreeConsoleView == null) continue;
                        buildTreeConsoleView.hideRootNode();
                    }
                } else {
                    this.b.setFirstComponent(null);
                }
                this.i.onBuildStart(buildInfo2);
                this.j.addBuild(buildInfo2);
                ((BuildContentManagerImpl)this.myBuildContentManager).startBuildNotified(buildInfo2, buildInfo2.content, startBuildEvent.getProcessHandler());
            } else {
                if (buildEvent instanceof FinishBuildEvent) {
                    buildInfo2.endTime = buildEvent.getEventTime();
                    buildInfo2.message = buildEvent.getMessage();
                    buildInfo2.result = ((FinishBuildEvent)buildEvent).getResult();
                    this.j.stopBuild(buildInfo2);
                    ((BuildContentManagerImpl)this.myBuildContentManager).finishBuildNotified(buildInfo2, buildInfo2.content);
                    this.i.onBuildFinish(buildInfo2);
                } else {
                    buildInfo2.statusMessage = buildEvent.getMessage();
                }
                this.h.get(buildInfo2).onEvent(buildEvent);
            }
        });
        if (this.k == null) {
            this.e.addAll((Collection<Runnable>)smartList);
            if (this.c.compareAndSet(false, true)) {
                this.a.offer(() -> {
                    this.g.setSelectionMode(0);
                    this.g.addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent listSelectionEvent) {
                            AbstractViewManager.BuildInfo buildInfo = (AbstractViewManager.BuildInfo)MultipleBuildsView.this.g.getSelectedValue();
                            if (buildInfo == null) {
                                return;
                            }
                            BuildView buildView = (BuildView)MultipleBuildsView.this.h.get(buildInfo);
                            JComponent jComponent = MultipleBuildsView.this.b.getLastComponent();
                            if (buildView != null && jComponent != buildView.getComponent()) {
                                MultipleBuildsView.this.b.setLastComponent(buildView.getComponent());
                                buildView.getComponent().setVisible(true);
                                if (jComponent != null) {
                                    jComponent.setVisible(false);
                                }
                                MultipleBuildsView.this.i.configureToolbar(MultipleBuildsView.this.f, MultipleBuildsView.this, buildView);
                                buildView.getComponent().repaint();
                            }
                            int n2 = MultipleBuildsView.this.b.getFirstSize();
                            int n3 = MultipleBuildsView.this.b.getLastSize();
                            if (n2 == 0 && n3 == 0) {
                                EdtInvocationManager.getInstance().invokeLater(() -> {
                                    int n2 = Math.round((float)MultipleBuildsView.this.b.getWidth() / 4.0f);
                                    MultipleBuildsView.this.b.setFirstSize(n2);
                                });
                            }
                        }
                    });
                    JPanel jPanel = new JPanel(new BorderLayout());
                    jPanel.add((Component)this.b, "Center");
                    this.f = new DefaultActionGroup();
                    jPanel.add((Component)ActionManager.getInstance().createActionToolbar("BuildView", (ActionGroup)this.f, false).getComponent(), "West");
                    this.k = new ContentImpl((JComponent)jPanel, this.i.getViewName(), true);
                    Disposer.register((Disposable)this.k, (Disposable)this);
                    this.k.setCloseable(false);
                    Icon icon = this.i.getContentIcon();
                    if (icon != null) {
                        this.k.setIcon(icon);
                        this.k.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
                    }
                    this.myBuildContentManager.addContent(this.k);
                    ArrayList<Runnable> arrayList = new ArrayList<Runnable>(this.e);
                    this.e.clear();
                    for (Runnable runnable : arrayList) {
                        runnable.run();
                    }
                });
            }
        } else {
            this.a.offer(() -> MultipleBuildsView.a((List)smartList));
        }
    }

    public boolean hasRunningBuilds() {
        return !this.j.a.isEmpty();
    }

    private static /* synthetic */ void a(List list2) {
        for (Runnable runnable : list2) {
            runnable.run();
        }
    }

    private class ProgressWatcher
    implements Runnable {
        private final Alarm b = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        private final Set<AbstractViewManager.BuildInfo> a = ContainerUtil.newConcurrentSet();

        private ProgressWatcher() {
        }

        @Override
        public void run() {
            this.b.cancelAllRequests();
            JComponent jComponent = MultipleBuildsView.this.b.getFirstComponent();
            if (jComponent != null) {
                jComponent.revalidate();
                jComponent.repaint();
            }
            if (!this.a.isEmpty()) {
                this.b.addRequest((Runnable)this, 300);
            }
        }

        void addBuild(AbstractViewManager.BuildInfo buildInfo) {
            this.a.add(buildInfo);
            if (this.a.size() > 1) {
                this.b.cancelAllRequests();
                this.b.addRequest((Runnable)this, 300);
            }
        }

        void stopBuild(AbstractViewManager.BuildInfo buildInfo) {
            this.a.remove(buildInfo);
        }
    }
}

