/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.ChunkCustomCompilerExtension;
import com.intellij.compiler.ant.Comment;
import com.intellij.compiler.ant.CompilerExcludes;
import com.intellij.compiler.ant.CompilerResourcePatterns;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.IgnoredFiles;
import com.intellij.compiler.ant.LibraryDefinitionsGeneratorFactory;
import com.intellij.compiler.ant.LibraryPatterns;
import com.intellij.compiler.ant.Tag;
import com.intellij.compiler.ant.taskdefs.FileSet;
import com.intellij.compiler.ant.taskdefs.Include;
import com.intellij.compiler.ant.taskdefs.Path;
import com.intellij.compiler.ant.taskdefs.PathElement;
import com.intellij.compiler.ant.taskdefs.Property;
import com.intellij.compiler.ant.taskdefs.Target;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.io.IOException;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;

public class BuildPropertiesImpl
extends BuildProperties {
    public BuildPropertiesImpl(Project project2, GenerationOptions generationOptions) {
        Path path;
        Generator generator;
        LibraryTablesRegistrar libraryTablesRegistrar;
        LibraryDefinitionsGeneratorFactory libraryDefinitionsGeneratorFactory;
        Generator generator2;
        this.add((Generator)new Property(generationOptions.getPropertiesFileName()));
        this.add(new Comment(CompilerBundle.message((String)"generated.ant.build.disable.tests.property.comment", (Object[])new Object[0]), (Generator)new Property("skip.tests", "true")));
        JpsJavaCompilerOptions jpsJavaCompilerOptions = JavacConfiguration.getOptions(project2, JavacConfiguration.class);
        this.add(new Comment(CompilerBundle.message((String)"generated.ant.build.compiler.options.comment", (Object[])new Object[0])), 1);
        this.add((Generator)new Property("compiler.debug", jpsJavaCompilerOptions.DEBUGGING_INFO ? "on" : "off"), 1);
        this.add((Generator)new Property("compiler.generate.no.warnings", jpsJavaCompilerOptions.GENERATE_NO_WARNINGS ? "on" : "off"));
        this.add((Generator)new Property("compiler.args", jpsJavaCompilerOptions.ADDITIONAL_OPTIONS_STRING));
        int n2 = CompilerConfiguration.getInstance((Project)project2).getBuildProcessHeapSize(jpsJavaCompilerOptions.MAXIMUM_HEAP_SIZE);
        this.add((Generator)new Property("compiler.max.memory", Integer.toString(n2) + "m"));
        this.add(new IgnoredFiles());
        if (CompilerExcludes.isAvailable(project2)) {
            this.add(new CompilerExcludes(project2, generationOptions));
        }
        if (!generationOptions.expandJarDirectories) {
            this.add(new LibraryPatterns(project2, generationOptions));
        }
        this.add(new CompilerResourcePatterns(project2));
        if (generationOptions.forceTargetJdk) {
            this.createJdkGenerators(project2);
        }
        if ((generator2 = (libraryDefinitionsGeneratorFactory = new LibraryDefinitionsGeneratorFactory((ProjectEx)project2, generationOptions)).create((libraryTablesRegistrar = LibraryTablesRegistrar.getInstance()).getLibraryTable(project2), BuildPropertiesImpl.getProjectBaseDir((Project)project2), CompilerBundle.message((String)"generated.ant.build.project.libraries.comment", (Object[])new Object[0]))) != null) {
            this.add(generator2);
        }
        if ((generator = libraryDefinitionsGeneratorFactory.create(libraryTablesRegistrar.getLibraryTable(), null, CompilerBundle.message((String)"generated.ant.build.global.libraries.comment", (Object[])new Object[0]))) != null) {
            this.add(generator);
        }
        for (LibraryTable libraryTable : libraryTablesRegistrar.getCustomLibraryTables()) {
            if (libraryTable.getLibraries().length == 0 || (path = libraryDefinitionsGeneratorFactory.create(libraryTable, null, libraryTable.getPresentation().getDisplayName(true))) == null) continue;
            this.add((Generator)path);
        }
        Path path2 = generationOptions.getCustomCompilers();
        if (generationOptions.enableFormCompiler || ((ChunkCustomCompilerExtension[])path2).length > 0) {
            LibraryTable libraryTable;
            this.add(new Comment(CompilerBundle.message((String)"generated.ant.build.custom.compilers.comment", (Object[])new Object[0])));
            libraryTable = new Target("register.custom.compilers", null, null, null);
            if (generationOptions.enableFormCompiler) {
                this.add((Generator)new Property("javac2.home", BuildPropertiesImpl.propertyRelativePath((String)"idea.home", (String)"lib")));
                path = new Path("javac2.classpath");
                path.add((Generator)new PathElement(BuildPropertiesImpl.propertyRelativePath((String)"javac2.home", (String)"javac2.jar")));
                path.add((Generator)new PathElement(BuildPropertiesImpl.propertyRelativePath((String)"javac2.home", (String)"jdom.jar")));
                path.add((Generator)new PathElement(BuildPropertiesImpl.propertyRelativePath((String)"javac2.home", (String)"asm-all.jar")));
                path.add((Generator)new PathElement(BuildPropertiesImpl.propertyRelativePath((String)"javac2.home", (String)"jgoodies-forms.jar")));
                this.add((Generator)path);
                libraryTable.add((Generator)new Tag("taskdef", new Pair[]{Couple.of((Object)"name", (Object)"javac2"), Couple.of((Object)"classname", (Object)"com.intellij.ant.Javac2"), Couple.of((Object)"classpathref", (Object)"javac2.classpath")}));
                libraryTable.add((Generator)new Tag("taskdef", new Pair[]{Couple.of((Object)"name", (Object)"instrumentIdeaExtensions"), Couple.of((Object)"classname", (Object)"com.intellij.ant.InstrumentIdeaExtensions"), Couple.of((Object)"classpathref", (Object)"javac2.classpath")}));
            }
            if (((ChunkCustomCompilerExtension[])path2).length > 0) {
                for (Path path3 : path2) {
                    path3.generateCustomCompilerTaskRegistration(project2, generationOptions, (CompositeGenerator)libraryTable);
                }
            }
            this.add((Generator)libraryTable);
        }
    }

    protected void createJdkGenerators(Project project2) {
        Sdk[] sdkArray;
        Sdk[] sdkArray2 = BuildPropertiesImpl.getUsedJdks((Project)project2);
        if (sdkArray2.length > 0) {
            this.add(new Comment(CompilerBundle.message((String)"generated.ant.build.jdk.definitions.comment", (Object[])new Object[0])), 1);
            sdkArray = sdkArray2;
            int n2 = sdkArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                File file;
                SdkTypeId sdkTypeId;
                Sdk sdk = sdkArray[i2];
                if (sdk.getHomeDirectory() == null || !((sdkTypeId = sdk.getSdkType()) instanceof JavaSdkType) || ((JavaSdkType)sdkTypeId).getBinPath(sdk) == null) continue;
                File file2 = VfsUtil.virtualToIoFile((VirtualFile)sdk.getHomeDirectory());
                try {
                    file = file2.getCanonicalFile();
                }
                catch (IOException iOException) {
                    file = file2;
                }
                String string = sdk.getName();
                String string2 = BuildPropertiesImpl.getJdkHomeProperty((String)string);
                FileSet fileSet = new FileSet(BuildPropertiesImpl.propertyRef((String)string2));
                String[] stringArray = sdk.getRootProvider().getUrls(OrderRootType.CLASSES);
                for (String string3 : stringArray) {
                    String string4 = GenerationUtils.trimJarSeparator((String)VirtualFileManager.extractPath((String)string3));
                    File file3 = new File(string4);
                    String string5 = FileUtil.getRelativePath((File)file, (File)file3);
                    if (string5 == null) continue;
                    fileSet.add((Generator)new Include(string5.replace(File.separatorChar, '/')));
                }
                File file4 = BuildPropertiesImpl.toCanonicalFile((File)new File(((JavaSdkType)sdkTypeId).getBinPath(sdk)));
                String string6 = FileUtil.getRelativePath((File)file, (File)file4);
                if (string6 != null) {
                    this.add((Generator)new Property(BuildProperties.getJdkBinProperty((String)string), BuildPropertiesImpl.propertyRef((String)string2) + "/" + FileUtil.toSystemIndependentName((String)string6)), 1);
                } else {
                    this.add((Generator)new Property(BuildProperties.getJdkBinProperty((String)string), FileUtil.toSystemIndependentName((String)file4.getPath())), 1);
                }
                Path path = new Path(BuildPropertiesImpl.getJdkPathId((String)string));
                path.add((Generator)fileSet);
                this.add((Generator)path);
            }
        }
        this.add((Generator)new Property("project.jdk.home", (sdkArray = ProjectRootManager.getInstance((Project)project2).getProjectSdk()) != null ? BuildPropertiesImpl.propertyRef((String)BuildPropertiesImpl.getJdkHomeProperty((String)sdkArray.getName())) : ""), 1);
        this.add((Generator)new Property("project.jdk.bin", sdkArray != null ? BuildPropertiesImpl.propertyRef((String)BuildPropertiesImpl.getJdkBinProperty((String)sdkArray.getName())) : ""));
        this.add((Generator)new Property("project.jdk.classpath", sdkArray != null ? BuildPropertiesImpl.getJdkPathId((String)sdkArray.getName()) : ""));
    }
}

