/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant.artifacts;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.taskdefs.Mkdir;
import com.intellij.compiler.ant.taskdefs.Property;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ArtifactAntGenerationContextImpl
implements ArtifactAntGenerationContext {
    @NonNls
    public static final String ARTIFACTS_TEMP_DIR_PROPERTY = "artifacts.temp.dir";
    private final Map<Artifact, String> h = new THashMap();
    private final List<Generator> b = new ArrayList<Generator>();
    private final List<Generator> f = new ArrayList<Generator>();
    private final Set<String> c = new THashSet();
    private final Set<String> g = new THashSet();
    private final Set<String> e = new LinkedHashSet<String>();
    private final Project i;
    private final GenerationOptions d;
    private final List<Generator> a = new ArrayList<Generator>();
    private final Set<Artifact> j = new THashSet();

    public ArtifactAntGenerationContextImpl(Project project2, GenerationOptions generationOptions, List<Artifact> list2) {
        this.i = project2;
        this.d = generationOptions;
        for (Artifact artifact : list2) {
            if (!ArtifactUtil.shouldClearArtifactOutputBeforeRebuild(artifact)) continue;
            this.j.add(artifact);
        }
    }

    public Project getProject() {
        return this.i;
    }

    public GenerationOptions getGenerationOptions() {
        return this.d;
    }

    public String getConfiguredArtifactOutputProperty(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactAntGenerationContextImpl.a(0);
        }
        return "artifact.output." + BuildProperties.convertName((String)artifact.getName());
    }

    public String getArtifactOutputProperty(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactAntGenerationContextImpl.a(1);
        }
        if (this.shouldBuildIntoTempDirectory(artifact)) {
            return "artifact.temp.output." + BuildProperties.convertName((String)artifact.getName());
        }
        return this.getConfiguredArtifactOutputProperty(artifact);
    }

    public boolean shouldBuildIntoTempDirectory(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactAntGenerationContextImpl.a(2);
        }
        return !this.j.contains(artifact);
    }

    public String getCleanTargetName(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactAntGenerationContextImpl.a(3);
        }
        return "clean.artifact." + BuildProperties.convertName((String)artifact.getName());
    }

    public String getTargetName(@NotNull Artifact artifact) {
        String string;
        if (artifact == null) {
            ArtifactAntGenerationContextImpl.a(4);
        }
        if ((string = this.h.get(artifact)) == null) {
            string = ArtifactAntGenerationContextImpl.a(artifact.getName());
            this.h.put(artifact, string);
        }
        return string;
    }

    private static String a(String string) {
        return "artifact." + BuildProperties.convertName((String)string);
    }

    public String getSubstitutedPath(String string) {
        return GenerationUtils.toRelativePath((String)string, (File)VfsUtil.virtualToIoFile((VirtualFile)this.i.getBaseDir()), (String)BuildProperties.getProjectBaseDirProperty(), (GenerationOptions)this.d);
    }

    public void runBeforeCurrentArtifact(Generator generator) {
        this.a.add(generator);
    }

    public void runBeforeBuild(Generator generator) {
        this.b.add(generator);
    }

    public void runAfterBuild(Generator generator) {
        this.f.add(generator);
    }

    public String createNewTempFileProperty(String string, String string2) {
        String string3 = string2;
        int n2 = 1;
        String string4 = null;
        while (this.c.contains(string3)) {
            string4 = String.valueOf(n2++);
            string3 = string4 + "/" + string2;
        }
        String string5 = string;
        n2 = 2;
        while (this.e.contains(string5)) {
            string5 = string + n2++;
        }
        this.runBeforeBuild((Generator)new Property(string5, BuildProperties.propertyRelativePath((String)ARTIFACTS_TEMP_DIR_PROPERTY, (String)string3)));
        if (string4 != null && this.g.add(string4)) {
            this.runBeforeBuild((Generator)new Mkdir(BuildProperties.propertyRelativePath((String)ARTIFACTS_TEMP_DIR_PROPERTY, (String)string4)));
        }
        this.c.add(string3);
        this.e.add(string5);
        return string5;
    }

    public Generator[] getAndClearBeforeCurrentArtifact() {
        Generator[] generatorArray = this.a.toArray(new Generator[0]);
        this.a.clear();
        return generatorArray;
    }

    public String getModuleOutputPath(String string) {
        return BuildProperties.getOutputPathProperty((String)string);
    }

    public String getModuleTestOutputPath(@NonNls String string) {
        return BuildProperties.getOutputPathForTestsProperty((String)string);
    }

    public List<Generator> getBeforeBuildGenerators() {
        return this.b;
    }

    public List<Generator> getAfterBuildGenerators() {
        return this.f;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "artifact";
        objectArray2[1] = "com/intellij/compiler/ant/artifacts/ArtifactAntGenerationContextImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfiguredArtifactOutputProperty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getArtifactOutputProperty";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldBuildIntoTempDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCleanTargetName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

