/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch.context;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ChainSearchTarget {
    private static final Set<String> a = ContainerUtil.set((Object[])new String[]{"java.lang", "java.util.function"});
    private final String e;
    private final byte[] d;
    private final PsiType b;
    private final boolean c;

    public ChainSearchTarget(String string, byte[] byArray, PsiType psiType) {
        this(string, byArray, psiType, false);
    }

    private ChainSearchTarget(String string, byte[] byArray, PsiType psiType, boolean bl2) {
        this.e = string;
        this.d = byArray;
        this.b = psiType;
        this.c = bl2;
    }

    public String getClassQName() {
        return this.e;
    }

    public byte[] getArrayKind() {
        return this.d;
    }

    public PsiClass getTargetClass() {
        return PsiUtil.resolveClassInType((PsiType)this.b);
    }

    public boolean isIteratorAccess() {
        return this.c;
    }

    public ChainSearchTarget toIterators() {
        return this.d.length == 1 && this.d[0] == 0 ? new ChainSearchTarget(this.e, new byte[]{1, -1}, this.b, true) : this;
    }

    @Nullable
    public static ChainSearchTarget create(PsiType psiType) {
        if (psiType instanceof PsiArrayType) {
            return ChainSearchTarget.a((PsiArrayType)psiType);
        }
        if (psiType instanceof PsiClassType) {
            return ChainSearchTarget.a((PsiClassType)psiType);
        }
        return null;
    }

    @Nullable
    private static ChainSearchTarget a(PsiArrayType psiArrayType) {
        PsiType psiType = psiArrayType.getComponentType();
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)psiType);
        if (psiClass == null) {
            return null;
        }
        String string = psiClass.getQualifiedName();
        if (string == null) {
            return null;
        }
        return new ChainSearchTarget(string, new byte[]{1}, (PsiType)psiArrayType);
    }

    @Nullable
    private static ChainSearchTarget a(PsiClassType psiClassType) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)psiClassType);
        if (psiClass == null) {
            return null;
        }
        byte by2 = 0;
        String string = ChainSearchTarget.getIteratorKind(psiClass);
        if (string != null) {
            psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)string, (int)0, (boolean)false));
            if (psiClass == null) {
                return null;
            }
            by2 = -1;
        }
        if (psiClass.hasTypeParameters() || psiClass instanceof PsiTypeParameter || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"java.lang.FunctionalInterface", (int)2)) {
            return null;
        }
        String string2 = JavaHierarchyUtil.getPackageName((PsiClass)psiClass);
        if (string2 == null || a.contains(string2)) {
            return null;
        }
        String string3 = psiClass.getQualifiedName();
        if (string3 == null) {
            return null;
        }
        return new ChainSearchTarget(string3, new byte[]{by2}, (PsiType)psiClassType);
    }

    public static String getIteratorKind(PsiClass psiClass) {
        if (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.Iterable")) {
            return "java.lang.Iterable";
        }
        if (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.Iterator")) {
            return "java.util.Iterator";
        }
        if (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.stream.Stream")) {
            return "java.util.stream.Stream";
        }
        return null;
    }
}

