/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.StateCache;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.ValidityStateFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class FileProcessingCompilerStateCache {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.compiler.impl.FileProcessingCompilerStateCache");
    private final StateCache<MyState> a;

    public FileProcessingCompilerStateCache(File file, final ValidityStateFactory validityStateFactory) throws IOException {
        this.a = new StateCache<MyState>(new File(file, "timestamps")){

            @Override
            public MyState read(DataInput dataInput) throws IOException {
                return new MyState(dataInput.readLong(), validityStateFactory.createValidityState(dataInput));
            }

            @Override
            public void write(MyState myState, DataOutput dataOutput) throws IOException {
                dataOutput.writeLong(myState.getTimestamp());
                ValidityState validityState = myState.getExtState();
                if (validityState != null) {
                    validityState.save(dataOutput);
                }
            }
        };
    }

    public void update(VirtualFile virtualFile, ValidityState validityState) throws IOException {
        if (virtualFile.isValid()) {
            this.a.update(virtualFile.getUrl(), new MyState(virtualFile.getTimeStamp(), validityState));
        }
    }

    public void remove(String string) throws IOException {
        this.a.remove(string);
    }

    public long getTimestamp(String string) throws IOException {
        MyState myState;
        Serializable serializable = this.a.getState(string);
        if (serializable != null) {
            b.assertTrue(serializable instanceof MyState);
        }
        return (myState = (MyState)serializable) != null ? myState.getTimestamp() : -1L;
    }

    public ValidityState getExtState(String string) throws IOException {
        MyState myState = this.a.getState(string);
        return myState != null ? myState.getExtState() : null;
    }

    public void force() {
        this.a.force();
    }

    public Collection<String> getUrls() throws IOException {
        return this.a.getUrls();
    }

    public boolean wipe() {
        return this.a.wipe();
    }

    public void close() {
        try {
            this.a.close();
        }
        catch (IOException iOException) {
            b.info((Throwable)iOException);
        }
    }

    private static class MyState
    implements Serializable {
        private final long b;
        private final ValidityState a;

        public MyState(long l2, @Nullable ValidityState validityState) {
            this.b = l2;
            this.a = validityState;
        }

        public long getTimestamp() {
            return this.b;
        }

        @Nullable
        public ValidityState getExtState() {
            return this.a;
        }
    }
}

