/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.util.TripleFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessagesContainer {
    private static final int b = 8;
    private final Project c;
    private final Map<CompilerMessageCategory, Collection<CompilerMessage>> d = new EnumMap<CompilerMessageCategory, Collection<CompilerMessage>>(CompilerMessageCategory.class);
    private final int a;

    public MessagesContainer(Project project2) {
        this.c = project2;
        this.a = CodeStyleFacade.getInstance().getTabSize((FileType)StdFileTypes.JAVA);
    }

    @NotNull
    public Collection<CompilerMessage> getMessages(@NotNull CompilerMessageCategory compilerMessageCategory) {
        Collection<CompilerMessage> collection;
        if (compilerMessageCategory == null) {
            MessagesContainer.a(0);
        }
        if ((collection = this.d.get(compilerMessageCategory)) == null) {
            List<CompilerMessage> list2 = Collections.emptyList();
            if (list2 == null) {
                MessagesContainer.a(1);
            }
            return list2;
        }
        Collection<CompilerMessage> collection2 = Collections.unmodifiableCollection(collection);
        if (collection2 == null) {
            MessagesContainer.a(2);
        }
        return collection2;
    }

    @Nullable
    public CompilerMessage addMessage(CompilerMessageCategory compilerMessageCategory, String string, String string2, int n4, int n5, Navigatable navigatable) {
        CompilerMessageImpl compilerMessageImpl = new CompilerMessageImpl(this.c, compilerMessageCategory, string, MessagesContainer.a(string2), n4, n5, navigatable);
        if (this.addMessage(compilerMessageImpl)) {
            compilerMessageImpl.setColumnAdjuster((TripleFunction<CompilerMessage, Integer, Integer, Integer>)((TripleFunction)(compilerMessage, n2, n3) -> this.a((CompilerMessage)compilerMessage, (int)n2, (int)n3)));
            return compilerMessageImpl;
        }
        return null;
    }

    private int a(CompilerMessage compilerMessage, int n2, int n3) {
        int n4;
        VirtualFile virtualFile;
        if (this.a != 8 && n2 >= 1 && (virtualFile = compilerMessage.getVirtualFile()) != null && virtualFile.isValid() && (n4 = ((Integer)ApplicationManager.getApplication().runReadAction(() -> {
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (document == null) {
                return 0;
            }
            int n4 = 0;
            CharSequence charSequence = document.getCharsSequence();
            int n5 = document.getLineStartOffset(n2);
            int n6 = document.getLineEndOffset(n2);
            int n7 = 0;
            for (int i2 = n5; i2 < n6; ++i2) {
                if (charSequence.charAt(i2) == '\t') {
                    n7 += 8;
                    ++n4;
                } else {
                    ++n7;
                }
                if (n7 >= n3) break;
            }
            return n4;
        })).intValue()) > 0) {
            return Math.max(0, n3 + n4 * (this.a - 8));
        }
        return n3;
    }

    public boolean addMessage(CompilerMessage compilerMessage) {
        Collection collection = this.d.computeIfAbsent(compilerMessage.getCategory(), compilerMessageCategory -> new LinkedHashSet());
        return collection.add(compilerMessage);
    }

    @Nullable
    private static VirtualFile a(@Nullable String string) {
        if (string == null) {
            return null;
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(string);
        if (virtualFile == null) {
            return VirtualFileManager.getInstance().refreshAndFindFileByUrl(string);
        }
        return virtualFile;
    }

    public int getMessageCount(@Nullable CompilerMessageCategory compilerMessageCategory) {
        if (compilerMessageCategory != null) {
            Collection<CompilerMessage> collection = this.d.get(compilerMessageCategory);
            return collection != null ? collection.size() : 0;
        }
        return this.d.values().stream().filter(Objects::nonNull).mapToInt(Collection::size).sum();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/impl/MessagesContainer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/impl/MessagesContainer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessages";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMessages";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

