/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.FileIndexCompileScope;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleCompileScope
extends FileIndexCompileScope {
    private final Project c;
    private final Set<Module> a;
    private final Module[] b;
    private final Collection<String> e;
    private final Map<Module, String[]> d = new HashMap<Module, String[]>();

    public ModuleCompileScope(Module module2, boolean bl2) {
        this(module2.getProject(), Collections.singleton(module2), Collections.emptyList(), bl2, false);
    }

    public ModuleCompileScope(Project project2, Module[] moduleArray, boolean bl2) {
        this(project2, moduleArray, bl2, false);
    }

    public ModuleCompileScope(Project project2, Module[] moduleArray, boolean bl2, boolean bl3) {
        this(project2, Arrays.asList(moduleArray), Collections.emptyList(), bl2, bl3);
    }

    public ModuleCompileScope(Project project2, Collection<Module> collection, Collection<String> collection2, boolean bl2, boolean bl3) {
        this.c = project2;
        this.e = collection2;
        this.a = new HashSet<Module>();
        for (Module module2 : collection) {
            if (module2 == null) continue;
            if (bl2) {
                OrderEnumerator orderEnumerator = ModuleRootManager.getInstance((Module)module2).orderEntries().recursively();
                if (!bl3) {
                    orderEnumerator = orderEnumerator.compileOnly();
                }
                orderEnumerator.forEachModule((Processor)new CommonProcessors.CollectProcessor(this.a));
                continue;
            }
            this.a.add(module2);
        }
        this.b = ModuleManager.getInstance((Project)this.c).getModules();
    }

    @NotNull
    public Module[] getAffectedModules() {
        Module[] moduleArray = this.a.toArray(Module.EMPTY_ARRAY);
        if (moduleArray == null) {
            ModuleCompileScope.b(0);
        }
        return moduleArray;
    }

    @NotNull
    public Collection<String> getAffectedUnloadedModules() {
        Collection<String> collection = Collections.unmodifiableCollection(this.e);
        if (collection == null) {
            ModuleCompileScope.b(1);
        }
        return collection;
    }

    @Override
    protected FileIndex[] getFileIndices() {
        FileIndex[] fileIndexArray = new FileIndex[this.a.size()];
        int n2 = 0;
        for (Module module2 : this.a) {
            fileIndexArray[n2++] = ModuleRootManager.getInstance((Module)module2).getFileIndex();
        }
        return fileIndexArray;
    }

    /*
     * WARNING - void declaration
     */
    public boolean belongs(String string) {
        ModuleManager moduleManager;
        Module module32;
        if (this.a.isEmpty() && this.e.isEmpty()) {
            return false;
        }
        Module module2 = null;
        int n2 = 0;
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.c).getFileIndex();
        for (Module module32 : this.b) {
            String[] stringArray;
            for (String string2 : stringArray = this.a(module32)) {
                if (string2.length() < n2 || !ModuleCompileScope.a(string, string2)) continue;
                if (string2.length() == n2) {
                    if (module2 == null) {
                        module2 = module32;
                        continue;
                    }
                    if (module2.equals(module32)) continue;
                    module2 = (Module)ReadAction.compute(() -> {
                        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(string2);
                        if (virtualFile != null) {
                            return projectFileIndex.getModuleForFile(virtualFile);
                        }
                        return null;
                    });
                    continue;
                }
                n2 = string2.length();
                module2 = module32;
            }
        }
        if (module2 != null && this.a.contains(module2)) {
            void var10_21;
            int i2;
            Module module4;
            moduleManager = ModuleRootManager.getInstance(module2);
            Module module5 = module4 = moduleManager.getExcludeRootUrls();
            int n3 = ((String[])module5).length;
            for (i2 = 0; i2 < n3; ++i2) {
                String virtualFilePointer = module5[i2];
                if (!ModuleCompileScope.a(string, virtualFilePointer)) continue;
                return false;
            }
            module32 = module5 = moduleManager.getSourceRootUrls();
            i2 = ((String[])module32).length;
            boolean bl2 = false;
            while (var10_21 < i2) {
                String string3 = module32[var10_21];
                if (ModuleCompileScope.a(string, string3)) {
                    return true;
                }
                ++var10_21;
            }
        }
        moduleManager = ModuleManager.getInstance((Project)this.c);
        for (String string4 : this.e) {
            module32 = moduleManager.getUnloadedModuleDescription(string4);
            if (module32 == null) continue;
            for (VirtualFilePointer virtualFilePointer : module32.getContentRoots()) {
                if (!ModuleCompileScope.a(string, virtualFilePointer.getUrl())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean a(String string, String string2) {
        return string.length() > string2.length() && string.charAt(string2.length()) == '/' && FileUtil.startsWith((String)string, (String)string2);
    }

    private String[] a(Module module2) {
        String[] stringArray = this.d.get(module2);
        if (stringArray == null) {
            stringArray = ModuleRootManager.getInstance((Module)module2).getContentRootUrls();
            this.d.put(module2, stringArray);
        }
        return stringArray;
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/compiler/impl/ModuleCompileScope";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedModules";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedUnloadedModules";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

