/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class StateCache<T> {
    private PersistentHashMap<String, T> a;
    private final File b;

    public StateCache(@NonNls File file) throws IOException {
        this.b = file;
        this.a = this.a(file);
    }

    protected abstract T read(DataInput var1) throws IOException;

    protected abstract void write(T var1, DataOutput var2) throws IOException;

    public void force() {
        this.a.force();
    }

    public void close() throws IOException {
        this.a.close();
    }

    public boolean wipe() {
        try {
            this.a.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PersistentHashMap.deleteFilesStartingWith((File)this.b);
        try {
            this.a = this.a(this.b);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void update(@NonNls String string, T t2) throws IOException {
        if (t2 != null) {
            this.a.put((Object)string, t2);
        } else {
            this.remove(string);
        }
    }

    public void remove(String string) throws IOException {
        this.a.remove((Object)string);
    }

    public T getState(String string) throws IOException {
        return (T)this.a.get((Object)string);
    }

    public Collection<String> getUrls() throws IOException {
        return this.a.getAllKeysWithExistingMapping();
    }

    public Iterator<String> getUrlsIterator() throws IOException {
        return this.a.getAllKeysWithExistingMapping().iterator();
    }

    private PersistentHashMap<String, T> a(File file) throws IOException {
        return new PersistentHashMap(file, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, new DataExternalizer<T>(){

            public void save(@NotNull DataOutput dataOutput, T t2) throws IOException {
                if (dataOutput == null) {
                    1.a(0);
                }
                StateCache.this.write(t2, dataOutput);
            }

            public T read(@NotNull DataInput dataInput) throws IOException {
                if (dataInput == null) {
                    1.a(1);
                }
                return StateCache.this.read(dataInput);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/compiler/impl/StateCache$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }
}

