/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TranslatingCompilerFilesMonitor {
    public TranslatingCompilerFilesMonitor(VirtualFileManager virtualFileManager, Application application) {
        virtualFileManager.addVirtualFileListener((VirtualFileListener)new MyVfsListener(), (Disposable)application);
    }

    public static TranslatingCompilerFilesMonitor getInstance() {
        return (TranslatingCompilerFilesMonitor)ApplicationManager.getApplication().getComponent(TranslatingCompilerFilesMonitor.class);
    }

    private static void a(final VirtualFile virtualFile, final boolean bl2, final FileProcessor fileProcessor) {
        if (!(virtualFile.getFileSystem() instanceof LocalFileSystem)) {
            return;
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile virtualFile2) {
                if (virtualFile2 == null) {
                    1.a(0);
                }
                if (TranslatingCompilerFilesMonitor.b(virtualFile2)) {
                    VirtualFileVisitor.Result result2 = SKIP_CHILDREN;
                    if (result2 == null) {
                        1.a(1);
                    }
                    return result2;
                }
                if (!virtualFile2.isDirectory()) {
                    fileProcessor.execute(virtualFile2);
                }
                VirtualFileVisitor.Result result3 = CONTINUE;
                if (result3 == null) {
                    1.a(2);
                }
                return result3;
            }

            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile virtualFile2) {
                if (virtualFile2 == null) {
                    1.a(3);
                }
                if (bl2) {
                    return virtualFile2.isDirectory() ? ((NewVirtualFile)virtualFile2).iterInDbChildren() : null;
                }
                if (virtualFile2.equals(virtualFile) || !virtualFile2.isDirectory()) {
                    return null;
                }
                return TranslatingCompilerFilesMonitor.c(virtualFile2) ? null : ((NewVirtualFile)virtualFile2).iterInDbChildren();
            }

            private static /* synthetic */ void a(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                switch (n2) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$1";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getChildrenIterable";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static boolean c(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            TranslatingCompilerFilesMonitor.a(0);
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            if (!project2.isInitialized() || !BuildManager.getInstance().isProjectWatched(project2) || !ProjectRootManager.getInstance((Project)project2).getFileIndex().isInContent(virtualFile)) continue;
            return true;
        }
        return false;
    }

    private static void a(VirtualFile virtualFile, Consumer<Collection<File>> consumer) {
        if (!TranslatingCompilerFilesMonitor.a(virtualFile)) {
            THashSet tHashSet = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            TranslatingCompilerFilesMonitor.a(virtualFile, !TranslatingCompilerFilesMonitor.c(virtualFile), arg_0 -> TranslatingCompilerFilesMonitor.a((Set)tHashSet, arg_0));
            consumer.consume((Object)tHashSet);
        }
    }

    private static boolean a(VirtualFile virtualFile) {
        if (TranslatingCompilerFilesMonitor.b(virtualFile)) {
            return true;
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        for (VirtualFile virtualFile2 = virtualFile.getParent(); virtualFile2 != null; virtualFile2 = virtualFile2.getParent()) {
            if (!fileTypeManager.isFileIgnored(virtualFile2)) continue;
            return true;
        }
        return false;
    }

    private static boolean b(VirtualFile virtualFile) {
        return FileTypeManager.getInstance().isFileIgnored(virtualFile) || ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile) || FileUtil.isAncestor((String)PathManager.getConfigPath(), (String)virtualFile.getPath(), (boolean)false);
    }

    private static void b(Collection<File> collection) {
        if (!collection.isEmpty()) {
            BuildManager.getInstance().notifyFilesChanged(collection);
        }
    }

    private static void a(Collection<File> collection) {
        if (!collection.isEmpty()) {
            BuildManager.getInstance().notifyFilesDeleted(collection);
        }
    }

    private static /* synthetic */ void a(Set set, VirtualFile virtualFile) {
        set.add(new File(virtualFile.getPath()));
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor", "isInContentOfOpenedProject"));
    }

    private static class MyVfsListener
    implements VirtualFileListener {
        private MyVfsListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent virtualFilePropertyEvent) {
            VirtualFile virtualFile;
            if (virtualFilePropertyEvent == null) {
                MyVfsListener.a(0);
            }
            if ("name".equals(virtualFilePropertyEvent.getPropertyName()) && TranslatingCompilerFilesMonitor.c(virtualFile = virtualFilePropertyEvent.getFile())) {
                VirtualFile virtualFile2 = virtualFilePropertyEvent.getParent();
                if (virtualFile2 != null) {
                    String string = (String)virtualFilePropertyEvent.getOldValue();
                    final String string2 = virtualFile2.getPath() + "/" + string;
                    THashSet tHashSet = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                    if (virtualFile.isDirectory()) {
                        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0], (Set)tHashSet){
                            private StringBuilder a;
                            final /* synthetic */ Set val$toMark;
                            {
                                this.val$toMark = set;
                                super(optionArray);
                                this.a = new StringBuilder(string2);
                            }

                            public boolean visitFile(@NotNull VirtualFile virtualFile2) {
                                if (virtualFile2 == null) {
                                    1.a(0);
                                }
                                if (virtualFile2.isDirectory()) {
                                    if (!Comparing.equal((Object)virtualFile2, (Object)virtualFile)) {
                                        this.a.append("/").append(virtualFile2.getName());
                                    }
                                } else {
                                    String string = this.a.toString();
                                    if (!Comparing.equal((Object)virtualFile2, (Object)virtualFile)) {
                                        string = string + "/" + virtualFile2.getName();
                                    }
                                    this.val$toMark.add(new File(string));
                                }
                                return true;
                            }

                            public void afterChildrenVisited(@NotNull VirtualFile virtualFile2) {
                                if (virtualFile2 == null) {
                                    1.a(1);
                                }
                                if (virtualFile2.isDirectory() && !Comparing.equal((Object)virtualFile2, (Object)virtualFile)) {
                                    this.a.delete(this.a.length() - virtualFile2.getName().length() - 1, this.a.length());
                                }
                            }

                            private static /* synthetic */ void a(int n2) {
                                Object[] objectArray;
                                Object[] objectArray2;
                                Object[] objectArray3 = new Object[3];
                                switch (n2) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "child";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "file";
                                        break;
                                    }
                                }
                                objectArray2[1] = "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener$1";
                                switch (n2) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "visitFile";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "afterChildrenVisited";
                                        break;
                                    }
                                }
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        });
                    } else {
                        tHashSet.add(new File(string2));
                    }
                    TranslatingCompilerFilesMonitor.a((Collection)tHashSet);
                }
                TranslatingCompilerFilesMonitor.a(virtualFile, (Consumer<Collection<File>>)collection -> TranslatingCompilerFilesMonitor.b(collection));
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent virtualFileEvent) {
            if (virtualFileEvent == null) {
                MyVfsListener.a(1);
            }
            TranslatingCompilerFilesMonitor.a(virtualFileEvent.getFile(), (Consumer<Collection<File>>)collection -> TranslatingCompilerFilesMonitor.b(collection));
        }

        public void fileCreated(@NotNull VirtualFileEvent virtualFileEvent) {
            if (virtualFileEvent == null) {
                MyVfsListener.a(2);
            }
            TranslatingCompilerFilesMonitor.a(virtualFileEvent.getFile(), (Consumer<Collection<File>>)collection -> TranslatingCompilerFilesMonitor.b(collection));
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent virtualFileCopyEvent) {
            if (virtualFileCopyEvent == null) {
                MyVfsListener.a(3);
            }
            TranslatingCompilerFilesMonitor.a(virtualFileCopyEvent.getFile(), (Consumer<Collection<File>>)collection -> TranslatingCompilerFilesMonitor.b(collection));
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent virtualFileMoveEvent) {
            if (virtualFileMoveEvent == null) {
                MyVfsListener.a(4);
            }
            TranslatingCompilerFilesMonitor.a(virtualFileMoveEvent.getFile(), (Consumer<Collection<File>>)collection -> TranslatingCompilerFilesMonitor.b(collection));
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent virtualFileEvent) {
            if (virtualFileEvent == null) {
                MyVfsListener.a(5);
            }
            TranslatingCompilerFilesMonitor.a(virtualFileEvent.getFile(), (Consumer<Collection<File>>)collection -> TranslatingCompilerFilesMonitor.a(collection));
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent virtualFileMoveEvent) {
            if (virtualFileMoveEvent == null) {
                MyVfsListener.a(6);
            }
            TranslatingCompilerFilesMonitor.a(virtualFileMoveEvent.getFile(), (Consumer<Collection<File>>)collection -> TranslatingCompilerFilesMonitor.a(collection));
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileDeletion";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileMovement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface FileProcessor {
        public void execute(VirtualFile var1);
    }
}

