/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.options.ProcessorProfilePanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.SmartList;
import com.intellij.util.ui.EditableTreeModel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.java.impl.compiler.ProcessorConfigProfileImpl;

public class AnnotationProcessorsPanel
extends JPanel {
    private final ProcessorConfigProfile g = new ProcessorConfigProfileImpl("");
    private final List<ProcessorConfigProfile> a = new ArrayList<ProcessorConfigProfile>();
    private final Map<String, Module> c = new HashMap<String, Module>();
    private final Project d;
    private final Tree f;
    private final ProcessorProfilePanel b;
    private ProcessorConfigProfile e = null;

    public AnnotationProcessorsPanel(Project project2) {
        super(new BorderLayout());
        Splitter splitter = new Splitter(false, 0.3f);
        this.add((Component)splitter, "Center");
        this.d = project2;
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            this.c.put(module2.getName(), module2);
        }
        this.f = new Tree((TreeModel)new MyTreeModel());
        this.f.setRootVisible(false);
        JPanel jPanel = ToolbarDecorator.createDecorator((JTree)this.f).addExtraAction(new AnActionButton("Move to", AllIcons.Actions.Nextfile){

            public void actionPerformed(AnActionEvent anActionEvent) {
                ProcessorConfigProfile processorConfigProfile3;
                MyModuleNode myModuleNode = (MyModuleNode)AnnotationProcessorsPanel.this.f.getSelectionPath().getLastPathComponent();
                TreePath[] treePathArray = AnnotationProcessorsPanel.this.f.getSelectionPaths();
                ProcessorConfigProfile processorConfigProfile2 = ((ProfileNode)myModuleNode.getParent()).b;
                ArrayList<ProcessorConfigProfile> arrayList = new ArrayList<ProcessorConfigProfile>();
                arrayList.add(AnnotationProcessorsPanel.this.g);
                for (ProcessorConfigProfile processorConfigProfile3 : AnnotationProcessorsPanel.this.a) {
                    arrayList.add(processorConfigProfile3);
                }
                arrayList.remove(processorConfigProfile2);
                JBList jBList = new JBList(arrayList);
                processorConfigProfile3 = JBPopupFactory.getInstance().createListPopupBuilder((JList)jBList).setTitle("Move to").setItemChoosenCallback(() -> {
                    Object object = jBList.getSelectedValue();
                    if (object instanceof ProcessorConfigProfile) {
                        ProcessorConfigProfile processorConfigProfile2 = (ProcessorConfigProfile)object;
                        Module module2 = (Module)myModuleNode.getUserObject();
                        if (treePathArray != null) {
                            for (TreePath treePath : treePathArray) {
                                Object object2 = treePath.getLastPathComponent();
                                if (!(object2 instanceof MyModuleNode)) continue;
                                Module module3 = (Module)((MyModuleNode)object2).getUserObject();
                                if (processorConfigProfile2 != AnnotationProcessorsPanel.this.g) {
                                    processorConfigProfile2.removeModuleName(module3.getName());
                                }
                                if (processorConfigProfile2 == AnnotationProcessorsPanel.this.g) continue;
                                processorConfigProfile2.addModuleName(module3.getName());
                            }
                        }
                        RootNode rootNode = (RootNode)AnnotationProcessorsPanel.this.f.getModel().getRoot();
                        rootNode.sync();
                        DefaultMutableTreeNode defaultMutableTreeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)rootNode, (Object)module2);
                        if (defaultMutableTreeNode != null) {
                            TreeUtil.selectNode((JTree)AnnotationProcessorsPanel.this.f, (TreeNode)defaultMutableTreeNode);
                        }
                    }
                }).createPopup();
                RelativePoint relativePoint = anActionEvent.getInputEvent() instanceof MouseEvent ? this.getPreferredPopupPoint() : TreeUtil.getPointForSelection((JTree)AnnotationProcessorsPanel.this.f);
                processorConfigProfile3.show(relativePoint);
            }

            public ShortcutSet getShortcut() {
                return ActionManager.getInstance().getAction("Move").getShortcutSet();
            }

            public boolean isEnabled() {
                return AnnotationProcessorsPanel.this.f.getSelectionPath() != null && AnnotationProcessorsPanel.this.f.getSelectionPath().getLastPathComponent() instanceof MyModuleNode && !AnnotationProcessorsPanel.this.a.isEmpty();
            }
        }).createPanel();
        splitter.setFirstComponent((JComponent)jPanel);
        this.f.setCellRenderer((TreeCellRenderer)((Object)new MyCellRenderer()));
        this.f.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = AnnotationProcessorsPanel.this.f.getSelectionPath();
                if (treePath != null) {
                    ProcessorConfigProfile processorConfigProfile;
                    ProcessorConfigProfile processorConfigProfile2;
                    Object object = treePath.getLastPathComponent();
                    if (object instanceof MyModuleNode) {
                        object = ((MyModuleNode)object).getParent();
                    }
                    if (object instanceof ProfileNode && (processorConfigProfile2 = ((ProfileNode)object).b) != (processorConfigProfile = AnnotationProcessorsPanel.this.e)) {
                        if (processorConfigProfile != null) {
                            AnnotationProcessorsPanel.this.b.saveTo(processorConfigProfile);
                        }
                        AnnotationProcessorsPanel.this.e = processorConfigProfile2;
                        AnnotationProcessorsPanel.this.b.setProfile(processorConfigProfile2);
                    }
                }
            }
        });
        this.b = new ProcessorProfilePanel(project2);
        this.b.setBorder((Border)JBUI.Borders.emptyLeft((int)6));
        splitter.setSecondComponent((JComponent)this.b);
    }

    public void initProfiles(ProcessorConfigProfile processorConfigProfile, Collection<ProcessorConfigProfile> collection) {
        Object object2;
        this.g.initFrom(processorConfigProfile);
        this.a.clear();
        for (Object object2 : collection) {
            ProcessorConfigProfileImpl processorConfigProfileImpl = new ProcessorConfigProfileImpl("");
            processorConfigProfileImpl.initFrom(object2);
            this.a.add((ProcessorConfigProfile)processorConfigProfileImpl);
        }
        RootNode rootNode = (RootNode)this.f.getModel().getRoot();
        rootNode.sync();
        object2 = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)rootNode, (Object)this.g);
        if (object2 != null) {
            TreeUtil.selectNode((JTree)this.f, (TreeNode)object2);
        }
    }

    public ProcessorConfigProfile getDefaultProfile() {
        ProcessorConfigProfile processorConfigProfile = this.e;
        if (this.g == processorConfigProfile) {
            this.b.saveTo(processorConfigProfile);
        }
        return this.g;
    }

    public List<ProcessorConfigProfile> getModuleProfiles() {
        ProcessorConfigProfile processorConfigProfile = this.e;
        if (this.g != processorConfigProfile) {
            this.b.saveTo(processorConfigProfile);
        }
        return this.a;
    }

    private static class ModuleComparator
    implements Comparator<Module> {
        static final ModuleComparator INSTANCE = new ModuleComparator();

        private ModuleComparator() {
        }

        @Override
        public int compare(Module module2, Module module3) {
            return module2.getName().compareTo(module3.getName());
        }
    }

    private static class MyCellRenderer
    extends ColoredTreeCellRenderer {
        private MyCellRenderer() {
        }

        public void customizeCellRenderer(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
            if (object instanceof ProfileNode) {
                this.append(((ProfileNode)object).b.getName());
            } else if (object instanceof MyModuleNode) {
                Module module2 = (Module)((MyModuleNode)object).getUserObject();
                this.setIcon(AllIcons.Nodes.Module);
                this.append(module2.getName());
            }
        }
    }

    private static class MyModuleNode
    extends DefaultMutableTreeNode {
        public MyModuleNode(Module module2, ProfileNode profileNode) {
            super(module2);
            this.setParent(profileNode);
            this.setAllowsChildren(false);
        }
    }

    private class ProfileNode
    extends DefaultMutableTreeNode
    implements DataSynchronizable {
        private final ProcessorConfigProfile b;
        private final boolean a;

        public ProfileNode(ProcessorConfigProfile processorConfigProfile, RootNode rootNode, boolean bl2) {
            super(processorConfigProfile);
            this.setParent(rootNode);
            this.a = bl2;
            this.b = processorConfigProfile;
        }

        @Override
        public DataSynchronizable sync() {
            Vector<MyModuleNode> vector;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (this.a) {
                vector = new HashSet();
                for (ProcessorConfigProfile object : AnnotationProcessorsPanel.this.a) {
                    vector.addAll(object.getModuleNames());
                }
                for (Map.Entry entry : AnnotationProcessorsPanel.this.c.entrySet()) {
                    if (vector.contains(entry.getKey())) continue;
                    arrayList.add(entry.getValue());
                }
            } else {
                for (Iterator iterator : this.b.getModuleNames()) {
                    Module module2 = (Module)AnnotationProcessorsPanel.this.c.get(iterator);
                    if (module2 == null) continue;
                    arrayList.add(module2);
                }
            }
            Collections.sort(arrayList, ModuleComparator.INSTANCE);
            vector = new Vector<MyModuleNode>();
            for (Module module3 : arrayList) {
                vector.add(new MyModuleNode(module3, this));
            }
            this.children = vector;
            return this;
        }
    }

    private static interface DataSynchronizable {
        public DataSynchronizable sync();
    }

    private class RootNode
    extends DefaultMutableTreeNode
    implements DataSynchronizable {
        private RootNode() {
        }

        @Override
        public DataSynchronizable sync() {
            Vector<DataSynchronizable> vector = new Vector<DataSynchronizable>();
            vector.add(new ProfileNode(AnnotationProcessorsPanel.this.g, this, true).sync());
            for (ProcessorConfigProfile processorConfigProfile : AnnotationProcessorsPanel.this.a) {
                vector.add(new ProfileNode(processorConfigProfile, this, false).sync());
            }
            this.children = vector;
            ((DefaultTreeModel)AnnotationProcessorsPanel.this.f.getModel()).reload();
            TreeUtil.expandAll((JTree)AnnotationProcessorsPanel.this.f);
            return this;
        }
    }

    private class MyTreeModel
    extends DefaultTreeModel
    implements EditableTreeModel {
        public MyTreeModel() {
            super(new RootNode());
        }

        public TreePath addNode(TreePath treePath) {
            String string = Messages.showInputDialog((Project)AnnotationProcessorsPanel.this.d, (String)"Profile name", (String)"Create new profile", null, (String)"", (InputValidator)new InputValidatorEx(){

                public boolean checkInput(String string) {
                    if (StringUtil.isEmpty((String)string) || Comparing.equal((String)string, (String)AnnotationProcessorsPanel.this.g.getName())) {
                        return false;
                    }
                    for (ProcessorConfigProfile processorConfigProfile : AnnotationProcessorsPanel.this.a) {
                        if (!Comparing.equal((String)string, (String)processorConfigProfile.getName())) continue;
                        return false;
                    }
                    return true;
                }

                public boolean canClose(String string) {
                    return this.checkInput(string);
                }

                public String getErrorText(String string) {
                    if (this.checkInput(string)) {
                        return null;
                    }
                    return StringUtil.isEmpty((String)string) ? "Profile name shouldn't be empty" : "Profile " + string + " already exists";
                }
            });
            if (string != null) {
                ProcessorConfigProfileImpl processorConfigProfileImpl = new ProcessorConfigProfileImpl(string);
                AnnotationProcessorsPanel.this.a.add(processorConfigProfileImpl);
                ((DataSynchronizable)this.getRoot()).sync();
                DefaultMutableTreeNode defaultMutableTreeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)this.getRoot()), (Object)processorConfigProfileImpl);
                if (defaultMutableTreeNode != null) {
                    TreeUtil.selectNode((JTree)AnnotationProcessorsPanel.this.f, (TreeNode)defaultMutableTreeNode);
                }
            }
            return null;
        }

        public void removeNode(TreePath treePath) {
            this.removeNodes(Collections.singleton(treePath));
        }

        public void removeNodes(Collection<TreePath> collection) {
            SmartList smartList = new SmartList();
            for (TreePath object : collection) {
                ProcessorConfigProfile processorConfigProfile;
                Object object2 = object.getLastPathComponent();
                if (!(object2 instanceof ProfileNode) || (processorConfigProfile = ((ProfileNode)object2).b) == AnnotationProcessorsPanel.this.g) continue;
                smartList.add(processorConfigProfile);
            }
            if (!smartList.isEmpty()) {
                boolean bl2 = false;
                for (Object object2 : smartList) {
                    if (AnnotationProcessorsPanel.this.e == object2) {
                        AnnotationProcessorsPanel.this.e = null;
                    }
                    bl2 |= AnnotationProcessorsPanel.this.a.remove(object2);
                }
                if (bl2) {
                    ((DataSynchronizable)this.getRoot()).sync();
                    DefaultMutableTreeNode defaultMutableTreeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)this.getRoot()), (Object)AnnotationProcessorsPanel.this.g);
                    if (defaultMutableTreeNode != null) {
                        TreeUtil.selectNode((JTree)AnnotationProcessorsPanel.this.f, (TreeNode)defaultMutableTreeNode);
                    }
                }
            }
        }

        public void moveNodeTo(TreePath treePath) {
        }
    }
}

