/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nullable;

public class ProcessedModulesTable
extends JPanel {
    private JBTable a = null;
    private MyTableModel b = null;
    private int[] c = null;

    public ProcessedModulesTable(Project project2) {
        super(new BorderLayout());
        this.b = new MyTableModel(project2);
        this.a = new JBTable((TableModel)this.b);
        this.a.getEmptyText().setText("No modules configured");
        this.a.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.a.setAutoResizeMode(3);
        this.a.setColumnSelectionAllowed(false);
        TableColumnModel tableColumnModel = this.a.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(this.b.DIRNAME_COLUMN_INDEX);
        String string = "Generated Sources Directory Name";
        tableColumn.setHeaderValue("Generated Sources Directory Name");
        JTableHeader jTableHeader = this.a.getTableHeader();
        FontMetrics fontMetrics = jTableHeader.getFontMetrics(jTableHeader.getFont());
        int n2 = fontMetrics.stringWidth("Generated Sources Directory Name") + 12;
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2 + 20);
        tableColumn.setCellRenderer(new MyElementColumnCellRenderer());
        TableColumn tableColumn2 = tableColumnModel.getColumn(this.b.ELEMENT_COLUMN_INDEX);
        tableColumn2.setHeaderValue("Module");
        tableColumn2.setCellRenderer(new MyElementColumnCellRenderer());
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)this.a).disableUpDownActions().setPreferredSize((Dimension)JBUI.size((int)100, (int)155)).createPanel();
        this.add((Component)jPanel, "Center");
        SpeedSearchBase<JBTable> speedSearchBase = new SpeedSearchBase<JBTable>(this.a){

            public int getSelectedIndex() {
                return ProcessedModulesTable.this.a.getSelectedRow();
            }

            protected int convertIndexToModel(int n2) {
                return ProcessedModulesTable.this.a.convertRowIndexToModel(n2);
            }

            public Object[] getAllElements() {
                int n2 = ProcessedModulesTable.this.b.getRowCount();
                Object[] objectArray = new Object[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    objectArray[i2] = ProcessedModulesTable.this.b.getModuleAt(i2);
                }
                return objectArray;
            }

            public String getElementText(Object object) {
                return ((Module)object).getName() + " (" + FileUtil.toSystemDependentName((String)((Module)object).getModuleFilePath()) + ")";
            }

            public void selectElement(Object object, String string) {
                int n2 = ProcessedModulesTable.this.b.getRowCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (!object.equals(ProcessedModulesTable.this.b.getModuleAt(i2))) continue;
                    int n3 = ProcessedModulesTable.this.a.convertRowIndexToView(i2);
                    ProcessedModulesTable.this.a.getSelectionModel().setSelectionInterval(n3, n3);
                    TableUtil.scrollSelectionToVisible((JTable)ProcessedModulesTable.this.a);
                    break;
                }
            }
        };
        speedSearchBase.setComparator(new SpeedSearchComparator(false));
    }

    public void refresh() {
        this.b.fireTableDataChanged();
    }

    public void refresh(Module module2) {
        int n2 = this.b.getElementRow(module2);
        if (n2 >= 0) {
            this.b.fireTableRowsUpdated(n2, n2);
        }
    }

    public void saveSelection() {
        this.c = this.a.getSelectedRows();
    }

    public void restoreSelection() {
        if (this.c != null) {
            TableUtil.selectRows((JTable)this.a, (int[])this.c);
            this.c = null;
        }
    }

    public void addModule(Module module2, String string) {
        this.b.addElement(module2, string);
        this.a(this.b.getRowCount() - 1);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.a, true));
    }

    public void removeModule(Module module2) {
        int n2 = this.b.getElementRow(module2);
        if (n2 < 0) {
            return;
        }
        boolean bl2 = this.a.getSelectionModel().isSelectedIndex(n2);
        this.b.removeElement(module2);
        if (bl2) {
            int n3 = this.b.getRowCount();
            if (n3 > 0) {
                this.a(n2 % n3);
            } else {
                this.a.getSelectionModel().clearSelection();
            }
        }
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.a, true));
    }

    public void removeAllElements() {
        this.b.removeAllElements();
        this.a.getSelectionModel().clearSelection();
    }

    private void a(int n2) {
        this.a.getSelectionModel().setSelectionInterval(n2, n2);
        this.a.scrollRectToVisible(this.a.getCellRect(n2, 0, true));
    }

    @Nullable
    public Module getSelectedElement() {
        int n2 = this.getSelectedElementRow();
        return n2 < 0 ? null : this.b.getModuleAt(n2);
    }

    public int getSelectedElementRow() {
        return this.a.getSelectedRow();
    }

    public List<Module> getSelectedElements() {
        int[] nArray;
        ArrayList<Module> arrayList = new ArrayList<Module>();
        for (int n2 : nArray = this.a.getSelectedRows()) {
            if (n2 < 0) continue;
            arrayList.add(this.b.getModuleAt(n2));
        }
        return arrayList;
    }

    public void selectElements(Collection<? extends Module> collection) {
        if (collection.size() == 0) {
            this.a.clearSelection();
            return;
        }
        int[] nArray = this.a(collection);
        TableUtil.selectRows((JTable)this.a, (int[])nArray);
        TableUtil.scrollSelectionToVisible((JTable)this.a);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.a, true));
    }

    private int[] a(Collection<? extends Module> collection) {
        int[] nArray = new int[collection.size()];
        int n2 = 0;
        for (Module module2 : collection) {
            nArray[n2++] = this.b.getElementRow(module2);
        }
        return nArray;
    }

    public List<Pair<Module, String>> getAllModules() {
        int n2 = this.b.getRowCount();
        ArrayList<Pair<Module, String>> arrayList = new ArrayList<Pair<Module, String>>();
        for (int i2 = 0; i2 < n2; ++i2) {
            Module module2 = this.b.getModuleAt(i2);
            arrayList.add((Pair<Module, String>)Pair.create((Object)module2, (Object)this.b.getGenDirName(module2)));
        }
        return arrayList;
    }

    public void sort(Comparator<Module> comparator) {
        this.b.sort(comparator);
    }

    @Override
    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        this.a.setRowSelectionAllowed(bl2);
        this.b.fireTableDataChanged();
    }

    public void stopEditing() {
        TableCellEditor tableCellEditor = this.a.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    public JComponent getComponent() {
        return this.a;
    }

    public void clear() {
        this.b.clear();
    }

    public int getElementCount() {
        return this.b.getRowCount();
    }

    public Module getElementAt(int n2) {
        return this.b.getModuleAt(n2);
    }

    private class MyElementColumnCellRenderer
    extends DefaultTableCellRenderer {
        private MyElementColumnCellRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            Component component;
            Color color = UIUtil.getTableFocusCellBackground();
            Module module2 = object instanceof Module ? (Module)object : null;
            try {
                UIManager.put("Table.focusCellBackground", jTable.getSelectionBackground());
                component = super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
                if (module2 != null) {
                    this.setText(module2.getName() + " (" + FileUtil.toSystemDependentName((String)module2.getModuleFilePath()) + ")");
                }
                if (component instanceof JLabel) {
                    ((JLabel)component).setBorder(noFocusBorder);
                }
            }
            finally {
                UIManager.put("Table.focusCellBackground", color);
            }
            component.setEnabled(ProcessedModulesTable.this.isEnabled());
            if (component instanceof JLabel) {
                Icon icon = module2 != null ? ModuleType.get((Module)module2).getIcon() : null;
                JLabel jLabel = (JLabel)component;
                jLabel.setIcon(icon);
                jLabel.setDisabledIcon(icon);
            }
            component.setForeground(bl2 ? jTable.getSelectionForeground() : jTable.getForeground());
            return component;
        }
    }

    private final class MyTableModel
    extends AbstractTableModel
    implements EditableModel {
        private final List<Module> a = new ArrayList<Module>();
        private final Map<Module, String> c = new HashMap<Module, String>();
        public final int ELEMENT_COLUMN_INDEX = 0;
        public final int DIRNAME_COLUMN_INDEX = 1;
        private final Project b;

        private MyTableModel(Project project2) {
            this.b = project2;
        }

        public void sort(Comparator<Module> comparator) {
            Collections.sort(this.a, comparator);
            this.fireTableDataChanged();
        }

        public List<Module> getAllModules() {
            return Collections.unmodifiableList(this.a);
        }

        public Module getModuleAt(int n2) {
            return this.a.get(n2);
        }

        public String getGenDirName(Module module2) {
            return this.c.get(module2);
        }

        void addElement(Module module2, String string) {
            this.a.add(module2);
            if (string != null && string.length() > 0) {
                this.c.put(module2, string);
            }
            int n2 = this.a.size() - 1;
            this.fireTableRowsInserted(n2, n2);
        }

        public void addRow() {
            HashSet<Module> hashSet = new HashSet<Module>(Arrays.asList(ModuleManager.getInstance((Project)this.b).getModules()));
            hashSet.removeAll(this.getAllModules());
            ChooseModulesDialog chooseModulesDialog = new ChooseModulesDialog((Component)ProcessedModulesTable.this, new ArrayList<Module>(hashSet), "ChooseModule");
            if (chooseModulesDialog.showAndGet()) {
                List list2 = chooseModulesDialog.getChosenElements();
                for (Module module2 : list2) {
                    this.addElement(module2, null);
                }
            }
        }

        public void removeRow(int n2) {
            Module module2 = this.a.remove(n2);
            this.c.remove(module2);
            this.fireTableRowsDeleted(n2, n2);
        }

        public void exchangeRows(int n2, int n3) {
        }

        public boolean canExchangeRows(int n2, int n3) {
            return false;
        }

        public void removeElement(Module module2) {
            boolean bl2 = this.a.remove(module2);
            if (bl2) {
                this.c.remove(module2);
                this.fireTableDataChanged();
            }
        }

        public int getElementRow(Module module2) {
            return this.a.indexOf(module2);
        }

        public void removeAllElements() {
            this.a.clear();
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.a.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        @Nullable
        public Object getValueAt(int n2, int n3) {
            Module module2 = this.a.get(n2);
            if (n3 == 0) {
                return module2;
            }
            if (n3 == 1) {
                return this.c.get(module2);
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n2, int n3) {
            if (n3 == 1) {
                Module module2 = this.a.get(n2);
                if (object != null) {
                    String string = FileUtil.toSystemIndependentName((String)((String)object));
                    while (string.startsWith("/")) {
                        string = string.substring(1);
                    }
                    if (string.length() > 0) {
                        this.c.put(module2, string);
                    } else {
                        this.c.remove(module2);
                    }
                } else {
                    this.c.remove(module2);
                }
                this.fireTableRowsUpdated(n2, n2);
            }
        }

        public Class getColumnClass(int n2) {
            if (n2 == 1) {
                return String.class;
            }
            return super.getColumnClass(n2);
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            if (!ProcessedModulesTable.this.isEnabled()) {
                return false;
            }
            return n3 == 1;
        }

        public void clear() {
            this.a.clear();
            this.c.clear();
            this.fireTableDataChanged();
        }
    }
}

