/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.impl.AlternativeJreClassFinder;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.SearchScopeProvider;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDebugEnvironment
implements DebugEnvironment {
    private final GlobalSearchScope c;
    private final RemoteConnection b;
    private final long a;
    private final ExecutionEnvironment d;
    private final RunProfileState e;
    private final boolean f;

    public DefaultDebugEnvironment(@NotNull ExecutionEnvironment executionEnvironment, @NotNull RunProfileState runProfileState, RemoteConnection remoteConnection, boolean bl2) {
        if (executionEnvironment == null) {
            DefaultDebugEnvironment.a(0);
        }
        if (runProfileState == null) {
            DefaultDebugEnvironment.a(1);
        }
        this(executionEnvironment, runProfileState, remoteConnection, bl2 ? 30000L : 0L);
    }

    public DefaultDebugEnvironment(@NotNull ExecutionEnvironment executionEnvironment, @NotNull RunProfileState runProfileState, RemoteConnection remoteConnection, long l2) {
        if (executionEnvironment == null) {
            DefaultDebugEnvironment.a(2);
        }
        if (runProfileState == null) {
            DefaultDebugEnvironment.a(3);
        }
        this.d = executionEnvironment;
        this.e = runProfileState;
        this.b = remoteConnection;
        this.a = l2;
        this.c = DefaultDebugEnvironment.a(executionEnvironment.getProject(), executionEnvironment.getRunProfile());
        this.f = remoteConnection.isServerMode() && remoteConnection.isUseSockets() && "0".equals(remoteConnection.getAddress());
    }

    private static GlobalSearchScope a(final @NotNull Project project2, @Nullable RunProfile runProfile) {
        GlobalSearchScope globalSearchScope;
        if (project2 == null) {
            DefaultDebugEnvironment.a(4);
        }
        if ((globalSearchScope = SearchScopeProvider.createSearchScope((Project)project2, (RunProfile)runProfile)).equals(GlobalSearchScope.allScope((Project)project2))) {
            return new DelegatingGlobalSearchScope(globalSearchScope){
                final ProjectFileIndex myProjectFileIndex;
                final Comparator<VirtualFile> myScopeComparator;
                {
                    super(globalSearchScope);
                    this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
                    this.myScopeComparator = Comparator.comparing(arg_0 -> ((ProjectFileIndex)this.myProjectFileIndex).isInSourceContent(arg_0)).thenComparing(arg_0 -> ((ProjectFileIndex)this.myProjectFileIndex).isInLibrarySource(arg_0)).thenComparing((virtualFile, virtualFile2) -> super.compare(virtualFile, virtualFile2));
                }

                public int compare(@NotNull VirtualFile virtualFile, @NotNull VirtualFile virtualFile2) {
                    if (virtualFile == null) {
                        1.a(0);
                    }
                    if (virtualFile2 == null) {
                        1.a(1);
                    }
                    return this.myScopeComparator.compare(virtualFile, virtualFile2);
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file2";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/debugger/DefaultDebugEnvironment$1";
                    objectArray[2] = "compare";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        return globalSearchScope;
    }

    @Override
    public ExecutionResult createExecutionResult() throws ExecutionException {
        if (this.f && this.e instanceof JavaCommandLine) {
            DebuggerManagerImpl.createDebugParameters(((JavaCommandLine)this.e).getJavaParameters(), true, 0, this.b.getAddress(), false);
        }
        return this.e.execute(this.d.getExecutor(), this.d.getRunner());
    }

    @Override
    @NotNull
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope globalSearchScope = this.c;
        if (globalSearchScope == null) {
            DefaultDebugEnvironment.a(5);
        }
        return globalSearchScope;
    }

    @Override
    public boolean isRemote() {
        return this.e instanceof RemoteState;
    }

    @Override
    public RemoteConnection getRemoteConnection() {
        return this.b;
    }

    @Override
    public long getPollTimeout() {
        return this.a;
    }

    @Override
    public String getSessionName() {
        return this.d.getRunProfile().getName();
    }

    @Override
    @Nullable
    public Sdk getAlternativeJre() {
        return AlternativeJreClassFinder.getAlternativeJre(this.d.getRunProfile());
    }

    @Override
    @Nullable
    public Sdk getRunJre() {
        if (this.e instanceof JavaCommandLine) {
            try {
                return ((JavaCommandLine)this.e).getJavaParameters().getJdk();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return ProjectRootManager.getInstance((Project)this.d.getProject()).getProjectSdk();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/DefaultDebugEnvironment";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/DefaultDebugEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSearchScope";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

