/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.GotoFrameSourceAction;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.impl.DebuggerTreePanel;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DoubleClickListener;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerAction
extends AnAction {
    private static final DebuggerTreeNodeImpl[] a = new DebuggerTreeNodeImpl[0];

    @Nullable
    public static DebuggerTree getTree(DataContext dataContext) {
        return (DebuggerTree)((Object)DebuggerTree.DATA_KEY.getData(dataContext));
    }

    @Nullable
    public static DebuggerTreePanel getPanel(DataContext dataContext) {
        return (DebuggerTreePanel)DebuggerTreePanel.DATA_KEY.getData(dataContext);
    }

    @Nullable
    public static DebuggerTreeNodeImpl getSelectedNode(DataContext dataContext) {
        DebuggerTree debuggerTree = DebuggerAction.getTree(dataContext);
        if (debuggerTree == null) {
            return null;
        }
        if (debuggerTree.getSelectionCount() != 1) {
            return null;
        }
        TreePath treePath = debuggerTree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        Object object = treePath.getLastPathComponent();
        if (!(object instanceof DebuggerTreeNodeImpl)) {
            return null;
        }
        return (DebuggerTreeNodeImpl)object;
    }

    @Nullable
    public static DebuggerTreeNodeImpl[] getSelectedNodes(DataContext dataContext) {
        DebuggerTree debuggerTree = DebuggerAction.getTree(dataContext);
        if (debuggerTree == null) {
            return null;
        }
        TreePath[] treePathArray = debuggerTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return a;
        }
        ArrayList<DebuggerTreeNodeImpl> arrayList = new ArrayList<DebuggerTreeNodeImpl>(treePathArray.length);
        for (TreePath treePath : treePathArray) {
            Object object = treePath.getLastPathComponent();
            if (!(object instanceof DebuggerTreeNodeImpl)) continue;
            arrayList.add((DebuggerTreeNodeImpl)object);
        }
        return arrayList.toArray(new DebuggerTreeNodeImpl[0]);
    }

    @NotNull
    public static DebuggerContextImpl getDebuggerContext(DataContext dataContext) {
        DebuggerTreePanel debuggerTreePanel = DebuggerAction.getPanel(dataContext);
        if (debuggerTreePanel != null) {
            DebuggerContextImpl debuggerContextImpl = debuggerTreePanel.getContext();
            if (debuggerContextImpl == null) {
                DebuggerAction.a(0);
            }
            return debuggerContextImpl;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        DebuggerContextImpl debuggerContextImpl = project2 != null ? DebuggerManagerEx.getInstanceEx(project2).getContext() : DebuggerContextImpl.EMPTY_CONTEXT;
        if (debuggerContextImpl == null) {
            DebuggerAction.a(1);
        }
        return debuggerContextImpl;
    }

    public static boolean isContextView(AnActionEvent anActionEvent) {
        return "Debugger.EvaluationDialogPopup".equals(anActionEvent.getPlace()) || "Debugger.FramePanelPopup".equals(anActionEvent.getPlace()) || "Debugger.WatchesPanelPopup".equals(anActionEvent.getPlace()) || "Debugger.InspectPanelPopup".equals(anActionEvent.getPlace());
    }

    public static Disposable installEditAction(final JTree jTree, String string) {
        DoubleClickListener doubleClickListener = new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent mouseEvent) {
                if (jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()) == null) {
                    return false;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)jTree);
                GotoFrameSourceAction.doAction(dataContext);
                return true;
            }
        };
        doubleClickListener.installOn((Component)jTree);
        Disposable disposable = () -> doubleClickListener.uninstall((Component)jTree);
        DebuggerUIUtil.registerActionOnComponent((String)string, (JComponent)jTree, (Disposable)disposable);
        return disposable;
    }

    public static boolean isFirstStart(AnActionEvent anActionEvent) {
        String string = "initalized";
        if (anActionEvent.getPresentation().getClientProperty(string) != null) {
            return false;
        }
        anActionEvent.getPresentation().putClientProperty(string, (Object)string);
        return true;
    }

    public static void enableAction(AnActionEvent anActionEvent, boolean bl2) {
        SwingUtilities.invokeLater(() -> {
            anActionEvent.getPresentation().setEnabled(bl2);
            anActionEvent.getPresentation().setVisible(true);
        });
    }

    public static void refreshViews(AnActionEvent anActionEvent) {
        XDebuggerTree xDebuggerTree = XDebuggerTree.getTree((DataContext)anActionEvent.getDataContext());
        if (xDebuggerTree != null) {
            DebuggerAction.refreshViews(XDebugView.getSession((Component)xDebuggerTree));
        }
    }

    public static void refreshViews(@Nullable XDebugSession xDebugSession) {
        if (xDebugSession != null) {
            XDebugProcess xDebugProcess = xDebugSession.getDebugProcess();
            if (xDebugProcess instanceof JavaDebugProcess) {
                ((JavaDebugProcess)xDebugProcess).saveNodeHistory();
            }
            xDebugSession.rebuildViews();
        }
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/DebuggerAction", "getDebuggerContext"));
    }
}

