/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;

public class FreezeThreadAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent anActionEvent) {
        DebuggerTreeNodeImpl[] debuggerTreeNodeImplArray = FreezeThreadAction.getSelectedNodes(anActionEvent.getDataContext());
        if (debuggerTreeNodeImplArray == null) {
            return;
        }
        DebuggerContextImpl debuggerContextImpl = FreezeThreadAction.getDebuggerContext(anActionEvent.getDataContext());
        final DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
        for (final DebuggerTreeNodeImpl debuggerTreeNodeImpl : debuggerTreeNodeImplArray) {
            ThreadDescriptorImpl threadDescriptorImpl = (ThreadDescriptorImpl)debuggerTreeNodeImpl.getDescriptor();
            final ThreadReferenceProxyImpl threadReferenceProxyImpl = threadDescriptorImpl.getThreadReference();
            if (threadDescriptorImpl.isFrozen()) continue;
            debugProcessImpl.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    debugProcessImpl.createFreezeThreadCommand(threadReferenceProxyImpl).run();
                    debuggerTreeNodeImpl.calcValue();
                }
            });
        }
    }

    public void update(AnActionEvent anActionEvent) {
        DebuggerTreeNodeImpl[] debuggerTreeNodeImplArray = FreezeThreadAction.getSelectedNodes(anActionEvent.getDataContext());
        if (debuggerTreeNodeImplArray == null) {
            return;
        }
        DebugProcessImpl debugProcessImpl = FreezeThreadAction.getDebuggerContext(anActionEvent.getDataContext()).getDebugProcess();
        boolean bl2 = false;
        if (debugProcessImpl != null) {
            bl2 = true;
            for (DebuggerTreeNodeImpl debuggerTreeNodeImpl : debuggerTreeNodeImplArray) {
                NodeDescriptorImpl nodeDescriptorImpl = debuggerTreeNodeImpl.getDescriptor();
                if (nodeDescriptorImpl instanceof ThreadDescriptorImpl && !((ThreadDescriptorImpl)nodeDescriptorImpl).isSuspended()) continue;
                bl2 = false;
                break;
            }
        }
        anActionEvent.getPresentation().setVisible(bl2);
    }
}

