/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import java.util.ArrayList;

public class InterruptThreadAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent anActionEvent) {
        DebugProcessImpl debugProcessImpl;
        DebuggerTreeNodeImpl[] debuggerTreeNodeImplArray = InterruptThreadAction.getSelectedNodes(anActionEvent.getDataContext());
        if (debuggerTreeNodeImplArray == null) {
            return;
        }
        final ArrayList<ThreadReferenceProxyImpl> arrayList = new ArrayList<ThreadReferenceProxyImpl>();
        Object object = debuggerTreeNodeImplArray;
        int n2 = ((DebuggerTreeNodeImpl[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            DebuggerTreeNodeImpl debuggerTreeNodeImpl = object[i2];
            NodeDescriptorImpl nodeDescriptorImpl = debuggerTreeNodeImpl.getDescriptor();
            if (!(nodeDescriptorImpl instanceof ThreadDescriptorImpl)) continue;
            arrayList.add(((ThreadDescriptorImpl)nodeDescriptorImpl).getThreadReference());
        }
        if (!arrayList.isEmpty() && (debugProcessImpl = ((DebuggerContextImpl)(object = InterruptThreadAction.getDebuggerContext(anActionEvent.getDataContext()))).getDebugProcess()) != null) {
            debugProcessImpl.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    boolean bl2 = false;
                    for (ThreadReferenceProxyImpl threadReferenceProxyImpl : arrayList) {
                        try {
                            threadReferenceProxyImpl.getThreadReference().interrupt();
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            bl2 = true;
                        }
                    }
                    if (bl2) {
                        Project project2 = debugProcessImpl.getProject();
                        XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification("Thread operation 'interrupt' is not supported by VM", MessageType.INFO).notify(project2);
                    }
                }
            });
        }
    }

    public void update(AnActionEvent anActionEvent) {
        DebuggerTreeNodeImpl[] debuggerTreeNodeImplArray = InterruptThreadAction.getSelectedNodes(anActionEvent.getDataContext());
        boolean bl2 = false;
        boolean bl3 = false;
        if (debuggerTreeNodeImplArray != null && debuggerTreeNodeImplArray.length > 0) {
            NodeDescriptorImpl nodeDescriptorImpl;
            bl2 = true;
            bl3 = true;
            for (DebuggerTreeNodeImpl debuggerTreeNodeImpl : debuggerTreeNodeImplArray) {
                nodeDescriptorImpl = debuggerTreeNodeImpl.getDescriptor();
                if (nodeDescriptorImpl instanceof ThreadDescriptorImpl) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                for (DebuggerTreeNodeImpl debuggerTreeNodeImpl : debuggerTreeNodeImplArray) {
                    nodeDescriptorImpl = (ThreadDescriptorImpl)debuggerTreeNodeImpl.getDescriptor();
                    if (!((ThreadDescriptorImpl)nodeDescriptorImpl).isFrozen() && !((ThreadDescriptorImpl)nodeDescriptorImpl).isSuspended()) continue;
                    bl3 = false;
                    break;
                }
            }
        }
        DebuggerTreeNodeImpl[] debuggerTreeNodeImplArray2 = anActionEvent.getPresentation();
        debuggerTreeNodeImplArray2.setText(DebuggerBundle.message((String)"action.interrupt.thread.text", (Object[])new Object[0]));
        debuggerTreeNodeImplArray2.setEnabledAndVisible(bl2 && bl3);
    }
}

