/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.actions.LambdaSmartStepTarget;
import com.intellij.debugger.actions.MethodSmartStepTarget;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Range;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.OrderedSet;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Location;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class JavaSmartStepIntoHandler
extends JvmSmartStepIntoHandler {
    private static final Logger a = Logger.getInstance(JavaSmartStepIntoHandler.class);

    @Override
    public boolean isAvailable(SourcePosition sourcePosition) {
        PsiFile psiFile = sourcePosition.getFile();
        return psiFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    @Override
    public boolean doSmartStep(final SourcePosition sourcePosition, final DebuggerSession debuggerSession, final TextEditor textEditor) {
        debuggerSession.getProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerSession.getContextManager().getContext()){

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
                if (suspendContextImpl == null) {
                    1.c(0);
                }
                List list2 = (List)ReadAction.compute(() -> {
                    if (suspendContextImpl == null) {
                        1.c(1);
                    }
                    return JavaSmartStepIntoHandler.this.findSmartStepTargets(sourcePosition, suspendContextImpl, this.getDebuggerContext());
                });
                DebuggerUIUtil.invokeLater(() -> {
                    if (list2.isEmpty()) {
                        JavaSmartStepIntoHandler.this.doStepInto(debuggerSession, Registry.is((String)"debugger.single.smart.step.force"), null);
                    } else {
                        JavaSmartStepIntoHandler.this.handleTargets(sourcePosition, debuggerSession, textEditor, list2);
                    }
                });
            }

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            private static /* synthetic */ void c(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "suspendContext";
                objectArray2[1] = "com/intellij/debugger/actions/JavaSmartStepIntoHandler$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "threadAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$threadAction$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return true;
    }

    @Override
    @NotNull
    public List<SmartStepTarget> findSmartStepTargets(SourcePosition sourcePosition) {
        throw new IllegalStateException("Should not be used");
    }

    protected List<SmartStepTarget> findSmartStepTargets(SourcePosition sourcePosition, @Nullable SuspendContextImpl suspendContextImpl, @NotNull DebuggerContextImpl debuggerContextImpl) {
        TextRange textRange;
        int n2;
        if (debuggerContextImpl == null) {
            JavaSmartStepIntoHandler.a(0);
        }
        if ((n2 = sourcePosition.getLine()) < 0) {
            return Collections.emptyList();
        }
        PsiFile psiFile = sourcePosition.getFile();
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return Collections.emptyList();
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return Collections.emptyList();
        }
        if (n2 >= document.getLineCount()) {
            return Collections.emptyList();
        }
        TextRange textRange2 = DocumentUtil.getLineTextRange((Document)document, (int)n2);
        PsiElement psiElement = sourcePosition.getElementAt();
        PsiElement psiElement2 = DebuggerUtilsEx.getBody(DebuggerUtilsEx.getContainingMethod(psiElement));
        TextRange textRange3 = textRange = psiElement2 != null ? textRange2.intersection(psiElement2.getTextRange()) : textRange2;
        if (textRange == null || textRange.isEmpty()) {
            return Collections.emptyList();
        }
        if (psiElement != null && !(psiElement instanceof PsiCompiledElement)) {
            PsiElement psiElement3;
            PsiElement psiElement4;
            while ((psiElement4 = psiElement.getParent()) != null && psiElement4.getTextOffset() >= textRange.getStartOffset()) {
                psiElement = psiElement4;
            }
            psiElement4 = new OrderedSet();
            Ref ref = new Ref((Object)textRange);
            JavaRecursiveElementVisitor javaRecursiveElementVisitor = new JavaRecursiveElementVisitor((List)psiElement4, sourcePosition, debuggerContextImpl, textRange, ref){
                final Deque<PsiMethod> myContextStack = new LinkedList<PsiMethod>();
                final Deque<String> myParamNameStack = new LinkedList<String>();
                private int b = 0;
                private boolean a = false;
                final /* synthetic */ List val$targets;
                final /* synthetic */ SourcePosition val$position;
                final /* synthetic */ DebuggerContextImpl val$debuggerContext;
                final /* synthetic */ TextRange val$lineRange;
                final /* synthetic */ Ref val$textRange;
                {
                    this.val$targets = list2;
                    this.val$position = sourcePosition;
                    this.val$debuggerContext = debuggerContextImpl;
                    this.val$lineRange = textRange;
                    this.val$textRange = ref;
                }

                @Nullable
                private String a() {
                    return this.myParamNameStack.peekFirst();
                }

                public void visitAnonymousClass(PsiAnonymousClass psiAnonymousClass) {
                    for (PsiMethod psiMethod : psiAnonymousClass.getMethods()) {
                        this.val$targets.add(0, new MethodSmartStepTarget(psiMethod, this.a(), (PsiElement)psiMethod.getBody(), true, null));
                    }
                }

                public void visitLambdaExpression(PsiLambdaExpression psiLambdaExpression) {
                    boolean bl2 = this.a;
                    this.a = true;
                    super.visitLambdaExpression(psiLambdaExpression);
                    this.a = bl2;
                    this.val$targets.add(0, new LambdaSmartStepTarget(psiLambdaExpression, this.a(), psiLambdaExpression.getBody(), this.b++, null, !this.a));
                }

                public void visitMethodReferenceExpression(PsiMethodReferenceExpression psiMethodReferenceExpression) {
                    PsiElement psiElement;
                    PsiElement psiElement2 = psiMethodReferenceExpression.resolve();
                    if (psiElement2 instanceof PsiMethod && (psiElement = psiElement2.getNavigationElement()) instanceof PsiMethod) {
                        this.val$targets.add(0, new MethodSmartStepTarget((PsiMethod)psiElement, null, (PsiElement)psiMethodReferenceExpression, true, null));
                    }
                }

                public void visitField(PsiField psiField) {
                    if (this.checkTextRange((PsiElement)psiField, false)) {
                        super.visitField(psiField);
                    }
                }

                public void visitMethod(PsiMethod psiMethod) {
                    if (this.checkTextRange((PsiElement)psiMethod, false)) {
                        super.visitMethod(psiMethod);
                    }
                }

                public void visitStatement(PsiStatement psiStatement) {
                    if (this.checkTextRange((PsiElement)psiStatement, true)) {
                        super.visitStatement(psiStatement);
                    }
                }

                public void visitIfStatement(PsiIfStatement psiIfStatement) {
                    this.a((PsiElement)psiIfStatement.getCondition(), (PsiElement)psiIfStatement.getThenBranch(), (PsiElement)psiIfStatement.getElseBranch());
                }

                public void visitConditionalExpression(PsiConditionalExpression psiConditionalExpression) {
                    this.a((PsiElement)psiConditionalExpression.getCondition(), (PsiElement)psiConditionalExpression.getThenExpression(), (PsiElement)psiConditionalExpression.getElseExpression());
                }

                private void a(@Nullable PsiElement psiElement, @Nullable PsiElement psiElement2, @Nullable PsiElement psiElement3) {
                    ThreeState threeState;
                    if (psiElement != null && this.checkTextRange(psiElement, true)) {
                        psiElement.accept((PsiElementVisitor)this);
                    }
                    if ((threeState = this.a(psiElement)) != ThreeState.NO && psiElement2 != null && this.checkTextRange(psiElement2, true)) {
                        psiElement2.accept((PsiElementVisitor)this);
                    }
                    if (threeState != ThreeState.YES && psiElement3 != null && this.checkTextRange(psiElement3, true)) {
                        psiElement3.accept((PsiElementVisitor)this);
                    }
                }

                private ThreeState a(@Nullable PsiElement psiElement) {
                    if (psiElement != null && !DebuggerUtils.hasSideEffects((PsiElement)psiElement)) {
                        try {
                            ExpressionEvaluator expressionEvaluator = EvaluatorBuilderImpl.getInstance().build(psiElement, this.val$position);
                            return ThreeState.fromBoolean((boolean)DebuggerUtilsEx.evaluateBoolean(expressionEvaluator, this.val$debuggerContext.createEvaluationContext()));
                        }
                        catch (EvaluateException evaluateException) {
                            a.info((Throwable)evaluateException);
                        }
                    }
                    return ThreeState.UNSURE;
                }

                public void visitExpression(PsiExpression psiExpression) {
                    this.checkTextRange((PsiElement)psiExpression, true);
                    super.visitExpression(psiExpression);
                }

                boolean checkTextRange(@NotNull PsiElement psiElement, boolean bl2) {
                    TextRange textRange;
                    if (psiElement == null) {
                        2.a(0);
                    }
                    if (this.val$lineRange.intersects(textRange = psiElement.getTextRange())) {
                        if (bl2) {
                            this.val$textRange.set((Object)((TextRange)this.val$textRange.get()).union(textRange));
                        }
                        return true;
                    }
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void visitExpressionList(PsiExpressionList psiExpressionList) {
                    PsiMethod psiMethod = this.myContextStack.peekFirst();
                    if (psiMethod != null) {
                        String string = psiMethod.getName();
                        PsiExpression[] psiExpressionArray = psiExpressionList.getExpressions();
                        PsiParameter[] psiParameterArray = psiMethod.getParameterList().getParameters();
                        for (int i2 = 0; i2 < psiExpressionArray.length; ++i2) {
                            String string2 = i2 < psiParameterArray.length && !psiParameterArray[i2].isVarArgs() ? psiParameterArray[i2].getName() : "arg" + (i2 + 1);
                            this.myParamNameStack.push(string + ": " + string2 + ".");
                            PsiExpression psiExpression = psiExpressionArray[i2];
                            try {
                                psiExpression.accept((PsiElementVisitor)this);
                                continue;
                            }
                            finally {
                                this.myParamNameStack.pop();
                            }
                        }
                    } else {
                        super.visitExpressionList(psiExpressionList);
                    }
                }

                public void visitCallExpression(PsiCallExpression psiCallExpression) {
                    PsiMethod psiMethod = psiCallExpression.resolveMethod();
                    if (psiMethod != null) {
                        this.myContextStack.push(psiMethod);
                        this.val$targets.add(new MethodSmartStepTarget(psiMethod, null, (PsiElement)(psiCallExpression instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)psiCallExpression).getMethodExpression().getReferenceNameElement() : (psiCallExpression instanceof PsiNewExpression ? ((PsiNewExpression)psiCallExpression).getClassOrAnonymousClassReference() : psiCallExpression)), this.a || psiCallExpression instanceof PsiNewExpression && ((PsiNewExpression)psiCallExpression).getAnonymousClass() != null, null));
                    }
                    try {
                        super.visitCallExpression(psiCallExpression);
                    }
                    finally {
                        if (psiMethod != null) {
                            this.myContextStack.pop();
                        }
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/debugger/actions/JavaSmartStepIntoHandler$2", "checkTextRange"));
                }
            };
            psiElement.accept((PsiElementVisitor)javaRecursiveElementVisitor);
            for (psiElement3 = psiElement.getNextSibling(); psiElement3 != null && textRange.intersects(psiElement3.getTextRange()); psiElement3 = psiElement3.getNextSibling()) {
                psiElement3.accept((PsiElementVisitor)javaRecursiveElementVisitor);
            }
            psiElement3 = new Range((Comparable)Integer.valueOf(document.getLineNumber(((TextRange)ref.get()).getStartOffset())), (Comparable)Integer.valueOf(document.getLineNumber(((TextRange)ref.get()).getEndOffset())));
            psiElement4.forEach(arg_0 -> JavaSmartStepIntoHandler.a((Range)psiElement3, arg_0));
            if (!psiElement4.isEmpty()) {
                StackFrameProxyImpl stackFrameProxyImpl;
                StackFrameProxyImpl stackFrameProxyImpl2 = stackFrameProxyImpl = suspendContextImpl != null ? suspendContextImpl.getFrameProxy() : null;
                if (stackFrameProxyImpl != null) {
                    try {
                        Location location = stackFrameProxyImpl.location();
                        MethodBytecodeUtil.visit(location.method(), location.codeIndex(), new MethodVisitor(393216, (Range)psiElement3, (List)psiElement4, suspendContextImpl){
                            boolean myLineMatch;
                            final /* synthetic */ Range val$lines;
                            final /* synthetic */ List val$targets;
                            final /* synthetic */ SuspendContextImpl val$suspendContext;
                            {
                                this.val$lines = range;
                                this.val$targets = list2;
                                this.val$suspendContext = suspendContextImpl;
                                super(n2);
                                this.myLineMatch = false;
                            }

                            public void visitLineNumber(int n2, Label label) {
                                this.myLineMatch = this.val$lines.isWithin((Comparable)Integer.valueOf(n2 - 1));
                            }

                            public void visitMethodInsn(int n2, String string, String string2, String string3, boolean bl2) {
                                if (this.myLineMatch) {
                                    this.val$targets.removeIf(smartStepTarget -> {
                                        if (smartStepTarget instanceof MethodSmartStepTarget) {
                                            return DebuggerUtilsEx.methodMatches(((MethodSmartStepTarget)smartStepTarget).getMethod(), string.replace("/", "."), string2, string3, this.val$suspendContext.getDebugProcess());
                                        }
                                        return false;
                                    });
                                }
                            }
                        }, true);
                    }
                    catch (Exception exception) {
                        a.info((Throwable)exception);
                    }
                }
                return psiElement4;
            }
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void a(Range range, SmartStepTarget smartStepTarget) {
        smartStepTarget.setCallingExpressionLines((Range<Integer>)range);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerContext", "com/intellij/debugger/actions/JavaSmartStepIntoHandler", "findSmartStepTargets"));
    }
}

