/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.VMDisconnectedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopFrameAction
extends DebuggerAction
implements DumbAware {
    private static final Logger b = Logger.getInstance(PopFrameAction.class);

    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        if (anActionEvent == null) {
            PopFrameAction.b(0);
        }
        final Project project2 = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
        final JavaStackFrame javaStackFrame = PopFrameAction.getStackFrame(anActionEvent);
        if (javaStackFrame == null || javaStackFrame.getStackFrameProxy().isBottom()) {
            return;
        }
        try {
            final DebuggerContextImpl debuggerContextImpl = DebuggerAction.getDebuggerContext(anActionEvent.getDataContext());
            final DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
            if (debugProcessImpl == null) {
                return;
            }
            debugProcessImpl.getSession().setSteppingThrough(javaStackFrame.getStackFrameProxy().threadProxy());
            if (PopFrameAction.evaluateFinallyBlocks(project2, UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.PopFrame")), javaStackFrame, new XDebuggerEvaluator.XEvaluationCallback(){

                public void evaluated(@NotNull XValue xValue) {
                    if (xValue == null) {
                        1.a(0);
                    }
                    PopFrameAction.a(debugProcessImpl, debuggerContextImpl, javaStackFrame);
                }

                public void errorOccurred(@NotNull String string) {
                    if (string == null) {
                        1.a(1);
                    }
                    PopFrameAction.showError(project2, DebuggerBundle.message((String)"error.executing.finally", (Object[])new Object[]{string}), UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.PopFrame")));
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "result";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/debugger/actions/PopFrameAction$1";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "evaluated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "errorOccurred";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            })) {
                return;
            }
            PopFrameAction.a(debugProcessImpl, debuggerContextImpl, javaStackFrame);
        }
        catch (NativeMethodException nativeMethodException) {
            Messages.showMessageDialog((Project)project2, (String)DebuggerBundle.message((String)"error.native.method.exception", (Object[])new Object[0]), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.PopFrame")), (Icon)Messages.getErrorIcon());
        }
        catch (InvalidStackFrameException | VMDisconnectedException runtimeException) {
            // empty catch block
        }
    }

    static boolean evaluateFinallyBlocks(Project project2, String string, JavaStackFrame javaStackFrame, XDebuggerEvaluator.XEvaluationCallback xEvaluationCallback) {
        List<PsiStatement> list2;
        if (!"EvaluateFinallyNever".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME) && !(list2 = PopFrameAction.a(project2, javaStackFrame.getDescriptor().getSourcePosition())).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (PsiStatement psiStatement : list2) {
                stringBuilder.append("\n").append(psiStatement.getText());
            }
            if ("EvaluateFinallyAlways".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME)) {
                PopFrameAction.a(project2, javaStackFrame, stringBuilder, xEvaluationCallback);
                return true;
            }
            int n2 = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)string, (String)(DebuggerBundle.message((String)"warning.finally.block.detected", (Object[])new Object[0]) + stringBuilder)).project(project2)).icon(Messages.getWarningIcon())).yesText(DebuggerBundle.message((String)"button.execute.finally", (Object[])new Object[0]))).noText(DebuggerBundle.message((String)"button.drop.anyway", (Object[])new Object[0]))).cancelText(CommonBundle.message((String)"button.cancel", (Object[])new Object[0])).doNotAsk(new DialogWrapper.DoNotAskOption(){

                public boolean isToBeShown() {
                    return !"EvaluateFinallyAlways".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME) && !"EvaluateFinallyNever".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME);
                }

                public void setToBeShown(boolean bl2, int n2) {
                    DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME = !bl2 ? (n2 == 0 ? "EvaluateFinallyAlways" : "EvaluateFinallyNever") : "EvaluateFinallyAsk";
                }

                public boolean canBeHidden() {
                    return true;
                }

                public boolean shouldSaveOptionsOnCancel() {
                    return false;
                }

                @NotNull
                public String getDoNotShowMessage() {
                    String string = CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                    if (string == null) {
                        2.a(0);
                    }
                    return string;
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/PopFrameAction$2", "getDoNotShowMessage"));
                }
            })).show();
            switch (n2) {
                case 2: {
                    return true;
                }
                case 1: {
                    break;
                }
                case 0: {
                    PopFrameAction.a(project2, javaStackFrame, stringBuilder, xEvaluationCallback);
                    return true;
                }
            }
        }
        return false;
    }

    private static void a(DebugProcessImpl debugProcessImpl, DebuggerContextImpl debuggerContextImpl, JavaStackFrame javaStackFrame) {
        debugProcessImpl.getManagerThread().schedule(debugProcessImpl.createPopFrameCommand(debuggerContextImpl, javaStackFrame.getStackFrameProxy()));
    }

    private static void a(Project project2, JavaStackFrame javaStackFrame, StringBuilder stringBuilder, XDebuggerEvaluator.XEvaluationCallback xEvaluationCallback) {
        XDebuggerEvaluator xDebuggerEvaluator = javaStackFrame.getEvaluator();
        if (xDebuggerEvaluator != null) {
            xDebuggerEvaluator.evaluate((XExpression)XExpressionImpl.fromText((String)stringBuilder.toString(), (EvaluationMode)EvaluationMode.CODE_FRAGMENT), xEvaluationCallback, javaStackFrame.getSourcePosition());
        } else {
            Messages.showMessageDialog((Project)project2, (String)XDebuggerBundle.message((String)"xdebugger.evaluate.stack.frame.has.not.evaluator", (Object[])new Object[0]), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.PopFrame")), (Icon)Messages.getErrorIcon());
        }
    }

    static void showError(Project project2, String string, String string2) {
        ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project2, (String)string, (String)string2, (Icon)Messages.getErrorIcon()), ModalityState.any());
    }

    private static List<PsiStatement> a(Project project2, @Nullable SourcePosition sourcePosition) {
        if (sourcePosition == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiStatement> arrayList = new ArrayList<PsiStatement>();
        PsiElement psiElement = sourcePosition.getFile().findElementAt(sourcePosition.getOffset());
        PsiTryStatement psiTryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiTryStatement.class);
        while (psiTryStatement != null) {
            PsiCodeBlock psiCodeBlock;
            PsiResourceList psiResourceList = psiTryStatement.getResourceList();
            if (psiResourceList != null) {
                psiCodeBlock = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
                for (PsiResourceListElement psiResourceListElement : psiResourceList) {
                    String string = PopFrameAction.a(psiResourceListElement);
                    if (string == null) continue;
                    arrayList.add(psiCodeBlock.createStatementFromText("if (" + string + " != null) " + string + ".close();", (PsiElement)psiTryStatement));
                }
            }
            if ((psiCodeBlock = psiTryStatement.getFinallyBlock()) != null) {
                ContainerUtil.addAll(arrayList, (Object[])psiCodeBlock.getStatements());
            }
            psiTryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)psiTryStatement, PsiTryStatement.class);
        }
        return arrayList;
    }

    private static String a(PsiResourceListElement psiResourceListElement) {
        if (psiResourceListElement instanceof PsiResourceVariable) {
            return ((PsiResourceVariable)psiResourceListElement).getName();
        }
        if (psiResourceListElement instanceof PsiResourceExpression) {
            return ((PsiResourceExpression)psiResourceListElement).getExpression().getText();
        }
        b.error("Unknown PsiResourceListElement type: " + psiResourceListElement.getClass());
        return null;
    }

    static JavaStackFrame getStackFrame(AnActionEvent anActionEvent) {
        StackFrameDescriptorImpl stackFrameDescriptorImpl = PopFrameAction.c(anActionEvent);
        if (stackFrameDescriptorImpl != null) {
            return new JavaStackFrame(stackFrameDescriptorImpl, false);
        }
        return PopFrameAction.b(anActionEvent);
    }

    static StackFrameProxyImpl getStackFrameProxy(AnActionEvent anActionEvent) {
        DebuggerTreeNodeImpl debuggerTreeNodeImpl = PopFrameAction.getSelectedNode(anActionEvent.getDataContext());
        if (debuggerTreeNodeImpl != null) {
            NodeDescriptorImpl nodeDescriptorImpl = debuggerTreeNodeImpl.getDescriptor();
            if (nodeDescriptorImpl instanceof StackFrameDescriptorImpl) {
                return ((StackFrameDescriptorImpl)nodeDescriptorImpl).getFrameProxy();
            }
        } else {
            JavaStackFrame javaStackFrame = PopFrameAction.b(anActionEvent);
            if (javaStackFrame != null) {
                return javaStackFrame.getStackFrameProxy();
            }
        }
        return null;
    }

    @Nullable
    private static StackFrameDescriptorImpl c(AnActionEvent anActionEvent) {
        NodeDescriptorImpl nodeDescriptorImpl;
        DebuggerTreeNodeImpl debuggerTreeNodeImpl = PopFrameAction.getSelectedNode(anActionEvent.getDataContext());
        if (debuggerTreeNodeImpl != null && (nodeDescriptorImpl = debuggerTreeNodeImpl.getDescriptor()) instanceof StackFrameDescriptorImpl) {
            return (StackFrameDescriptorImpl)nodeDescriptorImpl;
        }
        return null;
    }

    @Nullable
    private static JavaStackFrame b(AnActionEvent anActionEvent) {
        Project project2 = anActionEvent.getProject();
        if (project2 != null) {
            XStackFrame xStackFrame;
            XDebugSession xDebugSession = (XDebugSession)anActionEvent.getData(XDebugSession.DATA_KEY);
            if (xDebugSession == null) {
                xDebugSession = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
            }
            if (xDebugSession != null && (xStackFrame = xDebugSession.getCurrentStackFrame()) instanceof JavaStackFrame) {
                return (JavaStackFrame)xStackFrame;
            }
        }
        return null;
    }

    private static boolean a(AnActionEvent anActionEvent) {
        Object object;
        DebuggerTreeNodeImpl debuggerTreeNodeImpl = PopFrameAction.getSelectedNode(anActionEvent.getDataContext());
        if (debuggerTreeNodeImpl != null && debuggerTreeNodeImpl.getDescriptor() instanceof StackFrameDescriptorImpl && (object = debuggerTreeNodeImpl.getParent()) != null) {
            return ((ThreadDescriptorImpl)((DebuggerTreeNodeImpl)object).getDescriptor()).isAtBreakpoint();
        }
        object = DebuggerAction.getDebuggerContext(anActionEvent.getDataContext());
        SuspendContextImpl suspendContextImpl = ((DebuggerContextImpl)object).getSuspendContext();
        return suspendContextImpl != null && ((DebuggerContextImpl)object).getThreadProxy() == suspendContextImpl.getThread();
    }

    public void update(@NotNull AnActionEvent anActionEvent) {
        if (anActionEvent == null) {
            PopFrameAction.b(1);
        }
        boolean bl2 = false;
        StackFrameProxyImpl stackFrameProxyImpl = PopFrameAction.getStackFrameProxy(anActionEvent);
        if (stackFrameProxyImpl != null && !stackFrameProxyImpl.isBottom()) {
            bl2 = stackFrameProxyImpl.getVirtualMachine().canPopFrames();
        }
        if (ActionPlaces.isMainMenuOrActionSearch((String)anActionEvent.getPlace()) || "DebuggerToolbar".equals(anActionEvent.getPlace())) {
            anActionEvent.getPresentation().setEnabled(bl2);
        } else {
            anActionEvent.getPresentation().setVisible(bl2);
        }
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/debugger/actions/PopFrameAction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

