/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.ViewAsGroup;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.memory.ui.StackFramePopup;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ObjectReference;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ShowRelatedStackAction
extends AnAction {
    public void actionPerformed(AnActionEvent anActionEvent) {
        Project project2 = anActionEvent.getProject();
        List<StackFrameItem> list2 = ShowRelatedStackAction.a(anActionEvent);
        if (project2 != null && list2 != null) {
            DebugProcessImpl debugProcessImpl = DebuggerAction.getDebuggerContext(anActionEvent.getDataContext()).getDebugProcess();
            if (debugProcessImpl == null) {
                return;
            }
            StackFramePopup.show(list2, debugProcessImpl);
        }
    }

    public void update(AnActionEvent anActionEvent) {
        List<StackFrameItem> list2 = ShowRelatedStackAction.a(anActionEvent);
        anActionEvent.getPresentation().setEnabledAndVisible(list2 != null);
    }

    @Nullable
    private static List<StackFrameItem> a(AnActionEvent anActionEvent) {
        ValueDescriptorImpl valueDescriptorImpl;
        List<JavaValue> list2 = ViewAsGroup.getSelectedValues(anActionEvent);
        if (list2.size() == 1 && (valueDescriptorImpl = list2.get(0).getDescriptor()).canMark()) {
            DebuggerContextImpl debuggerContextImpl = DebuggerAction.getDebuggerContext(anActionEvent.getDataContext());
            return StackCapturingLineBreakpoint.getRelatedStack((ObjectReference)valueDescriptorImpl.getValue(), debuggerContextImpl.getDebugProcess());
        }
        return null;
    }
}

