/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ObjectReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleFieldBreakpointAction
extends AnAction {
    public void actionPerformed(AnActionEvent anActionEvent) {
        Document document;
        Project project2 = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        SourcePosition sourcePosition = ToggleFieldBreakpointAction.getPlace(anActionEvent);
        if (sourcePosition != null && (document = PsiDocumentManager.getInstance((Project)project2).getDocument(sourcePosition.getFile())) != null) {
            FieldBreakpoint fieldBreakpoint;
            DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx(project2);
            BreakpointManager breakpointManager = debuggerManagerEx.getBreakpointManager();
            int n2 = sourcePosition.getOffset();
            FieldBreakpoint fieldBreakpoint2 = fieldBreakpoint = n2 >= 0 ? breakpointManager.findBreakpoint(document, n2, FieldBreakpoint.CATEGORY) : null;
            if (fieldBreakpoint == null) {
                FieldBreakpoint fieldBreakpoint3 = breakpointManager.addFieldBreakpoint(document, n2);
                if (fieldBreakpoint3 != null) {
                    ObjectReference objectReference;
                    DebuggerTreeNodeImpl debuggerTreeNodeImpl;
                    if (DebuggerAction.isContextView(anActionEvent) && (debuggerTreeNodeImpl = DebuggerAction.getSelectedNode(anActionEvent.getDataContext())) != null && debuggerTreeNodeImpl.getDescriptor() instanceof FieldDescriptorImpl && (objectReference = ((FieldDescriptorImpl)debuggerTreeNodeImpl.getDescriptor()).getObject()) != null) {
                        long l2 = objectReference.uniqueID();
                        InstanceFilter[] instanceFilterArray = new InstanceFilter[]{InstanceFilter.create(Long.toString(l2))};
                        fieldBreakpoint3.setInstanceFilters(instanceFilterArray);
                        fieldBreakpoint3.setInstanceFiltersEnabled(true);
                    }
                    if ((debuggerTreeNodeImpl = (Editor)CommonDataKeys.EDITOR.getData(anActionEvent.getDataContext())) != null) {
                        breakpointManager.editBreakpoint(fieldBreakpoint3, (Editor)debuggerTreeNodeImpl);
                    }
                }
            } else {
                breakpointManager.removeBreakpoint(fieldBreakpoint);
            }
        }
    }

    public void update(AnActionEvent anActionEvent) {
        SourcePosition sourcePosition = ToggleFieldBreakpointAction.getPlace(anActionEvent);
        boolean bl2 = sourcePosition != null;
        Presentation presentation = anActionEvent.getPresentation();
        if ("ProjectViewPopup".equals(anActionEvent.getPlace()) || "StructureViewPopup".equals(anActionEvent.getPlace()) || "FavoritesPopup".equals(anActionEvent.getPlace())) {
            presentation.setVisible(bl2);
        } else if (DebuggerAction.isContextView(anActionEvent)) {
            Document document;
            presentation.setText(DebuggerBundle.message((String)"action.add.field.watchpoint.text", (Object[])new Object[0]));
            Project project2 = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
            if (project2 != null && sourcePosition != null && (document = PsiDocumentManager.getInstance((Project)project2).getDocument(sourcePosition.getFile())) != null) {
                FieldBreakpoint fieldBreakpoint;
                int n2 = sourcePosition.getOffset();
                BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(project2).getBreakpointManager();
                FieldBreakpoint fieldBreakpoint2 = fieldBreakpoint = n2 >= 0 ? breakpointManager.findBreakpoint(document, n2, FieldBreakpoint.CATEGORY) : null;
                if (fieldBreakpoint != null) {
                    presentation.setEnabled(false);
                    return;
                }
            }
        }
        presentation.setVisible(bl2);
    }

    @Nullable
    public static SourcePosition getPlace(AnActionEvent anActionEvent) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        DataContext dataContext = anActionEvent.getDataContext();
        Project project2 = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return null;
        }
        if ("ProjectViewPopup".equals(anActionEvent.getPlace()) || "StructureViewPopup".equals(anActionEvent.getPlace()) || "FavoritesPopup".equals(anActionEvent.getPlace())) {
            PsiElement psiElement = (PsiElement)anActionEvent.getData(CommonDataKeys.PSI_ELEMENT);
            if (psiElement instanceof PsiField) {
                return SourcePosition.createFromElement((PsiElement)psiElement);
            }
            return null;
        }
        DebuggerTreeNodeImpl debuggerTreeNodeImpl = DebuggerAction.getSelectedNode(dataContext);
        if (debuggerTreeNodeImpl != null && debuggerTreeNodeImpl.getDescriptor() instanceof FieldDescriptorImpl && (object4 = (object3 = DebuggerAction.getDebuggerContext(dataContext)).getDebugProcess()) != null) {
            object2 = new Ref(null);
            ((DebugProcessImpl)((Object)object4)).getManagerThread().invokeAndWait(new DebuggerContextCommandImpl((DebuggerContextImpl)object3, (Ref)object2, debuggerTreeNodeImpl, project2, (DebuggerContextImpl)object3){
                final /* synthetic */ Ref val$positionRef;
                final /* synthetic */ DebuggerTreeNodeImpl val$selectedNode;
                final /* synthetic */ Project val$project;
                final /* synthetic */ DebuggerContextImpl val$debuggerContext;
                {
                    this.val$positionRef = ref;
                    this.val$selectedNode = debuggerTreeNodeImpl;
                    this.val$project = project2;
                    this.val$debuggerContext = debuggerContextImpl2;
                    super(debuggerContextImpl);
                }

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.HIGH;
                }

                @Override
                public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
                    if (suspendContextImpl == null) {
                        1.c(0);
                    }
                    ApplicationManager.getApplication().runReadAction(() -> this.val$positionRef.set((Object)SourcePositionProvider.getSourcePosition(this.val$selectedNode.getDescriptor(), this.val$project, this.val$debuggerContext)));
                }

                private static /* synthetic */ void c(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/ToggleFieldBreakpointAction$1", "threadAction"));
                }
            });
            object = (SourcePosition)object2.get();
            if (object != null) {
                return object;
            }
        }
        if (DebuggerAction.isContextView(anActionEvent)) {
            object3 = (DebuggerTree)((Object)DebuggerTree.DATA_KEY.getData(dataContext));
            if (object3 != null && object3.getSelectionPath() != null && (object4 = (DebuggerTreeNodeImpl)object3.getSelectionPath().getLastPathComponent()) != null && ((DebuggerTreeNodeImpl)object4).getDescriptor() instanceof FieldDescriptorImpl) {
                PsiField psiField;
                object2 = ((FieldDescriptorImpl)((DebuggerTreeNodeImpl)object4).getDescriptor()).getField();
                object = ((DebuggerTree)((Object)object3)).getDebuggerContext().getDebuggerSession();
                PsiClass psiClass = DebuggerUtils.findClass((String)object2.declaringType().name(), (Project)project2, (GlobalSearchScope)(object != null ? ((DebuggerSession)object).getSearchScope() : GlobalSearchScope.allScope((Project)project2)));
                if (psiClass != null && (psiField = (psiClass = (PsiClass)psiClass.getNavigationElement()).findFieldByName(object2.name(), true)) != null) {
                    return SourcePosition.createFromElement((PsiElement)psiField);
                }
            }
            return null;
        }
        object3 = (Editor)anActionEvent.getData(CommonDataKeys.EDITOR);
        if (object3 == null) {
            object3 = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
        }
        if (object3 != null) {
            object4 = object3.getDocument();
            object2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile((Document)object4);
            if (object2 != null) {
                PsiField psiField;
                FileType fileType;
                object = object2.getVirtualFile();
                FileType fileType2 = fileType = object != null ? object.getFileType() : null;
                if ((StdFileTypes.JAVA == fileType || StdFileTypes.CLASS == fileType) && (psiField = FieldBreakpoint.findField(project2, (Document)object4, object3.getCaretModel().getOffset())) != null) {
                    return SourcePosition.createFromElement((PsiElement)psiField);
                }
            }
        }
        return null;
    }
}

