/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BasicStepMethodFilter;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.util.Range;
import org.jetbrains.annotations.Nullable;

public class AnonymousClassMethodFilter
extends BasicStepMethodFilter
implements BreakpointStepMethodFilter {
    @Nullable
    private final SourcePosition e;
    private final int d;

    public AnonymousClassMethodFilter(PsiMethod psiMethod, Range<Integer> range) {
        super(psiMethod, range);
        PsiStatement[] psiStatementArray;
        PsiCodeBlock psiCodeBlock;
        SourcePosition sourcePosition = null;
        SourcePosition sourcePosition2 = null;
        PsiElement psiElement = psiMethod.getNavigationElement();
        if (psiElement instanceof PsiMethod) {
            psiMethod = (PsiMethod)psiElement;
        }
        if ((psiCodeBlock = psiMethod.getBody()) != null && (psiStatementArray = psiCodeBlock.getStatements()).length > 0 && (sourcePosition = SourcePosition.createFromElement((PsiElement)psiStatementArray[0])) != null) {
            PsiStatement psiStatement = psiStatementArray[psiStatementArray.length - 1];
            sourcePosition2 = SourcePosition.createFromOffset((PsiFile)sourcePosition.getFile(), (int)psiStatement.getTextRange().getEndOffset());
        }
        this.e = sourcePosition;
        this.d = sourcePosition2 != null ? sourcePosition2.getLine() : -1;
    }

    @Override
    @Nullable
    public SourcePosition getBreakpointPosition() {
        return this.e;
    }

    @Override
    public int getLastStatementLine() {
        return this.d;
    }
}

