/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.AnonymousClassMethodFilter;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.ConstructorStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Range;
import com.sun.jdi.ObjectReference;
import org.jetbrains.annotations.NotNull;

public class ClassInstanceMethodFilter
extends ConstructorStepMethodFilter {
    private final BreakpointStepMethodFilter d;

    public ClassInstanceMethodFilter(PsiMethod psiMethod, Range<Integer> range) {
        super(psiMethod.getContainingClass(), range);
        this.d = new AnonymousClassMethodFilter(psiMethod, this.getCallingExpressionLines());
    }

    @Override
    public int onReached(SuspendContextImpl suspendContextImpl, RequestHint requestHint) {
        StackFrameProxyImpl stackFrameProxyImpl = suspendContextImpl.getFrameProxy();
        if (stackFrameProxyImpl != null) {
            try {
                StepIntoBreakpoint stepIntoBreakpoint;
                ObjectReference objectReference = stackFrameProxyImpl.thisObject();
                if (objectReference != null && (stepIntoBreakpoint = DebuggerManagerEx.getInstanceEx(suspendContextImpl.getDebugProcess().getProject()).getBreakpointManager().addStepIntoBreakpoint(this.d)) != null) {
                    stepIntoBreakpoint.addInstanceFilter(objectReference.uniqueID());
                    stepIntoBreakpoint.setInstanceFiltersEnabled(true);
                    ClassInstanceMethodFilter.setUpStepIntoBreakpoint(suspendContextImpl, stepIntoBreakpoint, requestHint);
                    return -100;
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        return 0;
    }

    static void setUpStepIntoBreakpoint(SuspendContextImpl suspendContextImpl, @NotNull StepIntoBreakpoint stepIntoBreakpoint, RequestHint requestHint) {
        if (stepIntoBreakpoint == null) {
            ClassInstanceMethodFilter.c(0);
        }
        DebugProcessImpl debugProcessImpl = suspendContextImpl.getDebugProcess();
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(debugProcessImpl.getProject()).getBreakpointManager();
        breakpointManager.applyThreadFilter(debugProcessImpl, null);
        stepIntoBreakpoint.setSuspendPolicy(suspendContextImpl.getSuspendPolicy() == 1 ? "SuspendThread" : "SuspendAll");
        stepIntoBreakpoint.createRequest(debugProcessImpl);
        stepIntoBreakpoint.setRequestHint(requestHint);
        debugProcessImpl.setRunToCursorBreakpoint(stepIntoBreakpoint);
    }

    private static /* synthetic */ void c(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/engine/ClassInstanceMethodFilter", "setUpStepIntoBreakpoint"));
    }
}

