/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.Method;
import org.jetbrains.annotations.NotNull;

class JavaFramesListRenderer {
    private final EditorColorsScheme a = EditorColorsManager.getInstance().getGlobalScheme();

    public void customizePresentation(StackFrameDescriptorImpl stackFrameDescriptorImpl, @NotNull ColoredTextContainer coloredTextContainer, StackFrameDescriptorImpl stackFrameDescriptorImpl2) {
        if (coloredTextContainer == null) {
            JavaFramesListRenderer.a(0);
        }
        coloredTextContainer.setIcon(stackFrameDescriptorImpl.getIcon());
        boolean bl2 = JavaFramesListRenderer.a(stackFrameDescriptorImpl2, stackFrameDescriptorImpl);
        ValueMarkup valueMarkup = stackFrameDescriptorImpl.getValueMarkup();
        if (valueMarkup != null) {
            coloredTextContainer.append("[" + valueMarkup.getText() + "] ", new SimpleTextAttributes(1, valueMarkup.getColor()));
        }
        boolean bl3 = false;
        String string = stackFrameDescriptorImpl.getLabel();
        int n2 = string.indexOf("{");
        int n3 = n2 < 0 ? -1 : string.indexOf("}");
        SimpleTextAttributes simpleTextAttributes = JavaFramesListRenderer.a(stackFrameDescriptorImpl);
        if (n2 < 0 || n3 < 0) {
            coloredTextContainer.append(string, simpleTextAttributes);
        } else {
            coloredTextContainer.append(string.substring(0, n2 - 1), simpleTextAttributes);
            coloredTextContainer.append(" (" + string.substring(n2 + 1, n3) + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            coloredTextContainer.append(string.substring(n3 + 1, string.length()), simpleTextAttributes);
            if (bl2 && stackFrameDescriptorImpl.isRecursiveCall()) {
                coloredTextContainer.append(" [" + stackFrameDescriptorImpl.getOccurrenceIndex() + "]", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
        }
    }

    private static boolean a(StackFrameDescriptorImpl stackFrameDescriptorImpl, StackFrameDescriptorImpl stackFrameDescriptorImpl2) {
        Method method;
        Method method2 = stackFrameDescriptorImpl2.getMethod();
        return method2 != null && stackFrameDescriptorImpl != null && (method = stackFrameDescriptorImpl.getMethod()) != null && Comparing.equal((Object)method, (Object)method2);
    }

    private static SimpleTextAttributes a(StackFrameDescriptorImpl stackFrameDescriptorImpl) {
        if (stackFrameDescriptorImpl.isSynthetic() || stackFrameDescriptorImpl.isInLibraryContent()) {
            return SimpleTextAttributes.GRAYED_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/debugger/engine/JavaFramesListRenderer", "customizePresentation"));
    }
}

