/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JavaReferringObjectsValue;
import com.intellij.debugger.actions.JumpToObjectAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.CompoundNodeRenderer;
import com.intellij.debugger.ui.tree.render.CompoundTypeRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.evaluation.XInstanceEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XReferrersProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XErrorValuePresentation;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.XValueCompactPresentation;
import com.intellij.xdebugger.impl.frame.XValueWithInlinePresentation;
import com.intellij.xdebugger.impl.ui.XValueTextProvider;
import com.intellij.xdebugger.impl.ui.tree.XValueExtendedPresentation;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class JavaValue
extends XNamedValue
implements NodeDescriptorProvider,
XValueTextProvider,
XValueWithInlinePresentation {
    private static final Logger b = Logger.getInstance(JavaValue.class);
    private final JavaValue e;
    private final ValueDescriptorImpl a;
    private final EvaluationContextImpl d;
    private final NodeManagerImpl c;
    private final boolean h;
    private int g;
    private volatile XExpression f;

    protected JavaValue(JavaValue javaValue, @NotNull ValueDescriptorImpl valueDescriptorImpl, @NotNull EvaluationContextImpl evaluationContextImpl, NodeManagerImpl nodeManagerImpl, boolean bl2) {
        if (valueDescriptorImpl == null) {
            JavaValue.a(0);
        }
        if (evaluationContextImpl == null) {
            JavaValue.a(1);
        }
        super(valueDescriptorImpl.calcValueName());
        this.g = -1;
        this.f = null;
        this.e = javaValue;
        this.a = valueDescriptorImpl;
        this.d = evaluationContextImpl;
        this.c = nodeManagerImpl;
        this.h = bl2;
    }

    public static JavaValue create(JavaValue javaValue, @NotNull ValueDescriptorImpl valueDescriptorImpl, @NotNull EvaluationContextImpl evaluationContextImpl, NodeManagerImpl nodeManagerImpl, boolean bl2) {
        if (valueDescriptorImpl == null) {
            JavaValue.a(2);
        }
        if (evaluationContextImpl == null) {
            JavaValue.a(3);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return new JavaValue(javaValue, valueDescriptorImpl, evaluationContextImpl, nodeManagerImpl, bl2);
    }

    static JavaValue create(@NotNull ValueDescriptorImpl valueDescriptorImpl, @NotNull EvaluationContextImpl evaluationContextImpl, NodeManagerImpl nodeManagerImpl) {
        if (valueDescriptorImpl == null) {
            JavaValue.a(4);
        }
        if (evaluationContextImpl == null) {
            JavaValue.a(5);
        }
        return JavaValue.create(null, valueDescriptorImpl, evaluationContextImpl, nodeManagerImpl, false);
    }

    public JavaValue getParent() {
        return this.e;
    }

    @Override
    @NotNull
    public ValueDescriptorImpl getDescriptor() {
        ValueDescriptorImpl valueDescriptorImpl = this.a;
        if (valueDescriptorImpl == null) {
            JavaValue.a(6);
        }
        return valueDescriptorImpl;
    }

    @NotNull
    public EvaluationContextImpl getEvaluationContext() {
        EvaluationContextImpl evaluationContextImpl = this.d;
        if (evaluationContextImpl == null) {
            JavaValue.a(7);
        }
        return evaluationContextImpl;
    }

    public NodeManagerImpl getNodeManager() {
        return this.c;
    }

    private boolean a() {
        return OnDemandRenderer.ON_DEMAND_CALCULATED.isIn((UserDataHolder)this.a);
    }

    private boolean c() {
        return OnDemandRenderer.isCalculated(this.a);
    }

    public void computePresentation(final @NotNull XValueNode xValueNode, @NotNull XValuePlace xValuePlace) {
        if (xValueNode == null) {
            JavaValue.a(8);
        }
        if (xValuePlace == null) {
            JavaValue.a(9);
        }
        if (this.a() && !this.c()) {
            xValueNode.setFullValueEvaluator(OnDemandRenderer.createFullValueEvaluator(DebuggerBundle.message((String)"message.node.evaluate", (Object[])new Object[0])));
            xValueNode.setPresentation(AllIcons.Debugger.Watch, (XValuePresentation)new XRegularValuePresentation("", null, ""), false);
            return;
        }
        this.d.getManagerThread().schedule(new SuspendContextCommandImpl(this.d.getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            protected void commandCancelled() {
                xValueNode.setPresentation(null, (XValuePresentation)new XErrorValuePresentation(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0])), false);
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) throws Exception {
                if (suspendContextImpl == null) {
                    1.b(0);
                }
                if (xValueNode.isObsolete()) {
                    return;
                }
                if (!JavaValue.this.h) {
                    JavaValue.this.a.setContext(JavaValue.this.d);
                }
                JavaValue.this.a.updateRepresentation(JavaValue.this.d, new DescriptorLabelListener(){

                    @Override
                    public void labelChanged() {
                        Icon icon = DebuggerTreeRenderer.getValueIcon(JavaValue.this.a, JavaValue.this.e != null ? JavaValue.this.e.getDescriptor() : null);
                        String string = JavaValue.this.getValueString();
                        EvaluateException evaluateException = JavaValue.this.a.getEvaluateException();
                        JavaValuePresentation javaValuePresentation = new JavaValuePresentation(string, JavaValue.this.a.getIdLabel(), evaluateException != null ? evaluateException.getMessage() : null, JavaValue.this.a);
                        Renderer renderer = JavaValue.this.a.getLastRenderer();
                        boolean bl2 = this.a(renderer);
                        if (!bl2 && renderer instanceof CompoundNodeRenderer) {
                            bl2 = this.a(((CompoundNodeRenderer)renderer).getLabelRenderer());
                        }
                        if (!bl2 && string.length() > 1000) {
                            xValueNode.setFullValueEvaluator((XFullValueEvaluator)new JavaFullValueEvaluator(JavaValue.this.d){

                                @Override
                                public void evaluate(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback xFullValueEvaluationCallback) {
                                    if (xFullValueEvaluationCallback == null) {
                                        1.b(0);
                                    }
                                    final ValueDescriptorImpl valueDescriptorImpl = JavaValue.this.a.getFullValueDescriptor();
                                    valueDescriptorImpl.updateRepresentation(this.myEvaluationContext, new DescriptorLabelListener(){

                                        @Override
                                        public void labelChanged() {
                                            xFullValueEvaluationCallback.evaluated(valueDescriptorImpl.getValueText());
                                        }
                                    });
                                }

                                private static /* synthetic */ void b(int n2) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/engine/JavaValue$1$1$1", "evaluate"));
                                }
                            });
                        }
                        xValueNode.setPresentation(icon, (XValuePresentation)javaValuePresentation, JavaValue.this.a.isExpandable());
                    }

                    private boolean a(Renderer renderer) {
                        XFullValueEvaluator xFullValueEvaluator;
                        if (renderer instanceof FullValueEvaluatorProvider && (xFullValueEvaluator = ((FullValueEvaluatorProvider)((Object)renderer)).getFullValueEvaluator(JavaValue.this.d, JavaValue.this.a)) != null) {
                            xValueNode.setFullValueEvaluator(xFullValueEvaluator);
                            return true;
                        }
                        return false;
                    }
                });
            }

            private static /* synthetic */ void b(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValue$1", "contextAction"));
            }
        });
    }

    private static String a(@NotNull String string) {
        if (string == null) {
            JavaValue.a(10);
        }
        return string.substring(0, Math.min(string.length(), 1000));
    }

    @NotNull
    String getValueString() {
        String string = this.a.getValueText();
        if (string == null) {
            JavaValue.a(11);
        }
        return string;
    }

    public void computeChildren(final @NotNull XCompositeNode xCompositeNode) {
        if (xCompositeNode == null) {
            JavaValue.a(12);
        }
        JavaValue.scheduleCommand(this.d, xCompositeNode, new SuspendContextCommandImpl(this.d.getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) {
                if (suspendContextImpl == null) {
                    2.b(0);
                }
                JavaValue.this.a.getChildrenRenderer(JavaValue.this.d.getDebugProcess()).buildChildren(JavaValue.this.a.getValue(), new ChildrenBuilder(){

                    @Override
                    public NodeDescriptorFactory getDescriptorManager() {
                        return JavaValue.this.c;
                    }

                    @Override
                    public NodeManager getNodeManager() {
                        return JavaValue.this.c;
                    }

                    @Override
                    public ValueDescriptor getParentDescriptor() {
                        return JavaValue.this.a;
                    }

                    @Override
                    public void initChildrenArrayRenderer(ArrayRenderer arrayRenderer, int n2) {
                        arrayRenderer.START_INDEX = 0;
                        if (JavaValue.this.g >= 0) {
                            arrayRenderer.START_INDEX = Math.max(0, n2 - JavaValue.this.g);
                        }
                    }

                    @Override
                    public void addChildren(List<DebuggerTreeNode> list2, boolean bl2) {
                        XValueChildrenList xValueChildrenList = XValueChildrenList.EMPTY;
                        if (!list2.isEmpty()) {
                            xValueChildrenList = new XValueChildrenList(list2.size());
                            for (DebuggerTreeNode debuggerTreeNode : list2) {
                                NodeDescriptor nodeDescriptor = debuggerTreeNode.getDescriptor();
                                if (nodeDescriptor instanceof ValueDescriptorImpl) {
                                    xValueChildrenList.add((XNamedValue)JavaValue.create(JavaValue.this, (ValueDescriptorImpl)nodeDescriptor, JavaValue.this.d, JavaValue.this.c, false));
                                    continue;
                                }
                                if (!(nodeDescriptor instanceof MessageDescriptor)) continue;
                                xValueChildrenList.add((XNamedValue)new JavaStackFrame.DummyMessageValueNode(nodeDescriptor.getLabel(), DebuggerTreeRenderer.getDescriptorIcon(nodeDescriptor)));
                            }
                        }
                        xCompositeNode.addChildren(xValueChildrenList, bl2);
                    }

                    @Override
                    public void setChildren(List<DebuggerTreeNode> list2) {
                        this.addChildren(list2, true);
                    }

                    public void setMessage(@NotNull String string, @Nullable Icon icon, @NotNull SimpleTextAttributes simpleTextAttributes, @Nullable XDebuggerTreeNodeHyperlink xDebuggerTreeNodeHyperlink) {
                        if (string == null) {
                            1.a(0);
                        }
                        if (simpleTextAttributes == null) {
                            1.a(1);
                        }
                        xCompositeNode.setMessage(string, icon, simpleTextAttributes, xDebuggerTreeNodeHyperlink);
                    }

                    public void addChildren(@NotNull XValueChildrenList xValueChildrenList, boolean bl2) {
                        if (xValueChildrenList == null) {
                            1.a(2);
                        }
                        xCompositeNode.addChildren(xValueChildrenList, bl2);
                    }

                    public void tooManyChildren(int n2) {
                        JavaValue.this.g = n2;
                        xCompositeNode.tooManyChildren(n2);
                    }

                    public void setAlreadySorted(boolean bl2) {
                        xCompositeNode.setAlreadySorted(bl2);
                    }

                    public void setErrorMessage(@NotNull String string) {
                        if (string == null) {
                            1.a(3);
                        }
                        xCompositeNode.setErrorMessage(string);
                    }

                    public void setErrorMessage(@NotNull String string, @Nullable XDebuggerTreeNodeHyperlink xDebuggerTreeNodeHyperlink) {
                        if (string == null) {
                            1.a(4);
                        }
                        xCompositeNode.setErrorMessage(string, xDebuggerTreeNodeHyperlink);
                    }

                    public boolean isObsolete() {
                        return xCompositeNode.isObsolete();
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "message";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "attributes";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "children";
                                break;
                            }
                            case 3: 
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "errorMessage";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/debugger/engine/JavaValue$2$1";
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "setMessage";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "addChildren";
                                break;
                            }
                            case 3: 
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[2] = "setErrorMessage";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, JavaValue.this.d);
            }

            private static /* synthetic */ void b(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValue$2", "contextAction"));
            }
        });
    }

    protected static boolean scheduleCommand(EvaluationContextImpl evaluationContextImpl, final @NotNull XCompositeNode xCompositeNode, final SuspendContextCommandImpl suspendContextCommandImpl) {
        if (xCompositeNode == null) {
            JavaValue.a(13);
        }
        if (xCompositeNode.isObsolete()) {
            return false;
        }
        evaluationContextImpl.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContextCommandImpl.getSuspendContext()){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) throws Exception {
                if (suspendContextImpl == null) {
                    3.b(0);
                }
                if (xCompositeNode.isObsolete()) {
                    return;
                }
                suspendContextCommandImpl.contextAction(suspendContextImpl);
            }

            @Override
            protected void commandCancelled() {
                xCompositeNode.setErrorMessage(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
            }

            private static /* synthetic */ void b(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValue$3", "contextAction"));
            }
        });
        return true;
    }

    public void computeSourcePosition(@NotNull XNavigatable xNavigatable) {
        if (xNavigatable == null) {
            JavaValue.a(14);
        }
        this.a(xNavigatable, false);
    }

    private void a(final @NotNull XNavigatable xNavigatable, final boolean bl2) {
        if (xNavigatable == null) {
            JavaValue.a(15);
        }
        this.d.getManagerThread().schedule(new SuspendContextCommandImpl(this.d.getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return bl2 ? PrioritizedTask.Priority.LOWEST : PrioritizedTask.Priority.NORMAL;
            }

            @Override
            protected void commandCancelled() {
                xNavigatable.setSourcePosition(null);
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) throws Exception {
                if (suspendContextImpl == null) {
                    4.b(0);
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    SourcePosition sourcePosition;
                    if (xNavigatable == null) {
                        4.b(1);
                    }
                    if ((sourcePosition = SourcePositionProvider.getSourcePosition(JavaValue.this.a, JavaValue.this.getProject(), JavaValue.this.b(), false)) != null) {
                        xNavigatable.setSourcePosition(DebuggerUtilsEx.toXSourcePosition(sourcePosition));
                    }
                    if (bl2 && (sourcePosition = SourcePositionProvider.getSourcePosition(JavaValue.this.a, JavaValue.this.getProject(), JavaValue.this.b(), true)) != null) {
                        xNavigatable.setSourcePosition(DebuggerUtilsEx.toXSourcePosition(sourcePosition));
                    }
                });
            }

            private static /* synthetic */ void b(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "suspendContext";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "navigatable";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/debugger/engine/JavaValue$4";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contextAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$contextAction$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback xInlineDebuggerDataCallback) {
        if (xInlineDebuggerDataCallback == null) {
            JavaValue.a(16);
        }
        this.a(arg_0 -> ((XInlineDebuggerDataCallback)xInlineDebuggerDataCallback).computed(arg_0), true);
        ThreeState threeState = ThreeState.YES;
        if (threeState == null) {
            JavaValue.a(17);
        }
        return threeState;
    }

    private DebuggerContextImpl b() {
        return this.d.getDebugProcess().getDebuggerContext();
    }

    public Project getProject() {
        return this.a.getProject();
    }

    public boolean canNavigateToTypeSource() {
        return true;
    }

    public void computeTypeSourcePosition(final @NotNull XNavigatable xNavigatable) {
        if (xNavigatable == null) {
            JavaValue.a(18);
        }
        if (this.d.getSuspendContext().isResumed()) {
            return;
        }
        DebugProcessImpl debugProcessImpl = this.d.getDebugProcess();
        debugProcessImpl.getManagerThread().schedule(new JumpToObjectAction.NavigateCommand(this.b(), this.a, debugProcessImpl, null){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            protected void doAction(@Nullable SourcePosition sourcePosition) {
                if (sourcePosition != null) {
                    ApplicationManager.getApplication().runReadAction(() -> {
                        if (xNavigatable == null) {
                            5.c(0);
                        }
                        xNavigatable.setSourcePosition(DebuggerUtilsEx.toXSourcePosition(sourcePosition));
                    });
                }
            }

            private static /* synthetic */ void c(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/debugger/engine/JavaValue$5", "lambda$doAction$0"));
            }
        });
    }

    @Nullable
    public XValueModifier getModifier() {
        return this.a.canSetValue() ? this.a.getModifier(this) : null;
    }

    @NotNull
    public Promise<XExpression> calculateEvaluationExpression() {
        if (this.f != null) {
            Promise promise = Promise.resolve((Object)this.f);
            if (promise == null) {
                JavaValue.a(19);
            }
            return promise;
        }
        final AsyncPromise asyncPromise = new AsyncPromise();
        this.d.getManagerThread().schedule(new SuspendContextCommandImpl(this.d.getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) throws Exception {
                if (suspendContextImpl == null) {
                    6.b(0);
                }
                JavaValue.this.f = (XExpression)ReadAction.compute(() -> {
                    try {
                        PsiElement psiElement = JavaValue.this.getDescriptor().getTreeEvaluation(JavaValue.this, JavaValue.this.b());
                        if (psiElement != null) {
                            XExpression xExpression = TextWithImportsImpl.toXExpression(new TextWithImportsImpl(psiElement));
                            Set set = (Set)psiElement.getUserData(DebuggerTreeNodeExpression.ADDITIONAL_IMPORTS_KEY);
                            if (set != null && xExpression != null) {
                                if (xExpression.getCustomInfo() != null) {
                                    set.add(xExpression.getCustomInfo());
                                }
                                xExpression = new XExpressionImpl(xExpression.getExpression(), xExpression.getLanguage(), StringUtil.join((Collection)set, (String)","), xExpression.getMode());
                            }
                            return xExpression;
                        }
                    }
                    catch (EvaluateException evaluateException) {
                        b.info((Throwable)evaluateException);
                    }
                    return null;
                });
                asyncPromise.setResult((Object)JavaValue.this.f);
            }

            private static /* synthetic */ void b(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValue$6", "contextAction"));
            }
        });
        AsyncPromise asyncPromise2 = asyncPromise;
        if (asyncPromise2 == null) {
            JavaValue.a(20);
        }
        return asyncPromise2;
    }

    public String getValueText() {
        return this.a.getValueText();
    }

    @Nullable
    public XReferrersProvider getReferrersProvider() {
        return new XReferrersProvider(){

            public XValue getReferringObjectsValue() {
                return new JavaReferringObjectsValue(JavaValue.this, false);
            }
        };
    }

    @Nullable
    public XInstanceEvaluator getInstanceEvaluator() {
        return new XInstanceEvaluator(){

            public void evaluate(final @NotNull XDebuggerEvaluator.XEvaluationCallback xEvaluationCallback, final @NotNull XStackFrame xStackFrame) {
                if (xEvaluationCallback == null) {
                    8.a(0);
                }
                if (xStackFrame == null) {
                    8.a(1);
                }
                JavaValue.this.d.getManagerThread().schedule(new DebuggerCommandImpl(){

                    @Override
                    protected void commandCancelled() {
                        xEvaluationCallback.errorOccurred(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
                    }

                    @Override
                    protected void action() throws Exception {
                        NodeDescriptor nodeDescriptor;
                        Object object;
                        ValueDescriptorImpl valueDescriptorImpl = JavaValue.this.a;
                        if (JavaValue.this.a instanceof WatchItemDescriptor && (object = ((WatchItemDescriptor)JavaValue.this.a).getModifier()) != null && (nodeDescriptor = object.getInspectItem(JavaValue.this.getProject())) != null) {
                            valueDescriptorImpl = (ValueDescriptorImpl)nodeDescriptor;
                        }
                        if ((object = ((JavaStackFrame)xStackFrame).getFrameDebuggerContext(null).createEvaluationContext()) != null) {
                            xEvaluationCallback.evaluated((XValue)JavaValue.create(valueDescriptorImpl, (EvaluationContextImpl)object, JavaValue.this.c));
                        } else {
                            xEvaluationCallback.errorOccurred("Context is not available");
                        }
                    }
                });
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "frame";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/engine/JavaValue$8";
                objectArray[2] = "evaluate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public void setRenderer(NodeRenderer nodeRenderer, XValueNodeImpl xValueNodeImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.a.setRenderer(nodeRenderer);
        this.reBuild(xValueNodeImpl);
    }

    public void reBuild(XValueNodeImpl xValueNodeImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.g = -1;
        xValueNodeImpl.invokeNodeUpdate(() -> {
            xValueNodeImpl.clearChildren();
            this.computePresentation((XValueNode)xValueNodeImpl, XValuePlace.TREE);
        });
    }

    @Nullable
    public String computeInlinePresentation() {
        ValueDescriptorImpl valueDescriptorImpl = this.getDescriptor();
        return valueDescriptorImpl.isNull() || valueDescriptorImpl.isPrimitive() ? valueDescriptorImpl.getValueText() : null;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 17: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 17: 
            case 19: 
            case 20: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDescriptor";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaValue";
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationContext";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueString";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInlineDebuggerData";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateEvaluationExpression";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "truncateToMaxLength";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "scheduleCommand";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeSourcePosition";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computeInlineDebuggerData";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "computeTypeSourcePosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 17: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JavaValuePresentation
    extends XValueExtendedPresentation
    implements XValueCompactPresentation {
        private final String a;
        private final String d;
        private final String c;
        private final ValueDescriptorImpl b;

        public JavaValuePresentation(@NotNull String string, @Nullable String string2, @Nullable String string3, ValueDescriptorImpl valueDescriptorImpl) {
            if (string == null) {
                JavaValuePresentation.a(0);
            }
            this.a = string;
            this.d = string2;
            this.c = string3;
            this.b = valueDescriptorImpl;
        }

        @Nullable
        public String getType() {
            return StringUtil.nullize((String)this.d);
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer xValueTextRenderer) {
            if (xValueTextRenderer == null) {
                JavaValuePresentation.a(1);
            }
            this.renderValue(xValueTextRenderer, null);
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer xValueTextRenderer, @Nullable XValueNodeImpl xValueNodeImpl) {
            boolean bl2;
            if (xValueTextRenderer == null) {
                JavaValuePresentation.a(2);
            }
            boolean bl3 = bl2 = xValueNodeImpl != null;
            if (this.c != null) {
                if (this.a.endsWith(this.c)) {
                    xValueTextRenderer.renderValue(this.a.substring(0, this.a.length() - this.c.length()));
                }
                xValueTextRenderer.renderError(this.c);
            } else {
                Object object;
                Object object2;
                if (bl2 && xValueNodeImpl.getValueContainer() instanceof JavaValue && ((JavaValue)(object2 = (JavaValue)xValueNodeImpl.getValueContainer())).getDescriptor().isArray()) {
                    String string;
                    object = (ArrayReference)((JavaValue)object2).getDescriptor().getValue();
                    ArrayType arrayType = (ArrayType)((JavaValue)object2).getDescriptor().getType();
                    if (arrayType != null && (TypeConversionUtil.isPrimitive((String)(string = arrayType.componentTypeName())) || "java.lang.String".equals(string))) {
                        int n2 = object.length();
                        int n3 = Math.min(n2, "java.lang.String".equals(string) ? 5 : 10);
                        List<Value> list2 = object.getValues(0, n3);
                        ArrayList<String> arrayList = new ArrayList<String>(n3);
                        for (int i2 = 0; i2 < list2.size(); ++i2) {
                            arrayList.add(StringUtil.first((String)list2.get(i2).toString(), (int)15, (boolean)true));
                        }
                        String string2 = "";
                        if (arrayList.size() < n2) {
                            string2 = ", + " + (n2 - arrayList.size()) + " more";
                        }
                        xValueTextRenderer.renderValue("{" + StringUtil.join(arrayList, (String)", ") + string2 + "}");
                        return;
                    }
                }
                if (this.b.isString()) {
                    xValueTextRenderer.renderStringValue(this.a, "\"", 1000);
                    return;
                }
                object2 = JavaValue.a(this.a);
                object = this.b.getLastRenderer();
                if (object instanceof CompoundTypeRenderer) {
                    object = ((CompoundTypeRenderer)object).getLabelRenderer();
                }
                if (object instanceof ToStringRenderer) {
                    if (!((ToStringRenderer)object).isShowValue(this.b, this.b.getStoredEvaluationContext())) {
                        return;
                    }
                    object2 = StringUtil.wrapWithDoubleQuote((String)object2);
                }
                xValueTextRenderer.renderValue((String)object2);
            }
        }

        @NotNull
        public String getSeparator() {
            boolean bl2 = !this.b.isShowIdLabel() && this.a();
            String string = this.b.getDeclaredTypeLabel();
            if (!StringUtil.isEmpty((String)string)) {
                String string2 = bl2 ? string : string + " " + " = ";
                if (string2 == null) {
                    JavaValuePresentation.a(3);
                }
                return string2;
            }
            String string3 = bl2 ? "" : " = ";
            if (string3 == null) {
                JavaValuePresentation.a(4);
            }
            return string3;
        }

        public boolean isModified() {
            return this.b.isDirty();
        }

        private boolean a() {
            MyEmptyContainerChecker myEmptyContainerChecker = new MyEmptyContainerChecker();
            this.renderValue((XValuePresentation.XValueTextRenderer)new XValueTextRendererImpl((ColoredTextContainer)myEmptyContainerChecker));
            return myEmptyContainerChecker.isEmpty;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/JavaValue$JavaValuePresentation";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/JavaValue$JavaValuePresentation";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeparator";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "renderValue";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class MyEmptyContainerChecker
        implements ColoredTextContainer {
            boolean isEmpty = true;

            private MyEmptyContainerChecker() {
            }

            public void append(@NotNull String string, @NotNull SimpleTextAttributes simpleTextAttributes) {
                if (string == null) {
                    MyEmptyContainerChecker.a(0);
                }
                if (simpleTextAttributes == null) {
                    MyEmptyContainerChecker.a(1);
                }
                if (!string.isEmpty()) {
                    this.isEmpty = false;
                }
            }

            public void append(@NotNull String string, @NotNull SimpleTextAttributes simpleTextAttributes, Object object) {
                if (string == null) {
                    MyEmptyContainerChecker.a(2);
                }
                if (simpleTextAttributes == null) {
                    MyEmptyContainerChecker.a(3);
                }
                this.append(string, simpleTextAttributes);
            }

            public void setIcon(@Nullable Icon icon) {
            }

            public void setToolTipText(@Nullable String string) {
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fragment";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "attributes";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/engine/JavaValue$JavaValuePresentation$MyEmptyContainerChecker";
                objectArray[2] = "append";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static abstract class JavaFullValueEvaluator
    extends XFullValueEvaluator {
        protected final EvaluationContextImpl myEvaluationContext;

        public JavaFullValueEvaluator(@NotNull String string, EvaluationContextImpl evaluationContextImpl) {
            if (string == null) {
                JavaFullValueEvaluator.a(0);
            }
            super(string);
            this.myEvaluationContext = evaluationContextImpl;
        }

        public JavaFullValueEvaluator(EvaluationContextImpl evaluationContextImpl) {
            this.myEvaluationContext = evaluationContextImpl;
        }

        public abstract void evaluate(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback var1) throws Exception;

        protected EvaluationContextImpl getEvaluationContext() {
            return this.myEvaluationContext;
        }

        public void startEvaluation(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback xFullValueEvaluationCallback) {
            if (xFullValueEvaluationCallback == null) {
                JavaFullValueEvaluator.a(1);
            }
            if (xFullValueEvaluationCallback.isObsolete()) {
                return;
            }
            this.myEvaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.NORMAL;
                }

                @Override
                protected void commandCancelled() {
                    xFullValueEvaluationCallback.errorOccurred(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
                }

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) throws Exception {
                    if (suspendContextImpl == null) {
                        1.b(0);
                    }
                    if (xFullValueEvaluationCallback.isObsolete()) {
                        return;
                    }
                    this.evaluate(xFullValueEvaluationCallback);
                }

                private static /* synthetic */ void b(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValue$JavaFullValueEvaluator$1", "contextAction"));
                }
            });
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "linkText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/engine/JavaValue$JavaFullValueEvaluator";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startEvaluation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

