/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.BoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.IdentityEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public abstract class JavaValueModifier
extends XValueModifier {
    private final JavaValue a;

    public JavaValueModifier(JavaValue javaValue) {
        this.a = javaValue;
    }

    public void calculateInitialValueEditorText(final XValueModifier.XInitialValueCallback xInitialValueCallback) {
        final Value value = this.a.getDescriptor().getValue();
        if (value == null || value instanceof PrimitiveValue) {
            String string = this.a.getValueString();
            int n2 = string.lastIndexOf(40);
            if (n2 > 1) {
                string = string.substring(0, n2).trim();
            }
            xInitialValueCallback.setValue(string);
        } else if (value instanceof StringReference) {
            final EvaluationContextImpl evaluationContextImpl = this.a.getEvaluationContext();
            evaluationContextImpl.getManagerThread().schedule(new SuspendContextCommandImpl(evaluationContextImpl.getSuspendContext()){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.NORMAL;
                }

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) throws Exception {
                    if (suspendContextImpl == null) {
                        1.b(0);
                    }
                    xInitialValueCallback.setValue(StringUtil.wrapWithDoubleQuote((String)DebuggerUtils.translateStringValue((String)DebuggerUtils.getValueAsString((EvaluationContext)evaluationContextImpl, (Value)value))));
                }

                private static /* synthetic */ void b(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValueModifier$1", "contextAction"));
                }
            });
        } else {
            xInitialValueCallback.setValue(null);
        }
    }

    protected static void update(DebuggerContextImpl debuggerContextImpl) {
        DebuggerInvocationUtil.swingInvokeLater(debuggerContextImpl.getProject(), () -> {
            DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
            if (debuggerSession != null) {
                debuggerSession.refresh(false);
            }
        });
    }

    protected abstract void setValueImpl(@NotNull XExpression var1, @NotNull XValueModifier.XModificationCallback var2);

    public void setValue(@NotNull XExpression xExpression, @NotNull XValueModifier.XModificationCallback xModificationCallback) {
        ValueDescriptorImpl valueDescriptorImpl;
        if (xExpression == null) {
            JavaValueModifier.a(0);
        }
        if (xModificationCallback == null) {
            JavaValueModifier.a(1);
        }
        if (!(valueDescriptorImpl = this.a.getDescriptor()).canSetValue()) {
            return;
        }
        if (this.a.getEvaluationContext().getSuspendContext().isResumed()) {
            xModificationCallback.errorOccurred(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
            return;
        }
        this.setValueImpl(xExpression, xModificationCallback);
    }

    protected static Value preprocessValue(EvaluationContextImpl evaluationContextImpl, Value value, Type type) throws EvaluateException {
        String string;
        if (value != null && "java.lang.String".equals(type.name()) && !(value instanceof StringReference) && (string = DebuggerUtils.getValueAsString((EvaluationContext)evaluationContextImpl, (Value)value)) != null) {
            value = evaluationContextImpl.getSuspendContext().getDebugProcess().getVirtualMachineProxy().mirrorOf(string);
        }
        if (value instanceof DoubleValue) {
            double d2 = ((DoubleValue)value).doubleValue();
            if (type instanceof FloatType && (double)1.4E-45f <= d2 && d2 <= 3.4028234663852886E38) {
                value = evaluationContextImpl.getSuspendContext().getDebugProcess().getVirtualMachineProxy().mirrorOf((float)d2);
            }
        }
        if (value != null) {
            if (type instanceof PrimitiveType) {
                if (!(value instanceof PrimitiveValue)) {
                    value = (Value)new UnBoxingEvaluator(new IdentityEvaluator(value)).evaluate(evaluationContextImpl);
                }
            } else if (type instanceof ReferenceType && value instanceof PrimitiveValue) {
                value = (Value)new BoxingEvaluator(new IdentityEvaluator(value)).evaluate(evaluationContextImpl);
            }
        }
        return value;
    }

    private static void a(ExpressionEvaluator expressionEvaluator, EvaluationContextImpl evaluationContextImpl, SetValueRunnable setValueRunnable) throws EvaluateException {
        try {
            Value value = expressionEvaluator.evaluate((EvaluationContext)evaluationContextImpl);
            setValueRunnable.setValue(evaluationContextImpl, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw EvaluateExceptionUtil.createEvaluateException((String)illegalArgumentException.getMessage());
        }
        catch (InvalidTypeException invalidTypeException) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.type.mismatch", (Object[])new Object[0]));
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)incompatibleThreadStateException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            if (!evaluationContextImpl.isAutoLoadClasses()) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)classNotLoadedException);
            }
            try {
                ReferenceType referenceType = setValueRunnable.loadClass(evaluationContextImpl, classNotLoadedException.className());
                if (referenceType != null) {
                    JavaValueModifier.a(expressionEvaluator, evaluationContextImpl, setValueRunnable);
                }
            }
            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException exception) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
            }
        }
    }

    protected void set(final @NotNull XExpression xExpression, final XValueModifier.XModificationCallback xModificationCallback, DebuggerContextImpl debuggerContextImpl, final SetValueRunnable setValueRunnable) {
        if (xExpression == null) {
            JavaValueModifier.a(2);
        }
        final ProgressWindow progressWindow = new ProgressWindow(true, debuggerContextImpl.getProject());
        final EvaluationContextImpl evaluationContextImpl = this.a.getEvaluationContext();
        DebuggerContextCommandImpl debuggerContextCommandImpl = new DebuggerContextCommandImpl(debuggerContextImpl){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
                if (suspendContextImpl == null) {
                    2.c(0);
                }
                try {
                    final Project project2 = evaluationContextImpl.getProject();
                    final SourcePosition sourcePosition = ContextUtil.getSourcePosition((StackFrameContext)evaluationContextImpl);
                    final PsiElement psiElement = ContextUtil.getContextElement((StackFrameContext)evaluationContextImpl, sourcePosition);
                    ExpressionEvaluator expressionEvaluator = DebuggerInvocationUtil.commitAndRunReadAction(project2, new EvaluatingComputable<ExpressionEvaluator>(){

                        @Override
                        public ExpressionEvaluator compute() throws EvaluateException {
                            return EvaluatorBuilderImpl.build(TextWithImportsImpl.fromXExpression(xExpression), psiElement, sourcePosition, project2);
                        }
                    });
                    JavaValueModifier.a(expressionEvaluator, evaluationContextImpl, new SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContextImpl, Value value) throws ClassNotLoadedException, InvalidTypeException, EvaluateException, IncompatibleThreadStateException {
                            if (!progressWindow.isCanceled()) {
                                setValueRunnable.setValue(evaluationContextImpl, value);
                            }
                        }

                        @Override
                        public ReferenceType loadClass(EvaluationContextImpl evaluationContextImpl, String string) throws InvocationException, ClassNotLoadedException, EvaluateException, IncompatibleThreadStateException, InvalidTypeException {
                            return setValueRunnable.loadClass(evaluationContextImpl, string);
                        }
                    });
                    xModificationCallback.valueModified();
                }
                catch (EvaluateException evaluateException) {
                    xModificationCallback.errorOccurred(evaluateException.getMessage());
                }
            }

            private static /* synthetic */ void c(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValueModifier$2", "threadAction"));
            }
        };
        progressWindow.setTitle(DebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
        evaluationContextImpl.getDebugProcess().getManagerThread().startProgress((DebuggerCommandImpl)debuggerContextCommandImpl, progressWindow);
    }

    private static String a(PrimitiveValue primitiveValue, boolean bl2) {
        if (primitiveValue instanceof CharValue) {
            long l2 = primitiveValue.longValue();
            return bl2 ? "0x" + Long.toHexString(l2).toUpperCase() : Long.toString(l2);
        }
        if (primitiveValue instanceof ByteValue) {
            byte by2 = primitiveValue.byteValue();
            String string = Integer.toHexString(by2).toUpperCase();
            if (string.length() > 2) {
                string = string.substring(string.length() - 2);
            }
            return bl2 ? "0x" + string : primitiveValue.toString();
        }
        if (primitiveValue instanceof ShortValue) {
            short s2 = primitiveValue.shortValue();
            String string = Integer.toHexString(s2).toUpperCase();
            if (string.length() > 4) {
                string = string.substring(string.length() - 4);
            }
            return bl2 ? "0x" + string : primitiveValue.toString();
        }
        if (primitiveValue instanceof IntegerValue) {
            int n2 = primitiveValue.intValue();
            return bl2 ? "0x" + Integer.toHexString(n2).toUpperCase() : primitiveValue.toString();
        }
        if (primitiveValue instanceof LongValue) {
            long l3 = primitiveValue.longValue();
            return bl2 ? "0x" + Long.toHexString(l3).toUpperCase() + "L" : primitiveValue.toString() + "L";
        }
        return DebuggerUtils.translateStringValue((String)primitiveValue.toString());
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/JavaValueModifier";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "set";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static interface SetValueRunnable {
        public void setValue(EvaluationContextImpl var1, Value var2) throws ClassNotLoadedException, InvalidTypeException, EvaluateException, IncompatibleThreadStateException;

        public ReferenceType loadClass(EvaluationContextImpl var1, String var2) throws EvaluateException, InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException;
    }
}

