/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BasicStepMethodFilter;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.ClassInstanceMethodFilter;
import com.intellij.debugger.engine.LambdaMethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import org.jetbrains.annotations.NotNull;

public class LambdaAsyncMethodFilter
extends BasicStepMethodFilter {
    private final int d;
    private final LambdaMethodFilter e;

    public LambdaAsyncMethodFilter(@NotNull PsiMethod psiMethod, int n2, LambdaMethodFilter lambdaMethodFilter) {
        if (psiMethod == null) {
            LambdaAsyncMethodFilter.c(0);
        }
        super(psiMethod, lambdaMethodFilter.getCallingExpressionLines());
        this.d = n2;
        this.e = lambdaMethodFilter;
    }

    @Override
    public int onReached(SuspendContextImpl suspendContextImpl, RequestHint requestHint) {
        try {
            SourcePosition sourcePosition;
            Value value;
            StackFrameProxyImpl stackFrameProxyImpl = suspendContextImpl.getFrameProxy();
            if (stackFrameProxyImpl != null && (value = (Value)ContainerUtil.getOrElse(stackFrameProxyImpl.getArgumentValues(), (int)this.d, null)) instanceof ObjectReference && (sourcePosition = this.e.getBreakpointPosition()) != null) {
                Project project2 = suspendContextImpl.getDebugProcess().getProject();
                long l2 = ((ObjectReference)value).uniqueID();
                LambdaInstanceBreakpoint lambdaInstanceBreakpoint = new LambdaInstanceBreakpoint(project2, l2, sourcePosition, this.e);
                ClassInstanceMethodFilter.setUpStepIntoBreakpoint(suspendContextImpl, lambdaInstanceBreakpoint, requestHint);
                return -100;
            }
        }
        catch (EvaluateException evaluateException) {
            // empty catch block
        }
        return 0;
    }

    private static /* synthetic */ void c(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callerMethod", "com/intellij/debugger/engine/LambdaAsyncMethodFilter", "<init>"));
    }

    private static class LambdaInstanceBreakpoint
    extends StepIntoBreakpoint {
        private final long r;

        public LambdaInstanceBreakpoint(@NotNull Project project2, long l2, @NotNull SourcePosition sourcePosition, @NotNull BreakpointStepMethodFilter breakpointStepMethodFilter) {
            if (project2 == null) {
                LambdaInstanceBreakpoint.g(0);
            }
            if (sourcePosition == null) {
                LambdaInstanceBreakpoint.g(1);
            }
            if (breakpointStepMethodFilter == null) {
                LambdaInstanceBreakpoint.g(2);
            }
            super(project2, sourcePosition, breakpointStepMethodFilter);
            this.r = l2;
        }

        @Override
        public boolean evaluateCondition(EvaluationContextImpl evaluationContextImpl, LocatableEvent locatableEvent) throws EvaluateException {
            if (!super.evaluateCondition(evaluationContextImpl, locatableEvent)) {
                return false;
            }
            if (!DebuggerUtilsEx.isLambda(locatableEvent.location().method())) {
                return false;
            }
            ObjectReference objectReference = null;
            StackFrameProxyImpl stackFrameProxyImpl = evaluationContextImpl.getSuspendContext().getThread().frame(1);
            if (stackFrameProxyImpl != null) {
                try {
                    objectReference = stackFrameProxyImpl.thisObject();
                }
                catch (EvaluateException evaluateException) {
                    // empty catch block
                }
            }
            return objectReference != null && objectReference.uniqueID() == this.r;
        }

        private static /* synthetic */ void g(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pos";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filter";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/engine/LambdaAsyncMethodFilter$LambdaInstanceBreakpoint";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

