/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.SmartHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspendManagerUtil {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.engine.SuspendManagerUtil");

    public static boolean isEvaluating(SuspendManager suspendManager, ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        for (SuspendContextImpl suspendContextImpl : suspendManager.getEventContexts()) {
            if (!suspendContextImpl.isEvaluating() || !threadReferenceProxyImpl.equals(suspendContextImpl.getThread())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static SuspendContextImpl findContextByThread(@NotNull SuspendManager suspendManager, ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        if (suspendManager == null) {
            SuspendManagerUtil.a(0);
        }
        for (SuspendContextImpl suspendContextImpl : suspendManager.getEventContexts()) {
            if (suspendContextImpl.getThread() != threadReferenceProxyImpl && suspendContextImpl.getSuspendPolicy() != 2 || suspendContextImpl.isExplicitlyResumed(threadReferenceProxyImpl)) continue;
            return suspendContextImpl;
        }
        return null;
    }

    public static void assertSuspendContext(SuspendContextImpl suspendContextImpl) {
        if (a.isDebugEnabled()) {
            a.assertTrue(suspendContextImpl.myInProgress, (Object)"You can invoke methods only inside commands invoked for SuspendContext");
        }
    }

    @NotNull
    public static Set<SuspendContextImpl> getSuspendingContexts(@NotNull SuspendManager suspendManager, ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        if (suspendManager == null) {
            SuspendManagerUtil.a(1);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Set set = (Set)suspendManager.getEventContexts().stream().filter(suspendContextImpl -> suspendContextImpl.suspends(threadReferenceProxyImpl)).collect(Collectors.toCollection(SmartHashSet::new));
        if (set == null) {
            SuspendManagerUtil.a(2);
        }
        return set;
    }

    @Nullable
    public static SuspendContextImpl getSuspendingContext(@NotNull SuspendManager suspendManager, ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        if (suspendManager == null) {
            SuspendManagerUtil.a(3);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return suspendManager.getEventContexts().stream().filter(suspendContextImpl -> suspendContextImpl.suspends(threadReferenceProxyImpl)).findFirst().orElse(null);
    }

    public static void restoreAfterResume(SuspendContextImpl suspendContextImpl, Object object) {
        SuspendManager suspendManager = suspendContextImpl.getDebugProcess().getSuspendManager();
        ResumeData resumeData = (ResumeData)object;
        ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
        if (resumeData.myIsFrozen && !suspendManager.isFrozen(threadReferenceProxyImpl)) {
            suspendManager.freezeThread(threadReferenceProxyImpl);
        }
        a.debug("RestoreAfterResume SuspendContextImpl...");
        a.assertTrue(suspendContextImpl.myResumedThreads == null);
        if (resumeData.myResumedThreads != null) {
            resumeData.myResumedThreads.forEach(ThreadReferenceProxyImpl::resume);
            suspendContextImpl.myResumedThreads = resumeData.myResumedThreads;
        }
    }

    public static Object prepareForResume(SuspendContextImpl suspendContextImpl) {
        SuspendManager suspendManager = suspendContextImpl.getDebugProcess().getSuspendManager();
        ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
        ResumeData resumeData = new ResumeData(suspendManager.isFrozen(threadReferenceProxyImpl), suspendContextImpl.myResumedThreads);
        if (resumeData.myIsFrozen) {
            suspendManager.unfreezeThread(threadReferenceProxyImpl);
        }
        a.debug("Resuming SuspendContextImpl...");
        if (suspendContextImpl.myResumedThreads != null) {
            suspendContextImpl.myResumedThreads.forEach(ThreadReferenceProxyImpl::suspend);
            suspendContextImpl.myResumedThreads = null;
        }
        return resumeData;
    }

    public static SuspendContextImpl getEvaluatingContext(SuspendManager suspendManager, ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        for (SuspendContextImpl suspendContextImpl : suspendManager.getEventContexts()) {
            if (suspendContextImpl.isResumed() || !suspendContextImpl.isEvaluating() || suspendContextImpl.getThread() != threadReferenceProxyImpl) continue;
            return suspendContextImpl;
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/SuspendManagerUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/SuspendManagerUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendingContexts";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findContextByThread";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSuspendingContexts";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuspendingContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ResumeData {
        final boolean myIsFrozen;
        final Set<ThreadReferenceProxyImpl> myResumedThreads;

        public ResumeData(boolean bl2, Set<ThreadReferenceProxyImpl> set) {
            this.myIsFrozen = bl2;
            this.myResumedThreads = set;
        }
    }
}

