/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextWithImportsImpl
implements TextWithImports {
    private final CodeFragmentKind c;
    private String d;
    private final FileType b;
    private final String e;
    private static final char a = '\r';

    public TextWithImportsImpl(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            TextWithImportsImpl.a(0);
        }
        this.c = CodeFragmentKind.EXPRESSION;
        String string = psiElement.getText();
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile instanceof PsiExpressionCodeFragment) {
            this.d = string;
            this.e = ((JavaCodeFragment)psiFile).importsToString();
            this.b = StdFileTypes.JAVA;
        } else {
            Trinity<String, String, FileType> trinity = TextWithImportsImpl.a(string);
            this.d = (String)trinity.first;
            this.e = (String)trinity.second;
            this.b = (FileType)trinity.third;
        }
    }

    public TextWithImportsImpl(CodeFragmentKind codeFragmentKind, @NotNull String string, @NotNull String string2, @Nullable FileType fileType) {
        if (string == null) {
            TextWithImportsImpl.a(1);
        }
        if (string2 == null) {
            TextWithImportsImpl.a(2);
        }
        this.c = codeFragmentKind;
        this.d = string;
        this.e = string2;
        this.b = fileType;
    }

    public TextWithImportsImpl(CodeFragmentKind codeFragmentKind, @NotNull String string) {
        if (string == null) {
            TextWithImportsImpl.a(3);
        }
        this.c = codeFragmentKind;
        Trinity<String, String, FileType> trinity = TextWithImportsImpl.a(string);
        this.d = (String)trinity.first;
        this.e = (String)trinity.second;
        this.b = (FileType)trinity.third;
    }

    private static Trinity<String, String, FileType> a(String string) {
        String[] stringArray = string.split(String.valueOf('\r'));
        return Trinity.create((Object)stringArray[0], (Object)(stringArray.length > 1 ? stringArray[1] : ""), stringArray.length > 2 ? FileTypeManager.getInstance().getStdFileType(stringArray[2]) : null);
    }

    public CodeFragmentKind getKind() {
        return this.c;
    }

    public String getText() {
        return this.d;
    }

    @NotNull
    public String getImports() {
        String string = this.e;
        if (string == null) {
            TextWithImportsImpl.a(4);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TextWithImportsImpl)) {
            return false;
        }
        TextWithImportsImpl textWithImportsImpl = (TextWithImportsImpl)object;
        return Comparing.equal((String)textWithImportsImpl.d, (String)this.d) && Comparing.equal((String)textWithImportsImpl.e, (String)this.e);
    }

    public String toString() {
        return this.getText();
    }

    public String toExternalForm() {
        String string = this.d;
        if (StringUtil.isNotEmpty((String)this.e) || this.b != null) {
            string = string + '\r' + this.e;
        }
        if (this.b != null) {
            string = string + '\r' + this.b.getName();
        }
        return string;
    }

    public int hashCode() {
        return this.d.hashCode();
    }

    public boolean isEmpty() {
        return StringUtil.isEmptyOrSpaces((String)this.getText());
    }

    public void setText(String string) {
        this.d = string;
    }

    public FileType getFileType() {
        return this.b;
    }

    @Nullable
    public static XExpression toXExpression(@Nullable TextWithImports textWithImports) {
        if (textWithImports != null && !textWithImports.getText().isEmpty()) {
            return new XExpressionImpl(textWithImports.getText(), LanguageUtil.getFileTypeLanguage((FileType)textWithImports.getFileType()), StringUtil.nullize((String)textWithImports.getImports()), TextWithImportsImpl.a(textWithImports.getKind()));
        }
        return null;
    }

    private static EvaluationMode a(CodeFragmentKind codeFragmentKind) {
        switch (codeFragmentKind) {
            case EXPRESSION: {
                return EvaluationMode.EXPRESSION;
            }
            case CODE_BLOCK: {
                return EvaluationMode.CODE_FRAGMENT;
            }
        }
        throw new IllegalStateException("Unknown kind " + codeFragmentKind);
    }

    private static CodeFragmentKind a(EvaluationMode evaluationMode) {
        switch (evaluationMode) {
            case EXPRESSION: {
                return CodeFragmentKind.EXPRESSION;
            }
            case CODE_FRAGMENT: {
                return CodeFragmentKind.CODE_BLOCK;
            }
        }
        throw new IllegalStateException("Unknown mode " + evaluationMode);
    }

    public static TextWithImports fromXExpression(@Nullable XExpression xExpression) {
        if (xExpression == null) {
            return null;
        }
        if (xExpression.getCustomInfo() == null && xExpression.getLanguage() == null) {
            return new TextWithImportsImpl(TextWithImportsImpl.a(xExpression.getMode()), xExpression.getExpression());
        }
        return new TextWithImportsImpl(TextWithImportsImpl.a(xExpression.getMode()), xExpression.getExpression(), StringUtil.notNullize((String)xExpression.getCustomInfo()), LanguageUtil.getLanguageFileType((Language)xExpression.getLanguage()));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/evaluation/TextWithImportsImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/evaluation/TextWithImportsImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImports";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

