/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.tree.IElementType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

class BinaryExpressionEvaluator
implements Evaluator {
    private static final Logger c = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.BinaryExpressionEvaluator");
    private final Evaluator b;
    private final Evaluator d;
    private final IElementType a;
    private final String e;

    public BinaryExpressionEvaluator(@NotNull Evaluator evaluator, @NotNull Evaluator evaluator2, @NotNull IElementType iElementType, String string) {
        if (evaluator == null) {
            BinaryExpressionEvaluator.a(0);
        }
        if (evaluator2 == null) {
            BinaryExpressionEvaluator.a(1);
        }
        if (iElementType == null) {
            BinaryExpressionEvaluator.a(2);
        }
        this.b = DisableGC.create(evaluator);
        this.d = DisableGC.create(evaluator2);
        this.a = iElementType;
        this.e = string;
    }

    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        Value value = (Value)this.b.evaluate(evaluationContextImpl);
        return BinaryExpressionEvaluator.evaluateOperation(value, this.a, this.d, this.e, evaluationContextImpl);
    }

    static Object evaluateOperation(Value value, IElementType iElementType, Evaluator evaluator, String string, EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        VirtualMachineProxyImpl virtualMachineProxyImpl = evaluationContextImpl.getDebugProcess().getVirtualMachineProxy();
        if (value instanceof BooleanValue) {
            boolean bl2 = ((PrimitiveValue)value).booleanValue();
            if (iElementType == JavaTokenType.OROR && bl2) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, true);
            }
            if (iElementType == JavaTokenType.ANDAND && !bl2) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, false);
            }
        }
        Value value2 = (Value)evaluator.evaluate(evaluationContextImpl);
        if (iElementType == JavaTokenType.PLUS) {
            if (DebuggerUtils.isInteger((Value)value) && DebuggerUtils.isInteger((Value)value2)) {
                long l2 = ((PrimitiveValue)value).longValue();
                long l3 = ((PrimitiveValue)value2).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, l2 + l3);
            }
            if (DebuggerUtils.isNumeric((Value)value) && DebuggerUtils.isNumeric((Value)value2)) {
                double d2 = ((PrimitiveValue)value).doubleValue();
                double d3 = ((PrimitiveValue)value2).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, d2 + d3);
            }
            if (value instanceof CharValue && value2 instanceof CharValue) {
                char c2 = ((CharValue)value).charValue();
                char c3 = ((CharValue)value2).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, c2 + c3);
            }
            if (value instanceof StringReference || value2 instanceof StringReference) {
                String string2 = DebuggerUtils.getValueAsString((EvaluationContext)evaluationContextImpl, (Value)value);
                String string3 = DebuggerUtils.getValueAsString((EvaluationContext)evaluationContextImpl, (Value)value2);
                return virtualMachineProxyImpl.mirrorOf(string2 + string3);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"+"}));
        }
        if (iElementType == JavaTokenType.MINUS) {
            if (DebuggerUtils.isInteger((Value)value) && DebuggerUtils.isInteger((Value)value2)) {
                long l4 = ((PrimitiveValue)value).longValue();
                long l5 = ((PrimitiveValue)value2).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, l4 - l5);
            }
            if (DebuggerUtils.isNumeric((Value)value) && DebuggerUtils.isNumeric((Value)value2)) {
                double d4 = ((PrimitiveValue)value).doubleValue();
                double d5 = ((PrimitiveValue)value2).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, d4 - d5);
            }
            if (value instanceof CharValue && value2 instanceof CharValue) {
                char c4 = ((CharValue)value).charValue();
                char c5 = ((CharValue)value2).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, c4 - c5);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"-"}));
        }
        if (iElementType == JavaTokenType.ASTERISK) {
            if (DebuggerUtils.isInteger((Value)value) && DebuggerUtils.isInteger((Value)value2)) {
                long l6 = ((PrimitiveValue)value).longValue();
                long l7 = ((PrimitiveValue)value2).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, l6 * l7);
            }
            if (DebuggerUtils.isNumeric((Value)value) && DebuggerUtils.isNumeric((Value)value2)) {
                double d6 = ((PrimitiveValue)value).doubleValue();
                double d7 = ((PrimitiveValue)value2).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, d6 * d7);
            }
            if (value instanceof CharValue && value2 instanceof CharValue) {
                char c6 = ((CharValue)value).charValue();
                char c7 = ((CharValue)value2).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, c6 * c7);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"*"}));
        }
        if (iElementType == JavaTokenType.DIV) {
            if (DebuggerUtils.isInteger((Value)value) && DebuggerUtils.isInteger((Value)value2)) {
                long l8 = ((PrimitiveValue)value).longValue();
                long l9 = ((PrimitiveValue)value2).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, l8 / l9);
            }
            if (DebuggerUtils.isNumeric((Value)value) && DebuggerUtils.isNumeric((Value)value2)) {
                double d8 = ((PrimitiveValue)value).doubleValue();
                double d9 = ((PrimitiveValue)value2).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, d8 / d9);
            }
            if (value instanceof CharValue && value2 instanceof CharValue) {
                char c8 = ((CharValue)value).charValue();
                char c9 = ((CharValue)value2).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, c8 / c9);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"/"}));
        }
        if (iElementType == JavaTokenType.PERC) {
            if (DebuggerUtils.isInteger((Value)value) && DebuggerUtils.isInteger((Value)value2)) {
                long l10 = ((PrimitiveValue)value).longValue();
                long l11 = ((PrimitiveValue)value2).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, l10 % l11);
            }
            if (DebuggerUtils.isNumeric((Value)value) && DebuggerUtils.isNumeric((Value)value2)) {
                double d10 = ((PrimitiveValue)value).doubleValue();
                double d11 = ((PrimitiveValue)value2).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, d10 % d11);
            }
            if (value instanceof CharValue && value2 instanceof CharValue) {
                char c10 = ((CharValue)value).charValue();
                char c11 = ((CharValue)value2).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, c10 % c11);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"%"}));
        }
        if (iElementType == JavaTokenType.LTLT) {
            if (DebuggerUtils.isInteger((Value)value) && DebuggerUtils.isInteger((Value)value2)) {
                long l12 = ((PrimitiveValue)value2).longValue();
                if (value instanceof ByteValue) {
                    return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, ((ByteValue)value).byteValue() << (int)l12);
                }
                if (value instanceof ShortValue) {
                    return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, ((ShortValue)value).shortValue() << (int)l12);
                }
                if (value instanceof IntegerValue) {
                    return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, ((IntegerValue)value).intValue() << (int)l12);
                }
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, ((PrimitiveValue)value).longValue() << (int)l12);
            }
            if (value instanceof CharValue && value2 instanceof CharValue) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, ((CharValue)value).charValue() << ((CharValue)value2).charValue());
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"<<"}));
        }
        if (iElementType == JavaTokenType.GTGT) {
            if (DebuggerUtils.isInteger((Value)value) && DebuggerUtils.isInteger((Value)value2)) {
                long l13 = ((PrimitiveValue)value2).longValue();
                if (value instanceof ByteValue) {
                    return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, ((ByteValue)value).byteValue() >> (int)l13);
                }
                if (value instanceof ShortValue) {
                    return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, ((ShortValue)value).shortValue() >> (int)l13);
                }
                if (value instanceof IntegerValue) {
                    return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, ((IntegerValue)value).intValue() >> (int)l13);
                }
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, ((PrimitiveValue)value).longValue() >> (int)l13);
            }
            if (value instanceof CharValue && value2 instanceof CharValue) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, ((CharValue)value).charValue() >> ((CharValue)value2).charValue());
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{">>"}));
        }
        if (iElementType == JavaTokenType.GTGTGT) {
            if (DebuggerUtils.isInteger((Value)value) && DebuggerUtils.isInteger((Value)value2)) {
                long l14 = ((PrimitiveValue)value2).longValue();
                if (value instanceof ByteValue) {
                    return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, ((ByteValue)value).byteValue() >>> (int)l14);
                }
                if (value instanceof ShortValue) {
                    return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, ((ShortValue)value).shortValue() >>> (int)l14);
                }
                if (value instanceof IntegerValue) {
                    return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, ((IntegerValue)value).intValue() >>> (int)l14);
                }
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, ((PrimitiveValue)value).longValue() >>> (int)l14);
            }
            if (value instanceof CharValue && value2 instanceof CharValue) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, ((CharValue)value).charValue() >>> ((CharValue)value2).charValue());
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{">>>"}));
        }
        if (iElementType == JavaTokenType.AND) {
            if (DebuggerUtils.isInteger((Value)value) && DebuggerUtils.isInteger((Value)value2)) {
                long l15 = ((PrimitiveValue)value).longValue();
                long l16 = ((PrimitiveValue)value2).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, l15 & l16);
            }
            if (value instanceof CharValue && value2 instanceof CharValue) {
                char c12 = ((CharValue)value).charValue();
                char c13 = ((CharValue)value2).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, c12 & c13);
            }
            if (value instanceof BooleanValue && value2 instanceof BooleanValue) {
                boolean bl3 = ((PrimitiveValue)value).booleanValue();
                boolean bl4 = ((PrimitiveValue)value2).booleanValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, bl3 & bl4);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"&"}));
        }
        if (iElementType == JavaTokenType.OR) {
            if (DebuggerUtils.isInteger((Value)value) && DebuggerUtils.isInteger((Value)value2)) {
                long l17 = ((PrimitiveValue)value).longValue();
                long l18 = ((PrimitiveValue)value2).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, l17 | l18);
            }
            if (value instanceof CharValue && value2 instanceof CharValue) {
                char c14 = ((CharValue)value).charValue();
                char c15 = ((CharValue)value2).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, c14 | c15);
            }
            if (value instanceof BooleanValue && value2 instanceof BooleanValue) {
                boolean bl5 = ((PrimitiveValue)value).booleanValue();
                boolean bl6 = ((PrimitiveValue)value2).booleanValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, bl5 | bl6);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"|"}));
        }
        if (iElementType == JavaTokenType.XOR) {
            if (DebuggerUtils.isInteger((Value)value) && DebuggerUtils.isInteger((Value)value2)) {
                long l19 = ((PrimitiveValue)value).longValue();
                long l20 = ((PrimitiveValue)value2).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, l19 ^ l20);
            }
            if (value instanceof CharValue && value2 instanceof CharValue) {
                char c16 = ((CharValue)value).charValue();
                char c17 = ((CharValue)value2).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, c16 ^ c17);
            }
            if (value instanceof BooleanValue && value2 instanceof BooleanValue) {
                boolean bl7 = ((PrimitiveValue)value).booleanValue();
                boolean bl8 = ((PrimitiveValue)value2).booleanValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, bl7 ^ bl8);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"^"}));
        }
        if (iElementType == JavaTokenType.EQEQ) {
            if (value == null && value2 == null) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, true);
            }
            if (value == null) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, value2.equals(null));
            }
            if (value2 == null) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, value.equals(null));
            }
            if (DebuggerUtils.isInteger((Value)value) && DebuggerUtils.isInteger((Value)value2)) {
                long l21;
                long l22 = ((PrimitiveValue)value).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, l22 == (l21 = ((PrimitiveValue)value2).longValue()));
            }
            if (DebuggerUtils.isNumeric((Value)value) && DebuggerUtils.isNumeric((Value)value2)) {
                double d12;
                double d13 = ((PrimitiveValue)value).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, d13 == (d12 = ((PrimitiveValue)value2).doubleValue()));
            }
            if (value instanceof BooleanValue && value2 instanceof BooleanValue) {
                boolean bl9;
                boolean bl10 = ((PrimitiveValue)value).booleanValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, bl10 == (bl9 = ((PrimitiveValue)value2).booleanValue()));
            }
            if (value instanceof CharValue && value2 instanceof CharValue) {
                char c18;
                char c19 = ((CharValue)value).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, c19 == (c18 = ((CharValue)value2).charValue()));
            }
            if (value instanceof ObjectReference && value2 instanceof ObjectReference) {
                ObjectReference objectReference = (ObjectReference)value;
                ObjectReference objectReference2 = (ObjectReference)value2;
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, objectReference.uniqueID() == objectReference2.uniqueID());
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"=="}));
        }
        if (iElementType == JavaTokenType.OROR) {
            if (value instanceof BooleanValue && value2 instanceof BooleanValue) {
                boolean bl11 = ((PrimitiveValue)value).booleanValue();
                boolean bl12 = ((PrimitiveValue)value2).booleanValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, bl11 || bl12);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"||"}));
        }
        if (iElementType == JavaTokenType.ANDAND) {
            if (value instanceof BooleanValue && value2 instanceof BooleanValue) {
                boolean bl13 = ((PrimitiveValue)value).booleanValue();
                boolean bl14 = ((PrimitiveValue)value2).booleanValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, bl13 && bl14);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"&&"}));
        }
        if (iElementType == JavaTokenType.NE) {
            if (value == null && value2 == null) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, false);
            }
            if (value == null) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, !value2.equals(null));
            }
            if (value2 == null) {
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, !value.equals(null));
            }
            if (DebuggerUtils.isInteger((Value)value) && DebuggerUtils.isInteger((Value)value2)) {
                long l23;
                long l24 = ((PrimitiveValue)value).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, l24 != (l23 = ((PrimitiveValue)value2).longValue()));
            }
            if (DebuggerUtils.isNumeric((Value)value) && DebuggerUtils.isNumeric((Value)value2)) {
                double d14;
                double d15 = ((PrimitiveValue)value).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, d15 != (d14 = ((PrimitiveValue)value2).doubleValue()));
            }
            if (value instanceof BooleanValue && value2 instanceof BooleanValue) {
                boolean bl15;
                boolean bl16 = ((PrimitiveValue)value).booleanValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, bl16 != (bl15 = ((PrimitiveValue)value2).booleanValue()));
            }
            if (value instanceof CharValue && value2 instanceof CharValue) {
                char c20;
                char c21 = ((CharValue)value).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, c21 != (c20 = ((CharValue)value2).charValue()));
            }
            if (value instanceof ObjectReference && value2 instanceof ObjectReference) {
                ObjectReference objectReference = (ObjectReference)value;
                ObjectReference objectReference3 = (ObjectReference)value2;
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, objectReference.uniqueID() != objectReference3.uniqueID());
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"!="}));
        }
        if (iElementType == JavaTokenType.LT) {
            if (DebuggerUtils.isInteger((Value)value) && DebuggerUtils.isInteger((Value)value2)) {
                long l25;
                long l26 = ((PrimitiveValue)value).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, l26 < (l25 = ((PrimitiveValue)value2).longValue()));
            }
            if (DebuggerUtils.isNumeric((Value)value) && DebuggerUtils.isNumeric((Value)value2)) {
                double d16;
                double d17 = ((PrimitiveValue)value).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, d17 < (d16 = ((PrimitiveValue)value2).doubleValue()));
            }
            if (value instanceof CharValue && value2 instanceof CharValue) {
                char c22;
                char c23 = ((CharValue)value).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, c23 < (c22 = ((CharValue)value2).charValue()));
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"<"}));
        }
        if (iElementType == JavaTokenType.GT) {
            if (DebuggerUtils.isInteger((Value)value) && DebuggerUtils.isInteger((Value)value2)) {
                long l27;
                long l28 = ((PrimitiveValue)value).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, l28 > (l27 = ((PrimitiveValue)value2).longValue()));
            }
            if (DebuggerUtils.isNumeric((Value)value) && DebuggerUtils.isNumeric((Value)value2)) {
                double d18;
                double d19 = ((PrimitiveValue)value).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, d19 > (d18 = ((PrimitiveValue)value2).doubleValue()));
            }
            if (value instanceof CharValue && value2 instanceof CharValue) {
                char c24;
                char c25 = ((CharValue)value).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, c25 > (c24 = ((CharValue)value2).charValue()));
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{">"}));
        }
        if (iElementType == JavaTokenType.LE) {
            if (DebuggerUtils.isInteger((Value)value) && DebuggerUtils.isInteger((Value)value2)) {
                long l29;
                long l30 = ((PrimitiveValue)value).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, l30 <= (l29 = ((PrimitiveValue)value2).longValue()));
            }
            if (DebuggerUtils.isNumeric((Value)value) && DebuggerUtils.isNumeric((Value)value2)) {
                double d20;
                double d21 = ((PrimitiveValue)value).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, d21 <= (d20 = ((PrimitiveValue)value2).doubleValue()));
            }
            if (value instanceof CharValue && value2 instanceof CharValue) {
                char c26;
                char c27 = ((CharValue)value).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, c27 <= (c26 = ((CharValue)value2).charValue()));
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"<="}));
        }
        if (iElementType == JavaTokenType.GE) {
            if (DebuggerUtils.isInteger((Value)value) && DebuggerUtils.isInteger((Value)value2)) {
                long l31;
                long l32 = ((PrimitiveValue)value).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, l32 >= (l31 = ((PrimitiveValue)value2).longValue()));
            }
            if (DebuggerUtils.isNumeric((Value)value) && DebuggerUtils.isNumeric((Value)value2)) {
                double d22;
                double d23 = ((PrimitiveValue)value).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, d23 >= (d22 = ((PrimitiveValue)value2).doubleValue()));
            }
            if (value instanceof CharValue && value2 instanceof CharValue) {
                char c28;
                char c29 = ((CharValue)value).charValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, c29 >= (c28 = ((CharValue)value2).charValue()));
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{">="}));
        }
        c.assertTrue(false);
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "leftOperand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rightOperand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "opType";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/engine/evaluation/expression/BinaryExpressionEvaluator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

