/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.Patches;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluateRuntimeException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.SuperEvaluator;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rt.debugger.DefaultMethodInvoker;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MethodEvaluator
implements Evaluator {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.MethodEvaluator");
    private final JVMName a;
    private final JVMName d;
    private final String e;
    private final Evaluator[] h;
    private final Evaluator c;
    private final boolean g;
    private final boolean f;

    public MethodEvaluator(Evaluator evaluator, JVMName jVMName, String string, JVMName jVMName2, Evaluator[] evaluatorArray) {
        this(evaluator, jVMName, string, jVMName2, evaluatorArray, false, false);
    }

    public MethodEvaluator(Evaluator evaluator, JVMName jVMName, String string, JVMName jVMName2, Evaluator[] evaluatorArray, boolean bl2, boolean bl3) {
        this.c = DisableGC.create(evaluator);
        this.a = jVMName;
        this.e = string;
        this.d = jVMName2;
        this.h = evaluatorArray;
        this.g = bl2;
        this.f = bl3;
    }

    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        if (!evaluationContextImpl.getDebugProcess().isAttached()) {
            return null;
        }
        DebugProcessImpl debugProcessImpl = evaluationContextImpl.getDebugProcess();
        boolean bl2 = this.c instanceof SuperEvaluator || this.c instanceof DisableGC && ((DisableGC)this.c).getDelegate() instanceof SuperEvaluator;
        Object object = this.c.evaluate(evaluationContextImpl);
        if (b.isDebugEnabled()) {
            b.debug("MethodEvaluator: object = " + object);
        }
        if (object == null) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)new NullPointerException());
        }
        if (!(object instanceof ObjectReference) && !MethodEvaluator.a(object)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.evaluating.method", (Object[])new Object[]{this.e}));
        }
        ArrayList<Value> arrayList = new ArrayList<Value>(this.h.length);
        for (Evaluator object2 : this.h) {
            arrayList.add((Value)object2.evaluate(evaluationContextImpl));
        }
        try {
            int n2;
            Method method;
            Object object3 = null;
            if (object instanceof ObjectReference) {
                object3 = ((ObjectReference)object).referenceType();
            } else if (MethodEvaluator.a(object)) {
                object3 = (ReferenceType)object;
            }
            if (object3 == null) {
                throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.evaluate.qualifier", (Object[])new Object[]{this.e})));
            }
            String string = this.d != null ? this.d.getName(debugProcessImpl) : null;
            String string2 = DebuggerUtilsEx.methodName(object3.name(), this.e, string);
            if (MethodEvaluator.a(object)) {
                Method method2;
                if (MethodEvaluator.a(object3) && (method2 = DebuggerUtils.findMethod((ReferenceType)object3, (String)this.e, (String)string)) != null && method2.isStatic()) {
                    if (object3 instanceof ClassType) {
                        return debugProcessImpl.invokeMethod((EvaluationContext)evaluationContextImpl, (ClassType)object3, method2, arrayList);
                    }
                    return debugProcessImpl.invokeMethod((EvaluationContext)evaluationContextImpl, (InterfaceType)object3, method2, arrayList);
                }
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.static.method", (Object[])new Object[]{string2}));
            }
            ObjectReference objectReference = (ObjectReference)object;
            Object object2 = object3;
            if (bl2 && object3 instanceof ClassType) {
                object2 = ((ClassType)object3).superclass();
                Method method3 = method = this.a != null ? this.a.getName(debugProcessImpl) : null;
                if (object2 == null || method != null && !((String)((Object)method)).equals(object2.name())) {
                    object2 = debugProcessImpl.findClass(evaluationContextImpl, (String)((Object)method), evaluationContextImpl.getClassLoader());
                }
            }
            method = DebuggerUtils.findMethod((ReferenceType)object2, (String)this.e, (String)string);
            if (string == null) {
                if (method == null || method.argumentTypeNames().size() != arrayList.size()) {
                    for (Method method4 : object2.methodsByName(this.e)) {
                        if (method4.argumentTypeNames().size() != arrayList.size()) continue;
                        method = method4;
                        break;
                    }
                }
            } else if (this.f && method != null && !method.isVarArgs() && method.isBridge() && (n2 = string.lastIndexOf(")")) >= 0) {
                String string3 = string.substring(0, n2 + 1);
                for (Method method5 : object2.visibleMethods()) {
                    if (!method5.name().equals(this.e) || !method5.signature().startsWith(string3) || method5.isBridge() || method5.isAbstract()) continue;
                    method = method5;
                    break;
                }
            }
            if (method == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.instance.method", (Object[])new Object[]{string2}));
            }
            if (bl2) {
                return debugProcessImpl.invokeInstanceMethod(evaluationContextImpl, objectReference, method, arrayList, 2);
            }
            if (Patches.JDK_BUG_ID_8042123 && this.g && method.declaringType() instanceof InterfaceType) {
                try {
                    return MethodEvaluator.a(debugProcessImpl, evaluationContextImpl, objectReference, this.e);
                }
                catch (EvaluateException evaluateException) {
                    b.info((Throwable)evaluateException);
                }
            }
            return debugProcessImpl.invokeMethod((EvaluationContext)evaluationContextImpl, objectReference, method, arrayList);
        }
        catch (Exception exception) {
            b.debug((Throwable)exception);
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
        }
    }

    private static boolean a(Object object) {
        return object instanceof ClassType || object instanceof InterfaceType;
    }

    private static Value a(DebugProcess debugProcess, EvaluationContext evaluationContext, Value value, String string) throws EvaluateException {
        List<Method> list2;
        ClassType classType = ClassLoadingUtils.getHelperClass(DefaultMethodInvoker.class.getName(), evaluationContext, debugProcess);
        if (classType != null && !(list2 = classType.methodsByName("invoke")).isEmpty()) {
            return debugProcess.invokeMethod(evaluationContext, classType, list2.get(0), Arrays.asList(value, ((VirtualMachineProxyImpl)debugProcess.getVirtualMachineProxy()).mirrorOf(string)));
        }
        return null;
    }

    public String toString() {
        return "call " + this.e;
    }
}

